/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.tooling.internal.provider.runner;

import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.gradle.initialization.BuildEventConsumer;
import org.gradle.internal.operations.BuildOperationDescriptor;
import org.gradle.tooling.internal.protocol.events.InternalOperationFinishedProgressEvent;
import org.gradle.tooling.internal.protocol.events.InternalOperationStartedProgressEvent;
import org.gradle.tooling.internal.provider.runner.BuildOperationParentTracker;

class ProgressEventConsumer {
    private final Set<Object> startedIds = ConcurrentHashMap.newKeySet();
    private final BuildEventConsumer delegate;
    private final BuildOperationParentTracker parentTracker;

    ProgressEventConsumer(BuildEventConsumer delegate, BuildOperationParentTracker parentTracker) {
        this.delegate = delegate;
        this.parentTracker = parentTracker;
    }

    Object findStartedParentId(BuildOperationDescriptor operation) {
        return this.parentTracker.findClosestMatchingAncestor(operation.getParentId(), this.startedIds::contains);
    }

    void started(InternalOperationStartedProgressEvent event) {
        this.delegate.dispatch((Object)event);
        this.startedIds.add(event.getDescriptor().getId());
    }

    void finished(InternalOperationFinishedProgressEvent event) {
        this.startedIds.remove(event.getDescriptor().getId());
        this.delegate.dispatch((Object)event);
    }
}

