/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.execution.impl.steps;

import java.time.Duration;
import java.util.Optional;
import org.gradle.api.GradleException;
import org.gradle.api.InvalidUserDataException;
import org.gradle.internal.execution.Result;
import org.gradle.internal.execution.UnitOfWork;
import org.gradle.internal.execution.impl.steps.Context;
import org.gradle.internal.execution.impl.steps.Step;
import org.gradle.internal.execution.timeout.Timeout;
import org.gradle.internal.execution.timeout.TimeoutHandler;

public class TimeoutStep<C extends Context>
implements Step<C, Result> {
    private final TimeoutHandler timeoutHandler;
    private final Step<? super C, ? extends Result> delegate;

    public TimeoutStep(TimeoutHandler timeoutHandler, Step<? super C, ? extends Result> delegate) {
        this.timeoutHandler = timeoutHandler;
        this.delegate = delegate;
    }

    @Override
    public Result execute(C context) {
        UnitOfWork work = context.getWork();
        Optional<Duration> timeoutProperty = work.getTimeout();
        if (timeoutProperty.isPresent()) {
            Duration timeout = timeoutProperty.get();
            if (timeout.isNegative()) {
                throw new InvalidUserDataException("Timeout of " + work.getDisplayName() + " must be positive, but was " + timeout.toString().substring(2));
            }
            return this.executeWithTimeout(context, timeout);
        }
        return this.executeWithoutTimeout(context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Result executeWithTimeout(C context, Duration timeout) {
        Timeout taskTimeout = this.timeoutHandler.start(Thread.currentThread(), timeout);
        try {
            Result result = this.executeWithoutTimeout(context);
            return result;
        }
        finally {
            taskTimeout.stop();
            if (taskTimeout.timedOut()) {
                Thread.interrupted();
                throw new GradleException("Timeout has been exceeded");
            }
        }
    }

    private Result executeWithoutTimeout(C context) {
        return this.delegate.execute(context);
    }
}

