/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.corrosion.run;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.concurrent.CompletableFuture;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.corrosion.CorrosionPlugin;
import org.eclipse.corrosion.Messages;
import org.eclipse.corrosion.cargo.core.CargoTools;
import org.eclipse.corrosion.launch.RustLaunchDelegateTools;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.debug.core.model.LaunchConfigurationDelegate;
import org.eclipse.debug.ui.ILaunchShortcut;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.ui.IEditorPart;

public class CargoRunDelegate
extends LaunchConfigurationDelegate
implements ILaunchShortcut {
    public void launch(ISelection selection, String mode) {
        ILaunchConfiguration launchConfig = CargoRunDelegate.getLaunchConfiguration(RustLaunchDelegateTools.firstResourceFromSelection(selection));
        try {
            RustLaunchDelegateTools.launch(launchConfig, mode);
        }
        catch (CoreException e) {
            CorrosionPlugin.logError(e);
        }
    }

    public void launch(IEditorPart editor, String mode) {
        ILaunchConfiguration launchConfig = CargoRunDelegate.getLaunchConfiguration(RustLaunchDelegateTools.resourceFromEditor(editor));
        try {
            RustLaunchDelegateTools.launch(launchConfig, mode);
        }
        catch (CoreException e) {
            CorrosionPlugin.logError(e);
        }
    }

    public void launch(ILaunchConfiguration configuration, String mode, ILaunch launch, IProgressMonitor monitor) throws CoreException {
        IFile cargoManifest;
        String projectName = configuration.getAttribute("PROJECT", "");
        IProject project = null;
        ILaunchConfigurationWorkingCopy wc = null;
        if (!projectName.isEmpty()) {
            project = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
        }
        if (project == null || !project.exists()) {
            RustLaunchDelegateTools.openError(Messages.CargoRunDelegate_unableToLaunch, Messages.CargoRunDelegate_unableToFindProject);
            return;
        }
        String options = configuration.getAttribute("OPTIONS", "").trim();
        String arguments = configuration.getAttribute("ARGUMENTS", "").trim();
        String workingDirectoryString = RustLaunchDelegateTools.performVariableSubstitution(configuration.getAttribute("WORKING_DIRECTORY", "").trim());
        File workingDirectory = RustLaunchDelegateTools.convertToAbsolutePath(workingDirectoryString);
        if (workingDirectoryString.isEmpty() || !workingDirectory.exists() || !workingDirectory.isDirectory()) {
            workingDirectory = project.getLocation().toFile();
            if (configuration instanceof ILaunchConfigurationWorkingCopy) {
                wc = (ILaunchConfigurationWorkingCopy)configuration;
                wc.setAttribute("WORKING_DIRECTORY", project.getLocation().toString());
            }
        }
        if (!(cargoManifest = project.getFile("Cargo.toml")).exists()) {
            RustLaunchDelegateTools.openError(Messages.CargoRunDelegate_unableToLaunch, Messages.CargoRunDelegate_unableToFindToml);
            return;
        }
        ArrayList<String> cargoRunCommand = new ArrayList<String>();
        cargoRunCommand.add(CargoTools.getCargoCommand());
        cargoRunCommand.add("run");
        if (!options.isEmpty()) {
            cargoRunCommand.addAll(Arrays.asList(RustLaunchDelegateTools.performVariableSubstitution(options).split("\\s+")));
        }
        String cargoPathString = cargoManifest.getLocation().toPortableString();
        cargoRunCommand.add("--manifest-path");
        cargoRunCommand.add(cargoPathString);
        if (!arguments.isEmpty()) {
            cargoRunCommand.add("--");
            cargoRunCommand.addAll(Arrays.asList(RustLaunchDelegateTools.performVariableSubstitution(arguments).split("\\s+")));
        }
        ArrayList<String> finalRunCommand = cargoRunCommand;
        File finalWorkingDirectory = workingDirectory;
        CompletableFuture.runAsync(() -> {
            try {
                CharSequence[] cmdLine = finalRunCommand.toArray(new String[finalRunCommand.size()]);
                Process p = DebugPlugin.exec((String[])cmdLine, (File)finalWorkingDirectory);
                IProcess process = DebugPlugin.newProcess((ILaunch)launch, (Process)p, (String)"cargo run");
                process.setAttribute(IProcess.ATTR_CMDLINE, String.join((CharSequence)" ", cmdLine));
            }
            catch (CoreException e) {
                RustLaunchDelegateTools.openError(Messages.CargoRunDelegate_unableToLaunch, e.getLocalizedMessage());
            }
        });
        if (wc != null) {
            wc.doSave();
        }
    }

    private static ILaunchConfiguration getLaunchConfiguration(IResource resource) {
        ILaunchConfiguration launchConfiguration = RustLaunchDelegateTools.getLaunchConfiguration(resource, "org.eclipse.corrosion.run.CargoRunDelegate");
        if (launchConfiguration instanceof ILaunchConfigurationWorkingCopy) {
            ILaunchConfigurationWorkingCopy wc = (ILaunchConfigurationWorkingCopy)launchConfiguration;
            wc.setAttribute("PROJECT", resource.getProject().getName());
        }
        return launchConfiguration;
    }
}

