/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.dom.parser.cpp.semantics;

import org.eclipse.cdt.core.dom.ast.IASTExpression;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IBinding;
import org.eclipse.cdt.core.dom.ast.IType;
import org.eclipse.cdt.core.dom.ast.IValue;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPTemplateParameterMap;
import org.eclipse.cdt.internal.core.dom.parser.DependentValue;
import org.eclipse.cdt.internal.core.dom.parser.ITypeMarshalBuffer;
import org.eclipse.cdt.internal.core.dom.parser.ProblemType;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPParameterPackType;
import org.eclipse.cdt.internal.core.dom.parser.cpp.ICPPEvaluation;
import org.eclipse.cdt.internal.core.dom.parser.cpp.InstantiationContext;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.ActivationRecord;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.CPPDependentEvaluation;
import org.eclipse.core.runtime.CoreException;

public class EvalPackExpansion
extends CPPDependentEvaluation {
    private ICPPEvaluation fExpansionPattern;
    private IType fType;

    public EvalPackExpansion(ICPPEvaluation expansionPattern, IASTNode pointOfDefinition) {
        this(expansionPattern, EvalPackExpansion.findEnclosingTemplate(pointOfDefinition));
    }

    public EvalPackExpansion(ICPPEvaluation expansionPattern, IBinding templateDefinition) {
        super(templateDefinition);
        this.fExpansionPattern = expansionPattern;
    }

    public ICPPEvaluation getExpansionPattern() {
        return this.fExpansionPattern;
    }

    @Override
    public boolean isInitializerList() {
        return this.fExpansionPattern.isInitializerList();
    }

    @Override
    public boolean isFunctionSet() {
        return this.fExpansionPattern.isFunctionSet();
    }

    @Override
    public boolean isTypeDependent() {
        return this.fExpansionPattern.isTypeDependent();
    }

    @Override
    public boolean isValueDependent() {
        return this.fExpansionPattern.isValueDependent();
    }

    @Override
    public boolean isConstantExpression() {
        return false;
    }

    @Override
    public boolean isEquivalentTo(ICPPEvaluation other) {
        if (!(other instanceof EvalPackExpansion)) {
            return false;
        }
        EvalPackExpansion o = (EvalPackExpansion)other;
        return this.fExpansionPattern.isEquivalentTo(o.fExpansionPattern);
    }

    @Override
    public IType getType() {
        if (this.fType == null) {
            IType type = this.fExpansionPattern.getType();
            this.fType = type == null ? ProblemType.UNKNOWN_FOR_EXPRESSION : new CPPParameterPackType(type);
        }
        return this.fType;
    }

    @Override
    public IValue getValue() {
        return DependentValue.create(this.fExpansionPattern);
    }

    @Override
    public IASTExpression.ValueCategory getValueCategory() {
        return IASTExpression.ValueCategory.PRVALUE;
    }

    @Override
    public ICPPEvaluation instantiate(InstantiationContext context, int maxDepth) {
        ICPPEvaluation expansionPattern = this.fExpansionPattern.instantiate(context, maxDepth);
        if (expansionPattern == this.fExpansionPattern) {
            return this;
        }
        return new EvalPackExpansion(expansionPattern, this.getTemplateDefinition());
    }

    @Override
    public ICPPEvaluation computeForFunctionCall(ActivationRecord record, ICPPEvaluation.ConstexprEvaluationContext context) {
        ICPPEvaluation expansionPattern = this.fExpansionPattern.computeForFunctionCall(record, context.recordStep());
        if (expansionPattern == this.fExpansionPattern) {
            return this;
        }
        EvalPackExpansion evalParamPack = new EvalPackExpansion(expansionPattern, this.getTemplateDefinition());
        return evalParamPack;
    }

    @Override
    public int determinePackSize(ICPPTemplateParameterMap tpMap) {
        return Integer.MAX_VALUE;
    }

    @Override
    public boolean referencesTemplateParameter() {
        return this.fExpansionPattern.referencesTemplateParameter();
    }

    @Override
    public void marshal(ITypeMarshalBuffer buffer, boolean includeValue) throws CoreException {
        buffer.putShort((short)13);
        buffer.marshalEvaluation(this.fExpansionPattern, includeValue);
        this.marshalTemplateDefinition(buffer);
    }

    public static ICPPEvaluation unmarshal(short firstBytes, ITypeMarshalBuffer buffer) throws CoreException {
        ICPPEvaluation expansionPattern = buffer.unmarshalEvaluation();
        IBinding templateDefinition = buffer.unmarshalBinding();
        return new EvalPackExpansion(expansionPattern, templateDefinition);
    }
}

