/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.tmf.analysis.xml.core.fsm.compile;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.common.core.NonNullUtils;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.Activator;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.fsm.compile.AnalysisCompilationData;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.fsm.compile.IDataDrivenCompilationUnit;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.fsm.compile.TmfXmlConditionCu;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.fsm.compile.TmfXmlStateSystemPathCu;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.fsm.compile.TmfXmlStateValueCu;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.fsm.model.DataDrivenAction;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.fsm.model.DataDrivenActionConditional;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.fsm.model.DataDrivenActionList;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.fsm.model.DataDrivenActionSegment;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.fsm.model.DataDrivenActionStateChange;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.fsm.model.DataDrivenCondition;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.fsm.model.DataDrivenStateSystemPath;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.fsm.model.values.DataDrivenValue;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.fsm.model.values.DataDrivenValueConstant;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.module.XmlUtils;
import org.eclipse.tracecompass.statesystem.core.statevalue.ITmfStateValue;
import org.eclipse.tracecompass.tmf.analysis.xml.core.module.TmfXmlUtils;
import org.w3c.dom.Element;

public abstract class TmfXmlActionCu
implements IDataDrivenCompilationUnit {
    private static final TmfXmlActionCu NO_ACTION_CU = new TmfXmlActionCu(){

        @Override
        public DataDrivenAction generate() {
            return DataDrivenAction.NO_ACTION;
        }
    };

    @Override
    public abstract DataDrivenAction generate();

    public static @Nullable TmfXmlActionCu compile(AnalysisCompilationData analysisData, Element stateChange) {
        List<Element> childElements = TmfXmlUtils.getChildElements(stateChange, "if");
        if (childElements.size() == 1) {
            return TmfXmlActionCu.compileConditionalChange(analysisData, stateChange, childElements.get(0));
        }
        if (childElements.size() > 1) {
            Activator.logError("Conditional State Change: There should be only 1 if node");
            return null;
        }
        return TmfXmlActionCu.compileAssignationChange(analysisData, stateChange);
    }

    private static @Nullable TmfXmlActionCu compileConditionalChange(AnalysisCompilationData analysisData, Element stateChange, Element ifNode) {
        List<@Nullable Element> childElements = XmlUtils.getChildElements(ifNode);
        if (childElements.size() != 1) {
            Activator.logError("There should be only one element under this condition");
            return null;
        }
        Element subCondition = Objects.requireNonNull(childElements.get(0));
        TmfXmlConditionCu condition = TmfXmlConditionCu.compile(analysisData, subCondition);
        if (condition == null) {
            return null;
        }
        List<Element> thenElements = TmfXmlUtils.getChildElements(stateChange, "then");
        if (thenElements.size() != 1) {
            Activator.logError("Conditional State Change: There should be 1 and only 1 then element");
            return null;
        }
        TmfXmlActionCu thenChange = TmfXmlActionCu.compile(analysisData, thenElements.get(0));
        if (thenChange == null) {
            return null;
        }
        List<Element> elseElements = TmfXmlUtils.getChildElements(stateChange, "else");
        if (elseElements.isEmpty()) {
            return new TmfXmlConditionalStateChangeCu(condition, thenChange, null);
        }
        if (thenElements.size() != 1) {
            Activator.logError("Conditional State Change: There should be at most 1 else element");
            return null;
        }
        TmfXmlActionCu elseChange = TmfXmlActionCu.compile(analysisData, elseElements.get(0));
        if (elseChange == null) {
            return null;
        }
        return new TmfXmlConditionalStateChangeCu(condition, thenChange, elseChange);
    }

    private static @Nullable TmfXmlActionCu compileAssignationChange(AnalysisCompilationData analysisContent, Element stateChange) {
        List<@NonNull Element> leftOperands = TmfXmlUtils.getChildElements(stateChange, "stateAttribute");
        List<@NonNull Element> rightOperands = TmfXmlUtils.getChildElements(stateChange, "stateValue");
        List<@NonNull Element> futureTimes = TmfXmlUtils.getChildElements(stateChange, "futureTime");
        if (rightOperands.size() != 1) {
            Activator.logError("There should only be one state Value in this state change");
        }
        Element rightOperand = rightOperands.get(0);
        TmfXmlStateSystemPathCu path = TmfXmlStateSystemPathCu.compile(analysisContent, leftOperands);
        if (path == null) {
            return null;
        }
        if (futureTimes.size() > 1) {
            Activator.logError("There should at most one future time for this state change");
        }
        Element futureTime = futureTimes.isEmpty() ? null : futureTimes.get(0);
        TmfXmlStateValueCu futureTimeCu = null;
        if (futureTime != null && (futureTimeCu = TmfXmlStateValueCu.compileValue(analysisContent, futureTime)) == null) {
            return null;
        }
        TmfXmlStateValueCu rightOperandCu = TmfXmlStateValueCu.compileValue(analysisContent, rightOperand);
        if (rightOperandCu == null) {
            return null;
        }
        boolean increment = Boolean.parseBoolean(rightOperand.getAttribute("increment"));
        boolean update = Boolean.parseBoolean(rightOperand.getAttribute("update"));
        String stack = rightOperand.getAttribute("stack");
        DataDrivenActionStateChange.StackAction stackAction = DataDrivenActionStateChange.StackAction.getTypeFromString(stack);
        if (update && stackAction != DataDrivenActionStateChange.StackAction.NONE) {
            Activator.logError("State change: Update cannot be done with stack action " + (Object)((Object)stackAction));
            return null;
        }
        if (increment && stackAction != DataDrivenActionStateChange.StackAction.NONE) {
            Activator.logError("State change: Increment cannot be done with stack action " + (Object)((Object)stackAction));
            return null;
        }
        return new TmfXmlStateChangeAssignationCu(path, rightOperandCu, increment, update, stackAction, futureTimeCu);
    }

    public static @Nullable String compileNamedAction(AnalysisCompilationData analysisData, Element namedEl) {
        String actionId = namedEl.getAttribute("id");
        if (actionId.isEmpty()) {
            Activator.logError("The action should have an ID attribute");
            return null;
        }
        List<@Nullable Element> childElements = XmlUtils.getChildElements(namedEl);
        ArrayList<TmfXmlActionCu> actionList = new ArrayList<TmfXmlActionCu>();
        for (Element child : childElements) {
            @NonNull Element nonNullChild = (Element)NonNullUtils.checkNotNull((Object)child);
            switch (nonNullChild.getNodeName()) {
                case "stateChange": {
                    TmfXmlActionCu action = TmfXmlActionCu.compile(analysisData, nonNullChild);
                    if (action == null) {
                        return null;
                    }
                    actionList.add(action);
                    break;
                }
                case "fsmScheduleAction": {
                    Activator.logWarning("Action fsmScheduleAction is not supported yet, it will have no effect");
                    break;
                }
                case "segment": {
                    TmfXmlActionCu action = TmfXmlActionCu.compileSegmentAction(analysisData, nonNullChild);
                    if (action == null) {
                        return null;
                    }
                    actionList.add(action);
                    break;
                }
                case "action": {
                    String subActionId = TmfXmlActionCu.compileNamedAction(analysisData, nonNullChild);
                    if (subActionId == null) {
                        return null;
                    }
                    TmfXmlActionCu action = analysisData.getAction(subActionId);
                    if (action == null) {
                        return null;
                    }
                    actionList.add(action);
                    break;
                }
                default: {
                    Activator.logError("Invalid action type : " + nonNullChild.getNodeName());
                }
            }
        }
        TmfXmlActionCu actionCu = TmfXmlActionCu.createActionList(actionList);
        analysisData.addAction(actionId, actionCu);
        return actionId;
    }

    private static @Nullable TmfXmlActionCu compileSegmentAction(AnalysisCompilationData analysisData, Element node) {
        List<@NonNull Element> segmentType = TmfXmlUtils.getChildElements(node, "segType");
        if (segmentType.size() != 1) {
            Activator.logWarning("Segment action: There should be one and only one segType element.");
            return null;
        }
        Element typeElement = Objects.requireNonNull(segmentType.get(0));
        String segmentName = typeElement.getAttribute("segName");
        TmfXmlStateValueCu segmentTypeValue = null;
        if (!segmentName.isEmpty()) {
            segmentTypeValue = new TmfXmlStateValueCu(() -> new DataDrivenValueConstant(null, ITmfStateValue.Type.NULL, segmentName));
        } else {
            List<Element> nameElements = TmfXmlUtils.getChildElements(typeElement, "segName");
            if (nameElements.size() != 1) {
                Activator.logError("Segment type: You need to either give a segName attribute or define one and only one <segName> element with child <stateValue> to get the type name");
                return null;
            }
            Element segNameElement = Objects.requireNonNull(nameElements.get(0));
            List<Element> nameValueElements = TmfXmlUtils.getChildElements(segNameElement, "stateValue");
            if (nameValueElements.size() != 1) {
                Activator.logError("Segment type: the <segName> element should have one and only one <stateValue> child");
                return null;
            }
            Element segNameValueElement = Objects.requireNonNull(nameValueElements.get(0));
            segmentTypeValue = TmfXmlStateValueCu.compileValue(analysisData, segNameValueElement);
        }
        if (segmentTypeValue == null) {
            return null;
        }
        TmfXmlStateValueCu beginTimeValue = null;
        TmfXmlStateValueCu durationValue = null;
        TmfXmlStateValueCu endTimeValue = null;
        List<Element> timeElements = TmfXmlUtils.getChildElements(node, "segTime");
        if (timeElements.size() > 1) {
            Activator.logWarning("Segment time: there should be only one <segTime> element");
        }
        if (timeElements.size() > 0) {
            Element segTimeElement = Objects.requireNonNull(timeElements.get(0));
            List<Element> beginElements = TmfXmlUtils.getChildElements(segTimeElement, "begin");
            if (beginElements.isEmpty()) {
                Activator.logError("Segment time: there should be one <begin> element to describe segment start time");
                return null;
            }
            if (beginElements.size() > 1) {
                Activator.logWarning("Segment time: there should be only one <begin> element");
            }
            if ((beginTimeValue = TmfXmlStateValueCu.compileValue(analysisData, Objects.requireNonNull(beginElements.get(0)))) == null) {
                return null;
            }
            beginTimeValue = new TmfXmlStateValueCu(new TmfXmlStateValueCu.ValueWrapperGenerator(beginTimeValue, ITmfStateValue.Type.LONG));
            List<Element> durationElements = TmfXmlUtils.getChildElements(segTimeElement, "duration");
            List<Element> endElements = TmfXmlUtils.getChildElements(segTimeElement, "end");
            if (durationElements.isEmpty() && endElements.isEmpty()) {
                Activator.logError("Segment time: there should be either a <duration> or <end> element");
                return null;
            }
            if (!durationElements.isEmpty() && !endElements.isEmpty()) {
                Activator.logError("Segment time: only one of <duration> or <end> shoud be present");
                return null;
            }
            if (durationElements.size() > 1) {
                Activator.logWarning("Segment time: there should be only one <duration> element");
            }
            if (endElements.size() > 1) {
                Activator.logWarning("Segment time: there should be only one <end> element");
            }
            if (!durationElements.isEmpty()) {
                durationValue = TmfXmlStateValueCu.compileValue(analysisData, Objects.requireNonNull(durationElements.get(0)));
                if (durationValue == null) {
                    return null;
                }
                durationValue = new TmfXmlStateValueCu(new TmfXmlStateValueCu.ValueWrapperGenerator(durationValue, ITmfStateValue.Type.LONG));
            } else {
                endTimeValue = TmfXmlStateValueCu.compileValue(analysisData, Objects.requireNonNull(endElements.get(0)));
                if (endTimeValue == null) {
                    return null;
                }
                endTimeValue = new TmfXmlStateValueCu(new TmfXmlStateValueCu.ValueWrapperGenerator(endTimeValue, ITmfStateValue.Type.LONG));
            }
        }
        List<Element> contentElements = TmfXmlUtils.getChildElements(node, "segContent");
        HashMap<String, TmfXmlStateValueCu> fieldMap = new HashMap<String, TmfXmlStateValueCu>();
        for (Element contentEl : contentElements) {
            List<Element> fieldElements = TmfXmlUtils.getChildElements(contentEl, "segField");
            for (Element fieldEl : fieldElements) {
                String name = fieldEl.getAttribute("name");
                if (name.isEmpty()) {
                    Activator.logError("Segment field does not have a name");
                    return null;
                }
                if (fieldMap.containsKey(name)) {
                    Activator.logError("Redefinition of field " + name);
                    return null;
                }
                TmfXmlStateValueCu fieldCu = TmfXmlStateValueCu.compileSegmentField(analysisData, fieldEl);
                if (fieldCu == null) {
                    return null;
                }
                fieldMap.put(name, fieldCu);
            }
        }
        return new TmfXmlActionSegmentCu(segmentTypeValue, beginTimeValue, durationValue, endTimeValue, fieldMap);
    }

    public static TmfXmlActionCu createActionList(List<TmfXmlActionCu> actions) {
        if (actions.size() == 0) {
            return NO_ACTION_CU;
        }
        return actions.size() == 1 ? actions.get(0) : new TmfXmlActionListCu(actions);
    }

    private static class TmfXmlActionListCu
    extends TmfXmlActionCu {
        private final List<TmfXmlActionCu> fActions;

        public TmfXmlActionListCu(List<TmfXmlActionCu> actions) {
            this.fActions = actions;
        }

        @Override
        public DataDrivenAction generate() {
            List<DataDrivenAction> actions = this.fActions.stream().map(TmfXmlActionCu::generate).collect(Collectors.toList());
            return new DataDrivenActionList(actions);
        }
    }

    private static class TmfXmlActionSegmentCu
    extends TmfXmlActionCu {
        private final TmfXmlStateValueCu fType;
        private final @Nullable TmfXmlStateValueCu fStart;
        private final @Nullable TmfXmlStateValueCu fDuration;
        private final @Nullable TmfXmlStateValueCu fEnd;
        private final Map<String, TmfXmlStateValueCu> fFieldMap;

        public TmfXmlActionSegmentCu(TmfXmlStateValueCu segmentTypeValue, @Nullable TmfXmlStateValueCu beginTimeValue, @Nullable TmfXmlStateValueCu durationValue, @Nullable TmfXmlStateValueCu endTimeValue, Map<String, TmfXmlStateValueCu> fieldMap) {
            this.fType = segmentTypeValue;
            this.fStart = beginTimeValue;
            this.fDuration = durationValue;
            this.fEnd = endTimeValue;
            this.fFieldMap = fieldMap;
        }

        @Override
        public DataDrivenAction generate() {
            DataDrivenValue type = this.fType.generate();
            DataDrivenValue start = this.fStart != null ? this.fStart.generate() : null;
            DataDrivenValue end = this.fEnd != null ? this.fEnd.generate() : null;
            DataDrivenValue duration = this.fDuration != null ? this.fDuration.generate() : null;
            HashMap<String, DataDrivenValue> fields = new HashMap<String, DataDrivenValue>();
            for (Map.Entry<String, TmfXmlStateValueCu> fieldEntry : this.fFieldMap.entrySet()) {
                fields.put(fieldEntry.getKey(), fieldEntry.getValue().generate());
            }
            return new DataDrivenActionSegment(type, start, duration, end, fields);
        }
    }

    private static class TmfXmlConditionalStateChangeCu
    extends TmfXmlActionCu {
        private final TmfXmlConditionCu fCondition;
        private final TmfXmlActionCu fThen;
        private final @Nullable TmfXmlActionCu fElse;

        public TmfXmlConditionalStateChangeCu(TmfXmlConditionCu condition, TmfXmlActionCu thenChange, @Nullable TmfXmlActionCu elseChange) {
            this.fCondition = condition;
            this.fThen = thenChange;
            this.fElse = elseChange;
        }

        @Override
        public DataDrivenAction generate() {
            DataDrivenCondition condition = this.fCondition.generate();
            DataDrivenAction thenChange = this.fThen.generate();
            DataDrivenAction elseChange = this.fElse != null ? this.fElse.generate() : null;
            return new DataDrivenActionConditional(condition, thenChange, elseChange);
        }
    }

    private static class TmfXmlStateChangeAssignationCu
    extends TmfXmlActionCu {
        private TmfXmlStateSystemPathCu fPath;
        private TmfXmlStateValueCu fRightOperand;
        private boolean fIncrement;
        private boolean fUpdate;
        private DataDrivenActionStateChange.StackAction fStackAction;
        private @Nullable TmfXmlStateValueCu fFutureTime;

        public TmfXmlStateChangeAssignationCu(TmfXmlStateSystemPathCu path, TmfXmlStateValueCu rightOperandCu, boolean increment, boolean update, DataDrivenActionStateChange.StackAction stackAction, @Nullable TmfXmlStateValueCu futureTime) {
            this.fPath = path;
            this.fRightOperand = rightOperandCu;
            this.fIncrement = increment;
            this.fUpdate = update;
            this.fStackAction = stackAction;
            this.fFutureTime = futureTime;
        }

        @Override
        public DataDrivenAction generate() {
            DataDrivenStateSystemPath path = this.fPath.generate();
            DataDrivenValue rightOperand = this.fRightOperand.generate();
            DataDrivenValue futureTime = null;
            if (this.fFutureTime != null) {
                futureTime = this.fFutureTime.generate();
            }
            return new DataDrivenActionStateChange(path, rightOperand, this.fIncrement, this.fUpdate, this.fStackAction, futureTime);
        }
    }
}

