Object.defineProperty(exports, '__esModule', {
  value: true
});

var _createClass = (function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ('value' in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; })();

var _get = function get(_x, _x2, _x3) { var _again = true; _function: while (_again) { var object = _x, property = _x2, receiver = _x3; _again = false; if (object === null) object = Function.prototype; var desc = Object.getOwnPropertyDescriptor(object, property); if (desc === undefined) { var parent = Object.getPrototypeOf(object); if (parent === null) { return undefined; } else { _x = parent; _x2 = property; _x3 = receiver; _again = true; desc = parent = undefined; continue _function; } } else if ('value' in desc) { return desc.value; } else { var getter = desc.get; if (getter === undefined) { return undefined; } return getter.call(receiver); } } };

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { 'default': obj }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError('Cannot call a class as a function'); } }

function _inherits(subClass, superClass) { if (typeof superClass !== 'function' && superClass !== null) { throw new TypeError('Super expression must either be null or a function, not ' + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }

/** @babel */
/** @jsx etch.dom */

var _fuzzaldrin = require('fuzzaldrin');

var _fuzzaldrin2 = _interopRequireDefault(_fuzzaldrin);

var _etch = require('etch');

var _etch2 = _interopRequireDefault(_etch);

var _underscorePlus = require('underscore-plus');

var _underscorePlus2 = _interopRequireDefault(_underscorePlus);

var _atom = require('atom');

var _collapsibleSectionPanel = require('./collapsible-section-panel');

var _collapsibleSectionPanel2 = _interopRequireDefault(_collapsibleSectionPanel);

var _packageCard = require('./package-card');

var _packageCard2 = _interopRequireDefault(_packageCard);

var _errorView = require('./error-view');

var _errorView2 = _interopRequireDefault(_errorView);

var _list = require('./list');

var _list2 = _interopRequireDefault(_list);

var _listView = require('./list-view');

var _listView2 = _interopRequireDefault(_listView);

var _utils = require('./utils');

var ThemesPanel = (function (_CollapsibleSectionPanel) {
  _inherits(ThemesPanel, _CollapsibleSectionPanel);

  _createClass(ThemesPanel, null, [{
    key: 'loadPackagesDelay',
    value: function loadPackagesDelay() {
      return 300;
    }
  }]);

  function ThemesPanel(settingsView, packageManager) {
    var _this = this;

    _classCallCheck(this, ThemesPanel);

    _get(Object.getPrototypeOf(ThemesPanel.prototype), 'constructor', this).call(this);

    this.settingsView = settingsView;
    this.packageManager = packageManager;
    _etch2['default'].initialize(this);
    this.items = {
      dev: new _list2['default']('name'),
      core: new _list2['default']('name'),
      user: new _list2['default']('name'),
      git: new _list2['default']('name')
    };
    this.itemViews = {
      dev: new _listView2['default'](this.items.dev, this.refs.devPackages, this.createPackageCard.bind(this)),
      core: new _listView2['default'](this.items.core, this.refs.corePackages, this.createPackageCard.bind(this)),
      user: new _listView2['default'](this.items.user, this.refs.communityPackages, this.createPackageCard.bind(this)),
      git: new _listView2['default'](this.items.git, this.refs.gitPackages, this.createPackageCard.bind(this))
    };

    this.disposables = new _atom.CompositeDisposable();
    this.disposables.add(this.packageManager.on('theme-install-failed theme-uninstall-failed', function (_ref) {
      var pack = _ref.pack;
      var error = _ref.error;

      _this.refs.themeErrors.appendChild(new _errorView2['default'](_this.packageManager, error).element);
    }));
    this.disposables.add(this.handleEvents());
    this.disposables.add(atom.commands.add(this.element, {
      'core:move-up': function coreMoveUp() {
        _this.scrollUp();
      },
      'core:move-down': function coreMoveDown() {
        _this.scrollDown();
      },
      'core:page-up': function corePageUp() {
        _this.pageUp();
      },
      'core:page-down': function corePageDown() {
        _this.pageDown();
      },
      'core:move-to-top': function coreMoveToTop() {
        _this.scrollToTop();
      },
      'core:move-to-bottom': function coreMoveToBottom() {
        _this.scrollToBottom();
      }
    }));
    this.loadPackages();

    this.disposables.add(this.packageManager.on('theme-installed theme-uninstalled', function () {
      var loadPackagesTimeout = undefined;
      clearTimeout(loadPackagesTimeout);
      loadPackagesTimeout = setTimeout(function () {
        _this.populateThemeMenus();
        _this.loadPackages();
      }, ThemesPanel.loadPackagesDelay());
    }));

    this.disposables.add(atom.themes.onDidChangeActiveThemes(function () {
      return _this.updateActiveThemes();
    }));
    this.disposables.add(atom.tooltips.add(this.refs.activeUiThemeSettings, { title: 'Settings' }));
    this.disposables.add(atom.tooltips.add(this.refs.activeSyntaxThemeSettings, { title: 'Settings' }));
    this.updateActiveThemes();

    this.disposables.add(this.refs.filterEditor.onDidStopChanging(function () {
      _this.matchPackages();
    }));
  }

  _createClass(ThemesPanel, [{
    key: 'update',
    value: function update() {}
  }, {
    key: 'focus',
    value: function focus() {
      this.refs.filterEditor.element.focus();
    }
  }, {
    key: 'show',
    value: function show() {
      this.element.style.display = '';
    }
  }, {
    key: 'destroy',
    value: function destroy() {
      this.disposables.dispose();
      return _etch2['default'].destroy(this);
    }
  }, {
    key: 'render',
    value: function render() {
      return _etch2['default'].dom(
        'div',
        { className: 'panels-item', tabIndex: '-1' },
        _etch2['default'].dom(
          'div',
          { className: 'section packages themes-panel' },
          _etch2['default'].dom(
            'div',
            { className: 'section-container' },
            _etch2['default'].dom(
              'div',
              { className: 'section-heading icon icon-paintcan' },
              'Choose a Theme'
            ),
            _etch2['default'].dom(
              'div',
              { className: 'text native-key-bindings', tabIndex: '-1' },
              _etch2['default'].dom(
                'span',
                { className: 'icon icon-question' },
                'You can also style Atom by editing '
              ),
              _etch2['default'].dom(
                'a',
                { className: 'link', onclick: this.didClickOpenUserStyleSheet },
                'your stylesheet'
              )
            ),
            _etch2['default'].dom(
              'div',
              { className: 'themes-picker' },
              _etch2['default'].dom(
                'div',
                { className: 'themes-picker-item control-group' },
                _etch2['default'].dom(
                  'div',
                  { className: 'controls' },
                  _etch2['default'].dom(
                    'label',
                    { className: 'control-label' },
                    _etch2['default'].dom(
                      'div',
                      { className: 'setting-title themes-label text' },
                      'UI Theme'
                    ),
                    _etch2['default'].dom(
                      'div',
                      { className: 'setting-description text theme-description' },
                      'This styles the tabs, status bar, tree view, and dropdowns'
                    )
                  ),
                  _etch2['default'].dom(
                    'div',
                    { className: 'select-container' },
                    _etch2['default'].dom('select', { ref: 'uiMenu', className: 'form-control', onchange: this.didChangeUiMenu.bind(this) }),
                    _etch2['default'].dom('button', {
                      ref: 'activeUiThemeSettings',
                      className: 'btn icon icon-gear active-theme-settings',
                      onclick: this.didClickActiveUiThemeSettings.bind(this) })
                  )
                )
              ),
              _etch2['default'].dom(
                'div',
                { className: 'themes-picker-item control-group' },
                _etch2['default'].dom(
                  'div',
                  { className: 'controls' },
                  _etch2['default'].dom(
                    'label',
                    { className: 'control-label' },
                    _etch2['default'].dom(
                      'div',
                      { className: 'setting-title themes-label text' },
                      'Syntax Theme'
                    ),
                    _etch2['default'].dom(
                      'div',
                      { className: 'setting-description text theme-description' },
                      'This styles the text inside the editor'
                    )
                  ),
                  _etch2['default'].dom(
                    'div',
                    { className: 'select-container' },
                    _etch2['default'].dom('select', { ref: 'syntaxMenu', className: 'form-control', onchange: this.didChangeSyntaxMenu.bind(this) }),
                    _etch2['default'].dom('button', {
                      ref: 'activeSyntaxThemeSettings',
                      className: 'btn icon icon-gear active-syntax-settings',
                      onclick: this.didClickActiveSyntaxThemeSettings.bind(this) })
                  )
                )
              )
            )
          )
        ),
        _etch2['default'].dom(
          'section',
          { className: 'section' },
          _etch2['default'].dom(
            'div',
            { className: 'section-container' },
            _etch2['default'].dom(
              'div',
              { className: 'section-heading icon icon-paintcan' },
              'Installed Themes',
              _etch2['default'].dom(
                'span',
                { ref: 'totalPackages', className: 'section-heading-count badge badge-flexible' },
                '…'
              )
            ),
            _etch2['default'].dom(
              'div',
              { className: 'editor-container' },
              _etch2['default'].dom(_atom.TextEditor, { ref: 'filterEditor', mini: true, placeholderText: 'Filter themes by name' })
            ),
            _etch2['default'].dom('div', { ref: 'themeErrors' }),
            _etch2['default'].dom(
              'section',
              { className: 'sub-section installed-packages' },
              _etch2['default'].dom(
                'h3',
                { ref: 'communityThemesHeader', className: 'sub-section-heading icon icon-paintcan' },
                'Community Themes',
                _etch2['default'].dom(
                  'span',
                  { ref: 'communityCount', className: 'section-heading-count badge badge-flexible' },
                  '…'
                )
              ),
              _etch2['default'].dom(
                'div',
                { ref: 'communityPackages', className: 'container package-container' },
                _etch2['default'].dom(
                  'div',
                  { ref: 'communityLoadingArea', className: 'alert alert-info loading-area icon icon-hourglass' },
                  'Loading themes…'
                )
              )
            ),
            _etch2['default'].dom(
              'section',
              { className: 'sub-section core-packages' },
              _etch2['default'].dom(
                'h3',
                { ref: 'coreThemesHeader', className: 'sub-section-heading icon icon-paintcan' },
                'Core Themes',
                _etch2['default'].dom(
                  'span',
                  { ref: 'coreCount', className: 'section-heading-count badge badge-flexible' },
                  '…'
                )
              ),
              _etch2['default'].dom(
                'div',
                { ref: 'corePackages', className: 'container package-container' },
                _etch2['default'].dom(
                  'div',
                  { ref: 'coreLoadingArea', className: 'alert alert-info loading-area icon icon-hourglass' },
                  'Loading themes…'
                )
              )
            ),
            _etch2['default'].dom(
              'section',
              { className: 'sub-section dev-packages' },
              _etch2['default'].dom(
                'h3',
                { ref: 'developmentThemesHeader', className: 'sub-section-heading icon icon-paintcan' },
                'Development Themes',
                _etch2['default'].dom(
                  'span',
                  { ref: 'devCount', className: 'section-heading-count badge badge-flexible' },
                  '…'
                )
              ),
              _etch2['default'].dom(
                'div',
                { ref: 'devPackages', className: 'container package-container' },
                _etch2['default'].dom(
                  'div',
                  { ref: 'devLoadingArea', className: 'alert alert-info loading-area icon icon-hourglass' },
                  'Loading themes…'
                )
              )
            ),
            _etch2['default'].dom(
              'section',
              { className: 'sub-section git-packages' },
              _etch2['default'].dom(
                'h3',
                { ref: 'gitThemesHeader', className: 'sub-section-heading icon icon-paintcan' },
                'Git Themes',
                _etch2['default'].dom(
                  'span',
                  { ref: 'gitCount', className: 'section-heading-count badge badge-flexible' },
                  '…'
                )
              ),
              _etch2['default'].dom(
                'div',
                { ref: 'gitPackages', className: 'container package-container' },
                _etch2['default'].dom(
                  'div',
                  { ref: 'gitLoadingArea', className: 'alert alert-info loading-area icon icon-hourglass' },
                  'Loading themes…'
                )
              )
            )
          )
        )
      );
    }
  }, {
    key: 'filterThemes',
    value: function filterThemes(packages) {
      packages.dev = packages.dev.filter(function (_ref2) {
        var theme = _ref2.theme;
        return theme;
      });
      packages.user = packages.user.filter(function (_ref3) {
        var theme = _ref3.theme;
        return theme;
      });
      packages.core = packages.core.filter(function (_ref4) {
        var theme = _ref4.theme;
        return theme;
      });
      packages.git = (packages.git || []).filter(function (_ref5) {
        var theme = _ref5.theme;
        return theme;
      });

      for (var pack of packages.core) {
        if (pack.repository == null) {
          pack.repository = 'https://github.com/atom/' + pack.name;
        }
      }

      for (var packageType of ['dev', 'core', 'user', 'git']) {
        for (var pack of packages[packageType]) {
          pack.owner = (0, _utils.ownerFromRepository)(pack.repository);
        }
      }
      return packages;
    }
  }, {
    key: 'sortThemes',
    value: function sortThemes(packages) {
      packages.dev.sort(_utils.packageComparatorAscending);
      packages.core.sort(_utils.packageComparatorAscending);
      packages.user.sort(_utils.packageComparatorAscending);
      packages.git.sort(_utils.packageComparatorAscending);
      return packages;
    }
  }, {
    key: 'loadPackages',
    value: function loadPackages() {
      var _this2 = this;

      this.packageViews = [];
      this.packageManager.getInstalled().then(function (packages) {
        _this2.packages = _this2.sortThemes(_this2.filterThemes(packages));

        _this2.refs.devLoadingArea.remove();
        _this2.items.dev.setItems(_this2.packages.dev);

        _this2.refs.coreLoadingArea.remove();
        _this2.items.core.setItems(_this2.packages.core);

        _this2.refs.communityLoadingArea.remove();
        _this2.items.user.setItems(_this2.packages.user);

        _this2.refs.gitLoadingArea.remove();
        _this2.items.git.setItems(_this2.packages.git);

        // TODO show empty mesage per section

        _this2.updateSectionCounts();
      })['catch'](function (error) {
        _this2.refs.themeErrors.appendChild(new _errorView2['default'](_this2.packageManager, error).element);
      });
    }

    // Update the active UI and syntax themes and populate the menu
  }, {
    key: 'updateActiveThemes',
    value: function updateActiveThemes() {
      this.activeUiTheme = this.getActiveUiTheme();
      this.activeSyntaxTheme = this.getActiveSyntaxTheme();
      this.populateThemeMenus();
      this.toggleActiveThemeButtons();
    }
  }, {
    key: 'toggleActiveThemeButtons',
    value: function toggleActiveThemeButtons() {
      if (this.hasSettings(this.activeUiTheme)) {
        this.refs.activeUiThemeSettings.style.display = '';
      } else {
        this.refs.activeUiThemeSettings.style.display = 'none';
      }

      if (this.hasSettings(this.activeSyntaxTheme)) {
        this.refs.activeSyntaxThemeSettings.display = '';
      } else {
        this.refs.activeSyntaxThemeSettings.display = 'none';
      }
    }
  }, {
    key: 'hasSettings',
    value: function hasSettings(packageName) {
      return this.packageManager.packageHasSettings(packageName);
    }

    // Populate the theme menus from the theme manager's active themes
  }, {
    key: 'populateThemeMenus',
    value: function populateThemeMenus() {
      this.refs.uiMenu.innerHTML = '';
      this.refs.syntaxMenu.innerHTML = '';
      var availableThemes = _underscorePlus2['default'].sortBy(atom.themes.getLoadedThemes(), 'name');
      for (var _ref62 of availableThemes) {
        var _name = _ref62.name;
        var metadata = _ref62.metadata;

        switch (metadata.theme) {
          case 'ui':
            {
              var themeItem = this.createThemeMenuItem(_name);
              if (_name === this.activeUiTheme) {
                themeItem.selected = true;
              }
              this.refs.uiMenu.appendChild(themeItem);
              break;
            }
          case 'syntax':
            {
              var themeItem = this.createThemeMenuItem(_name);
              if (_name === this.activeSyntaxTheme) {
                themeItem.selected = true;
              }
              this.refs.syntaxMenu.appendChild(themeItem);
              break;
            }
        }
      }
    }

    // Get the name of the active ui theme.
  }, {
    key: 'getActiveUiTheme',
    value: function getActiveUiTheme() {
      for (var _ref72 of atom.themes.getActiveThemes()) {
        var _name2 = _ref72.name;
        var metadata = _ref72.metadata;

        if (metadata.theme === 'ui') {
          return _name2;
        }
      }
      return null;
    }

    // Get the name of the active syntax theme.
  }, {
    key: 'getActiveSyntaxTheme',
    value: function getActiveSyntaxTheme() {
      for (var _ref82 of atom.themes.getActiveThemes()) {
        var _name3 = _ref82.name;
        var metadata = _ref82.metadata;

        if (metadata.theme === 'syntax') {
          return _name3;
        }
      }
      return null;
    }

    // Update the config with the selected themes
  }, {
    key: 'updateThemeConfig',
    value: function updateThemeConfig() {
      var themes = [];
      if (this.activeUiTheme) {
        themes.push(this.activeUiTheme);
      }
      if (this.activeSyntaxTheme) {
        themes.push(this.activeSyntaxTheme);
      }
      if (themes.length > 0) {
        atom.config.set('core.themes', themes);
      }
    }
  }, {
    key: 'scheduleUpdateThemeConfig',
    value: function scheduleUpdateThemeConfig() {
      var _this3 = this;

      setTimeout(function () {
        _this3.updateThemeConfig();
      }, 100);
    }

    // Create a menu item for the given theme name.
  }, {
    key: 'createThemeMenuItem',
    value: function createThemeMenuItem(themeName) {
      var title = _underscorePlus2['default'].undasherize(_underscorePlus2['default'].uncamelcase(themeName.replace(/-(ui|syntax)/g, '').replace(/-theme$/g, '')));
      var option = document.createElement('option');
      option.value = themeName;
      option.textContent = title;
      return option;
    }
  }, {
    key: 'createPackageCard',
    value: function createPackageCard(pack) {
      return new _packageCard2['default'](pack, this.settingsView, this.packageManager, { back: 'Themes' });
    }
  }, {
    key: 'filterPackageListByText',
    value: function filterPackageListByText(text) {
      if (!this.packages) {
        return;
      }

      for (var packageType of ['dev', 'core', 'user', 'git']) {
        var allViews = this.itemViews[packageType].getViews();
        var activeViews = this.itemViews[packageType].filterViews(function (pack) {
          if (text === '') {
            return true;
          } else {
            var owner = pack.owner != null ? pack.owner : (0, _utils.ownerFromRepository)(pack.repository);
            var filterText = pack.name + ' ' + owner;
            return _fuzzaldrin2['default'].score(filterText, text) > 0;
          }
        });

        for (var view of allViews) {
          if (view) {
            view.element.style.display = 'none';
            view.element.classList.add('hidden');
          }
        }

        for (var view of activeViews) {
          if (view) {
            view.element.style.display = '';
            view.element.classList.remove('hidden');
          }
        }
      }

      this.updateSectionCounts();
    }
  }, {
    key: 'updateUnfilteredSectionCounts',
    value: function updateUnfilteredSectionCounts() {
      this.updateSectionCount(this.refs.communityThemesHeader, this.refs.communityCount, this.packages.user.length);
      this.updateSectionCount(this.refs.coreThemesHeader, this.refs.coreCount, this.packages.core.length);
      this.updateSectionCount(this.refs.developmentThemesHeader, this.refs.devCount, this.packages.dev.length);
      this.updateSectionCount(this.refs.gitThemesHeader, this.refs.gitCount, this.packages.git.length);

      this.refs.totalPackages.textContent = '' + (this.packages.user.length + this.packages.core.length + this.packages.dev.length + this.packages.git.length);
    }
  }, {
    key: 'updateFilteredSectionCounts',
    value: function updateFilteredSectionCounts() {
      var community = this.notHiddenCardsLength(this.refs.communityPackages);
      this.updateSectionCount(this.refs.communityThemesHeader, this.refs.communityCount, community, this.packages.user.length);

      var dev = this.notHiddenCardsLength(this.refs.devPackages);
      this.updateSectionCount(this.refs.developmentThemesHeader, this.refs.devCount, dev, this.packages.dev.length);

      var core = this.notHiddenCardsLength(this.refs.corePackages);
      this.updateSectionCount(this.refs.coreThemesHeader, this.refs.coreCount, core, this.packages.core.length);

      var git = this.notHiddenCardsLength(this.refs.gitPackages);
      this.updateSectionCount(this.refs.gitThemesHeader, this.refs.gitCount, git, this.packages.git.length);

      var shownThemes = dev + core + community + git;
      var totalThemes = this.packages.user.length + this.packages.core.length + this.packages.dev.length + this.packages.git.length;
      this.refs.totalPackages.textContent = shownThemes + '/' + totalThemes;
    }
  }, {
    key: 'resetSectionHasItems',
    value: function resetSectionHasItems() {
      this.resetCollapsibleSections([this.refs.communityThemesHeader, this.refs.coreThemesHeader, this.refs.developmentThemesHeader, this.refs.gitThemesHeader]);
    }
  }, {
    key: 'matchPackages',
    value: function matchPackages() {
      this.filterPackageListByText(this.refs.filterEditor.getText());
    }
  }, {
    key: 'didClickOpenUserStyleSheet',
    value: function didClickOpenUserStyleSheet(e) {
      e.preventDefault();
      atom.commands.dispatch(atom.views.getView(atom.workspace), 'application:open-your-stylesheet');
    }
  }, {
    key: 'didChangeUiMenu',
    value: function didChangeUiMenu() {
      this.activeUiTheme = this.refs.uiMenu.value;
      this.scheduleUpdateThemeConfig();
    }
  }, {
    key: 'didChangeSyntaxMenu',
    value: function didChangeSyntaxMenu() {
      this.activeSyntaxTheme = this.refs.syntaxMenu.value;
      this.scheduleUpdateThemeConfig();
    }
  }, {
    key: 'didClickActiveUiThemeSettings',
    value: function didClickActiveUiThemeSettings(event) {
      event.stopPropagation();
      var theme = atom.themes.getActiveThemes().find(function (theme) {
        return theme.metadata.theme === 'ui';
      });
      var activeUiTheme = theme != null ? theme.metadata : null;
      if (activeUiTheme != null) {
        this.settingsView.showPanel(this.activeUiTheme, {
          back: 'Themes',
          pack: activeUiTheme
        });
      }
    }
  }, {
    key: 'didClickActiveSyntaxThemeSettings',
    value: function didClickActiveSyntaxThemeSettings(event) {
      event.stopPropagation();
      var theme = atom.themes.getActiveThemes().find(function (theme) {
        return theme.metadata.theme === 'syntax';
      });
      var activeSyntaxTheme = theme != null ? theme.metadata : null;
      if (activeSyntaxTheme != null) {
        this.settingsView.showPanel(this.activeSyntaxTheme, {
          back: 'Themes',
          pack: activeSyntaxTheme
        });
      }
    }
  }, {
    key: 'scrollUp',
    value: function scrollUp() {
      this.element.scrollTop -= document.body.offsetHeight / 20;
    }
  }, {
    key: 'scrollDown',
    value: function scrollDown() {
      this.element.scrollTop += document.body.offsetHeight / 20;
    }
  }, {
    key: 'pageUp',
    value: function pageUp() {
      this.element.scrollTop -= this.element.offsetHeight;
    }
  }, {
    key: 'pageDown',
    value: function pageDown() {
      this.element.scrollTop += this.element.offsetHeight;
    }
  }, {
    key: 'scrollToTop',
    value: function scrollToTop() {
      this.element.scrollTop = 0;
    }
  }, {
    key: 'scrollToBottom',
    value: function scrollToBottom() {
      this.element.scrollTop = this.element.scrollHeight;
    }
  }]);

  return ThemesPanel;
})(_collapsibleSectionPanel2['default']);

exports['default'] = ThemesPanel;
module.exports = exports['default'];
//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbIi9idWlsZC9hdG9tL3NyYy9hdG9tLTEuMzYuMS9vdXQvYXBwL25vZGVfbW9kdWxlcy9zZXR0aW5ncy12aWV3L2xpYi90aGVtZXMtcGFuZWwuanMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6Ijs7Ozs7Ozs7Ozs7Ozs7Ozs7MEJBR3VCLFlBQVk7Ozs7b0JBQ2xCLE1BQU07Ozs7OEJBQ1QsaUJBQWlCOzs7O29CQUNlLE1BQU07O3VDQUVoQiw2QkFBNkI7Ozs7MkJBQ3pDLGdCQUFnQjs7Ozt5QkFDbEIsY0FBYzs7OztvQkFFbkIsUUFBUTs7Ozt3QkFDSixhQUFhOzs7O3FCQUM0QixTQUFTOztJQUVsRCxXQUFXO1lBQVgsV0FBVzs7ZUFBWCxXQUFXOztXQUNMLDZCQUFHO0FBQzFCLGFBQU8sR0FBRyxDQUFBO0tBQ1g7OztBQUVXLFdBTE8sV0FBVyxDQUtqQixZQUFZLEVBQUUsY0FBYyxFQUFFOzs7MEJBTHhCLFdBQVc7O0FBTTVCLCtCQU5pQixXQUFXLDZDQU1yQjs7QUFFUCxRQUFJLENBQUMsWUFBWSxHQUFHLFlBQVksQ0FBQTtBQUNoQyxRQUFJLENBQUMsY0FBYyxHQUFHLGNBQWMsQ0FBQTtBQUNwQyxzQkFBSyxVQUFVLENBQUMsSUFBSSxDQUFDLENBQUE7QUFDckIsUUFBSSxDQUFDLEtBQUssR0FBRztBQUNYLFNBQUcsRUFBRSxzQkFBUyxNQUFNLENBQUM7QUFDckIsVUFBSSxFQUFFLHNCQUFTLE1BQU0sQ0FBQztBQUN0QixVQUFJLEVBQUUsc0JBQVMsTUFBTSxDQUFDO0FBQ3RCLFNBQUcsRUFBRSxzQkFBUyxNQUFNLENBQUM7S0FDdEIsQ0FBQTtBQUNELFFBQUksQ0FBQyxTQUFTLEdBQUc7QUFDZixTQUFHLEVBQUUsMEJBQWEsSUFBSSxDQUFDLEtBQUssQ0FBQyxHQUFHLEVBQUUsSUFBSSxDQUFDLElBQUksQ0FBQyxXQUFXLEVBQUUsSUFBSSxDQUFDLGlCQUFpQixDQUFDLElBQUksQ0FBQyxJQUFJLENBQUMsQ0FBQztBQUMzRixVQUFJLEVBQUUsMEJBQWEsSUFBSSxDQUFDLEtBQUssQ0FBQyxJQUFJLEVBQUUsSUFBSSxDQUFDLElBQUksQ0FBQyxZQUFZLEVBQUUsSUFBSSxDQUFDLGlCQUFpQixDQUFDLElBQUksQ0FBQyxJQUFJLENBQUMsQ0FBQztBQUM5RixVQUFJLEVBQUUsMEJBQWEsSUFBSSxDQUFDLEtBQUssQ0FBQyxJQUFJLEVBQUUsSUFBSSxDQUFDLElBQUksQ0FBQyxpQkFBaUIsRUFBRSxJQUFJLENBQUMsaUJBQWlCLENBQUMsSUFBSSxDQUFDLElBQUksQ0FBQyxDQUFDO0FBQ25HLFNBQUcsRUFBRSwwQkFBYSxJQUFJLENBQUMsS0FBSyxDQUFDLEdBQUcsRUFBRSxJQUFJLENBQUMsSUFBSSxDQUFDLFdBQVcsRUFBRSxJQUFJLENBQUMsaUJBQWlCLENBQUMsSUFBSSxDQUFDLElBQUksQ0FBQyxDQUFDO0tBQzVGLENBQUE7O0FBRUQsUUFBSSxDQUFDLFdBQVcsR0FBRywrQkFBeUIsQ0FBQTtBQUM1QyxRQUFJLENBQUMsV0FBVyxDQUFDLEdBQUcsQ0FDbEIsSUFBSSxDQUFDLGNBQWMsQ0FBQyxFQUFFLENBQUMsNkNBQTZDLEVBQUUsVUFBQyxJQUFhLEVBQUs7VUFBakIsSUFBSSxHQUFMLElBQWEsQ0FBWixJQUFJO1VBQUUsS0FBSyxHQUFaLElBQWEsQ0FBTixLQUFLOztBQUNqRixZQUFLLElBQUksQ0FBQyxXQUFXLENBQUMsV0FBVyxDQUFDLDJCQUFjLE1BQUssY0FBYyxFQUFFLEtBQUssQ0FBQyxDQUFDLE9BQU8sQ0FBQyxDQUFBO0tBQ3JGLENBQUMsQ0FDSCxDQUFBO0FBQ0QsUUFBSSxDQUFDLFdBQVcsQ0FBQyxHQUFHLENBQUMsSUFBSSxDQUFDLFlBQVksRUFBRSxDQUFDLENBQUE7QUFDekMsUUFBSSxDQUFDLFdBQVcsQ0FBQyxHQUFHLENBQUMsSUFBSSxDQUFDLFFBQVEsQ0FBQyxHQUFHLENBQUMsSUFBSSxDQUFDLE9BQU8sRUFBRTtBQUNuRCxvQkFBYyxFQUFFLHNCQUFNO0FBQUUsY0FBSyxRQUFRLEVBQUUsQ0FBQTtPQUFFO0FBQ3pDLHNCQUFnQixFQUFFLHdCQUFNO0FBQUUsY0FBSyxVQUFVLEVBQUUsQ0FBQTtPQUFFO0FBQzdDLG9CQUFjLEVBQUUsc0JBQU07QUFBRSxjQUFLLE1BQU0sRUFBRSxDQUFBO09BQUU7QUFDdkMsc0JBQWdCLEVBQUUsd0JBQU07QUFBRSxjQUFLLFFBQVEsRUFBRSxDQUFBO09BQUU7QUFDM0Msd0JBQWtCLEVBQUUseUJBQU07QUFBRSxjQUFLLFdBQVcsRUFBRSxDQUFBO09BQUU7QUFDaEQsMkJBQXFCLEVBQUUsNEJBQU07QUFBRSxjQUFLLGNBQWMsRUFBRSxDQUFBO09BQUU7S0FDdkQsQ0FBQyxDQUFDLENBQUE7QUFDSCxRQUFJLENBQUMsWUFBWSxFQUFFLENBQUE7O0FBRW5CLFFBQUksQ0FBQyxXQUFXLENBQUMsR0FBRyxDQUNsQixJQUFJLENBQUMsY0FBYyxDQUFDLEVBQUUsQ0FBQyxtQ0FBbUMsRUFBRSxZQUFNO0FBQ2hFLFVBQUksbUJBQW1CLFlBQUEsQ0FBQTtBQUN2QixrQkFBWSxDQUFDLG1CQUFtQixDQUFDLENBQUE7QUFDakMseUJBQW1CLEdBQUcsVUFBVSxDQUFDLFlBQU07QUFDckMsY0FBSyxrQkFBa0IsRUFBRSxDQUFBO0FBQ3pCLGNBQUssWUFBWSxFQUFFLENBQUE7T0FDcEIsRUFBRSxXQUFXLENBQUMsaUJBQWlCLEVBQUUsQ0FBQyxDQUFBO0tBQ3BDLENBQUMsQ0FDSCxDQUFBOztBQUVELFFBQUksQ0FBQyxXQUFXLENBQUMsR0FBRyxDQUFDLElBQUksQ0FBQyxNQUFNLENBQUMsdUJBQXVCLENBQUM7YUFBTSxNQUFLLGtCQUFrQixFQUFFO0tBQUEsQ0FBQyxDQUFDLENBQUE7QUFDMUYsUUFBSSxDQUFDLFdBQVcsQ0FBQyxHQUFHLENBQUMsSUFBSSxDQUFDLFFBQVEsQ0FBQyxHQUFHLENBQUMsSUFBSSxDQUFDLElBQUksQ0FBQyxxQkFBcUIsRUFBRSxFQUFDLEtBQUssRUFBRSxVQUFVLEVBQUMsQ0FBQyxDQUFDLENBQUE7QUFDN0YsUUFBSSxDQUFDLFdBQVcsQ0FBQyxHQUFHLENBQUMsSUFBSSxDQUFDLFFBQVEsQ0FBQyxHQUFHLENBQUMsSUFBSSxDQUFDLElBQUksQ0FBQyx5QkFBeUIsRUFBRSxFQUFDLEtBQUssRUFBRSxVQUFVLEVBQUMsQ0FBQyxDQUFDLENBQUE7QUFDakcsUUFBSSxDQUFDLGtCQUFrQixFQUFFLENBQUE7O0FBRXpCLFFBQUksQ0FBQyxXQUFXLENBQUMsR0FBRyxDQUFDLElBQUksQ0FBQyxJQUFJLENBQUMsWUFBWSxDQUFDLGlCQUFpQixDQUFDLFlBQU07QUFBRSxZQUFLLGFBQWEsRUFBRSxDQUFBO0tBQUUsQ0FBQyxDQUFDLENBQUE7R0FDL0Y7O2VBMURrQixXQUFXOztXQTREdkIsa0JBQUcsRUFBRTs7O1dBRU4saUJBQUc7QUFDUCxVQUFJLENBQUMsSUFBSSxDQUFDLFlBQVksQ0FBQyxPQUFPLENBQUMsS0FBSyxFQUFFLENBQUE7S0FDdkM7OztXQUVJLGdCQUFHO0FBQ04sVUFBSSxDQUFDLE9BQU8sQ0FBQyxLQUFLLENBQUMsT0FBTyxHQUFHLEVBQUUsQ0FBQTtLQUNoQzs7O1dBRU8sbUJBQUc7QUFDVCxVQUFJLENBQUMsV0FBVyxDQUFDLE9BQU8sRUFBRSxDQUFBO0FBQzFCLGFBQU8sa0JBQUssT0FBTyxDQUFDLElBQUksQ0FBQyxDQUFBO0tBQzFCOzs7V0FFTSxrQkFBRztBQUNSLGFBQ0U7O1VBQUssU0FBUyxFQUFDLGFBQWEsRUFBQyxRQUFRLEVBQUMsSUFBSTtRQUN4Qzs7WUFBSyxTQUFTLEVBQUMsK0JBQStCO1VBQzVDOztjQUFLLFNBQVMsRUFBQyxtQkFBbUI7WUFDaEM7O2dCQUFLLFNBQVMsRUFBQyxvQ0FBb0M7O2FBQXFCO1lBRXhFOztnQkFBSyxTQUFTLEVBQUMsMEJBQTBCLEVBQUMsUUFBUSxFQUFDLElBQUk7Y0FDckQ7O2tCQUFNLFNBQVMsRUFBQyxvQkFBb0I7O2VBQTJDO2NBQy9FOztrQkFBRyxTQUFTLEVBQUMsTUFBTSxFQUFDLE9BQU8sRUFBRSxJQUFJLENBQUMsMEJBQTBCLEFBQUM7O2VBQW9CO2FBQzdFO1lBRU47O2dCQUFLLFNBQVMsRUFBQyxlQUFlO2NBQzVCOztrQkFBSyxTQUFTLEVBQUMsa0NBQWtDO2dCQUMvQzs7b0JBQUssU0FBUyxFQUFDLFVBQVU7a0JBQ3ZCOztzQkFBTyxTQUFTLEVBQUMsZUFBZTtvQkFDOUI7O3dCQUFLLFNBQVMsRUFBQyxpQ0FBaUM7O3FCQUFlO29CQUMvRDs7d0JBQUssU0FBUyxFQUFDLDRDQUE0Qzs7cUJBQWlFO21CQUN0SDtrQkFDUjs7c0JBQUssU0FBUyxFQUFDLGtCQUFrQjtvQkFDL0Isa0NBQVEsR0FBRyxFQUFDLFFBQVEsRUFBQyxTQUFTLEVBQUMsY0FBYyxFQUFDLFFBQVEsRUFBRSxJQUFJLENBQUMsZUFBZSxDQUFDLElBQUksQ0FBQyxJQUFJLENBQUMsQUFBQyxHQUFHO29CQUMzRjtBQUNFLHlCQUFHLEVBQUMsdUJBQXVCO0FBQzNCLCtCQUFTLEVBQUMsMENBQTBDO0FBQ3BELDZCQUFPLEVBQUUsSUFBSSxDQUFDLDZCQUE2QixDQUFDLElBQUksQ0FBQyxJQUFJLENBQUMsQUFBQyxHQUFHO21CQUN4RDtpQkFDRjtlQUNGO2NBRU47O2tCQUFLLFNBQVMsRUFBQyxrQ0FBa0M7Z0JBQy9DOztvQkFBSyxTQUFTLEVBQUMsVUFBVTtrQkFDdkI7O3NCQUFPLFNBQVMsRUFBQyxlQUFlO29CQUM5Qjs7d0JBQUssU0FBUyxFQUFDLGlDQUFpQzs7cUJBQW1CO29CQUNuRTs7d0JBQUssU0FBUyxFQUFDLDRDQUE0Qzs7cUJBQTZDO21CQUNsRztrQkFDUjs7c0JBQUssU0FBUyxFQUFDLGtCQUFrQjtvQkFDL0Isa0NBQVEsR0FBRyxFQUFDLFlBQVksRUFBQyxTQUFTLEVBQUMsY0FBYyxFQUFDLFFBQVEsRUFBRSxJQUFJLENBQUMsbUJBQW1CLENBQUMsSUFBSSxDQUFDLElBQUksQ0FBQyxBQUFDLEdBQUc7b0JBQ25HO0FBQ0UseUJBQUcsRUFBQywyQkFBMkI7QUFDL0IsK0JBQVMsRUFBQywyQ0FBMkM7QUFDckQsNkJBQU8sRUFBRSxJQUFJLENBQUMsaUNBQWlDLENBQUMsSUFBSSxDQUFDLElBQUksQ0FBQyxBQUFDLEdBQUc7bUJBQzVEO2lCQUNGO2VBQ0Y7YUFDRjtXQUNGO1NBQ0Y7UUFFTjs7WUFBUyxTQUFTLEVBQUMsU0FBUztVQUMxQjs7Y0FBSyxTQUFTLEVBQUMsbUJBQW1CO1lBQ2hDOztnQkFBSyxTQUFTLEVBQUMsb0NBQW9DOztjQUVqRDs7a0JBQU0sR0FBRyxFQUFDLGVBQWUsRUFBQyxTQUFTLEVBQUMsNENBQTRDOztlQUFTO2FBQ3JGO1lBQ047O2dCQUFLLFNBQVMsRUFBQyxrQkFBa0I7Y0FDL0IsMENBQVksR0FBRyxFQUFDLGNBQWMsRUFBQyxJQUFJLE1BQUEsRUFBQyxlQUFlLEVBQUMsdUJBQXVCLEdBQUc7YUFDMUU7WUFFTiwrQkFBSyxHQUFHLEVBQUMsYUFBYSxHQUFHO1lBRXpCOztnQkFBUyxTQUFTLEVBQUMsZ0NBQWdDO2NBQ2pEOztrQkFBSSxHQUFHLEVBQUMsdUJBQXVCLEVBQUMsU0FBUyxFQUFDLHdDQUF3Qzs7Z0JBRWhGOztvQkFBTSxHQUFHLEVBQUMsZ0JBQWdCLEVBQUMsU0FBUyxFQUFDLDRDQUE0Qzs7aUJBQVM7ZUFDdkY7Y0FDTDs7a0JBQUssR0FBRyxFQUFDLG1CQUFtQixFQUFDLFNBQVMsRUFBQyw2QkFBNkI7Z0JBQ2xFOztvQkFBSyxHQUFHLEVBQUMsc0JBQXNCLEVBQUMsU0FBUyxFQUFDLG1EQUFtRDs7aUJBQXNCO2VBQy9HO2FBQ0U7WUFFVjs7Z0JBQVMsU0FBUyxFQUFDLDJCQUEyQjtjQUM1Qzs7a0JBQUksR0FBRyxFQUFDLGtCQUFrQixFQUFDLFNBQVMsRUFBQyx3Q0FBd0M7O2dCQUUzRTs7b0JBQU0sR0FBRyxFQUFDLFdBQVcsRUFBQyxTQUFTLEVBQUMsNENBQTRDOztpQkFBUztlQUNsRjtjQUNMOztrQkFBSyxHQUFHLEVBQUMsY0FBYyxFQUFDLFNBQVMsRUFBQyw2QkFBNkI7Z0JBQzdEOztvQkFBSyxHQUFHLEVBQUMsaUJBQWlCLEVBQUMsU0FBUyxFQUFDLG1EQUFtRDs7aUJBQXNCO2VBQzFHO2FBQ0U7WUFFVjs7Z0JBQVMsU0FBUyxFQUFDLDBCQUEwQjtjQUMzQzs7a0JBQUksR0FBRyxFQUFDLHlCQUF5QixFQUFDLFNBQVMsRUFBQyx3Q0FBd0M7O2dCQUVsRjs7b0JBQU0sR0FBRyxFQUFDLFVBQVUsRUFBQyxTQUFTLEVBQUMsNENBQTRDOztpQkFBUztlQUNqRjtjQUNMOztrQkFBSyxHQUFHLEVBQUMsYUFBYSxFQUFDLFNBQVMsRUFBQyw2QkFBNkI7Z0JBQzVEOztvQkFBSyxHQUFHLEVBQUMsZ0JBQWdCLEVBQUMsU0FBUyxFQUFDLG1EQUFtRDs7aUJBQXNCO2VBQ3pHO2FBQ0U7WUFFVjs7Z0JBQVMsU0FBUyxFQUFDLDBCQUEwQjtjQUMzQzs7a0JBQUksR0FBRyxFQUFDLGlCQUFpQixFQUFDLFNBQVMsRUFBQyx3Q0FBd0M7O2dCQUUxRTs7b0JBQU0sR0FBRyxFQUFDLFVBQVUsRUFBQyxTQUFTLEVBQUMsNENBQTRDOztpQkFBUztlQUNqRjtjQUNMOztrQkFBSyxHQUFHLEVBQUMsYUFBYSxFQUFDLFNBQVMsRUFBQyw2QkFBNkI7Z0JBQzVEOztvQkFBSyxHQUFHLEVBQUMsZ0JBQWdCLEVBQUMsU0FBUyxFQUFDLG1EQUFtRDs7aUJBQXNCO2VBQ3pHO2FBQ0U7V0FDTjtTQUNFO09BQ04sQ0FDUDtLQUNGOzs7V0FFWSxzQkFBQyxRQUFRLEVBQUU7QUFDdEIsY0FBUSxDQUFDLEdBQUcsR0FBRyxRQUFRLENBQUMsR0FBRyxDQUFDLE1BQU0sQ0FBQyxVQUFDLEtBQU87WUFBTixLQUFLLEdBQU4sS0FBTyxDQUFOLEtBQUs7ZUFBTSxLQUFLO09BQUEsQ0FBQyxDQUFBO0FBQ3RELGNBQVEsQ0FBQyxJQUFJLEdBQUcsUUFBUSxDQUFDLElBQUksQ0FBQyxNQUFNLENBQUMsVUFBQyxLQUFPO1lBQU4sS0FBSyxHQUFOLEtBQU8sQ0FBTixLQUFLO2VBQU0sS0FBSztPQUFBLENBQUMsQ0FBQTtBQUN4RCxjQUFRLENBQUMsSUFBSSxHQUFHLFFBQVEsQ0FBQyxJQUFJLENBQUMsTUFBTSxDQUFDLFVBQUMsS0FBTztZQUFOLEtBQUssR0FBTixLQUFPLENBQU4sS0FBSztlQUFNLEtBQUs7T0FBQSxDQUFDLENBQUE7QUFDeEQsY0FBUSxDQUFDLEdBQUcsR0FBRyxDQUFDLFFBQVEsQ0FBQyxHQUFHLElBQUksRUFBRSxDQUFBLENBQUUsTUFBTSxDQUFDLFVBQUMsS0FBTztZQUFOLEtBQUssR0FBTixLQUFPLENBQU4sS0FBSztlQUFNLEtBQUs7T0FBQSxDQUFDLENBQUE7O0FBRTlELFdBQUssSUFBSSxJQUFJLElBQUksUUFBUSxDQUFDLElBQUksRUFBRTtBQUM5QixZQUFJLElBQUksQ0FBQyxVQUFVLElBQUksSUFBSSxFQUFFO0FBQzNCLGNBQUksQ0FBQyxVQUFVLGdDQUE4QixJQUFJLENBQUMsSUFBSSxBQUFFLENBQUE7U0FDekQ7T0FDRjs7QUFFRCxXQUFLLElBQUksV0FBVyxJQUFJLENBQUMsS0FBSyxFQUFFLE1BQU0sRUFBRSxNQUFNLEVBQUUsS0FBSyxDQUFDLEVBQUU7QUFDdEQsYUFBSyxJQUFJLElBQUksSUFBSSxRQUFRLENBQUMsV0FBVyxDQUFDLEVBQUU7QUFDdEMsY0FBSSxDQUFDLEtBQUssR0FBRyxnQ0FBb0IsSUFBSSxDQUFDLFVBQVUsQ0FBQyxDQUFBO1NBQ2xEO09BQ0Y7QUFDRCxhQUFPLFFBQVEsQ0FBQTtLQUNoQjs7O1dBRVUsb0JBQUMsUUFBUSxFQUFFO0FBQ3BCLGNBQVEsQ0FBQyxHQUFHLENBQUMsSUFBSSxtQ0FBNEIsQ0FBQTtBQUM3QyxjQUFRLENBQUMsSUFBSSxDQUFDLElBQUksbUNBQTRCLENBQUE7QUFDOUMsY0FBUSxDQUFDLElBQUksQ0FBQyxJQUFJLG1DQUE0QixDQUFBO0FBQzlDLGNBQVEsQ0FBQyxHQUFHLENBQUMsSUFBSSxtQ0FBNEIsQ0FBQTtBQUM3QyxhQUFPLFFBQVEsQ0FBQTtLQUNoQjs7O1dBRVksd0JBQUc7OztBQUNkLFVBQUksQ0FBQyxZQUFZLEdBQUcsRUFBRSxDQUFBO0FBQ3RCLFVBQUksQ0FBQyxjQUFjLENBQUMsWUFBWSxFQUFFLENBQUMsSUFBSSxDQUFDLFVBQUEsUUFBUSxFQUFJO0FBQ2xELGVBQUssUUFBUSxHQUFHLE9BQUssVUFBVSxDQUFDLE9BQUssWUFBWSxDQUFDLFFBQVEsQ0FBQyxDQUFDLENBQUE7O0FBRTVELGVBQUssSUFBSSxDQUFDLGNBQWMsQ0FBQyxNQUFNLEVBQUUsQ0FBQTtBQUNqQyxlQUFLLEtBQUssQ0FBQyxHQUFHLENBQUMsUUFBUSxDQUFDLE9BQUssUUFBUSxDQUFDLEdBQUcsQ0FBQyxDQUFBOztBQUUxQyxlQUFLLElBQUksQ0FBQyxlQUFlLENBQUMsTUFBTSxFQUFFLENBQUE7QUFDbEMsZUFBSyxLQUFLLENBQUMsSUFBSSxDQUFDLFFBQVEsQ0FBQyxPQUFLLFFBQVEsQ0FBQyxJQUFJLENBQUMsQ0FBQTs7QUFFNUMsZUFBSyxJQUFJLENBQUMsb0JBQW9CLENBQUMsTUFBTSxFQUFFLENBQUE7QUFDdkMsZUFBSyxLQUFLLENBQUMsSUFBSSxDQUFDLFFBQVEsQ0FBQyxPQUFLLFFBQVEsQ0FBQyxJQUFJLENBQUMsQ0FBQTs7QUFFNUMsZUFBSyxJQUFJLENBQUMsY0FBYyxDQUFDLE1BQU0sRUFBRSxDQUFBO0FBQ2pDLGVBQUssS0FBSyxDQUFDLEdBQUcsQ0FBQyxRQUFRLENBQUMsT0FBSyxRQUFRLENBQUMsR0FBRyxDQUFDLENBQUE7Ozs7QUFJMUMsZUFBSyxtQkFBbUIsRUFBRSxDQUFBO09BQzNCLENBQUMsU0FBTSxDQUFDLFVBQUMsS0FBSyxFQUFLO0FBQ2xCLGVBQUssSUFBSSxDQUFDLFdBQVcsQ0FBQyxXQUFXLENBQUMsMkJBQWMsT0FBSyxjQUFjLEVBQUUsS0FBSyxDQUFDLENBQUMsT0FBTyxDQUFDLENBQUE7T0FDckYsQ0FBQyxDQUFBO0tBQ0g7Ozs7O1dBR2tCLDhCQUFHO0FBQ3BCLFVBQUksQ0FBQyxhQUFhLEdBQUcsSUFBSSxDQUFDLGdCQUFnQixFQUFFLENBQUE7QUFDNUMsVUFBSSxDQUFDLGlCQUFpQixHQUFHLElBQUksQ0FBQyxvQkFBb0IsRUFBRSxDQUFBO0FBQ3BELFVBQUksQ0FBQyxrQkFBa0IsRUFBRSxDQUFBO0FBQ3pCLFVBQUksQ0FBQyx3QkFBd0IsRUFBRSxDQUFBO0tBQ2hDOzs7V0FFd0Isb0NBQUc7QUFDMUIsVUFBSSxJQUFJLENBQUMsV0FBVyxDQUFDLElBQUksQ0FBQyxhQUFhLENBQUMsRUFBRTtBQUN4QyxZQUFJLENBQUMsSUFBSSxDQUFDLHFCQUFxQixDQUFDLEtBQUssQ0FBQyxPQUFPLEdBQUcsRUFBRSxDQUFBO09BQ25ELE1BQU07QUFDTCxZQUFJLENBQUMsSUFBSSxDQUFDLHFCQUFxQixDQUFDLEtBQUssQ0FBQyxPQUFPLEdBQUcsTUFBTSxDQUFBO09BQ3ZEOztBQUVELFVBQUksSUFBSSxDQUFDLFdBQVcsQ0FBQyxJQUFJLENBQUMsaUJBQWlCLENBQUMsRUFBRTtBQUM1QyxZQUFJLENBQUMsSUFBSSxDQUFDLHlCQUF5QixDQUFDLE9BQU8sR0FBRyxFQUFFLENBQUE7T0FDakQsTUFBTTtBQUNMLFlBQUksQ0FBQyxJQUFJLENBQUMseUJBQXlCLENBQUMsT0FBTyxHQUFHLE1BQU0sQ0FBQTtPQUNyRDtLQUNGOzs7V0FFVyxxQkFBQyxXQUFXLEVBQUU7QUFDeEIsYUFBTyxJQUFJLENBQUMsY0FBYyxDQUFDLGtCQUFrQixDQUFDLFdBQVcsQ0FBQyxDQUFBO0tBQzNEOzs7OztXQUdrQiw4QkFBRztBQUNwQixVQUFJLENBQUMsSUFBSSxDQUFDLE1BQU0sQ0FBQyxTQUFTLEdBQUcsRUFBRSxDQUFBO0FBQy9CLFVBQUksQ0FBQyxJQUFJLENBQUMsVUFBVSxDQUFDLFNBQVMsR0FBRyxFQUFFLENBQUE7QUFDbkMsVUFBTSxlQUFlLEdBQUcsNEJBQUUsTUFBTSxDQUFDLElBQUksQ0FBQyxNQUFNLENBQUMsZUFBZSxFQUFFLEVBQUUsTUFBTSxDQUFDLENBQUE7QUFDdkUseUJBQTZCLGVBQWUsRUFBRTtZQUFwQyxLQUFJLFVBQUosSUFBSTtZQUFFLFFBQVEsVUFBUixRQUFROztBQUN0QixnQkFBUSxRQUFRLENBQUMsS0FBSztBQUNwQixlQUFLLElBQUk7QUFBRTtBQUNULGtCQUFNLFNBQVMsR0FBRyxJQUFJLENBQUMsbUJBQW1CLENBQUMsS0FBSSxDQUFDLENBQUE7QUFDaEQsa0JBQUksS0FBSSxLQUFLLElBQUksQ0FBQyxhQUFhLEVBQUU7QUFDL0IseUJBQVMsQ0FBQyxRQUFRLEdBQUcsSUFBSSxDQUFBO2VBQzFCO0FBQ0Qsa0JBQUksQ0FBQyxJQUFJLENBQUMsTUFBTSxDQUFDLFdBQVcsQ0FBQyxTQUFTLENBQUMsQ0FBQTtBQUN2QyxvQkFBSzthQUNOO0FBQUEsQUFDRCxlQUFLLFFBQVE7QUFBRTtBQUNiLGtCQUFNLFNBQVMsR0FBRyxJQUFJLENBQUMsbUJBQW1CLENBQUMsS0FBSSxDQUFDLENBQUE7QUFDaEQsa0JBQUksS0FBSSxLQUFLLElBQUksQ0FBQyxpQkFBaUIsRUFBRTtBQUNuQyx5QkFBUyxDQUFDLFFBQVEsR0FBRyxJQUFJLENBQUE7ZUFDMUI7QUFDRCxrQkFBSSxDQUFDLElBQUksQ0FBQyxVQUFVLENBQUMsV0FBVyxDQUFDLFNBQVMsQ0FBQyxDQUFBO0FBQzNDLG9CQUFLO2FBQ047QUFBQSxTQUNGO09BQ0Y7S0FDRjs7Ozs7V0FHZ0IsNEJBQUc7QUFDbEIseUJBQTZCLElBQUksQ0FBQyxNQUFNLENBQUMsZUFBZSxFQUFFLEVBQUU7WUFBbEQsTUFBSSxVQUFKLElBQUk7WUFBRSxRQUFRLFVBQVIsUUFBUTs7QUFDdEIsWUFBSSxRQUFRLENBQUMsS0FBSyxLQUFLLElBQUksRUFBRTtBQUMzQixpQkFBTyxNQUFJLENBQUE7U0FDWjtPQUNGO0FBQ0QsYUFBTyxJQUFJLENBQUE7S0FDWjs7Ozs7V0FHb0IsZ0NBQUc7QUFDdEIseUJBQTZCLElBQUksQ0FBQyxNQUFNLENBQUMsZUFBZSxFQUFFLEVBQUU7WUFBbEQsTUFBSSxVQUFKLElBQUk7WUFBRSxRQUFRLFVBQVIsUUFBUTs7QUFDdEIsWUFBSSxRQUFRLENBQUMsS0FBSyxLQUFLLFFBQVEsRUFBRTtBQUFFLGlCQUFPLE1BQUksQ0FBQTtTQUFFO09BQ2pEO0FBQ0QsYUFBTyxJQUFJLENBQUE7S0FDWjs7Ozs7V0FHaUIsNkJBQUc7QUFDbkIsVUFBTSxNQUFNLEdBQUcsRUFBRSxDQUFBO0FBQ2pCLFVBQUksSUFBSSxDQUFDLGFBQWEsRUFBRTtBQUN0QixjQUFNLENBQUMsSUFBSSxDQUFDLElBQUksQ0FBQyxhQUFhLENBQUMsQ0FBQTtPQUNoQztBQUNELFVBQUksSUFBSSxDQUFDLGlCQUFpQixFQUFFO0FBQzFCLGNBQU0sQ0FBQyxJQUFJLENBQUMsSUFBSSxDQUFDLGlCQUFpQixDQUFDLENBQUE7T0FDcEM7QUFDRCxVQUFJLE1BQU0sQ0FBQyxNQUFNLEdBQUcsQ0FBQyxFQUFFO0FBQ3JCLFlBQUksQ0FBQyxNQUFNLENBQUMsR0FBRyxDQUFDLGFBQWEsRUFBRSxNQUFNLENBQUMsQ0FBQTtPQUN2QztLQUNGOzs7V0FFeUIscUNBQUc7OztBQUMzQixnQkFBVSxDQUFDLFlBQU07QUFBRSxlQUFLLGlCQUFpQixFQUFFLENBQUE7T0FBRSxFQUFFLEdBQUcsQ0FBQyxDQUFBO0tBQ3BEOzs7OztXQUdtQiw2QkFBQyxTQUFTLEVBQUU7QUFDOUIsVUFBTSxLQUFLLEdBQUcsNEJBQUUsV0FBVyxDQUFDLDRCQUFFLFdBQVcsQ0FBQyxTQUFTLENBQUMsT0FBTyxDQUFDLGVBQWUsRUFBRSxFQUFFLENBQUMsQ0FBQyxPQUFPLENBQUMsVUFBVSxFQUFFLEVBQUUsQ0FBQyxDQUFDLENBQUMsQ0FBQTtBQUMxRyxVQUFNLE1BQU0sR0FBRyxRQUFRLENBQUMsYUFBYSxDQUFDLFFBQVEsQ0FBQyxDQUFBO0FBQy9DLFlBQU0sQ0FBQyxLQUFLLEdBQUcsU0FBUyxDQUFBO0FBQ3hCLFlBQU0sQ0FBQyxXQUFXLEdBQUcsS0FBSyxDQUFBO0FBQzFCLGFBQU8sTUFBTSxDQUFBO0tBQ2Q7OztXQUVpQiwyQkFBQyxJQUFJLEVBQUU7QUFDdkIsYUFBTyw2QkFBZ0IsSUFBSSxFQUFFLElBQUksQ0FBQyxZQUFZLEVBQUUsSUFBSSxDQUFDLGNBQWMsRUFBRSxFQUFDLElBQUksRUFBRSxRQUFRLEVBQUMsQ0FBQyxDQUFBO0tBQ3ZGOzs7V0FFdUIsaUNBQUMsSUFBSSxFQUFFO0FBQzdCLFVBQUksQ0FBQyxJQUFJLENBQUMsUUFBUSxFQUFFO0FBQ2xCLGVBQU07T0FDUDs7QUFFRCxXQUFLLElBQUksV0FBVyxJQUFJLENBQUMsS0FBSyxFQUFFLE1BQU0sRUFBRSxNQUFNLEVBQUUsS0FBSyxDQUFDLEVBQUU7QUFDdEQsWUFBTSxRQUFRLEdBQUcsSUFBSSxDQUFDLFNBQVMsQ0FBQyxXQUFXLENBQUMsQ0FBQyxRQUFRLEVBQUUsQ0FBQTtBQUN2RCxZQUFNLFdBQVcsR0FBRyxJQUFJLENBQUMsU0FBUyxDQUFDLFdBQVcsQ0FBQyxDQUFDLFdBQVcsQ0FBQyxVQUFDLElBQUksRUFBSztBQUNwRSxjQUFJLElBQUksS0FBSyxFQUFFLEVBQUU7QUFDZixtQkFBTyxJQUFJLENBQUE7V0FDWixNQUFNO0FBQ0wsZ0JBQU0sS0FBSyxHQUFHLElBQUksQ0FBQyxLQUFLLElBQUksSUFBSSxHQUFHLElBQUksQ0FBQyxLQUFLLEdBQUcsZ0NBQW9CLElBQUksQ0FBQyxVQUFVLENBQUMsQ0FBQTtBQUNwRixnQkFBTSxVQUFVLEdBQU0sSUFBSSxDQUFDLElBQUksU0FBSSxLQUFLLEFBQUUsQ0FBQTtBQUMxQyxtQkFBTyx3QkFBVyxLQUFLLENBQUMsVUFBVSxFQUFFLElBQUksQ0FBQyxHQUFHLENBQUMsQ0FBQTtXQUM5QztTQUNGLENBQUMsQ0FBQTs7QUFFRixhQUFLLElBQU0sSUFBSSxJQUFJLFFBQVEsRUFBRTtBQUMzQixjQUFJLElBQUksRUFBRTtBQUNSLGdCQUFJLENBQUMsT0FBTyxDQUFDLEtBQUssQ0FBQyxPQUFPLEdBQUcsTUFBTSxDQUFBO0FBQ25DLGdCQUFJLENBQUMsT0FBTyxDQUFDLFNBQVMsQ0FBQyxHQUFHLENBQUMsUUFBUSxDQUFDLENBQUE7V0FDckM7U0FDRjs7QUFFRCxhQUFLLElBQU0sSUFBSSxJQUFJLFdBQVcsRUFBRTtBQUM5QixjQUFJLElBQUksRUFBRTtBQUNSLGdCQUFJLENBQUMsT0FBTyxDQUFDLEtBQUssQ0FBQyxPQUFPLEdBQUcsRUFBRSxDQUFBO0FBQy9CLGdCQUFJLENBQUMsT0FBTyxDQUFDLFNBQVMsQ0FBQyxNQUFNLENBQUMsUUFBUSxDQUFDLENBQUE7V0FDeEM7U0FDRjtPQUNGOztBQUVELFVBQUksQ0FBQyxtQkFBbUIsRUFBRSxDQUFBO0tBQzNCOzs7V0FFNkIseUNBQUc7QUFDL0IsVUFBSSxDQUFDLGtCQUFrQixDQUFDLElBQUksQ0FBQyxJQUFJLENBQUMscUJBQXFCLEVBQUUsSUFBSSxDQUFDLElBQUksQ0FBQyxjQUFjLEVBQUUsSUFBSSxDQUFDLFFBQVEsQ0FBQyxJQUFJLENBQUMsTUFBTSxDQUFDLENBQUE7QUFDN0csVUFBSSxDQUFDLGtCQUFrQixDQUFDLElBQUksQ0FBQyxJQUFJLENBQUMsZ0JBQWdCLEVBQUUsSUFBSSxDQUFDLElBQUksQ0FBQyxTQUFTLEVBQUUsSUFBSSxDQUFDLFFBQVEsQ0FBQyxJQUFJLENBQUMsTUFBTSxDQUFDLENBQUE7QUFDbkcsVUFBSSxDQUFDLGtCQUFrQixDQUFDLElBQUksQ0FBQyxJQUFJLENBQUMsdUJBQXVCLEVBQUUsSUFBSSxDQUFDLElBQUksQ0FBQyxRQUFRLEVBQUUsSUFBSSxDQUFDLFFBQVEsQ0FBQyxHQUFHLENBQUMsTUFBTSxDQUFDLENBQUE7QUFDeEcsVUFBSSxDQUFDLGtCQUFrQixDQUFDLElBQUksQ0FBQyxJQUFJLENBQUMsZUFBZSxFQUFFLElBQUksQ0FBQyxJQUFJLENBQUMsUUFBUSxFQUFFLElBQUksQ0FBQyxRQUFRLENBQUMsR0FBRyxDQUFDLE1BQU0sQ0FBQyxDQUFBOztBQUVoRyxVQUFJLENBQUMsSUFBSSxDQUFDLGFBQWEsQ0FBQyxXQUFXLFNBQU0sSUFBSSxDQUFDLFFBQVEsQ0FBQyxJQUFJLENBQUMsTUFBTSxHQUFHLElBQUksQ0FBQyxRQUFRLENBQUMsSUFBSSxDQUFDLE1BQU0sR0FBRyxJQUFJLENBQUMsUUFBUSxDQUFDLEdBQUcsQ0FBQyxNQUFNLEdBQUcsSUFBSSxDQUFDLFFBQVEsQ0FBQyxHQUFHLENBQUMsTUFBTSxDQUFBLEFBQUUsQ0FBQTtLQUN2Sjs7O1dBRTJCLHVDQUFHO0FBQzdCLFVBQU0sU0FBUyxHQUFHLElBQUksQ0FBQyxvQkFBb0IsQ0FBQyxJQUFJLENBQUMsSUFBSSxDQUFDLGlCQUFpQixDQUFDLENBQUE7QUFDeEUsVUFBSSxDQUFDLGtCQUFrQixDQUFDLElBQUksQ0FBQyxJQUFJLENBQUMscUJBQXFCLEVBQUUsSUFBSSxDQUFDLElBQUksQ0FBQyxjQUFjLEVBQUUsU0FBUyxFQUFFLElBQUksQ0FBQyxRQUFRLENBQUMsSUFBSSxDQUFDLE1BQU0sQ0FBQyxDQUFBOztBQUV4SCxVQUFNLEdBQUcsR0FBRyxJQUFJLENBQUMsb0JBQW9CLENBQUMsSUFBSSxDQUFDLElBQUksQ0FBQyxXQUFXLENBQUMsQ0FBQTtBQUM1RCxVQUFJLENBQUMsa0JBQWtCLENBQUMsSUFBSSxDQUFDLElBQUksQ0FBQyx1QkFBdUIsRUFBRSxJQUFJLENBQUMsSUFBSSxDQUFDLFFBQVEsRUFBRSxHQUFHLEVBQUUsSUFBSSxDQUFDLFFBQVEsQ0FBQyxHQUFHLENBQUMsTUFBTSxDQUFDLENBQUE7O0FBRTdHLFVBQU0sSUFBSSxHQUFHLElBQUksQ0FBQyxvQkFBb0IsQ0FBQyxJQUFJLENBQUMsSUFBSSxDQUFDLFlBQVksQ0FBQyxDQUFBO0FBQzlELFVBQUksQ0FBQyxrQkFBa0IsQ0FBQyxJQUFJLENBQUMsSUFBSSxDQUFDLGdCQUFnQixFQUFFLElBQUksQ0FBQyxJQUFJLENBQUMsU0FBUyxFQUFFLElBQUksRUFBRSxJQUFJLENBQUMsUUFBUSxDQUFDLElBQUksQ0FBQyxNQUFNLENBQUMsQ0FBQTs7QUFFekcsVUFBTSxHQUFHLEdBQUcsSUFBSSxDQUFDLG9CQUFvQixDQUFDLElBQUksQ0FBQyxJQUFJLENBQUMsV0FBVyxDQUFDLENBQUE7QUFDNUQsVUFBSSxDQUFDLGtCQUFrQixDQUFDLElBQUksQ0FBQyxJQUFJLENBQUMsZUFBZSxFQUFFLElBQUksQ0FBQyxJQUFJLENBQUMsUUFBUSxFQUFFLEdBQUcsRUFBRSxJQUFJLENBQUMsUUFBUSxDQUFDLEdBQUcsQ0FBQyxNQUFNLENBQUMsQ0FBQTs7QUFFckcsVUFBTSxXQUFXLEdBQUcsR0FBRyxHQUFHLElBQUksR0FBRyxTQUFTLEdBQUcsR0FBRyxDQUFBO0FBQ2hELFVBQU0sV0FBVyxHQUFHLElBQUksQ0FBQyxRQUFRLENBQUMsSUFBSSxDQUFDLE1BQU0sR0FBRyxJQUFJLENBQUMsUUFBUSxDQUFDLElBQUksQ0FBQyxNQUFNLEdBQUcsSUFBSSxDQUFDLFFBQVEsQ0FBQyxHQUFHLENBQUMsTUFBTSxHQUFHLElBQUksQ0FBQyxRQUFRLENBQUMsR0FBRyxDQUFDLE1BQU0sQ0FBQTtBQUMvSCxVQUFJLENBQUMsSUFBSSxDQUFDLGFBQWEsQ0FBQyxXQUFXLEdBQU0sV0FBVyxTQUFJLFdBQVcsQUFBRSxDQUFBO0tBQ3RFOzs7V0FFb0IsZ0NBQUc7QUFDdEIsVUFBSSxDQUFDLHdCQUF3QixDQUFDLENBQUMsSUFBSSxDQUFDLElBQUksQ0FBQyxxQkFBcUIsRUFBRSxJQUFJLENBQUMsSUFBSSxDQUFDLGdCQUFnQixFQUFFLElBQUksQ0FBQyxJQUFJLENBQUMsdUJBQXVCLEVBQUUsSUFBSSxDQUFDLElBQUksQ0FBQyxlQUFlLENBQUMsQ0FBQyxDQUFBO0tBQzNKOzs7V0FFYSx5QkFBRztBQUNmLFVBQUksQ0FBQyx1QkFBdUIsQ0FBQyxJQUFJLENBQUMsSUFBSSxDQUFDLFlBQVksQ0FBQyxPQUFPLEVBQUUsQ0FBQyxDQUFBO0tBQy9EOzs7V0FFMEIsb0NBQUMsQ0FBQyxFQUFFO0FBQzdCLE9BQUMsQ0FBQyxjQUFjLEVBQUUsQ0FBQTtBQUNsQixVQUFJLENBQUMsUUFBUSxDQUFDLFFBQVEsQ0FBQyxJQUFJLENBQUMsS0FBSyxDQUFDLE9BQU8sQ0FBQyxJQUFJLENBQUMsU0FBUyxDQUFDLEVBQUUsa0NBQWtDLENBQUMsQ0FBQTtLQUMvRjs7O1dBRWUsMkJBQUc7QUFDakIsVUFBSSxDQUFDLGFBQWEsR0FBRyxJQUFJLENBQUMsSUFBSSxDQUFDLE1BQU0sQ0FBQyxLQUFLLENBQUE7QUFDM0MsVUFBSSxDQUFDLHlCQUF5QixFQUFFLENBQUE7S0FDakM7OztXQUVtQiwrQkFBRztBQUNyQixVQUFJLENBQUMsaUJBQWlCLEdBQUcsSUFBSSxDQUFDLElBQUksQ0FBQyxVQUFVLENBQUMsS0FBSyxDQUFBO0FBQ25ELFVBQUksQ0FBQyx5QkFBeUIsRUFBRSxDQUFBO0tBQ2pDOzs7V0FFNkIsdUNBQUMsS0FBSyxFQUFFO0FBQ3BDLFdBQUssQ0FBQyxlQUFlLEVBQUUsQ0FBQTtBQUN2QixVQUFNLEtBQUssR0FBRyxJQUFJLENBQUMsTUFBTSxDQUFDLGVBQWUsRUFBRSxDQUFDLElBQUksQ0FBQyxVQUFDLEtBQUs7ZUFBSyxLQUFLLENBQUMsUUFBUSxDQUFDLEtBQUssS0FBSyxJQUFJO09BQUEsQ0FBQyxDQUFBO0FBQzFGLFVBQU0sYUFBYSxHQUFHLEtBQUssSUFBSSxJQUFJLEdBQUcsS0FBSyxDQUFDLFFBQVEsR0FBRyxJQUFJLENBQUE7QUFDM0QsVUFBSSxhQUFhLElBQUksSUFBSSxFQUFFO0FBQ3pCLFlBQUksQ0FBQyxZQUFZLENBQUMsU0FBUyxDQUFDLElBQUksQ0FBQyxhQUFhLEVBQUU7QUFDOUMsY0FBSSxFQUFFLFFBQVE7QUFDZCxjQUFJLEVBQUUsYUFBYTtTQUNwQixDQUFDLENBQUE7T0FDSDtLQUNGOzs7V0FFaUMsMkNBQUMsS0FBSyxFQUFFO0FBQ3hDLFdBQUssQ0FBQyxlQUFlLEVBQUUsQ0FBQTtBQUN2QixVQUFNLEtBQUssR0FBRyxJQUFJLENBQUMsTUFBTSxDQUFDLGVBQWUsRUFBRSxDQUFDLElBQUksQ0FBQyxVQUFDLEtBQUs7ZUFBSyxLQUFLLENBQUMsUUFBUSxDQUFDLEtBQUssS0FBSyxRQUFRO09BQUEsQ0FBQyxDQUFBO0FBQzlGLFVBQU0saUJBQWlCLEdBQUcsS0FBSyxJQUFJLElBQUksR0FBRyxLQUFLLENBQUMsUUFBUSxHQUFHLElBQUksQ0FBQTtBQUMvRCxVQUFJLGlCQUFpQixJQUFJLElBQUksRUFBRTtBQUM3QixZQUFJLENBQUMsWUFBWSxDQUFDLFNBQVMsQ0FBQyxJQUFJLENBQUMsaUJBQWlCLEVBQUU7QUFDbEQsY0FBSSxFQUFFLFFBQVE7QUFDZCxjQUFJLEVBQUUsaUJBQWlCO1NBQ3hCLENBQUMsQ0FBQTtPQUNIO0tBQ0Y7OztXQUVRLG9CQUFHO0FBQ1YsVUFBSSxDQUFDLE9BQU8sQ0FBQyxTQUFTLElBQUksUUFBUSxDQUFDLElBQUksQ0FBQyxZQUFZLEdBQUcsRUFBRSxDQUFBO0tBQzFEOzs7V0FFVSxzQkFBRztBQUNaLFVBQUksQ0FBQyxPQUFPLENBQUMsU0FBUyxJQUFJLFFBQVEsQ0FBQyxJQUFJLENBQUMsWUFBWSxHQUFHLEVBQUUsQ0FBQTtLQUMxRDs7O1dBRU0sa0JBQUc7QUFDUixVQUFJLENBQUMsT0FBTyxDQUFDLFNBQVMsSUFBSSxJQUFJLENBQUMsT0FBTyxDQUFDLFlBQVksQ0FBQTtLQUNwRDs7O1dBRVEsb0JBQUc7QUFDVixVQUFJLENBQUMsT0FBTyxDQUFDLFNBQVMsSUFBSSxJQUFJLENBQUMsT0FBTyxDQUFDLFlBQVksQ0FBQTtLQUNwRDs7O1dBRVcsdUJBQUc7QUFDYixVQUFJLENBQUMsT0FBTyxDQUFDLFNBQVMsR0FBRyxDQUFDLENBQUE7S0FDM0I7OztXQUVjLDBCQUFHO0FBQ2hCLFVBQUksQ0FBQyxPQUFPLENBQUMsU0FBUyxHQUFHLElBQUksQ0FBQyxPQUFPLENBQUMsWUFBWSxDQUFBO0tBQ25EOzs7U0FsZGtCLFdBQVc7OztxQkFBWCxXQUFXIiwiZmlsZSI6Ii9idWlsZC9hdG9tL3NyYy9hdG9tLTEuMzYuMS9vdXQvYXBwL25vZGVfbW9kdWxlcy9zZXR0aW5ncy12aWV3L2xpYi90aGVtZXMtcGFuZWwuanMiLCJzb3VyY2VzQ29udGVudCI6WyIvKiogQGJhYmVsICovXG4vKiogQGpzeCBldGNoLmRvbSAqL1xuXG5pbXBvcnQgZnV6emFsZHJpbiBmcm9tICdmdXp6YWxkcmluJ1xuaW1wb3J0IGV0Y2ggZnJvbSAnZXRjaCdcbmltcG9ydCBfIGZyb20gJ3VuZGVyc2NvcmUtcGx1cydcbmltcG9ydCB7Q29tcG9zaXRlRGlzcG9zYWJsZSwgVGV4dEVkaXRvcn0gZnJvbSAnYXRvbSdcblxuaW1wb3J0IENvbGxhcHNpYmxlU2VjdGlvblBhbmVsIGZyb20gJy4vY29sbGFwc2libGUtc2VjdGlvbi1wYW5lbCdcbmltcG9ydCBQYWNrYWdlQ2FyZCBmcm9tICcuL3BhY2thZ2UtY2FyZCdcbmltcG9ydCBFcnJvclZpZXcgZnJvbSAnLi9lcnJvci12aWV3J1xuXG5pbXBvcnQgTGlzdCBmcm9tICcuL2xpc3QnXG5pbXBvcnQgTGlzdFZpZXcgZnJvbSAnLi9saXN0LXZpZXcnXG5pbXBvcnQge293bmVyRnJvbVJlcG9zaXRvcnksIHBhY2thZ2VDb21wYXJhdG9yQXNjZW5kaW5nfSBmcm9tICcuL3V0aWxzJ1xuXG5leHBvcnQgZGVmYXVsdCBjbGFzcyBUaGVtZXNQYW5lbCBleHRlbmRzIENvbGxhcHNpYmxlU2VjdGlvblBhbmVsIHtcbiAgc3RhdGljIGxvYWRQYWNrYWdlc0RlbGF5ICgpIHtcbiAgICByZXR1cm4gMzAwXG4gIH1cblxuICBjb25zdHJ1Y3RvciAoc2V0dGluZ3NWaWV3LCBwYWNrYWdlTWFuYWdlcikge1xuICAgIHN1cGVyKClcblxuICAgIHRoaXMuc2V0dGluZ3NWaWV3ID0gc2V0dGluZ3NWaWV3XG4gICAgdGhpcy5wYWNrYWdlTWFuYWdlciA9IHBhY2thZ2VNYW5hZ2VyXG4gICAgZXRjaC5pbml0aWFsaXplKHRoaXMpXG4gICAgdGhpcy5pdGVtcyA9IHtcbiAgICAgIGRldjogbmV3IExpc3QoJ25hbWUnKSxcbiAgICAgIGNvcmU6IG5ldyBMaXN0KCduYW1lJyksXG4gICAgICB1c2VyOiBuZXcgTGlzdCgnbmFtZScpLFxuICAgICAgZ2l0OiBuZXcgTGlzdCgnbmFtZScpXG4gICAgfVxuICAgIHRoaXMuaXRlbVZpZXdzID0ge1xuICAgICAgZGV2OiBuZXcgTGlzdFZpZXcodGhpcy5pdGVtcy5kZXYsIHRoaXMucmVmcy5kZXZQYWNrYWdlcywgdGhpcy5jcmVhdGVQYWNrYWdlQ2FyZC5iaW5kKHRoaXMpKSxcbiAgICAgIGNvcmU6IG5ldyBMaXN0Vmlldyh0aGlzLml0ZW1zLmNvcmUsIHRoaXMucmVmcy5jb3JlUGFja2FnZXMsIHRoaXMuY3JlYXRlUGFja2FnZUNhcmQuYmluZCh0aGlzKSksXG4gICAgICB1c2VyOiBuZXcgTGlzdFZpZXcodGhpcy5pdGVtcy51c2VyLCB0aGlzLnJlZnMuY29tbXVuaXR5UGFja2FnZXMsIHRoaXMuY3JlYXRlUGFja2FnZUNhcmQuYmluZCh0aGlzKSksXG4gICAgICBnaXQ6IG5ldyBMaXN0Vmlldyh0aGlzLml0ZW1zLmdpdCwgdGhpcy5yZWZzLmdpdFBhY2thZ2VzLCB0aGlzLmNyZWF0ZVBhY2thZ2VDYXJkLmJpbmQodGhpcykpXG4gICAgfVxuXG4gICAgdGhpcy5kaXNwb3NhYmxlcyA9IG5ldyBDb21wb3NpdGVEaXNwb3NhYmxlKClcbiAgICB0aGlzLmRpc3Bvc2FibGVzLmFkZChcbiAgICAgIHRoaXMucGFja2FnZU1hbmFnZXIub24oJ3RoZW1lLWluc3RhbGwtZmFpbGVkIHRoZW1lLXVuaW5zdGFsbC1mYWlsZWQnLCAoe3BhY2ssIGVycm9yfSkgPT4ge1xuICAgICAgICB0aGlzLnJlZnMudGhlbWVFcnJvcnMuYXBwZW5kQ2hpbGQobmV3IEVycm9yVmlldyh0aGlzLnBhY2thZ2VNYW5hZ2VyLCBlcnJvcikuZWxlbWVudClcbiAgICAgIH0pXG4gICAgKVxuICAgIHRoaXMuZGlzcG9zYWJsZXMuYWRkKHRoaXMuaGFuZGxlRXZlbnRzKCkpXG4gICAgdGhpcy5kaXNwb3NhYmxlcy5hZGQoYXRvbS5jb21tYW5kcy5hZGQodGhpcy5lbGVtZW50LCB7XG4gICAgICAnY29yZTptb3ZlLXVwJzogKCkgPT4geyB0aGlzLnNjcm9sbFVwKCkgfSxcbiAgICAgICdjb3JlOm1vdmUtZG93bic6ICgpID0+IHsgdGhpcy5zY3JvbGxEb3duKCkgfSxcbiAgICAgICdjb3JlOnBhZ2UtdXAnOiAoKSA9PiB7IHRoaXMucGFnZVVwKCkgfSxcbiAgICAgICdjb3JlOnBhZ2UtZG93bic6ICgpID0+IHsgdGhpcy5wYWdlRG93bigpIH0sXG4gICAgICAnY29yZTptb3ZlLXRvLXRvcCc6ICgpID0+IHsgdGhpcy5zY3JvbGxUb1RvcCgpIH0sXG4gICAgICAnY29yZTptb3ZlLXRvLWJvdHRvbSc6ICgpID0+IHsgdGhpcy5zY3JvbGxUb0JvdHRvbSgpIH1cbiAgICB9KSlcbiAgICB0aGlzLmxvYWRQYWNrYWdlcygpXG5cbiAgICB0aGlzLmRpc3Bvc2FibGVzLmFkZChcbiAgICAgIHRoaXMucGFja2FnZU1hbmFnZXIub24oJ3RoZW1lLWluc3RhbGxlZCB0aGVtZS11bmluc3RhbGxlZCcsICgpID0+IHtcbiAgICAgICAgbGV0IGxvYWRQYWNrYWdlc1RpbWVvdXRcbiAgICAgICAgY2xlYXJUaW1lb3V0KGxvYWRQYWNrYWdlc1RpbWVvdXQpXG4gICAgICAgIGxvYWRQYWNrYWdlc1RpbWVvdXQgPSBzZXRUaW1lb3V0KCgpID0+IHtcbiAgICAgICAgICB0aGlzLnBvcHVsYXRlVGhlbWVNZW51cygpXG4gICAgICAgICAgdGhpcy5sb2FkUGFja2FnZXMoKVxuICAgICAgICB9LCBUaGVtZXNQYW5lbC5sb2FkUGFja2FnZXNEZWxheSgpKVxuICAgICAgfSlcbiAgICApXG5cbiAgICB0aGlzLmRpc3Bvc2FibGVzLmFkZChhdG9tLnRoZW1lcy5vbkRpZENoYW5nZUFjdGl2ZVRoZW1lcygoKSA9PiB0aGlzLnVwZGF0ZUFjdGl2ZVRoZW1lcygpKSlcbiAgICB0aGlzLmRpc3Bvc2FibGVzLmFkZChhdG9tLnRvb2x0aXBzLmFkZCh0aGlzLnJlZnMuYWN0aXZlVWlUaGVtZVNldHRpbmdzLCB7dGl0bGU6ICdTZXR0aW5ncyd9KSlcbiAgICB0aGlzLmRpc3Bvc2FibGVzLmFkZChhdG9tLnRvb2x0aXBzLmFkZCh0aGlzLnJlZnMuYWN0aXZlU3ludGF4VGhlbWVTZXR0aW5ncywge3RpdGxlOiAnU2V0dGluZ3MnfSkpXG4gICAgdGhpcy51cGRhdGVBY3RpdmVUaGVtZXMoKVxuXG4gICAgdGhpcy5kaXNwb3NhYmxlcy5hZGQodGhpcy5yZWZzLmZpbHRlckVkaXRvci5vbkRpZFN0b3BDaGFuZ2luZygoKSA9PiB7IHRoaXMubWF0Y2hQYWNrYWdlcygpIH0pKVxuICB9XG5cbiAgdXBkYXRlICgpIHt9XG5cbiAgZm9jdXMgKCkge1xuICAgIHRoaXMucmVmcy5maWx0ZXJFZGl0b3IuZWxlbWVudC5mb2N1cygpXG4gIH1cblxuICBzaG93ICgpIHtcbiAgICB0aGlzLmVsZW1lbnQuc3R5bGUuZGlzcGxheSA9ICcnXG4gIH1cblxuICBkZXN0cm95ICgpIHtcbiAgICB0aGlzLmRpc3Bvc2FibGVzLmRpc3Bvc2UoKVxuICAgIHJldHVybiBldGNoLmRlc3Ryb3kodGhpcylcbiAgfVxuXG4gIHJlbmRlciAoKSB7XG4gICAgcmV0dXJuIChcbiAgICAgIDxkaXYgY2xhc3NOYW1lPSdwYW5lbHMtaXRlbScgdGFiSW5kZXg9Jy0xJz5cbiAgICAgICAgPGRpdiBjbGFzc05hbWU9J3NlY3Rpb24gcGFja2FnZXMgdGhlbWVzLXBhbmVsJz5cbiAgICAgICAgICA8ZGl2IGNsYXNzTmFtZT0nc2VjdGlvbi1jb250YWluZXInPlxuICAgICAgICAgICAgPGRpdiBjbGFzc05hbWU9J3NlY3Rpb24taGVhZGluZyBpY29uIGljb24tcGFpbnRjYW4nPkNob29zZSBhIFRoZW1lPC9kaXY+XG5cbiAgICAgICAgICAgIDxkaXYgY2xhc3NOYW1lPSd0ZXh0IG5hdGl2ZS1rZXktYmluZGluZ3MnIHRhYkluZGV4PSctMSc+XG4gICAgICAgICAgICAgIDxzcGFuIGNsYXNzTmFtZT0naWNvbiBpY29uLXF1ZXN0aW9uJz5Zb3UgY2FuIGFsc28gc3R5bGUgQXRvbSBieSBlZGl0aW5nIDwvc3Bhbj5cbiAgICAgICAgICAgICAgPGEgY2xhc3NOYW1lPSdsaW5rJyBvbmNsaWNrPXt0aGlzLmRpZENsaWNrT3BlblVzZXJTdHlsZVNoZWV0fT55b3VyIHN0eWxlc2hlZXQ8L2E+XG4gICAgICAgICAgICA8L2Rpdj5cblxuICAgICAgICAgICAgPGRpdiBjbGFzc05hbWU9J3RoZW1lcy1waWNrZXInPlxuICAgICAgICAgICAgICA8ZGl2IGNsYXNzTmFtZT0ndGhlbWVzLXBpY2tlci1pdGVtIGNvbnRyb2wtZ3JvdXAnPlxuICAgICAgICAgICAgICAgIDxkaXYgY2xhc3NOYW1lPSdjb250cm9scyc+XG4gICAgICAgICAgICAgICAgICA8bGFiZWwgY2xhc3NOYW1lPSdjb250cm9sLWxhYmVsJz5cbiAgICAgICAgICAgICAgICAgICAgPGRpdiBjbGFzc05hbWU9J3NldHRpbmctdGl0bGUgdGhlbWVzLWxhYmVsIHRleHQnPlVJIFRoZW1lPC9kaXY+XG4gICAgICAgICAgICAgICAgICAgIDxkaXYgY2xhc3NOYW1lPSdzZXR0aW5nLWRlc2NyaXB0aW9uIHRleHQgdGhlbWUtZGVzY3JpcHRpb24nPlRoaXMgc3R5bGVzIHRoZSB0YWJzLCBzdGF0dXMgYmFyLCB0cmVlIHZpZXcsIGFuZCBkcm9wZG93bnM8L2Rpdj5cbiAgICAgICAgICAgICAgICAgIDwvbGFiZWw+XG4gICAgICAgICAgICAgICAgICA8ZGl2IGNsYXNzTmFtZT0nc2VsZWN0LWNvbnRhaW5lcic+XG4gICAgICAgICAgICAgICAgICAgIDxzZWxlY3QgcmVmPSd1aU1lbnUnIGNsYXNzTmFtZT0nZm9ybS1jb250cm9sJyBvbmNoYW5nZT17dGhpcy5kaWRDaGFuZ2VVaU1lbnUuYmluZCh0aGlzKX0gLz5cbiAgICAgICAgICAgICAgICAgICAgPGJ1dHRvblxuICAgICAgICAgICAgICAgICAgICAgIHJlZj0nYWN0aXZlVWlUaGVtZVNldHRpbmdzJ1xuICAgICAgICAgICAgICAgICAgICAgIGNsYXNzTmFtZT0nYnRuIGljb24gaWNvbi1nZWFyIGFjdGl2ZS10aGVtZS1zZXR0aW5ncydcbiAgICAgICAgICAgICAgICAgICAgICBvbmNsaWNrPXt0aGlzLmRpZENsaWNrQWN0aXZlVWlUaGVtZVNldHRpbmdzLmJpbmQodGhpcyl9IC8+XG4gICAgICAgICAgICAgICAgICA8L2Rpdj5cbiAgICAgICAgICAgICAgICA8L2Rpdj5cbiAgICAgICAgICAgICAgPC9kaXY+XG5cbiAgICAgICAgICAgICAgPGRpdiBjbGFzc05hbWU9J3RoZW1lcy1waWNrZXItaXRlbSBjb250cm9sLWdyb3VwJz5cbiAgICAgICAgICAgICAgICA8ZGl2IGNsYXNzTmFtZT0nY29udHJvbHMnPlxuICAgICAgICAgICAgICAgICAgPGxhYmVsIGNsYXNzTmFtZT0nY29udHJvbC1sYWJlbCc+XG4gICAgICAgICAgICAgICAgICAgIDxkaXYgY2xhc3NOYW1lPSdzZXR0aW5nLXRpdGxlIHRoZW1lcy1sYWJlbCB0ZXh0Jz5TeW50YXggVGhlbWU8L2Rpdj5cbiAgICAgICAgICAgICAgICAgICAgPGRpdiBjbGFzc05hbWU9J3NldHRpbmctZGVzY3JpcHRpb24gdGV4dCB0aGVtZS1kZXNjcmlwdGlvbic+VGhpcyBzdHlsZXMgdGhlIHRleHQgaW5zaWRlIHRoZSBlZGl0b3I8L2Rpdj5cbiAgICAgICAgICAgICAgICAgIDwvbGFiZWw+XG4gICAgICAgICAgICAgICAgICA8ZGl2IGNsYXNzTmFtZT0nc2VsZWN0LWNvbnRhaW5lcic+XG4gICAgICAgICAgICAgICAgICAgIDxzZWxlY3QgcmVmPSdzeW50YXhNZW51JyBjbGFzc05hbWU9J2Zvcm0tY29udHJvbCcgb25jaGFuZ2U9e3RoaXMuZGlkQ2hhbmdlU3ludGF4TWVudS5iaW5kKHRoaXMpfSAvPlxuICAgICAgICAgICAgICAgICAgICA8YnV0dG9uXG4gICAgICAgICAgICAgICAgICAgICAgcmVmPSdhY3RpdmVTeW50YXhUaGVtZVNldHRpbmdzJ1xuICAgICAgICAgICAgICAgICAgICAgIGNsYXNzTmFtZT0nYnRuIGljb24gaWNvbi1nZWFyIGFjdGl2ZS1zeW50YXgtc2V0dGluZ3MnXG4gICAgICAgICAgICAgICAgICAgICAgb25jbGljaz17dGhpcy5kaWRDbGlja0FjdGl2ZVN5bnRheFRoZW1lU2V0dGluZ3MuYmluZCh0aGlzKX0gLz5cbiAgICAgICAgICAgICAgICAgIDwvZGl2PlxuICAgICAgICAgICAgICAgIDwvZGl2PlxuICAgICAgICAgICAgICA8L2Rpdj5cbiAgICAgICAgICAgIDwvZGl2PlxuICAgICAgICAgIDwvZGl2PlxuICAgICAgICA8L2Rpdj5cblxuICAgICAgICA8c2VjdGlvbiBjbGFzc05hbWU9J3NlY3Rpb24nPlxuICAgICAgICAgIDxkaXYgY2xhc3NOYW1lPSdzZWN0aW9uLWNvbnRhaW5lcic+XG4gICAgICAgICAgICA8ZGl2IGNsYXNzTmFtZT0nc2VjdGlvbi1oZWFkaW5nIGljb24gaWNvbi1wYWludGNhbic+XG4gICAgICAgICAgICAgIEluc3RhbGxlZCBUaGVtZXNcbiAgICAgICAgICAgICAgPHNwYW4gcmVmPSd0b3RhbFBhY2thZ2VzJyBjbGFzc05hbWU9J3NlY3Rpb24taGVhZGluZy1jb3VudCBiYWRnZSBiYWRnZS1mbGV4aWJsZSc+4oCmPC9zcGFuPlxuICAgICAgICAgICAgPC9kaXY+XG4gICAgICAgICAgICA8ZGl2IGNsYXNzTmFtZT0nZWRpdG9yLWNvbnRhaW5lcic+XG4gICAgICAgICAgICAgIDxUZXh0RWRpdG9yIHJlZj0nZmlsdGVyRWRpdG9yJyBtaW5pIHBsYWNlaG9sZGVyVGV4dD0nRmlsdGVyIHRoZW1lcyBieSBuYW1lJyAvPlxuICAgICAgICAgICAgPC9kaXY+XG5cbiAgICAgICAgICAgIDxkaXYgcmVmPSd0aGVtZUVycm9ycycgLz5cblxuICAgICAgICAgICAgPHNlY3Rpb24gY2xhc3NOYW1lPSdzdWItc2VjdGlvbiBpbnN0YWxsZWQtcGFja2FnZXMnPlxuICAgICAgICAgICAgICA8aDMgcmVmPSdjb21tdW5pdHlUaGVtZXNIZWFkZXInIGNsYXNzTmFtZT0nc3ViLXNlY3Rpb24taGVhZGluZyBpY29uIGljb24tcGFpbnRjYW4nPlxuICAgICAgICAgICAgICAgIENvbW11bml0eSBUaGVtZXNcbiAgICAgICAgICAgICAgICA8c3BhbiByZWY9J2NvbW11bml0eUNvdW50JyBjbGFzc05hbWU9J3NlY3Rpb24taGVhZGluZy1jb3VudCBiYWRnZSBiYWRnZS1mbGV4aWJsZSc+4oCmPC9zcGFuPlxuICAgICAgICAgICAgICA8L2gzPlxuICAgICAgICAgICAgICA8ZGl2IHJlZj0nY29tbXVuaXR5UGFja2FnZXMnIGNsYXNzTmFtZT0nY29udGFpbmVyIHBhY2thZ2UtY29udGFpbmVyJz5cbiAgICAgICAgICAgICAgICA8ZGl2IHJlZj0nY29tbXVuaXR5TG9hZGluZ0FyZWEnIGNsYXNzTmFtZT0nYWxlcnQgYWxlcnQtaW5mbyBsb2FkaW5nLWFyZWEgaWNvbiBpY29uLWhvdXJnbGFzcyc+TG9hZGluZyB0aGVtZXPigKY8L2Rpdj5cbiAgICAgICAgICAgICAgPC9kaXY+XG4gICAgICAgICAgICA8L3NlY3Rpb24+XG5cbiAgICAgICAgICAgIDxzZWN0aW9uIGNsYXNzTmFtZT0nc3ViLXNlY3Rpb24gY29yZS1wYWNrYWdlcyc+XG4gICAgICAgICAgICAgIDxoMyByZWY9J2NvcmVUaGVtZXNIZWFkZXInIGNsYXNzTmFtZT0nc3ViLXNlY3Rpb24taGVhZGluZyBpY29uIGljb24tcGFpbnRjYW4nPlxuICAgICAgICAgICAgICAgIENvcmUgVGhlbWVzXG4gICAgICAgICAgICAgICAgPHNwYW4gcmVmPSdjb3JlQ291bnQnIGNsYXNzTmFtZT0nc2VjdGlvbi1oZWFkaW5nLWNvdW50IGJhZGdlIGJhZGdlLWZsZXhpYmxlJz7igKY8L3NwYW4+XG4gICAgICAgICAgICAgIDwvaDM+XG4gICAgICAgICAgICAgIDxkaXYgcmVmPSdjb3JlUGFja2FnZXMnIGNsYXNzTmFtZT0nY29udGFpbmVyIHBhY2thZ2UtY29udGFpbmVyJz5cbiAgICAgICAgICAgICAgICA8ZGl2IHJlZj0nY29yZUxvYWRpbmdBcmVhJyBjbGFzc05hbWU9J2FsZXJ0IGFsZXJ0LWluZm8gbG9hZGluZy1hcmVhIGljb24gaWNvbi1ob3VyZ2xhc3MnPkxvYWRpbmcgdGhlbWVz4oCmPC9kaXY+XG4gICAgICAgICAgICAgIDwvZGl2PlxuICAgICAgICAgICAgPC9zZWN0aW9uPlxuXG4gICAgICAgICAgICA8c2VjdGlvbiBjbGFzc05hbWU9J3N1Yi1zZWN0aW9uIGRldi1wYWNrYWdlcyc+XG4gICAgICAgICAgICAgIDxoMyByZWY9J2RldmVsb3BtZW50VGhlbWVzSGVhZGVyJyBjbGFzc05hbWU9J3N1Yi1zZWN0aW9uLWhlYWRpbmcgaWNvbiBpY29uLXBhaW50Y2FuJz5cbiAgICAgICAgICAgICAgICBEZXZlbG9wbWVudCBUaGVtZXNcbiAgICAgICAgICAgICAgICA8c3BhbiByZWY9J2RldkNvdW50JyBjbGFzc05hbWU9J3NlY3Rpb24taGVhZGluZy1jb3VudCBiYWRnZSBiYWRnZS1mbGV4aWJsZSc+4oCmPC9zcGFuPlxuICAgICAgICAgICAgICA8L2gzPlxuICAgICAgICAgICAgICA8ZGl2IHJlZj0nZGV2UGFja2FnZXMnIGNsYXNzTmFtZT0nY29udGFpbmVyIHBhY2thZ2UtY29udGFpbmVyJz5cbiAgICAgICAgICAgICAgICA8ZGl2IHJlZj0nZGV2TG9hZGluZ0FyZWEnIGNsYXNzTmFtZT0nYWxlcnQgYWxlcnQtaW5mbyBsb2FkaW5nLWFyZWEgaWNvbiBpY29uLWhvdXJnbGFzcyc+TG9hZGluZyB0aGVtZXPigKY8L2Rpdj5cbiAgICAgICAgICAgICAgPC9kaXY+XG4gICAgICAgICAgICA8L3NlY3Rpb24+XG5cbiAgICAgICAgICAgIDxzZWN0aW9uIGNsYXNzTmFtZT0nc3ViLXNlY3Rpb24gZ2l0LXBhY2thZ2VzJz5cbiAgICAgICAgICAgICAgPGgzIHJlZj0nZ2l0VGhlbWVzSGVhZGVyJyBjbGFzc05hbWU9J3N1Yi1zZWN0aW9uLWhlYWRpbmcgaWNvbiBpY29uLXBhaW50Y2FuJz5cbiAgICAgICAgICAgICAgICBHaXQgVGhlbWVzXG4gICAgICAgICAgICAgICAgPHNwYW4gcmVmPSdnaXRDb3VudCcgY2xhc3NOYW1lPSdzZWN0aW9uLWhlYWRpbmctY291bnQgYmFkZ2UgYmFkZ2UtZmxleGlibGUnPuKApjwvc3Bhbj5cbiAgICAgICAgICAgICAgPC9oMz5cbiAgICAgICAgICAgICAgPGRpdiByZWY9J2dpdFBhY2thZ2VzJyBjbGFzc05hbWU9J2NvbnRhaW5lciBwYWNrYWdlLWNvbnRhaW5lcic+XG4gICAgICAgICAgICAgICAgPGRpdiByZWY9J2dpdExvYWRpbmdBcmVhJyBjbGFzc05hbWU9J2FsZXJ0IGFsZXJ0LWluZm8gbG9hZGluZy1hcmVhIGljb24gaWNvbi1ob3VyZ2xhc3MnPkxvYWRpbmcgdGhlbWVz4oCmPC9kaXY+XG4gICAgICAgICAgICAgIDwvZGl2PlxuICAgICAgICAgICAgPC9zZWN0aW9uPlxuICAgICAgICAgIDwvZGl2PlxuICAgICAgICA8L3NlY3Rpb24+XG4gICAgICA8L2Rpdj5cbiAgICApXG4gIH1cblxuICBmaWx0ZXJUaGVtZXMgKHBhY2thZ2VzKSB7XG4gICAgcGFja2FnZXMuZGV2ID0gcGFja2FnZXMuZGV2LmZpbHRlcigoe3RoZW1lfSkgPT4gdGhlbWUpXG4gICAgcGFja2FnZXMudXNlciA9IHBhY2thZ2VzLnVzZXIuZmlsdGVyKCh7dGhlbWV9KSA9PiB0aGVtZSlcbiAgICBwYWNrYWdlcy5jb3JlID0gcGFja2FnZXMuY29yZS5maWx0ZXIoKHt0aGVtZX0pID0+IHRoZW1lKVxuICAgIHBhY2thZ2VzLmdpdCA9IChwYWNrYWdlcy5naXQgfHwgW10pLmZpbHRlcigoe3RoZW1lfSkgPT4gdGhlbWUpXG5cbiAgICBmb3IgKGxldCBwYWNrIG9mIHBhY2thZ2VzLmNvcmUpIHtcbiAgICAgIGlmIChwYWNrLnJlcG9zaXRvcnkgPT0gbnVsbCkge1xuICAgICAgICBwYWNrLnJlcG9zaXRvcnkgPSBgaHR0cHM6Ly9naXRodWIuY29tL2F0b20vJHtwYWNrLm5hbWV9YFxuICAgICAgfVxuICAgIH1cblxuICAgIGZvciAobGV0IHBhY2thZ2VUeXBlIG9mIFsnZGV2JywgJ2NvcmUnLCAndXNlcicsICdnaXQnXSkge1xuICAgICAgZm9yIChsZXQgcGFjayBvZiBwYWNrYWdlc1twYWNrYWdlVHlwZV0pIHtcbiAgICAgICAgcGFjay5vd25lciA9IG93bmVyRnJvbVJlcG9zaXRvcnkocGFjay5yZXBvc2l0b3J5KVxuICAgICAgfVxuICAgIH1cbiAgICByZXR1cm4gcGFja2FnZXNcbiAgfVxuXG4gIHNvcnRUaGVtZXMgKHBhY2thZ2VzKSB7XG4gICAgcGFja2FnZXMuZGV2LnNvcnQocGFja2FnZUNvbXBhcmF0b3JBc2NlbmRpbmcpXG4gICAgcGFja2FnZXMuY29yZS5zb3J0KHBhY2thZ2VDb21wYXJhdG9yQXNjZW5kaW5nKVxuICAgIHBhY2thZ2VzLnVzZXIuc29ydChwYWNrYWdlQ29tcGFyYXRvckFzY2VuZGluZylcbiAgICBwYWNrYWdlcy5naXQuc29ydChwYWNrYWdlQ29tcGFyYXRvckFzY2VuZGluZylcbiAgICByZXR1cm4gcGFja2FnZXNcbiAgfVxuXG4gIGxvYWRQYWNrYWdlcyAoKSB7XG4gICAgdGhpcy5wYWNrYWdlVmlld3MgPSBbXVxuICAgIHRoaXMucGFja2FnZU1hbmFnZXIuZ2V0SW5zdGFsbGVkKCkudGhlbihwYWNrYWdlcyA9PiB7XG4gICAgICB0aGlzLnBhY2thZ2VzID0gdGhpcy5zb3J0VGhlbWVzKHRoaXMuZmlsdGVyVGhlbWVzKHBhY2thZ2VzKSlcblxuICAgICAgdGhpcy5yZWZzLmRldkxvYWRpbmdBcmVhLnJlbW92ZSgpXG4gICAgICB0aGlzLml0ZW1zLmRldi5zZXRJdGVtcyh0aGlzLnBhY2thZ2VzLmRldilcblxuICAgICAgdGhpcy5yZWZzLmNvcmVMb2FkaW5nQXJlYS5yZW1vdmUoKVxuICAgICAgdGhpcy5pdGVtcy5jb3JlLnNldEl0ZW1zKHRoaXMucGFja2FnZXMuY29yZSlcblxuICAgICAgdGhpcy5yZWZzLmNvbW11bml0eUxvYWRpbmdBcmVhLnJlbW92ZSgpXG4gICAgICB0aGlzLml0ZW1zLnVzZXIuc2V0SXRlbXModGhpcy5wYWNrYWdlcy51c2VyKVxuXG4gICAgICB0aGlzLnJlZnMuZ2l0TG9hZGluZ0FyZWEucmVtb3ZlKClcbiAgICAgIHRoaXMuaXRlbXMuZ2l0LnNldEl0ZW1zKHRoaXMucGFja2FnZXMuZ2l0KVxuXG4gICAgICAvLyBUT0RPIHNob3cgZW1wdHkgbWVzYWdlIHBlciBzZWN0aW9uXG5cbiAgICAgIHRoaXMudXBkYXRlU2VjdGlvbkNvdW50cygpXG4gICAgfSkuY2F0Y2goKGVycm9yKSA9PiB7XG4gICAgICB0aGlzLnJlZnMudGhlbWVFcnJvcnMuYXBwZW5kQ2hpbGQobmV3IEVycm9yVmlldyh0aGlzLnBhY2thZ2VNYW5hZ2VyLCBlcnJvcikuZWxlbWVudClcbiAgICB9KVxuICB9XG5cbiAgLy8gVXBkYXRlIHRoZSBhY3RpdmUgVUkgYW5kIHN5bnRheCB0aGVtZXMgYW5kIHBvcHVsYXRlIHRoZSBtZW51XG4gIHVwZGF0ZUFjdGl2ZVRoZW1lcyAoKSB7XG4gICAgdGhpcy5hY3RpdmVVaVRoZW1lID0gdGhpcy5nZXRBY3RpdmVVaVRoZW1lKClcbiAgICB0aGlzLmFjdGl2ZVN5bnRheFRoZW1lID0gdGhpcy5nZXRBY3RpdmVTeW50YXhUaGVtZSgpXG4gICAgdGhpcy5wb3B1bGF0ZVRoZW1lTWVudXMoKVxuICAgIHRoaXMudG9nZ2xlQWN0aXZlVGhlbWVCdXR0b25zKClcbiAgfVxuXG4gIHRvZ2dsZUFjdGl2ZVRoZW1lQnV0dG9ucyAoKSB7XG4gICAgaWYgKHRoaXMuaGFzU2V0dGluZ3ModGhpcy5hY3RpdmVVaVRoZW1lKSkge1xuICAgICAgdGhpcy5yZWZzLmFjdGl2ZVVpVGhlbWVTZXR0aW5ncy5zdHlsZS5kaXNwbGF5ID0gJydcbiAgICB9IGVsc2Uge1xuICAgICAgdGhpcy5yZWZzLmFjdGl2ZVVpVGhlbWVTZXR0aW5ncy5zdHlsZS5kaXNwbGF5ID0gJ25vbmUnXG4gICAgfVxuXG4gICAgaWYgKHRoaXMuaGFzU2V0dGluZ3ModGhpcy5hY3RpdmVTeW50YXhUaGVtZSkpIHtcbiAgICAgIHRoaXMucmVmcy5hY3RpdmVTeW50YXhUaGVtZVNldHRpbmdzLmRpc3BsYXkgPSAnJ1xuICAgIH0gZWxzZSB7XG4gICAgICB0aGlzLnJlZnMuYWN0aXZlU3ludGF4VGhlbWVTZXR0aW5ncy5kaXNwbGF5ID0gJ25vbmUnXG4gICAgfVxuICB9XG5cbiAgaGFzU2V0dGluZ3MgKHBhY2thZ2VOYW1lKSB7XG4gICAgcmV0dXJuIHRoaXMucGFja2FnZU1hbmFnZXIucGFja2FnZUhhc1NldHRpbmdzKHBhY2thZ2VOYW1lKVxuICB9XG5cbiAgLy8gUG9wdWxhdGUgdGhlIHRoZW1lIG1lbnVzIGZyb20gdGhlIHRoZW1lIG1hbmFnZXIncyBhY3RpdmUgdGhlbWVzXG4gIHBvcHVsYXRlVGhlbWVNZW51cyAoKSB7XG4gICAgdGhpcy5yZWZzLnVpTWVudS5pbm5lckhUTUwgPSAnJ1xuICAgIHRoaXMucmVmcy5zeW50YXhNZW51LmlubmVySFRNTCA9ICcnXG4gICAgY29uc3QgYXZhaWxhYmxlVGhlbWVzID0gXy5zb3J0QnkoYXRvbS50aGVtZXMuZ2V0TG9hZGVkVGhlbWVzKCksICduYW1lJylcbiAgICBmb3IgKGxldCB7bmFtZSwgbWV0YWRhdGF9IG9mIGF2YWlsYWJsZVRoZW1lcykge1xuICAgICAgc3dpdGNoIChtZXRhZGF0YS50aGVtZSkge1xuICAgICAgICBjYXNlICd1aSc6IHtcbiAgICAgICAgICBjb25zdCB0aGVtZUl0ZW0gPSB0aGlzLmNyZWF0ZVRoZW1lTWVudUl0ZW0obmFtZSlcbiAgICAgICAgICBpZiAobmFtZSA9PT0gdGhpcy5hY3RpdmVVaVRoZW1lKSB7XG4gICAgICAgICAgICB0aGVtZUl0ZW0uc2VsZWN0ZWQgPSB0cnVlXG4gICAgICAgICAgfVxuICAgICAgICAgIHRoaXMucmVmcy51aU1lbnUuYXBwZW5kQ2hpbGQodGhlbWVJdGVtKVxuICAgICAgICAgIGJyZWFrXG4gICAgICAgIH1cbiAgICAgICAgY2FzZSAnc3ludGF4Jzoge1xuICAgICAgICAgIGNvbnN0IHRoZW1lSXRlbSA9IHRoaXMuY3JlYXRlVGhlbWVNZW51SXRlbShuYW1lKVxuICAgICAgICAgIGlmIChuYW1lID09PSB0aGlzLmFjdGl2ZVN5bnRheFRoZW1lKSB7XG4gICAgICAgICAgICB0aGVtZUl0ZW0uc2VsZWN0ZWQgPSB0cnVlXG4gICAgICAgICAgfVxuICAgICAgICAgIHRoaXMucmVmcy5zeW50YXhNZW51LmFwcGVuZENoaWxkKHRoZW1lSXRlbSlcbiAgICAgICAgICBicmVha1xuICAgICAgICB9XG4gICAgICB9XG4gICAgfVxuICB9XG5cbiAgLy8gR2V0IHRoZSBuYW1lIG9mIHRoZSBhY3RpdmUgdWkgdGhlbWUuXG4gIGdldEFjdGl2ZVVpVGhlbWUgKCkge1xuICAgIGZvciAobGV0IHtuYW1lLCBtZXRhZGF0YX0gb2YgYXRvbS50aGVtZXMuZ2V0QWN0aXZlVGhlbWVzKCkpIHtcbiAgICAgIGlmIChtZXRhZGF0YS50aGVtZSA9PT0gJ3VpJykge1xuICAgICAgICByZXR1cm4gbmFtZVxuICAgICAgfVxuICAgIH1cbiAgICByZXR1cm4gbnVsbFxuICB9XG5cbiAgLy8gR2V0IHRoZSBuYW1lIG9mIHRoZSBhY3RpdmUgc3ludGF4IHRoZW1lLlxuICBnZXRBY3RpdmVTeW50YXhUaGVtZSAoKSB7XG4gICAgZm9yIChsZXQge25hbWUsIG1ldGFkYXRhfSBvZiBhdG9tLnRoZW1lcy5nZXRBY3RpdmVUaGVtZXMoKSkge1xuICAgICAgaWYgKG1ldGFkYXRhLnRoZW1lID09PSAnc3ludGF4JykgeyByZXR1cm4gbmFtZSB9XG4gICAgfVxuICAgIHJldHVybiBudWxsXG4gIH1cblxuICAvLyBVcGRhdGUgdGhlIGNvbmZpZyB3aXRoIHRoZSBzZWxlY3RlZCB0aGVtZXNcbiAgdXBkYXRlVGhlbWVDb25maWcgKCkge1xuICAgIGNvbnN0IHRoZW1lcyA9IFtdXG4gICAgaWYgKHRoaXMuYWN0aXZlVWlUaGVtZSkge1xuICAgICAgdGhlbWVzLnB1c2godGhpcy5hY3RpdmVVaVRoZW1lKVxuICAgIH1cbiAgICBpZiAodGhpcy5hY3RpdmVTeW50YXhUaGVtZSkge1xuICAgICAgdGhlbWVzLnB1c2godGhpcy5hY3RpdmVTeW50YXhUaGVtZSlcbiAgICB9XG4gICAgaWYgKHRoZW1lcy5sZW5ndGggPiAwKSB7XG4gICAgICBhdG9tLmNvbmZpZy5zZXQoJ2NvcmUudGhlbWVzJywgdGhlbWVzKVxuICAgIH1cbiAgfVxuXG4gIHNjaGVkdWxlVXBkYXRlVGhlbWVDb25maWcgKCkge1xuICAgIHNldFRpbWVvdXQoKCkgPT4geyB0aGlzLnVwZGF0ZVRoZW1lQ29uZmlnKCkgfSwgMTAwKVxuICB9XG5cbiAgLy8gQ3JlYXRlIGEgbWVudSBpdGVtIGZvciB0aGUgZ2l2ZW4gdGhlbWUgbmFtZS5cbiAgY3JlYXRlVGhlbWVNZW51SXRlbSAodGhlbWVOYW1lKSB7XG4gICAgY29uc3QgdGl0bGUgPSBfLnVuZGFzaGVyaXplKF8udW5jYW1lbGNhc2UodGhlbWVOYW1lLnJlcGxhY2UoLy0odWl8c3ludGF4KS9nLCAnJykucmVwbGFjZSgvLXRoZW1lJC9nLCAnJykpKVxuICAgIGNvbnN0IG9wdGlvbiA9IGRvY3VtZW50LmNyZWF0ZUVsZW1lbnQoJ29wdGlvbicpXG4gICAgb3B0aW9uLnZhbHVlID0gdGhlbWVOYW1lXG4gICAgb3B0aW9uLnRleHRDb250ZW50ID0gdGl0bGVcbiAgICByZXR1cm4gb3B0aW9uXG4gIH1cblxuICBjcmVhdGVQYWNrYWdlQ2FyZCAocGFjaykge1xuICAgIHJldHVybiBuZXcgUGFja2FnZUNhcmQocGFjaywgdGhpcy5zZXR0aW5nc1ZpZXcsIHRoaXMucGFja2FnZU1hbmFnZXIsIHtiYWNrOiAnVGhlbWVzJ30pXG4gIH1cblxuICBmaWx0ZXJQYWNrYWdlTGlzdEJ5VGV4dCAodGV4dCkge1xuICAgIGlmICghdGhpcy5wYWNrYWdlcykge1xuICAgICAgcmV0dXJuXG4gICAgfVxuXG4gICAgZm9yIChsZXQgcGFja2FnZVR5cGUgb2YgWydkZXYnLCAnY29yZScsICd1c2VyJywgJ2dpdCddKSB7XG4gICAgICBjb25zdCBhbGxWaWV3cyA9IHRoaXMuaXRlbVZpZXdzW3BhY2thZ2VUeXBlXS5nZXRWaWV3cygpXG4gICAgICBjb25zdCBhY3RpdmVWaWV3cyA9IHRoaXMuaXRlbVZpZXdzW3BhY2thZ2VUeXBlXS5maWx0ZXJWaWV3cygocGFjaykgPT4ge1xuICAgICAgICBpZiAodGV4dCA9PT0gJycpIHtcbiAgICAgICAgICByZXR1cm4gdHJ1ZVxuICAgICAgICB9IGVsc2Uge1xuICAgICAgICAgIGNvbnN0IG93bmVyID0gcGFjay5vd25lciAhPSBudWxsID8gcGFjay5vd25lciA6IG93bmVyRnJvbVJlcG9zaXRvcnkocGFjay5yZXBvc2l0b3J5KVxuICAgICAgICAgIGNvbnN0IGZpbHRlclRleHQgPSBgJHtwYWNrLm5hbWV9ICR7b3duZXJ9YFxuICAgICAgICAgIHJldHVybiBmdXp6YWxkcmluLnNjb3JlKGZpbHRlclRleHQsIHRleHQpID4gMFxuICAgICAgICB9XG4gICAgICB9KVxuXG4gICAgICBmb3IgKGNvbnN0IHZpZXcgb2YgYWxsVmlld3MpIHtcbiAgICAgICAgaWYgKHZpZXcpIHtcbiAgICAgICAgICB2aWV3LmVsZW1lbnQuc3R5bGUuZGlzcGxheSA9ICdub25lJ1xuICAgICAgICAgIHZpZXcuZWxlbWVudC5jbGFzc0xpc3QuYWRkKCdoaWRkZW4nKVxuICAgICAgICB9XG4gICAgICB9XG5cbiAgICAgIGZvciAoY29uc3QgdmlldyBvZiBhY3RpdmVWaWV3cykge1xuICAgICAgICBpZiAodmlldykge1xuICAgICAgICAgIHZpZXcuZWxlbWVudC5zdHlsZS5kaXNwbGF5ID0gJydcbiAgICAgICAgICB2aWV3LmVsZW1lbnQuY2xhc3NMaXN0LnJlbW92ZSgnaGlkZGVuJylcbiAgICAgICAgfVxuICAgICAgfVxuICAgIH1cblxuICAgIHRoaXMudXBkYXRlU2VjdGlvbkNvdW50cygpXG4gIH1cblxuICB1cGRhdGVVbmZpbHRlcmVkU2VjdGlvbkNvdW50cyAoKSB7XG4gICAgdGhpcy51cGRhdGVTZWN0aW9uQ291bnQodGhpcy5yZWZzLmNvbW11bml0eVRoZW1lc0hlYWRlciwgdGhpcy5yZWZzLmNvbW11bml0eUNvdW50LCB0aGlzLnBhY2thZ2VzLnVzZXIubGVuZ3RoKVxuICAgIHRoaXMudXBkYXRlU2VjdGlvbkNvdW50KHRoaXMucmVmcy5jb3JlVGhlbWVzSGVhZGVyLCB0aGlzLnJlZnMuY29yZUNvdW50LCB0aGlzLnBhY2thZ2VzLmNvcmUubGVuZ3RoKVxuICAgIHRoaXMudXBkYXRlU2VjdGlvbkNvdW50KHRoaXMucmVmcy5kZXZlbG9wbWVudFRoZW1lc0hlYWRlciwgdGhpcy5yZWZzLmRldkNvdW50LCB0aGlzLnBhY2thZ2VzLmRldi5sZW5ndGgpXG4gICAgdGhpcy51cGRhdGVTZWN0aW9uQ291bnQodGhpcy5yZWZzLmdpdFRoZW1lc0hlYWRlciwgdGhpcy5yZWZzLmdpdENvdW50LCB0aGlzLnBhY2thZ2VzLmdpdC5sZW5ndGgpXG5cbiAgICB0aGlzLnJlZnMudG90YWxQYWNrYWdlcy50ZXh0Q29udGVudCA9IGAke3RoaXMucGFja2FnZXMudXNlci5sZW5ndGggKyB0aGlzLnBhY2thZ2VzLmNvcmUubGVuZ3RoICsgdGhpcy5wYWNrYWdlcy5kZXYubGVuZ3RoICsgdGhpcy5wYWNrYWdlcy5naXQubGVuZ3RofWBcbiAgfVxuXG4gIHVwZGF0ZUZpbHRlcmVkU2VjdGlvbkNvdW50cyAoKSB7XG4gICAgY29uc3QgY29tbXVuaXR5ID0gdGhpcy5ub3RIaWRkZW5DYXJkc0xlbmd0aCh0aGlzLnJlZnMuY29tbXVuaXR5UGFja2FnZXMpXG4gICAgdGhpcy51cGRhdGVTZWN0aW9uQ291bnQodGhpcy5yZWZzLmNvbW11bml0eVRoZW1lc0hlYWRlciwgdGhpcy5yZWZzLmNvbW11bml0eUNvdW50LCBjb21tdW5pdHksIHRoaXMucGFja2FnZXMudXNlci5sZW5ndGgpXG5cbiAgICBjb25zdCBkZXYgPSB0aGlzLm5vdEhpZGRlbkNhcmRzTGVuZ3RoKHRoaXMucmVmcy5kZXZQYWNrYWdlcylcbiAgICB0aGlzLnVwZGF0ZVNlY3Rpb25Db3VudCh0aGlzLnJlZnMuZGV2ZWxvcG1lbnRUaGVtZXNIZWFkZXIsIHRoaXMucmVmcy5kZXZDb3VudCwgZGV2LCB0aGlzLnBhY2thZ2VzLmRldi5sZW5ndGgpXG5cbiAgICBjb25zdCBjb3JlID0gdGhpcy5ub3RIaWRkZW5DYXJkc0xlbmd0aCh0aGlzLnJlZnMuY29yZVBhY2thZ2VzKVxuICAgIHRoaXMudXBkYXRlU2VjdGlvbkNvdW50KHRoaXMucmVmcy5jb3JlVGhlbWVzSGVhZGVyLCB0aGlzLnJlZnMuY29yZUNvdW50LCBjb3JlLCB0aGlzLnBhY2thZ2VzLmNvcmUubGVuZ3RoKVxuXG4gICAgY29uc3QgZ2l0ID0gdGhpcy5ub3RIaWRkZW5DYXJkc0xlbmd0aCh0aGlzLnJlZnMuZ2l0UGFja2FnZXMpXG4gICAgdGhpcy51cGRhdGVTZWN0aW9uQ291bnQodGhpcy5yZWZzLmdpdFRoZW1lc0hlYWRlciwgdGhpcy5yZWZzLmdpdENvdW50LCBnaXQsIHRoaXMucGFja2FnZXMuZ2l0Lmxlbmd0aClcblxuICAgIGNvbnN0IHNob3duVGhlbWVzID0gZGV2ICsgY29yZSArIGNvbW11bml0eSArIGdpdFxuICAgIGNvbnN0IHRvdGFsVGhlbWVzID0gdGhpcy5wYWNrYWdlcy51c2VyLmxlbmd0aCArIHRoaXMucGFja2FnZXMuY29yZS5sZW5ndGggKyB0aGlzLnBhY2thZ2VzLmRldi5sZW5ndGggKyB0aGlzLnBhY2thZ2VzLmdpdC5sZW5ndGhcbiAgICB0aGlzLnJlZnMudG90YWxQYWNrYWdlcy50ZXh0Q29udGVudCA9IGAke3Nob3duVGhlbWVzfS8ke3RvdGFsVGhlbWVzfWBcbiAgfVxuXG4gIHJlc2V0U2VjdGlvbkhhc0l0ZW1zICgpIHtcbiAgICB0aGlzLnJlc2V0Q29sbGFwc2libGVTZWN0aW9ucyhbdGhpcy5yZWZzLmNvbW11bml0eVRoZW1lc0hlYWRlciwgdGhpcy5yZWZzLmNvcmVUaGVtZXNIZWFkZXIsIHRoaXMucmVmcy5kZXZlbG9wbWVudFRoZW1lc0hlYWRlciwgdGhpcy5yZWZzLmdpdFRoZW1lc0hlYWRlcl0pXG4gIH1cblxuICBtYXRjaFBhY2thZ2VzICgpIHtcbiAgICB0aGlzLmZpbHRlclBhY2thZ2VMaXN0QnlUZXh0KHRoaXMucmVmcy5maWx0ZXJFZGl0b3IuZ2V0VGV4dCgpKVxuICB9XG5cbiAgZGlkQ2xpY2tPcGVuVXNlclN0eWxlU2hlZXQgKGUpIHtcbiAgICBlLnByZXZlbnREZWZhdWx0KClcbiAgICBhdG9tLmNvbW1hbmRzLmRpc3BhdGNoKGF0b20udmlld3MuZ2V0VmlldyhhdG9tLndvcmtzcGFjZSksICdhcHBsaWNhdGlvbjpvcGVuLXlvdXItc3R5bGVzaGVldCcpXG4gIH1cblxuICBkaWRDaGFuZ2VVaU1lbnUgKCkge1xuICAgIHRoaXMuYWN0aXZlVWlUaGVtZSA9IHRoaXMucmVmcy51aU1lbnUudmFsdWVcbiAgICB0aGlzLnNjaGVkdWxlVXBkYXRlVGhlbWVDb25maWcoKVxuICB9XG5cbiAgZGlkQ2hhbmdlU3ludGF4TWVudSAoKSB7XG4gICAgdGhpcy5hY3RpdmVTeW50YXhUaGVtZSA9IHRoaXMucmVmcy5zeW50YXhNZW51LnZhbHVlXG4gICAgdGhpcy5zY2hlZHVsZVVwZGF0ZVRoZW1lQ29uZmlnKClcbiAgfVxuXG4gIGRpZENsaWNrQWN0aXZlVWlUaGVtZVNldHRpbmdzIChldmVudCkge1xuICAgIGV2ZW50LnN0b3BQcm9wYWdhdGlvbigpXG4gICAgY29uc3QgdGhlbWUgPSBhdG9tLnRoZW1lcy5nZXRBY3RpdmVUaGVtZXMoKS5maW5kKCh0aGVtZSkgPT4gdGhlbWUubWV0YWRhdGEudGhlbWUgPT09ICd1aScpXG4gICAgY29uc3QgYWN0aXZlVWlUaGVtZSA9IHRoZW1lICE9IG51bGwgPyB0aGVtZS5tZXRhZGF0YSA6IG51bGxcbiAgICBpZiAoYWN0aXZlVWlUaGVtZSAhPSBudWxsKSB7XG4gICAgICB0aGlzLnNldHRpbmdzVmlldy5zaG93UGFuZWwodGhpcy5hY3RpdmVVaVRoZW1lLCB7XG4gICAgICAgIGJhY2s6ICdUaGVtZXMnLFxuICAgICAgICBwYWNrOiBhY3RpdmVVaVRoZW1lXG4gICAgICB9KVxuICAgIH1cbiAgfVxuXG4gIGRpZENsaWNrQWN0aXZlU3ludGF4VGhlbWVTZXR0aW5ncyAoZXZlbnQpIHtcbiAgICBldmVudC5zdG9wUHJvcGFnYXRpb24oKVxuICAgIGNvbnN0IHRoZW1lID0gYXRvbS50aGVtZXMuZ2V0QWN0aXZlVGhlbWVzKCkuZmluZCgodGhlbWUpID0+IHRoZW1lLm1ldGFkYXRhLnRoZW1lID09PSAnc3ludGF4JylcbiAgICBjb25zdCBhY3RpdmVTeW50YXhUaGVtZSA9IHRoZW1lICE9IG51bGwgPyB0aGVtZS5tZXRhZGF0YSA6IG51bGxcbiAgICBpZiAoYWN0aXZlU3ludGF4VGhlbWUgIT0gbnVsbCkge1xuICAgICAgdGhpcy5zZXR0aW5nc1ZpZXcuc2hvd1BhbmVsKHRoaXMuYWN0aXZlU3ludGF4VGhlbWUsIHtcbiAgICAgICAgYmFjazogJ1RoZW1lcycsXG4gICAgICAgIHBhY2s6IGFjdGl2ZVN5bnRheFRoZW1lXG4gICAgICB9KVxuICAgIH1cbiAgfVxuXG4gIHNjcm9sbFVwICgpIHtcbiAgICB0aGlzLmVsZW1lbnQuc2Nyb2xsVG9wIC09IGRvY3VtZW50LmJvZHkub2Zmc2V0SGVpZ2h0IC8gMjBcbiAgfVxuXG4gIHNjcm9sbERvd24gKCkge1xuICAgIHRoaXMuZWxlbWVudC5zY3JvbGxUb3AgKz0gZG9jdW1lbnQuYm9keS5vZmZzZXRIZWlnaHQgLyAyMFxuICB9XG5cbiAgcGFnZVVwICgpIHtcbiAgICB0aGlzLmVsZW1lbnQuc2Nyb2xsVG9wIC09IHRoaXMuZWxlbWVudC5vZmZzZXRIZWlnaHRcbiAgfVxuXG4gIHBhZ2VEb3duICgpIHtcbiAgICB0aGlzLmVsZW1lbnQuc2Nyb2xsVG9wICs9IHRoaXMuZWxlbWVudC5vZmZzZXRIZWlnaHRcbiAgfVxuXG4gIHNjcm9sbFRvVG9wICgpIHtcbiAgICB0aGlzLmVsZW1lbnQuc2Nyb2xsVG9wID0gMFxuICB9XG5cbiAgc2Nyb2xsVG9Cb3R0b20gKCkge1xuICAgIHRoaXMuZWxlbWVudC5zY3JvbGxUb3AgPSB0aGlzLmVsZW1lbnQuc2Nyb2xsSGVpZ2h0XG4gIH1cbn1cbiJdfQ==