"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _react = _interopRequireDefault(require("react"));

var _propTypes = _interopRequireDefault(require("prop-types"));

var _classnames = _interopRequireDefault(require("classnames"));

var _octicon = _interopRequireDefault(require("../atom/octicon"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _extends() { _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }

function _objectWithoutProperties(source, excluded) { if (source == null) return {}; var target = _objectWithoutPropertiesLoose(source, excluded); var key, i; if (Object.getOwnPropertySymbols) { var sourceSymbolKeys = Object.getOwnPropertySymbols(source); for (i = 0; i < sourceSymbolKeys.length; i++) { key = sourceSymbolKeys[i]; if (excluded.indexOf(key) >= 0) continue; if (!Object.prototype.propertyIsEnumerable.call(source, key)) continue; target[key] = source[key]; } } return target; }

function _objectWithoutPropertiesLoose(source, excluded) { if (source == null) return {}; var target = {}; var sourceKeys = Object.keys(source); var key, i; for (i = 0; i < sourceKeys.length; i++) { key = sourceKeys[i]; if (excluded.indexOf(key) >= 0) continue; target[key] = source[key]; } return target; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

const typeAndStateToIcon = {
  Issue: {
    OPEN: 'issue-opened',
    CLOSED: 'issue-closed'
  },
  PullRequest: {
    OPEN: 'git-pull-request',
    CLOSED: 'git-pull-request',
    MERGED: 'git-merge'
  }
};

class IssueishBadge extends _react.default.Component {
  render() {
    const _this$props = this.props,
          {
      type,
      state
    } = _this$props,
          others = _objectWithoutProperties(_this$props, ["type", "state"]);

    const icons = typeAndStateToIcon[type] || {};
    const icon = icons[state] || 'question';

    const {
      className
    } = others,
          otherProps = _objectWithoutProperties(others, ["className"]);

    return _react.default.createElement("span", _extends({
      className: (0, _classnames.default)(className, 'github-IssueishBadge', state.toLowerCase())
    }, otherProps), _react.default.createElement(_octicon.default, {
      icon: icon
    }), state.toLowerCase());
  }

}

exports.default = IssueishBadge;

_defineProperty(IssueishBadge, "propTypes", {
  type: _propTypes.default.oneOf(['Issue', 'PullRequest', 'Unknown']).isRequired,
  state: _propTypes.default.oneOf(['OPEN', 'CLOSED', 'MERGED', 'UNKNOWN']).isRequired
});
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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