"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _react = _interopRequireDefault(require("react"));

var _propTypes = _interopRequireDefault(require("prop-types"));

var _electron = require("electron");

var _helpers = require("../helpers");

var _reporterProxy = require("../reporter-proxy");

var _propTypes2 = require("../prop-types");

var _issueishSearchesController = _interopRequireDefault(require("./issueish-searches-controller"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

class RemoteController extends _react.default.Component {
  constructor(props) {
    super(props);
    (0, _helpers.autobind)(this, 'onCreatePr');
  }

  render() {
    return _react.default.createElement(_issueishSearchesController.default, {
      endpoint: this.props.endpoint,
      token: this.props.token,
      remoteOperationObserver: this.props.remoteOperationObserver,
      workingDirectory: this.props.workingDirectory,
      repository: this.props.repository,
      workspace: this.props.workspace,
      remote: this.props.remote,
      remotes: this.props.remotes,
      branches: this.props.branches,
      aheadCount: this.props.aheadCount,
      pushInProgress: this.props.pushInProgress,
      onCreatePr: this.onCreatePr
    });
  }

  async onCreatePr() {
    const currentBranch = this.props.branches.getHeadBranch();
    const upstream = currentBranch.getUpstream();

    if (!upstream.isPresent() || this.props.aheadCount > 0) {
      await this.props.onPushBranch();
    }

    let createPrUrl = 'https://github.com/';
    createPrUrl += this.props.remote.getOwner() + '/' + this.props.remote.getRepo();
    createPrUrl += '/compare/' + encodeURIComponent(currentBranch.getName());
    createPrUrl += '?expand=1';
    return new Promise((resolve, reject) => {
      _electron.shell.openExternal(createPrUrl, {}, err => {
        if (err) {
          reject(err);
        } else {
          (0, _reporterProxy.incrementCounter)('create-pull-request');
          resolve();
        }
      });
    });
  }

}

exports.default = RemoteController;

_defineProperty(RemoteController, "propTypes", {
  // Relay payload
  repository: _propTypes.default.shape({
    id: _propTypes.default.string.isRequired,
    defaultBranchRef: _propTypes.default.shape({
      prefix: _propTypes.default.string.isRequired,
      name: _propTypes.default.string.isRequired
    })
  }),
  // Connection
  endpoint: _propTypes2.EndpointPropType.isRequired,
  token: _propTypes.default.string.isRequired,
  // Repository derived attributes
  remoteOperationObserver: _propTypes2.OperationStateObserverPropType.isRequired,
  workingDirectory: _propTypes.default.string.isRequired,
  workspace: _propTypes.default.object.isRequired,
  remote: _propTypes2.RemotePropType.isRequired,
  remotes: _propTypes2.RemoteSetPropType.isRequired,
  branches: _propTypes2.BranchSetPropType.isRequired,
  aheadCount: _propTypes.default.number,
  pushInProgress: _propTypes.default.bool.isRequired,
  // Actions
  onPushBranch: _propTypes.default.func.isRequired
});
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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