"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _react = _interopRequireDefault(require("react"));

var _propTypes = _interopRequireDefault(require("prop-types"));

var _propTypes2 = require("../prop-types");

var _helpers = require("../helpers");

var _githubTabView = _interopRequireDefault(require("../views/github-tab-view"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

class GitHubTabController extends _react.default.Component {
  constructor(props) {
    super(props);
    (0, _helpers.autobind)(this, 'handlePushBranch', 'handleRemoteSelect');
  }

  render() {
    const gitHubRemotes = this.props.allRemotes.filter(remote => remote.isGithubRepo());
    const currentBranch = this.props.branches.getHeadBranch();
    let currentRemote = gitHubRemotes.withName(this.props.selectedRemoteName);
    let manyRemotesAvailable = false;

    if (!currentRemote.isPresent() && gitHubRemotes.size() === 1) {
      currentRemote = Array.from(gitHubRemotes)[0];
    } else if (!currentRemote.isPresent() && gitHubRemotes.size() > 1) {
      manyRemotesAvailable = true;
    }

    return _react.default.createElement(_githubTabView.default, {
      workspace: this.props.workspace,
      remoteOperationObserver: this.props.remoteOperationObserver,
      loginModel: this.props.loginModel,
      rootHolder: this.props.rootHolder,
      workingDirectory: this.props.workingDirectory,
      branches: this.props.branches,
      currentBranch: currentBranch,
      remotes: gitHubRemotes,
      currentRemote: currentRemote,
      manyRemotesAvailable: manyRemotesAvailable,
      aheadCount: this.props.aheadCount,
      pushInProgress: this.props.pushInProgress,
      isLoading: this.props.isLoading,
      handlePushBranch: this.handlePushBranch,
      handleRemoteSelect: this.handleRemoteSelect
    });
  }

  handlePushBranch(currentBranch, targetRemote) {
    return this.props.repository.push(currentBranch.getName(), {
      remote: targetRemote,
      setUpstream: true
    });
  }

  handleRemoteSelect(e, remote) {
    e.preventDefault();
    return this.props.repository.setConfig('atomGithub.currentRemote', remote.getName());
  }

}

exports.default = GitHubTabController;

_defineProperty(GitHubTabController, "propTypes", {
  workspace: _propTypes.default.object.isRequired,
  repository: _propTypes.default.object.isRequired,
  remoteOperationObserver: _propTypes2.OperationStateObserverPropType.isRequired,
  loginModel: _propTypes2.GithubLoginModelPropType.isRequired,
  rootHolder: _propTypes2.RefHolderPropType.isRequired,
  workingDirectory: _propTypes.default.string.isRequired,
  allRemotes: _propTypes2.RemoteSetPropType.isRequired,
  branches: _propTypes2.BranchSetPropType.isRequired,
  selectedRemoteName: _propTypes.default.string,
  aheadCount: _propTypes.default.number,
  pushInProgress: _propTypes.default.bool.isRequired,
  isLoading: _propTypes.default.bool.isRequired
});
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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