S2 = Manifold(2, 'S^2', start_index=1)
polar = S2.chart('th ph'); th, ph = polar[:]
epolar = polar.frame()
ch_basis = S2.automorphism_field()
ch_basis[1,1], ch_basis[2,2] = 1, 1/sin(th)
epolar_ON = epolar.new_frame(ch_basis, 'epolar_ON')
nab = S2.affine_connection('nab')
_ = nab.set_coef(frame=epolar_ON)
t,tmin,tmax,th0,ph0,v_th0,v_ph0 = var('t tmin tmax th0 ph0 v_th0 v_ph0')
p = S2.point((th0, ph0), name='p')
Tp = S2.tangent_space(p)
v = Tp((v_th0, v_ph0), basis=epolar_ON.at(p))
c = S2.integrated_autoparallel_curve(nab, (t, tmin, tmax), v,
                                          chart=polar, name='c')
R3 = Manifold(3, 'R3', start_index=1)
cart = R3.chart('X Y Z')
euclid_embedding = S2.diff_map(R3,
      {(polar, cart):[sin(th)*cos(ph),sin(th)*sin(ph),cos(th)]})
sol = c.solve(solution_key='sol-angle',
    parameters_values={tmin:0,tmax:2,th0:pi/4,ph0:0.1,v_th0:1,v_ph0:8})
interp = c.interpolate(solution_key='sol-angle',
                       interpolation_key='interp-angle')
graph3D_embedded_angle_curve = c.plot_integrated(interpolation_key='interp-angle',
    mapping=euclid_embedding, thickness=5, display_tangent=True,
    scale=0.1, width_tangent=0.5)
graph3D_embedded_polar_coords = polar.plot(chart=cart,
     mapping=euclid_embedding, number_values=15, color='yellow')
graph = graph3D_embedded_angle_curve + graph3D_embedded_polar_coords
sphinx_plot(graph)