/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.ProjectComponent;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.AreaInstance;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.progress.util.BackgroundTaskUtil;
import com.intellij.openapi.project.DumbAwareRunnable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.project.ProjectManagerListener;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.impl.DirectoryIndexExcludePolicy;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Couple;
import com.intellij.openapi.util.Factory;
import com.intellij.openapi.util.Getter;
import com.intellij.openapi.util.JDOMExternalizerUtil;
import com.intellij.openapi.util.NamedRunnable;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.AbstractVcsHelper;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.FileStatus;
import com.intellij.openapi.vcs.FileStatusManager;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.VcsConfiguration;
import com.intellij.openapi.vcs.VcsConnectionProblem;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.VcsListener;
import com.intellij.openapi.vcs.VcsShowConfirmationOption;
import com.intellij.openapi.vcs.changes.BaseRevision;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangeList;
import com.intellij.openapi.vcs.changes.ChangeListAdapter;
import com.intellij.openapi.vcs.changes.ChangeListData;
import com.intellij.openapi.vcs.changes.ChangeListListener;
import com.intellij.openapi.vcs.changes.ChangeListManagerEx;
import com.intellij.openapi.vcs.changes.ChangeListManagerGate;
import com.intellij.openapi.vcs.changes.ChangeListManagerSerialization;
import com.intellij.openapi.vcs.changes.ChangeListOwner;
import com.intellij.openapi.vcs.changes.ChangeListWorker;
import com.intellij.openapi.vcs.changes.ChangeProvider;
import com.intellij.openapi.vcs.changes.ChangelistBuilder;
import com.intellij.openapi.vcs.changes.ChangesUtil;
import com.intellij.openapi.vcs.changes.ChangesViewI;
import com.intellij.openapi.vcs.changes.ChangesViewManager;
import com.intellij.openapi.vcs.changes.CommitExecutor;
import com.intellij.openapi.vcs.changes.ContentRevision;
import com.intellij.openapi.vcs.changes.DelayedNotificator;
import com.intellij.openapi.vcs.changes.DummyChangesView;
import com.intellij.openapi.vcs.changes.FileHolder;
import com.intellij.openapi.vcs.changes.FileHolderComposite;
import com.intellij.openapi.vcs.changes.IgnoredFileBean;
import com.intellij.openapi.vcs.changes.IgnoredFileProvider;
import com.intellij.openapi.vcs.changes.IgnoredFilesComponent;
import com.intellij.openapi.vcs.changes.IgnoredFilesCompositeHolder;
import com.intellij.openapi.vcs.changes.InvokeAfterUpdateMode;
import com.intellij.openapi.vcs.changes.LastUnchangedContentTracker;
import com.intellij.openapi.vcs.changes.LocalChangeList;
import com.intellij.openapi.vcs.changes.LocalChangeListsLoadedListener;
import com.intellij.openapi.vcs.changes.LocallyDeletedChange;
import com.intellij.openapi.vcs.changes.LogicalLock;
import com.intellij.openapi.vcs.changes.Modifier;
import com.intellij.openapi.vcs.changes.RemoteRevisionsCache;
import com.intellij.openapi.vcs.changes.UpdateRequestsQueue;
import com.intellij.openapi.vcs.changes.UpdatingChangeListBuilder;
import com.intellij.openapi.vcs.changes.VcsAnnotationRefresher;
import com.intellij.openapi.vcs.changes.VcsConfirmationDialog;
import com.intellij.openapi.vcs.changes.VcsDirtyScope;
import com.intellij.openapi.vcs.changes.VcsDirtyScopeManager;
import com.intellij.openapi.vcs.changes.VcsDirtyScopeModifier;
import com.intellij.openapi.vcs.changes.VcsDirtyScopeVfsListener;
import com.intellij.openapi.vcs.changes.VcsInvalidated;
import com.intellij.openapi.vcs.changes.VcsModifiableDirtyScope;
import com.intellij.openapi.vcs.changes.VirtualFileHolder;
import com.intellij.openapi.vcs.changes.actions.ChangeListRemoveConfirmation;
import com.intellij.openapi.vcs.changes.conflicts.ChangelistConflictTracker;
import com.intellij.openapi.vcs.changes.ui.ChangeListDeltaListener;
import com.intellij.openapi.vcs.changes.ui.CommitHelper;
import com.intellij.openapi.vcs.checkin.CheckinEnvironment;
import com.intellij.openapi.vcs.impl.AbstractVcsHelperImpl;
import com.intellij.openapi.vcs.impl.ContentRevisionCache;
import com.intellij.openapi.vcs.impl.ProjectLevelVcsManagerImpl;
import com.intellij.openapi.vcs.impl.VcsInitObject;
import com.intellij.openapi.vcs.impl.VcsRootIterator;
import com.intellij.openapi.vcs.readOnlyHandler.ReadonlyStatusHandlerImpl;
import com.intellij.openapi.vcs.ui.VcsBalloonProblemNotifier;
import com.intellij.openapi.vfs.ReadonlyStatusHandler;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.ui.EditorNotifications;
import com.intellij.util.Consumer;
import com.intellij.util.EventDispatcher;
import com.intellij.util.ExceptionUtil;
import com.intellij.util.Function;
import com.intellij.util.FunctionUtil;
import com.intellij.util.NullableFunction;
import com.intellij.util.ObjectUtils;
import com.intellij.util.Processor;
import com.intellij.util.ThreeState;
import com.intellij.util.concurrency.AppExecutorUtil;
import com.intellij.util.concurrency.Semaphore;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.messages.Topic;
import com.intellij.util.ui.UIUtil;
import com.intellij.vcsUtil.VcsUtil;
import java.io.File;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EventListener;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.swing.JComponent;
import kotlin.jvm.functions.Function1;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@State(name="ChangeListManager", storages={@Storage(value="$WORKSPACE_FILE$")})
public class ChangeListManagerImpl
extends ChangeListManagerEx
implements ProjectComponent,
ChangeListOwner,
PersistentStateComponent<Element> {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.vcs.changes.ChangeListManagerImpl");
    private static final String EXCLUDED_CONVERTED_TO_IGNORED_OPTION = "EXCLUDED_CONVERTED_TO_IGNORED";
    public static final Topic<LocalChangeListsLoadedListener> LISTS_LOADED = new Topic("LOCAL_CHANGE_LISTS_LOADED", LocalChangeListsLoadedListener.class);
    private final Project myProject;
    private final VcsConfiguration myConfig;
    private final ChangesViewI myChangesViewManager;
    private final FileStatusManager myFileStatusManager;
    private final ChangelistConflictTracker myConflictTracker;
    private VcsDirtyScopeManager myDirtyScopeManager;
    private final Scheduler myScheduler;
    private final EventDispatcher<ChangeListListener> myListeners;
    private final DelayedNotificator myDelayedNotificator;
    private final Object myDataLock;
    private final IgnoredFilesComponent myIgnoredIdeaLevel;
    private final UpdateRequestsQueue myUpdater;
    private final Modifier myModifier;
    private final MyChangesDeltaForwarder myDeltaForwarder;
    private FileHolderComposite myComposite;
    private final ChangeListWorker myWorker;
    private VcsException myUpdateException;
    private Factory<JComponent> myAdditionalInfo;
    private volatile boolean myShowLocalChangesInvalidated;
    @NotNull
    private ProgressIndicator myUpdateChangesProgressIndicator;
    private volatile String myFreezeName;
    @NotNull
    private final Set<String> myListsToBeDeletedSilently;
    @NotNull
    private final Set<String> myListsToBeDeleted;
    private boolean myEmptyListDeletionScheduled;
    private boolean myModalNotificationsBlocked;
    private final List<CommitExecutor> myRegisteredCommitExecutors;
    private boolean myExcludedConvertedToIgnored;

    public static ChangeListManagerImpl getInstanceImpl(Project project) {
        return (ChangeListManagerImpl)ChangeListManagerImpl.getInstance((Project)project);
    }

    void setDirtyScopeManager(VcsDirtyScopeManager dirtyScopeManager) {
        this.myDirtyScopeManager = dirtyScopeManager;
    }

    public ChangeListManagerImpl(@NotNull Project project, VcsConfiguration config2) {
        if (project == null) {
            ChangeListManagerImpl.$$$reportNull$$$0(0);
        }
        this.myScheduler = new Scheduler();
        this.myListeners = EventDispatcher.create(ChangeListListener.class);
        this.myDataLock = new Object();
        this.myUpdateChangesProgressIndicator = ChangeListManagerImpl.createProgressIndicator();
        this.myListsToBeDeletedSilently = new HashSet<String>();
        this.myListsToBeDeleted = new HashSet<String>();
        this.myRegisteredCommitExecutors = new ArrayList<CommitExecutor>();
        this.myProject = project;
        this.myConfig = config2;
        this.myChangesViewManager = this.myProject.isDefault() ? new DummyChangesView(this.myProject) : ChangesViewManager.getInstance(this.myProject);
        this.myFileStatusManager = FileStatusManager.getInstance((Project)this.myProject);
        this.myConflictTracker = new ChangelistConflictTracker(project, this, this.myFileStatusManager, EditorNotifications.getInstance((Project)project));
        this.myIgnoredIdeaLevel = new IgnoredFilesComponent(this.myProject, true);
        this.myComposite = new FileHolderComposite(project);
        this.myDeltaForwarder = new MyChangesDeltaForwarder(this.myProject, this.myScheduler);
        this.myDelayedNotificator = new DelayedNotificator(this, this.myListeners, this.myScheduler);
        this.myWorker = new ChangeListWorker(this.myProject, this.myDelayedNotificator);
        this.myUpdater = new UpdateRequestsQueue(this.myProject, this.myScheduler, () -> this.updateImmediately());
        this.myModifier = new Modifier(this.myWorker, this.myDelayedNotificator);
        this.myListeners.addListener((EventListener)new ChangeListAdapter(){

            public void defaultListChanged(ChangeList oldDefaultList, ChangeList newDefaultList, boolean automatic) {
                LocalChangeList oldList = (LocalChangeList)oldDefaultList;
                if (automatic || oldDefaultList == null || oldList.hasDefaultName() || oldDefaultList.equals(newDefaultList)) {
                    return;
                }
                ChangeListManagerImpl.this.scheduleAutomaticEmptyChangeListDeletion(oldList);
            }
        });
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            ProjectManager.getInstance().addProjectManagerListener(project, new ProjectManagerListener(){

                public void projectClosing(@NotNull Project project) {
                    if (project == null) {
                        2.$$$reportNull$$$0(0);
                    }
                    ChangeListManagerImpl.this.waitEverythingDoneInTestMode();
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/vcs/changes/ChangeListManagerImpl$2", "projectClosing"));
                }
            });
        }
    }

    public void scheduleAutomaticEmptyChangeListDeletion(@NotNull LocalChangeList list2) {
        if (list2 == null) {
            ChangeListManagerImpl.$$$reportNull$$$0(1);
        }
        this.scheduleAutomaticEmptyChangeListDeletion(list2, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void scheduleAutomaticEmptyChangeListDeletion(@NotNull LocalChangeList oldList, boolean silently) {
        if (oldList == null) {
            ChangeListManagerImpl.$$$reportNull$$$0(2);
        }
        Object object = this.myDataLock;
        synchronized (object) {
            if (LOG.isDebugEnabled()) {
                LOG.debug(String.format("Schedule empty changelist deletion: %s, silently = %s", oldList.getName(), silently));
            }
            if (silently) {
                this.myListsToBeDeletedSilently.add(oldList.getId());
            } else {
                this.myListsToBeDeleted.add(oldList.getId());
            }
            if (!this.myEmptyListDeletionScheduled) {
                this.myEmptyListDeletionScheduled = true;
                this.invokeAfterUpdate(() -> this.deleteEmptyChangeLists(), InvokeAfterUpdateMode.SILENT, null, null);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deleteEmptyChangeLists() {
        List listsToBeDeleted;
        List listsToBeDeletedSilently;
        Function toDeleteMapping = id -> {
            LocalChangeList list2 = this.getChangeList((String)id);
            if (list2 == null || list2.isDefault() || list2.isReadOnly() || !list2.getChanges().isEmpty()) {
                return null;
            }
            return list2;
        };
        Object object = this.myDataLock;
        synchronized (object) {
            boolean askLater;
            if (LOG.isDebugEnabled()) {
                LOG.debug(String.format("Empty changelist deletion, scheduled:\nsilently: %s\nasking: %s", this.myListsToBeDeletedSilently, this.myListsToBeDeleted));
            }
            this.myListsToBeDeleted.removeAll(this.myListsToBeDeletedSilently);
            listsToBeDeletedSilently = ContainerUtil.mapNotNull(this.myListsToBeDeletedSilently, (Function)toDeleteMapping);
            this.myListsToBeDeletedSilently.clear();
            boolean bl = askLater = this.myModalNotificationsBlocked && this.myConfig.REMOVE_EMPTY_INACTIVE_CHANGELISTS == VcsShowConfirmationOption.Value.SHOW_CONFIRMATION;
            if (!askLater) {
                listsToBeDeleted = ContainerUtil.mapNotNull(this.myListsToBeDeleted, (Function)toDeleteMapping);
                this.myListsToBeDeleted.clear();
            } else {
                listsToBeDeleted = Collections.emptyList();
            }
            this.myEmptyListDeletionScheduled = false;
            if (LOG.isDebugEnabled()) {
                LOG.debug(String.format("Empty changelist deletion, to be deleted:\nsilently: %s\nasking: %s", listsToBeDeletedSilently, listsToBeDeleted));
            }
        }
        if (this.myConfig.REMOVE_EMPTY_INACTIVE_CHANGELISTS == VcsShowConfirmationOption.Value.DO_NOTHING_SILENTLY || this.myConfig.REMOVE_EMPTY_INACTIVE_CHANGELISTS == VcsShowConfirmationOption.Value.SHOW_CONFIRMATION && ApplicationManager.getApplication().isUnitTestMode()) {
            listsToBeDeleted.clear();
        }
        ChangeListRemoveConfirmation.deleteEmptyInactiveLists(this.myProject, listsToBeDeletedSilently, (Function1<? super List<? extends LocalChangeList>, Boolean>)((Function1)toAsk -> true));
        ChangeListRemoveConfirmation.deleteEmptyInactiveLists(this.myProject, listsToBeDeleted, (Function1<? super List<? extends LocalChangeList>, Boolean>)((Function1)toAsk -> this.myConfig.REMOVE_EMPTY_INACTIVE_CHANGELISTS == VcsShowConfirmationOption.Value.DO_ACTION_SILENTLY || ChangeListManagerImpl.showRemoveEmptyChangeListsProposal(this.myProject, this.myConfig, toAsk)));
    }

    public static boolean showRemoveEmptyChangeListsProposal(@NotNull Project project, final @NotNull VcsConfiguration config2, @NotNull Collection<? extends ChangeList> lists) {
        if (project == null) {
            ChangeListManagerImpl.$$$reportNull$$$0(3);
        }
        if (config2 == null) {
            ChangeListManagerImpl.$$$reportNull$$$0(4);
        }
        if (lists == null) {
            ChangeListManagerImpl.$$$reportNull$$$0(5);
        }
        if (lists.isEmpty()) {
            return false;
        }
        String question = lists.size() == 1 ? String.format("<html>The empty changelist '%s' is no longer active.<br>Do you want to remove it?</html>", StringUtil.first((String)lists.iterator().next().getName(), (int)30, (boolean)true)) : String.format("<html>Empty changelists<br/>%s are no longer active.<br>Do you want to remove them?</html>", StringUtil.join(lists, list2 -> StringUtil.first((String)list2.getName(), (int)30, (boolean)true), (String)"<br/>"));
        VcsConfirmationDialog dialog2 = new VcsConfirmationDialog(project, "Remove Empty Changelist", "Remove", "Cancel", new VcsShowConfirmationOption(){

            public VcsShowConfirmationOption.Value getValue() {
                return config2.REMOVE_EMPTY_INACTIVE_CHANGELISTS;
            }

            public void setValue(VcsShowConfirmationOption.Value value) {
                config2.REMOVE_EMPTY_INACTIVE_CHANGELISTS = value;
            }

            public boolean isPersistent() {
                return true;
            }
        }, question, "&Remember my choice");
        return dialog2.showAndGet();
    }

    @Override
    public void blockModalNotifications() {
        this.myModalNotificationsBlocked = true;
    }

    @Override
    public void unblockModalNotifications() {
        this.myModalNotificationsBlocked = false;
        this.deleteEmptyChangeLists();
    }

    public void projectOpened() {
        this.initializeForNewProject();
        VcsListener vcsListener = new VcsListener(){

            public void directoryMappingChanged() {
                VcsDirtyScopeManager.getInstance((Project)ChangeListManagerImpl.this.myProject).markEverythingDirty();
            }
        };
        ProjectLevelVcsManager vcsManager = ProjectLevelVcsManager.getInstance((Project)this.myProject);
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            this.myUpdater.initialized();
            this.myProject.getMessageBus().connect().subscribe(ProjectLevelVcsManager.VCS_CONFIGURATION_CHANGED, (Object)vcsListener);
        } else {
            ((ProjectLevelVcsManagerImpl)vcsManager).addInitializationRequest(VcsInitObject.CHANGE_LIST_MANAGER, (Runnable)((DumbAwareRunnable)() -> {
                this.myUpdater.initialized();
                this.broadcastStateAfterLoad();
                this.myProject.getMessageBus().connect().subscribe(ProjectLevelVcsManager.VCS_CONFIGURATION_CHANGED, (Object)vcsListener);
            }));
            this.myConflictTracker.startTracking();
        }
    }

    private void broadcastStateAfterLoad() {
        List listCopy = this.getChangeListsCopy();
        if (!this.myProject.isDisposed()) {
            ((LocalChangeListsLoadedListener)this.myProject.getMessageBus().syncPublisher(LISTS_LOADED)).processLoadedLists(listCopy);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initializeForNewProject() {
        Object object = this.myDataLock;
        synchronized (object) {
            if (!Registry.is((String)"ide.hide.excluded.files") && !this.myExcludedConvertedToIgnored) {
                this.convertExcludedToIgnored();
                this.myExcludedConvertedToIgnored = true;
            }
        }
    }

    void convertExcludedToIgnored() {
        for (DirectoryIndexExcludePolicy policy : (DirectoryIndexExcludePolicy[])DirectoryIndexExcludePolicy.EP_NAME.getExtensions((AreaInstance)this.myProject)) {
            for (VirtualFile file2 : policy.getExcludeRootsForProject()) {
                this.addDirectoryToIgnoreImplicitly(file2.getPath());
            }
        }
        ProjectFileIndex fileIndex = ProjectFileIndex.SERVICE.getInstance((Project)this.myProject);
        VirtualFileManager virtualFileManager = VirtualFileManager.getInstance();
        for (Module module : ModuleManager.getInstance((Project)this.myProject).getModules()) {
            for (String url : ModuleRootManager.getInstance((Module)module).getExcludeRootUrls()) {
                VirtualFile file3 = virtualFileManager.findFileByUrl(url);
                if (file3 != null && !fileIndex.isExcluded(file3)) continue;
                this.addDirectoryToIgnoreImplicitly(VfsUtilCore.urlToPath((String)url));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void projectClosed() {
        Object object = this.myDataLock;
        synchronized (object) {
            this.myUpdateChangesProgressIndicator.cancel();
        }
        this.myUpdater.stop();
        this.myConflictTracker.stopTracking();
    }

    @NotNull
    @NonNls
    public String getComponentName() {
        if ("ChangeListManager" == null) {
            ChangeListManagerImpl.$$$reportNull$$$0(6);
        }
        return "ChangeListManager";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerChangeTracker(@NotNull FilePath filePath, @NotNull ChangeListWorker.PartialChangeTracker tracker) {
        if (filePath == null) {
            ChangeListManagerImpl.$$$reportNull$$$0(7);
        }
        if (tracker == null) {
            ChangeListManagerImpl.$$$reportNull$$$0(8);
        }
        Object object = this.myDataLock;
        synchronized (object) {
            this.myWorker.registerChangeTracker(filePath, tracker);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterChangeTracker(@NotNull FilePath filePath, @NotNull ChangeListWorker.PartialChangeTracker tracker) {
        if (filePath == null) {
            ChangeListManagerImpl.$$$reportNull$$$0(9);
        }
        if (tracker == null) {
            ChangeListManagerImpl.$$$reportNull$$$0(10);
        }
        Object object = this.myDataLock;
        synchronized (object) {
            this.myWorker.unregisterChangeTracker(filePath, tracker);
        }
    }

    public void invokeAfterUpdate(@NotNull Runnable afterUpdate, @NotNull InvokeAfterUpdateMode mode, @Nullable String title, @Nullable ModalityState state) {
        if (afterUpdate == null) {
            ChangeListManagerImpl.$$$reportNull$$$0(11);
        }
        if (mode == null) {
            ChangeListManagerImpl.$$$reportNull$$$0(12);
        }
        this.invokeAfterUpdate(afterUpdate, mode, title, null, state);
    }

    public void invokeAfterUpdate(@NotNull Runnable afterUpdate, @NotNull InvokeAfterUpdateMode mode, @Nullable String title, @Nullable Consumer<? super VcsDirtyScopeManager> dirtyScopeManagerFiller, @Nullable ModalityState state) {
        if (afterUpdate == null) {
            ChangeListManagerImpl.$$$reportNull$$$0(13);
        }
        if (mode == null) {
            ChangeListManagerImpl.$$$reportNull$$$0(14);
        }
        if (dirtyScopeManagerFiller != null && !this.myProject.isDisposed()) {
            dirtyScopeManagerFiller.consume((Object)VcsDirtyScopeManager.getInstance((Project)this.myProject));
        }
        this.myUpdater.invokeAfterUpdate(afterUpdate, mode, title, state);
    }

    @Override
    public void freeze(@NotNull String reason) {
        if (reason == null) {
            ChangeListManagerImpl.$$$reportNull$$$0(15);
        }
        this.myUpdater.setIgnoreBackgroundOperation(true);
        Semaphore sem = new Semaphore();
        sem.down();
        this.invokeAfterUpdate(() -> {
            this.myUpdater.setIgnoreBackgroundOperation(false);
            this.myUpdater.pause();
            this.myFreezeName = reason;
            sem.up();
        }, InvokeAfterUpdateMode.SILENT_CALLBACK_POOLED, "", ModalityState.defaultModalityState());
        boolean free = false;
        while (!free) {
            ProgressIndicator pi = ProgressManager.getInstance().getProgressIndicator();
            if (pi != null) {
                pi.checkCanceled();
            }
            free = sem.waitFor(500L);
        }
    }

    @Override
    public void unfreeze() {
        this.myUpdater.go();
        this.myFreezeName = null;
    }

    public String isFreezed() {
        return this.myFreezeName;
    }

    public void executeOnUpdaterThread(@NotNull Runnable r) {
        if (r == null) {
            ChangeListManagerImpl.$$$reportNull$$$0(16);
        }
        this.myScheduler.submit(r);
    }

    public void executeUnderDataLock(@NotNull Runnable r) {
        if (r == null) {
            ChangeListManagerImpl.$$$reportNull$$$0(17);
        }
        ApplicationManager.getApplication().runReadAction(() -> {
            Object object = this.myDataLock;
            synchronized (object) {
                r.run();
            }
        });
    }

    public void scheduleUpdate() {
        this.myUpdater.schedule();
    }

    public void scheduleUpdate(boolean updateUnversionedFiles) {
        this.myUpdater.schedule();
    }

    private void filterOutIgnoredFiles(List<VcsDirtyScope> scopes) {
        HashSet refreshFiles = new HashSet();
        try {
            ReadAction.run(() -> {
                Object object = this.myDataLock;
                synchronized (object) {
                    IgnoredFilesCompositeHolder fileHolder = this.myComposite.getIgnoredFileHolder();
                    Iterator iterator = scopes.iterator();
                    while (iterator.hasNext()) {
                        VcsModifiableDirtyScope scope = (VcsModifiableDirtyScope)iterator.next();
                        VcsDirtyScopeModifier modifier = scope.getModifier();
                        if (modifier == null) continue;
                        fileHolder.notifyVcsStarted(scope.getVcs());
                        this.filterOutIgnoredFiles(modifier.getDirtyFilesIterator(), fileHolder, refreshFiles);
                        this.filterOutIgnoredFiles(modifier.getDirtyDirectoriesIterator(), fileHolder, refreshFiles);
                        modifier.recheckDirtyKeys();
                        if (!scope.isEmpty()) continue;
                        iterator.remove();
                    }
                }
            });
        }
        catch (ProcessCanceledException processCanceledException) {
        }
        catch (AssertionError | Exception ex) {
            LOG.error((Throwable)ex);
        }
        for (VirtualFile file2 : refreshFiles) {
            this.myFileStatusManager.fileStatusChanged(file2);
        }
    }

    private void filterOutIgnoredFiles(Iterator<? extends FilePath> iterator, IgnoredFilesCompositeHolder fileHolder, Set<? super VirtualFile> refreshFiles) {
        while (iterator.hasNext()) {
            VirtualFile file2 = iterator.next().getVirtualFile();
            if (file2 == null || !this.isIgnoredFile(file2)) continue;
            iterator.remove();
            fileHolder.addFile(file2);
            refreshFiles.add((VirtualFile)file2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateImmediately() {
        ProjectLevelVcsManager vcsManager = ProjectLevelVcsManager.getInstance((Project)this.myProject);
        if (!vcsManager.hasActiveVcss()) {
            return;
        }
        VcsInvalidated invalidated = this.myDirtyScopeManager.retrieveScopes();
        if (this.checkScopeIsEmpty(invalidated)) {
            LOG.debug("[update] - dirty scope is empty");
            this.myDirtyScopeManager.changesProcessed();
            return;
        }
        boolean wasEverythingDirty = invalidated.isEverythingDirty();
        List scopes = invalidated.getScopes();
        try {
            boolean takeChanges;
            DataHolder dataHolder;
            if (this.myUpdater.isStopped()) {
                return;
            }
            ProgressIndicator indicator = ChangeListManagerImpl.createProgressIndicator();
            Object object = this.myDataLock;
            synchronized (object) {
                dataHolder = new DataHolder(this.myComposite.copy(), new ChangeListWorker.ChangeListUpdater(this.myWorker), wasEverythingDirty);
                this.myModifier.enterUpdate();
                if (wasEverythingDirty) {
                    this.myUpdateException = null;
                    this.myAdditionalInfo = null;
                }
                this.myUpdateChangesProgressIndicator = indicator;
                if (LOG.isDebugEnabled()) {
                    String scopeInString = StringUtil.join((Collection)scopes, scope -> scope.toString(), (String)"->\n");
                    LOG.debug("refresh procedure started, everything: " + wasEverythingDirty + " dirty scope: " + scopeInString + "\nignored: " + this.myComposite.getIgnoredFileHolder().values().size() + "\nunversioned: " + this.myComposite.getVFHolder(FileHolder.HolderType.UNVERSIONED).getFiles().size() + "\ncurrent changes: " + this.myWorker);
                }
            }
            dataHolder.notifyStart();
            this.myChangesViewManager.scheduleRefresh();
            ProgressManager.getInstance().runProcess(() -> this.iterateScopes(dataHolder, scopes, indicator), indicator);
            Iterator iterator = this.myDataLock;
            synchronized (iterator) {
                takeChanges = this.myUpdateException == null;
            }
            if (takeChanges) {
                this.updateIgnoredFiles(dataHolder.getComposite());
            }
            ApplicationManager.getApplication().runReadAction(() -> {
                if (this.myProject.isDisposed()) {
                    return;
                }
                this.clearCurrentRevisionsCache(invalidated);
                Object object = this.myDataLock;
                synchronized (object) {
                    dataHolder.notifyEnd();
                    if (takeChanges) {
                        ChangeListWorker updatedWorker = dataHolder.getChangeListUpdater().finish();
                        this.myModifier.finishUpdate(updatedWorker);
                        this.myWorker.applyChangesFromUpdate(updatedWorker, this.myDeltaForwarder);
                        if (LOG.isDebugEnabled()) {
                            LOG.debug("refresh procedure finished, unversioned size: " + dataHolder.getComposite().getVFHolder(FileHolder.HolderType.UNVERSIONED).getFiles().size() + "\nchanges: " + this.myWorker);
                        }
                        boolean statusChanged = !this.myComposite.equals(dataHolder.getComposite());
                        this.myComposite = dataHolder.getComposite();
                        if (statusChanged) {
                            this.myDelayedNotificator.unchangedFileStatusChanged();
                        }
                        LOG.debug("[update] - success");
                    } else {
                        this.myModifier.finishUpdate(null);
                        LOG.debug("[update] - aborted");
                    }
                    this.myShowLocalChangesInvalidated = false;
                }
            });
            for (VcsDirtyScope scope2 : scopes) {
                AbstractVcs vcs = scope2.getVcs();
                if (vcs == null || !vcs.isTrackingUnchangedContent()) continue;
                scope2.iterateExistingInsideScope(file2 -> {
                    LastUnchangedContentTracker.markUntouched(file2);
                    return true;
                });
            }
        }
        catch (ProcessCanceledException dataHolder) {
        }
        catch (AssertionError | Exception ex) {
            LOG.error((Throwable)ex);
        }
        finally {
            this.myDirtyScopeManager.changesProcessed();
            this.myDelayedNotificator.changeListUpdateDone();
            this.myChangesViewManager.scheduleRefresh();
        }
    }

    private boolean checkScopeIsEmpty(VcsInvalidated invalidated) {
        if (invalidated == null) {
            return true;
        }
        if (invalidated.isEverythingDirty()) {
            return false;
        }
        if (invalidated.isEmpty()) {
            return true;
        }
        this.filterOutIgnoredFiles(invalidated.getScopes());
        return invalidated.isEmpty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void iterateScopes(DataHolder dataHolder, List<? extends VcsDirtyScope> scopes, @NotNull ProgressIndicator indicator) {
        if (indicator == null) {
            ChangeListManagerImpl.$$$reportNull$$$0(18);
        }
        ChangeListWorker.ChangeListUpdater updater = dataHolder.getChangeListUpdater();
        Getter disposedGetter = () -> this.myProject.isDisposed() || this.myUpdater.isStopped();
        UpdatingChangeListBuilder builder2 = new UpdatingChangeListBuilder(updater, dataHolder.getComposite(), (Getter<Boolean>)disposedGetter, this);
        for (VcsDirtyScope vcsDirtyScope : scopes) {
            indicator.checkCanceled();
            AbstractVcs vcs = vcsDirtyScope.getVcs();
            if (vcs == null) continue;
            this.myChangesViewManager.setBusy(true);
            this.actualUpdate(builder2, vcsDirtyScope, vcs, dataHolder, updater, indicator);
            Object object = this.myDataLock;
            synchronized (object) {
                if (this.myUpdateException != null) {
                    break;
                }
            }
        }
        Object object = this.myDataLock;
        synchronized (object) {
            if (this.myAdditionalInfo == null) {
                this.myAdditionalInfo = builder2.getAdditionalInfo();
            }
        }
    }

    private void clearCurrentRevisionsCache(VcsInvalidated invalidated) {
        ContentRevisionCache cache = ProjectLevelVcsManager.getInstance((Project)this.myProject).getContentRevisionCache();
        if (invalidated.isEverythingDirty()) {
            cache.clearAllCurrent();
        } else {
            cache.clearScope(invalidated.getScopes());
        }
    }

    @NotNull
    private static ProgressIndicator createProgressIndicator() {
        EmptyProgressIndicator emptyProgressIndicator = new EmptyProgressIndicator();
        if (emptyProgressIndicator == null) {
            ChangeListManagerImpl.$$$reportNull$$$0(19);
        }
        return emptyProgressIndicator;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void actualUpdate(@NotNull UpdatingChangeListBuilder builder2, @NotNull VcsDirtyScope scope, @NotNull AbstractVcs vcs, @NotNull DataHolder dataHolder, @NotNull ChangeListManagerGate gate, @NotNull ProgressIndicator indicator) {
        if (builder2 == null) {
            ChangeListManagerImpl.$$$reportNull$$$0(20);
        }
        if (scope == null) {
            ChangeListManagerImpl.$$$reportNull$$$0(21);
        }
        if (vcs == null) {
            ChangeListManagerImpl.$$$reportNull$$$0(22);
        }
        if (dataHolder == null) {
            ChangeListManagerImpl.$$$reportNull$$$0(23);
        }
        if (gate == null) {
            ChangeListManagerImpl.$$$reportNull$$$0(24);
        }
        if (indicator == null) {
            ChangeListManagerImpl.$$$reportNull$$$0(25);
        }
        dataHolder.notifyStartProcessingChanges((VcsModifiableDirtyScope)scope);
        try {
            ChangeProvider changeProvider = vcs.getChangeProvider();
            if (changeProvider != null) {
                builder2.setCurrent(scope);
                changeProvider.getChanges(scope, (ChangelistBuilder)builder2, indicator, gate);
            }
        }
        catch (VcsException e) {
            this.handleUpdateException(e);
        }
        catch (ProcessCanceledException e) {
            throw e;
        }
        catch (Throwable t) {
            LOG.debug(t);
            ExceptionUtil.rethrowAllAsUnchecked((Throwable)t);
        }
        finally {
            if (!this.myUpdater.isStopped()) {
                dataHolder.notifyDoneProcessingChanges();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleUpdateException(VcsException e) {
        LOG.info((Throwable)e);
        if (e instanceof VcsConnectionProblem) {
            ApplicationManager.getApplication().invokeLater(() -> ((VcsConnectionProblem)e).attemptQuickFix(false));
        }
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            AbstractVcsHelper helper = AbstractVcsHelper.getInstance((Project)this.myProject);
            if (helper instanceof AbstractVcsHelperImpl && ((AbstractVcsHelperImpl)helper).handleCustom(e)) {
                return;
            }
            e.printStackTrace();
        }
        Object object = this.myDataLock;
        synchronized (object) {
            this.myUpdateException = e;
        }
    }

    public static boolean isUnder(Change change, VcsDirtyScope scope) {
        ContentRevision before = change.getBeforeRevision();
        ContentRevision after2 = change.getAfterRevision();
        return before != null && scope.belongsTo(before.getFile()) || after2 != null && scope.belongsTo(after2.getFile());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @NotNull
    public List<LocalChangeList> getChangeLists() {
        Object object = this.myDataLock;
        // MONITORENTER : object
        List<LocalChangeList> list2 = this.myWorker.getChangeLists();
        // MONITOREXIT : object
        if (list2 != null) return list2;
        ChangeListManagerImpl.$$$reportNull$$$0(26);
        return list2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @NotNull
    public List<File> getAffectedPaths() {
        Object object = this.myDataLock;
        // MONITORENTER : object
        List<File> list2 = this.myWorker.getAffectedPaths();
        // MONITOREXIT : object
        if (list2 != null) return list2;
        ChangeListManagerImpl.$$$reportNull$$$0(27);
        return list2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @NotNull
    public List<VirtualFile> getAffectedFiles() {
        Object object = this.myDataLock;
        // MONITORENTER : object
        List<VirtualFile> list2 = this.myWorker.getAffectedFiles();
        // MONITOREXIT : object
        if (list2 != null) return list2;
        ChangeListManagerImpl.$$$reportNull$$$0(28);
        return list2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @NotNull
    public Collection<Change> getAllChanges() {
        Object object = this.myDataLock;
        // MONITORENTER : object
        Collection<Change> collection = this.myWorker.getAllChanges();
        // MONITOREXIT : object
        if (collection != null) return collection;
        ChangeListManagerImpl.$$$reportNull$$$0(29);
        return collection;
    }

    @NotNull
    public List<VirtualFile> getUnversionedFiles() {
        List list2 = (List)ReadAction.compute(() -> {
            Object object = this.myDataLock;
            synchronized (object) {
                return this.myComposite.getVFHolder(FileHolder.HolderType.UNVERSIONED).getFiles();
            }
        });
        if (list2 == null) {
            ChangeListManagerImpl.$$$reportNull$$$0(30);
        }
        return list2;
    }

    @NotNull
    public List<VirtualFile> getModifiedWithoutEditing() {
        List list2 = (List)ReadAction.compute(() -> {
            Object object = this.myDataLock;
            synchronized (object) {
                return this.myComposite.getVFHolder(FileHolder.HolderType.MODIFIED_WITHOUT_EDITING).getFiles();
            }
        });
        if (list2 == null) {
            ChangeListManagerImpl.$$$reportNull$$$0(31);
        }
        return list2;
    }

    @NotNull
    public List<VirtualFile> getIgnoredFiles() {
        List list2 = (List)ReadAction.compute(() -> {
            Object object = this.myDataLock;
            synchronized (object) {
                return new ArrayList<VirtualFile>(this.myComposite.getIgnoredFileHolder().values());
            }
        });
        if (list2 == null) {
            ChangeListManagerImpl.$$$reportNull$$$0(32);
        }
        return list2;
    }

    boolean isIgnoredInUpdateMode() {
        return (Boolean)ReadAction.compute(() -> {
            Object object = this.myDataLock;
            synchronized (object) {
                return this.myComposite.getIgnoredFileHolder().isInUpdatingMode();
            }
        });
    }

    public List<VirtualFile> getLockedFolders() {
        return (List)ReadAction.compute(() -> {
            Object object = this.myDataLock;
            synchronized (object) {
                return this.myComposite.getVFHolder(FileHolder.HolderType.LOCKED).getFiles();
            }
        });
    }

    Map<VirtualFile, LogicalLock> getLogicallyLockedFolders() {
        return (Map)ReadAction.compute(() -> {
            Object object = this.myDataLock;
            synchronized (object) {
                return new HashMap<VirtualFile, LogicalLock>(this.myComposite.getLogicallyLockedFileHolder().getMap());
            }
        });
    }

    public boolean isLogicallyLocked(VirtualFile file2) {
        return (Boolean)ReadAction.compute(() -> {
            Object object = this.myDataLock;
            synchronized (object) {
                return this.myComposite.getLogicallyLockedFileHolder().containsKey(file2);
            }
        });
    }

    public boolean isContainedInLocallyDeleted(FilePath filePath) {
        return (Boolean)ReadAction.compute(() -> {
            Object object = this.myDataLock;
            synchronized (object) {
                return this.myComposite.getDeletedFileHolder().isContainedInLocallyDeleted(filePath);
            }
        });
    }

    public List<LocallyDeletedChange> getDeletedFiles() {
        return (List)ReadAction.compute(() -> {
            Object object = this.myDataLock;
            synchronized (object) {
                return this.myComposite.getDeletedFileHolder().getFiles();
            }
        });
    }

    MultiMap<String, VirtualFile> getSwitchedFilesMap() {
        return (MultiMap)ReadAction.compute(() -> {
            Object object = this.myDataLock;
            synchronized (object) {
                return this.myComposite.getSwitchedFileHolder().getBranchToFileMap();
            }
        });
    }

    @Nullable
    Map<VirtualFile, String> getSwitchedRoots() {
        return (Map)ReadAction.compute(() -> {
            Object object = this.myDataLock;
            synchronized (object) {
                return this.myComposite.getRootSwitchFileHolder().getFilesMapCopy();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public VcsException getUpdateException() {
        Object object = this.myDataLock;
        synchronized (object) {
            return this.myUpdateException;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Factory<JComponent> getAdditionalUpdateInfo() {
        Object object = this.myDataLock;
        synchronized (object) {
            return this.myAdditionalInfo;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isFileAffected(@NotNull VirtualFile file2) {
        if (file2 == null) {
            ChangeListManagerImpl.$$$reportNull$$$0(33);
        }
        Object object = this.myDataLock;
        synchronized (object) {
            return this.myWorker.getStatus(file2) != null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public LocalChangeList findChangeList(String name) {
        Object object = this.myDataLock;
        synchronized (object) {
            return this.myWorker.getChangeListByName(name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LocalChangeList getChangeList(String id) {
        Object object = this.myDataLock;
        synchronized (object) {
            return this.myWorker.getChangeListById(id);
        }
    }

    public LocalChangeList addChangeList(@NotNull String name, @Nullable String comment) {
        if (name == null) {
            ChangeListManagerImpl.$$$reportNull$$$0(34);
        }
        return this.addChangeList(name, comment, null);
    }

    @Override
    @NotNull
    public LocalChangeList addChangeList(@NotNull String name, @Nullable String comment, @Nullable ChangeListData data) {
        if (name == null) {
            ChangeListManagerImpl.$$$reportNull$$$0(35);
        }
        LocalChangeList localChangeList = (LocalChangeList)ReadAction.compute(() -> {
            Object object = this.myDataLock;
            synchronized (object) {
                LocalChangeList changeList = this.myModifier.addChangeList(name, comment, data);
                this.myChangesViewManager.scheduleRefresh();
                return changeList;
            }
        });
        if (localChangeList == null) {
            ChangeListManagerImpl.$$$reportNull$$$0(36);
        }
        return localChangeList;
    }

    public void removeChangeList(@NotNull String name) {
        if (name == null) {
            ChangeListManagerImpl.$$$reportNull$$$0(37);
        }
        ApplicationManager.getApplication().runReadAction(() -> {
            Object object = this.myDataLock;
            synchronized (object) {
                this.myModifier.removeChangeList(name);
                this.myChangesViewManager.scheduleRefresh();
            }
        });
    }

    public void removeChangeList(@NotNull LocalChangeList list2) {
        if (list2 == null) {
            ChangeListManagerImpl.$$$reportNull$$$0(38);
        }
        this.removeChangeList(list2.getName());
    }

    public void setDefaultChangeList(@NotNull String name, boolean automatic) {
        if (name == null) {
            ChangeListManagerImpl.$$$reportNull$$$0(39);
        }
        ApplicationManager.getApplication().runReadAction(() -> {
            Object object = this.myDataLock;
            synchronized (object) {
                this.myModifier.setDefault(name, automatic);
            }
        });
        this.myChangesViewManager.scheduleRefresh();
    }

    public void setDefaultChangeList(@NotNull String name) {
        if (name == null) {
            ChangeListManagerImpl.$$$reportNull$$$0(40);
        }
        this.setDefaultChangeList(name, false);
    }

    public void setDefaultChangeList(@NotNull LocalChangeList list2) {
        if (list2 == null) {
            ChangeListManagerImpl.$$$reportNull$$$0(41);
        }
        this.setDefaultChangeList(list2, false);
    }

    @Override
    public void setDefaultChangeList(@NotNull LocalChangeList list2, boolean automatic) {
        if (list2 == null) {
            ChangeListManagerImpl.$$$reportNull$$$0(42);
        }
        this.setDefaultChangeList(list2.getName(), automatic);
    }

    public boolean setReadOnly(@NotNull String name, boolean value) {
        if (name == null) {
            ChangeListManagerImpl.$$$reportNull$$$0(43);
        }
        return (Boolean)ReadAction.compute(() -> {
            Object object = this.myDataLock;
            synchronized (object) {
                boolean result2 = this.myModifier.setReadOnly(name, value);
                this.myChangesViewManager.scheduleRefresh();
                return result2;
            }
        });
    }

    public boolean editName(@NotNull String fromName, @NotNull String toName) {
        if (fromName == null) {
            ChangeListManagerImpl.$$$reportNull$$$0(44);
        }
        if (toName == null) {
            ChangeListManagerImpl.$$$reportNull$$$0(45);
        }
        return (Boolean)ReadAction.compute(() -> {
            Object object = this.myDataLock;
            synchronized (object) {
                boolean result2 = this.myModifier.editName(fromName, toName);
                this.myChangesViewManager.scheduleRefresh();
                return result2;
            }
        });
    }

    public String editComment(@NotNull String name, String newComment) {
        if (name == null) {
            ChangeListManagerImpl.$$$reportNull$$$0(46);
        }
        return (String)ReadAction.compute(() -> {
            Object object = this.myDataLock;
            synchronized (object) {
                String oldComment = this.myModifier.editComment(name, StringUtil.notNullize((String)newComment));
                this.myChangesViewManager.scheduleRefresh();
                return oldComment;
            }
        });
    }

    @Override
    public boolean editChangeListData(@NotNull String name, @Nullable ChangeListData newData) {
        if (name == null) {
            ChangeListManagerImpl.$$$reportNull$$$0(47);
        }
        return (Boolean)ReadAction.compute(() -> {
            Object object = this.myDataLock;
            synchronized (object) {
                boolean result2 = this.myModifier.editData(name, newData);
                this.myChangesViewManager.scheduleRefresh();
                return result2;
            }
        });
    }

    @Override
    public void moveChangesTo(@NotNull LocalChangeList list2, Change ... changes2) {
        if (list2 == null) {
            ChangeListManagerImpl.$$$reportNull$$$0(48);
        }
        if (changes2 == null) {
            ChangeListManagerImpl.$$$reportNull$$$0(49);
        }
        ApplicationManager.getApplication().runReadAction(() -> {
            Object object = this.myDataLock;
            synchronized (object) {
                this.myModifier.moveChangesTo(list2.getName(), changes2);
            }
        });
        this.myChangesViewManager.scheduleRefresh();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @NotNull
    public LocalChangeList getDefaultChangeList() {
        Object object = this.myDataLock;
        // MONITORENTER : object
        LocalChangeList localChangeList = this.myWorker.getDefaultList();
        // MONITOREXIT : object
        if (localChangeList != null) return localChangeList;
        ChangeListManagerImpl.$$$reportNull$$$0(50);
        return localChangeList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @NotNull
    public String getDefaultListName() {
        Object object = this.myDataLock;
        // MONITORENTER : object
        String string = this.myWorker.getDefaultList().getName();
        // MONITOREXIT : object
        if (string != null) return string;
        ChangeListManagerImpl.$$$reportNull$$$0(51);
        return string;
    }

    public void notifyChangelistsChanged(@NotNull FilePath path, @NotNull List<String> beforeChangeListsIds, @NotNull List<String> afterChangeListsIds) {
        if (path == null) {
            ChangeListManagerImpl.$$$reportNull$$$0(52);
        }
        if (beforeChangeListsIds == null) {
            ChangeListManagerImpl.$$$reportNull$$$0(53);
        }
        if (afterChangeListsIds == null) {
            ChangeListManagerImpl.$$$reportNull$$$0(54);
        }
        this.myWorker.notifyChangelistsChanged(path, beforeChangeListsIds, afterChangeListsIds);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getChangeListNameIfOnlyOne(Change[] changes2) {
        Object object = this.myDataLock;
        synchronized (object) {
            List<LocalChangeList> lists = this.myWorker.getAffectedLists(Arrays.asList(changes2));
            return lists.size() == 1 ? lists.get(0).getName() : null;
        }
    }

    @Override
    public boolean isInUpdate() {
        return this.myModifier.isInsideUpdate() || this.myShowLocalChangesInvalidated;
    }

    @Nullable
    public Change getChange(@NotNull VirtualFile file2) {
        if (file2 == null) {
            ChangeListManagerImpl.$$$reportNull$$$0(55);
        }
        return this.getChange(VcsUtil.getFilePath((VirtualFile)file2));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @NotNull
    public List<LocalChangeList> getAffectedLists(@NotNull Collection<Change> changes2) {
        if (changes2 == null) {
            ChangeListManagerImpl.$$$reportNull$$$0(56);
        }
        Object object = this.myDataLock;
        // MONITORENTER : object
        List<LocalChangeList> list2 = this.myWorker.getAffectedLists(changes2);
        // MONITOREXIT : object
        if (list2 != null) return list2;
        ChangeListManagerImpl.$$$reportNull$$$0(57);
        return list2;
    }

    @NotNull
    public List<LocalChangeList> getChangeLists(@NotNull Change change) {
        if (change == null) {
            ChangeListManagerImpl.$$$reportNull$$$0(58);
        }
        Collection collection = this.getAffectedLists(Collections.singletonList(change));
        if (collection == null) {
            ChangeListManagerImpl.$$$reportNull$$$0(59);
        }
        return collection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @NotNull
    public List<LocalChangeList> getChangeLists(@NotNull VirtualFile file2) {
        if (file2 == null) {
            ChangeListManagerImpl.$$$reportNull$$$0(60);
        }
        Object object = this.myDataLock;
        // MONITORENTER : object
        Change change = this.myWorker.getChangeForPath(VcsUtil.getFilePath((VirtualFile)file2));
        if (change == null) {
            List<LocalChangeList> list2 = Collections.emptyList();
            // MONITOREXIT : object
            if (list2 != null) return list2;
            ChangeListManagerImpl.$$$reportNull$$$0(61);
            return list2;
        }
        List<LocalChangeList> list3 = this.getChangeLists(change);
        // MONITOREXIT : object
        if (list3 != null) return list3;
        ChangeListManagerImpl.$$$reportNull$$$0(62);
        return list3;
    }

    @Nullable
    public LocalChangeList getChangeList(@NotNull Change change) {
        if (change == null) {
            ChangeListManagerImpl.$$$reportNull$$$0(63);
        }
        return (LocalChangeList)ContainerUtil.getFirstItem(this.getChangeLists(change));
    }

    @Nullable
    public LocalChangeList getChangeList(@NotNull VirtualFile file2) {
        if (file2 == null) {
            ChangeListManagerImpl.$$$reportNull$$$0(64);
        }
        return (LocalChangeList)ContainerUtil.getFirstItem(this.getChangeLists(file2));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public Change getChange(FilePath file2) {
        Object object = this.myDataLock;
        synchronized (object) {
            return this.myWorker.getChangeForPath(file2);
        }
    }

    public boolean isUnversioned(VirtualFile file2) {
        return (Boolean)ReadAction.compute(() -> {
            Object object = this.myDataLock;
            synchronized (object) {
                return this.myComposite.getVFHolder(FileHolder.HolderType.UNVERSIONED).containsFile(file2);
            }
        });
    }

    @NotNull
    public FileStatus getStatus(@NotNull VirtualFile file2) {
        if (file2 == null) {
            ChangeListManagerImpl.$$$reportNull$$$0(65);
        }
        FileStatus fileStatus = (FileStatus)ReadAction.compute(() -> {
            Object object = this.myDataLock;
            synchronized (object) {
                boolean switched;
                if (this.myComposite.getVFHolder(FileHolder.HolderType.UNVERSIONED).containsFile(file2)) {
                    return FileStatus.UNKNOWN;
                }
                if (this.myComposite.getVFHolder(FileHolder.HolderType.MODIFIED_WITHOUT_EDITING).containsFile(file2)) {
                    return FileStatus.HIJACKED;
                }
                if (this.myComposite.getIgnoredFileHolder().containsFile(file2)) {
                    return FileStatus.IGNORED;
                }
                FileStatus status = (FileStatus)ObjectUtils.notNull((Object)this.myWorker.getStatus(file2), (Object)FileStatus.NOT_CHANGED);
                if (FileStatus.NOT_CHANGED.equals(status) && (switched = this.myComposite.getSwitchedFileHolder().containsFile(file2))) {
                    return FileStatus.SWITCHED;
                }
                return status;
            }
        });
        if (fileStatus == null) {
            ChangeListManagerImpl.$$$reportNull$$$0(66);
        }
        return fileStatus;
    }

    @NotNull
    public Collection<Change> getChangesIn(@NotNull VirtualFile dir) {
        if (dir == null) {
            ChangeListManagerImpl.$$$reportNull$$$0(67);
        }
        Collection<Change> collection = this.getChangesIn(VcsUtil.getFilePath((VirtualFile)dir));
        if (collection == null) {
            ChangeListManagerImpl.$$$reportNull$$$0(68);
        }
        return collection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @NotNull
    public ThreeState haveChangesUnder(@NotNull VirtualFile vf) {
        if (vf == null) {
            ChangeListManagerImpl.$$$reportNull$$$0(69);
        }
        if (vf.isValid() && vf.isDirectory()) {
            Object object = this.myDataLock;
            // MONITORENTER : object
            ThreeState threeState = this.myWorker.haveChangesUnder(vf);
            // MONITOREXIT : object
            if (threeState != null) return threeState;
            ChangeListManagerImpl.$$$reportNull$$$0(71);
            return threeState;
        }
        ThreeState threeState = ThreeState.NO;
        if (threeState != null) return threeState;
        ChangeListManagerImpl.$$$reportNull$$$0(70);
        return threeState;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @NotNull
    public Collection<Change> getChangesIn(@NotNull FilePath dirPath) {
        if (dirPath == null) {
            ChangeListManagerImpl.$$$reportNull$$$0(72);
        }
        Object object = this.myDataLock;
        // MONITORENTER : object
        List<Change> list2 = this.myWorker.getChangesUnder(dirPath);
        // MONITOREXIT : object
        if (list2 != null) return list2;
        ChangeListManagerImpl.$$$reportNull$$$0(73);
        return list2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public AbstractVcs getVcsFor(@NotNull Change change) {
        if (change == null) {
            ChangeListManagerImpl.$$$reportNull$$$0(74);
        }
        Object object = this.myDataLock;
        synchronized (object) {
            return this.myWorker.getVcsFor(change);
        }
    }

    @Override
    public void addUnversionedFiles(@NotNull LocalChangeList list2, @NotNull List<VirtualFile> files2) {
        if (list2 == null) {
            ChangeListManagerImpl.$$$reportNull$$$0(75);
        }
        if (files2 == null) {
            ChangeListManagerImpl.$$$reportNull$$$0(76);
        }
        this.addUnversionedFiles(list2, files2, ChangeListManagerImpl.getDefaultUnversionedFileCondition(), null);
    }

    @Deprecated
    @NotNull
    public List<VcsException> addUnversionedFiles(@NotNull LocalChangeList list2, @NotNull List<VirtualFile> files2, @NotNull Condition<? super FileStatus> statusChecker, @Nullable Consumer<? super List<Change>> changesConsumer) {
        boolean syncUpdateRequired;
        if (list2 == null) {
            ChangeListManagerImpl.$$$reportNull$$$0(77);
        }
        if (files2 == null) {
            ChangeListManagerImpl.$$$reportNull$$$0(78);
        }
        if (statusChecker == null) {
            ChangeListManagerImpl.$$$reportNull$$$0(79);
        }
        ArrayList<VcsException> exceptions = new ArrayList<VcsException>();
        HashSet allProcessedFiles = new HashSet();
        ChangesUtil.processVirtualFilesByVcs((Project)this.myProject, files2, (vcs, items) -> {
            final CheckinEnvironment environment = vcs.getCheckinEnvironment();
            if (environment != null) {
                final Set<VirtualFile> descendants = this.getUnversionedDescendantsRecursively(items, statusChecker);
                Set<VirtualFile> parents = this.getUnversionedParents(vcs, items, statusChecker);
                final ArrayList result2 = ContainerUtil.newArrayList();
                ProgressManager.getInstance().run((Task)new Task.Modal(this.myProject, "Adding Files to VCS...", true){

                    public void run(@NotNull ProgressIndicator indicator) {
                        if (indicator == null) {
                            5.$$$reportNull$$$0(0);
                        }
                        indicator.setIndeterminate(true);
                        List exs = environment.scheduleUnversionedFilesForAddition((List)ContainerUtil.newArrayList((Iterable)descendants));
                        if (exs != null) {
                            ContainerUtil.addAll((Collection)result2, (Iterable)exs);
                        }
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/openapi/vcs/changes/ChangeListManagerImpl$5", "run"));
                    }
                });
                allProcessedFiles.addAll(descendants);
                allProcessedFiles.addAll(parents);
                exceptions.addAll(result2);
            }
        });
        if (!exceptions.isEmpty()) {
            StringBuilder message = new StringBuilder(VcsBundle.message((String)"error.adding.files.prompt", (Object[])new Object[0]));
            for (VcsException ex : exceptions) {
                message.append("\n").append(ex.getMessage());
            }
            Messages.showErrorDialog((Project)this.myProject, (String)message.toString(), (String)VcsBundle.message((String)"error.adding.files.title", (Object[])new Object[0]));
        }
        for (VirtualFile file2 : allProcessedFiles) {
            this.myFileStatusManager.fileStatusChanged(file2);
        }
        VcsDirtyScopeManager.getInstance((Project)this.myProject).filesDirty(allProcessedFiles, null);
        Ref foundChanges = Ref.create();
        boolean moveRequired = !list2.isDefault();
        boolean bl = syncUpdateRequired = changesConsumer != null;
        if (moveRequired || syncUpdateRequired) {
            InvokeAfterUpdateMode updateMode = syncUpdateRequired ? InvokeAfterUpdateMode.SYNCHRONOUS_CANCELLABLE : InvokeAfterUpdateMode.BACKGROUND_NOT_CANCELLABLE;
            this.invokeAfterUpdate(() -> {
                ApplicationManager.getApplication().runReadAction(() -> {
                    Object object = this.myDataLock;
                    synchronized (object) {
                        List newChanges = ContainerUtil.filter((Collection)this.getDefaultChangeList().getChanges(), change -> {
                            FilePath path = ChangesUtil.getAfterPath((Change)change);
                            return path != null && allProcessedFiles.contains(path.getVirtualFile());
                        });
                        foundChanges.set((Object)newChanges);
                        if (moveRequired && !newChanges.isEmpty()) {
                            this.moveChangesTo(list2, newChanges.toArray(new Change[0]));
                        }
                    }
                });
                this.myChangesViewManager.scheduleRefresh();
            }, updateMode, VcsBundle.message((String)"change.lists.manager.add.unversioned", (Object[])new Object[0]), null);
            if (changesConsumer != null) {
                changesConsumer.consume(foundChanges.get());
            }
        } else {
            this.myChangesViewManager.scheduleRefresh();
        }
        ArrayList<VcsException> arrayList = exceptions;
        if (arrayList == null) {
            ChangeListManagerImpl.$$$reportNull$$$0(80);
        }
        return arrayList;
    }

    @NotNull
    public static Condition<FileStatus> getDefaultUnversionedFileCondition() {
        Condition condition = status -> status == FileStatus.UNKNOWN;
        if (condition == null) {
            ChangeListManagerImpl.$$$reportNull$$$0(81);
        }
        return condition;
    }

    @NotNull
    private Set<VirtualFile> getUnversionedDescendantsRecursively(@NotNull List<? extends VirtualFile> items, @NotNull Condition<? super FileStatus> condition) {
        if (items == null) {
            ChangeListManagerImpl.$$$reportNull$$$0(82);
        }
        if (condition == null) {
            ChangeListManagerImpl.$$$reportNull$$$0(83);
        }
        HashSet result2 = ContainerUtil.newHashSet();
        Processor addToResultProcessor = file2 -> {
            if (condition.value((Object)this.getStatus((VirtualFile)file2))) {
                result2.add(file2);
            }
            return true;
        };
        for (VirtualFile virtualFile : items) {
            VcsRootIterator.iterateVfUnderVcsRoot(this.myProject, virtualFile, (Processor<VirtualFile>)addToResultProcessor);
        }
        HashSet hashSet = result2;
        if (hashSet == null) {
            ChangeListManagerImpl.$$$reportNull$$$0(84);
        }
        return hashSet;
    }

    @NotNull
    private Set<VirtualFile> getUnversionedParents(@NotNull AbstractVcs vcs, @NotNull Collection<? extends VirtualFile> items, @NotNull Condition<? super FileStatus> condition) {
        if (vcs == null) {
            ChangeListManagerImpl.$$$reportNull$$$0(85);
        }
        if (items == null) {
            ChangeListManagerImpl.$$$reportNull$$$0(86);
        }
        if (condition == null) {
            ChangeListManagerImpl.$$$reportNull$$$0(87);
        }
        if (!vcs.areDirectoriesVersionedItems()) {
            Set<VirtualFile> set = Collections.emptySet();
            if (set == null) {
                ChangeListManagerImpl.$$$reportNull$$$0(88);
            }
            return set;
        }
        HashSet result2 = ContainerUtil.newHashSet();
        for (VirtualFile virtualFile : items) {
            for (VirtualFile parent = virtualFile.getParent(); parent != null && condition.value((Object)this.getStatus(parent)); parent = parent.getParent()) {
                result2.add(parent);
            }
        }
        HashSet hashSet = result2;
        if (hashSet == null) {
            ChangeListManagerImpl.$$$reportNull$$$0(89);
        }
        return hashSet;
    }

    @Override
    public Project getProject() {
        return this.myProject;
    }

    public void addChangeListListener(@NotNull ChangeListListener listener2, @NotNull Disposable disposable) {
        if (listener2 == null) {
            ChangeListManagerImpl.$$$reportNull$$$0(90);
        }
        if (disposable == null) {
            ChangeListManagerImpl.$$$reportNull$$$0(91);
        }
        this.myListeners.addListener((EventListener)listener2, disposable);
    }

    public void addChangeListListener(@NotNull ChangeListListener listener2) {
        if (listener2 == null) {
            ChangeListManagerImpl.$$$reportNull$$$0(92);
        }
        this.myListeners.addListener((EventListener)listener2);
    }

    public void removeChangeListListener(@NotNull ChangeListListener listener2) {
        if (listener2 == null) {
            ChangeListManagerImpl.$$$reportNull$$$0(93);
        }
        this.myListeners.removeListener((EventListener)listener2);
    }

    public void registerCommitExecutor(@NotNull CommitExecutor executor) {
        if (executor == null) {
            ChangeListManagerImpl.$$$reportNull$$$0(94);
        }
        this.myRegisteredCommitExecutors.add(executor);
    }

    public void commitChanges(@NotNull LocalChangeList changeList, @NotNull List<Change> changes2) {
        if (changeList == null) {
            ChangeListManagerImpl.$$$reportNull$$$0(95);
        }
        if (changes2 == null) {
            ChangeListManagerImpl.$$$reportNull$$$0(96);
        }
        this.doCommit(changeList, changes2, false);
    }

    private void doCommit(LocalChangeList changeList, List<Change> changes2, boolean synchronously) {
        FileDocumentManager.getInstance().saveAllDocuments();
        new CommitHelper(this.myProject, (ChangeList)changeList, changes2, changeList.getName(), StringUtil.isEmpty((String)changeList.getComment()) ? changeList.getName() : changeList.getComment(), new ArrayList(), false, synchronously, (NullableFunction<Object, Object>)FunctionUtil.nullConstant(), null, false, null).doCommit();
    }

    public void commitChangesSynchronouslyWithResult(@NotNull LocalChangeList changeList, @NotNull List<Change> changes2) {
        if (changeList == null) {
            ChangeListManagerImpl.$$$reportNull$$$0(97);
        }
        if (changes2 == null) {
            ChangeListManagerImpl.$$$reportNull$$$0(98);
        }
        this.doCommit(changeList, changes2, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadState(@NotNull Element element) {
        if (element == null) {
            ChangeListManagerImpl.$$$reportNull$$$0(99);
        }
        if (this.myProject.isDefault()) {
            return;
        }
        Object object = this.myDataLock;
        synchronized (object) {
            ChangeListManagerSerialization.readExternal(element, this.myIgnoredIdeaLevel, this.myWorker);
        }
        this.myExcludedConvertedToIgnored = Boolean.parseBoolean(JDOMExternalizerUtil.readField((Element)element, (String)EXCLUDED_CONVERTED_TO_IGNORED_OPTION));
        this.myConflictTracker.loadState(element);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public Element getState() {
        ChangeListWorker worker;
        IgnoredFilesComponent ignoredFilesComponent;
        Element element = new Element("state");
        if (this.myProject.isDefault()) {
            return element;
        }
        Object object = this.myDataLock;
        synchronized (object) {
            ignoredFilesComponent = this.myIgnoredIdeaLevel.copy();
            worker = this.myWorker.copy();
        }
        ChangeListManagerSerialization.writeExternal(element, ignoredFilesComponent, worker);
        JDOMExternalizerUtil.writeField((Element)element, (String)EXCLUDED_CONVERTED_TO_IGNORED_OPTION, (String)Boolean.toString(this.myExcludedConvertedToIgnored), (String)Boolean.toString(false));
        this.myConflictTracker.saveState(element);
        return element;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reopenFiles(@NotNull List<FilePath> paths) {
        if (paths == null) {
            ChangeListManagerImpl.$$$reportNull$$$0(100);
        }
        ReadonlyStatusHandlerImpl readonlyStatusHandler = (ReadonlyStatusHandlerImpl)ReadonlyStatusHandler.getInstance((Project)this.myProject);
        boolean savedOption = readonlyStatusHandler.getState().SHOW_DIALOG;
        readonlyStatusHandler.getState().SHOW_DIALOG = false;
        try {
            readonlyStatusHandler.ensureFilesWritable(ContainerUtil.mapNotNull(paths, FilePath::getVirtualFile));
        }
        finally {
            readonlyStatusHandler.getState().SHOW_DIALOG = savedOption;
        }
    }

    @NotNull
    public List<CommitExecutor> getRegisteredExecutors() {
        List<CommitExecutor> list2 = Collections.unmodifiableList(this.myRegisteredCommitExecutors);
        if (list2 == null) {
            ChangeListManagerImpl.$$$reportNull$$$0(101);
        }
        return list2;
    }

    public void addFilesToIgnore(IgnoredFileBean ... filesToIgnore) {
        if (filesToIgnore == null) {
            ChangeListManagerImpl.$$$reportNull$$$0(102);
        }
        this.myIgnoredIdeaLevel.add(filesToIgnore);
        this.scheduleUnversionedUpdate();
    }

    public void addDirectoryToIgnoreImplicitly(@NotNull String path) {
        if (path == null) {
            ChangeListManagerImpl.$$$reportNull$$$0(103);
        }
        this.myIgnoredIdeaLevel.addIgnoredDirectoryImplicitly(path, this.myProject);
    }

    public void removeImplicitlyIgnoredDirectory(@NotNull String path) {
        if (path == null) {
            ChangeListManagerImpl.$$$reportNull$$$0(104);
        }
        this.myIgnoredIdeaLevel.removeImplicitlyIgnoredDirectory(path, this.myProject);
    }

    public IgnoredFilesComponent getIgnoredFilesComponent() {
        return this.myIgnoredIdeaLevel;
    }

    private void scheduleUnversionedUpdate() {
        Couple couple = (Couple)ReadAction.compute(() -> {
            Object object = this.myDataLock;
            synchronized (object) {
                List<VirtualFile> unversioned = this.myComposite.getVFHolder(FileHolder.HolderType.UNVERSIONED).getFiles();
                Collection<VirtualFile> ignored = this.myComposite.getIgnoredFileHolder().values();
                return Couple.of(unversioned, ignored);
            }
        });
        Collection unversioned = (Collection)couple.first;
        Collection ignored = (Collection)couple.second;
        VcsDirtyScopeManager vcsDirtyScopeManager = VcsDirtyScopeManager.getInstance((Project)this.myProject);
        int ourPiecesLimit = 100;
        if (unversioned.size() + ignored.size() > 100) {
            vcsDirtyScopeManager.markEverythingDirty();
        } else {
            ArrayList<VirtualFile> dirs = new ArrayList<VirtualFile>();
            ArrayList<VirtualFile> files2 = new ArrayList<VirtualFile>();
            for (VirtualFile vf : ContainerUtil.concat((Iterable[])new Iterable[]{unversioned, ignored})) {
                if (vf.isDirectory()) {
                    dirs.add(vf);
                    continue;
                }
                files2.add(vf);
            }
            vcsDirtyScopeManager.filesDirty(files2, dirs);
        }
    }

    public void setFilesToIgnore(IgnoredFileBean ... filesToIgnore) {
        if (filesToIgnore == null) {
            ChangeListManagerImpl.$$$reportNull$$$0(105);
        }
        this.myIgnoredIdeaLevel.set(filesToIgnore);
        this.scheduleUnversionedUpdate();
    }

    private void updateIgnoredFiles(FileHolderComposite composite) {
        VirtualFileHolder vfHolder = composite.getVFHolder(FileHolder.HolderType.UNVERSIONED);
        List<VirtualFile> unversionedFiles = vfHolder.getFiles();
        this.exchangeWithIgnored(composite, vfHolder, unversionedFiles);
        VirtualFileHolder vfModifiedHolder = composite.getVFHolder(FileHolder.HolderType.MODIFIED_WITHOUT_EDITING);
        List<VirtualFile> modifiedFiles = vfModifiedHolder.getFiles();
        this.exchangeWithIgnored(composite, vfModifiedHolder, modifiedFiles);
    }

    private void exchangeWithIgnored(FileHolderComposite composite, VirtualFileHolder vfHolder, List<? extends VirtualFile> unversionedFiles) {
        for (VirtualFile virtualFile : unversionedFiles) {
            if (!this.isIgnoredFile(virtualFile)) continue;
            vfHolder.removeFile(virtualFile);
            composite.getIgnoredFileHolder().addFile(virtualFile);
        }
    }

    @NotNull
    public IgnoredFileBean[] getFilesToIgnore() {
        IgnoredFileBean[] ignoredFileBeanArray = this.myIgnoredIdeaLevel.getFilesToIgnore();
        if (ignoredFileBeanArray == null) {
            ChangeListManagerImpl.$$$reportNull$$$0(106);
        }
        return ignoredFileBeanArray;
    }

    public boolean isIgnoredFile(@NotNull VirtualFile file2) {
        if (file2 == null) {
            ChangeListManagerImpl.$$$reportNull$$$0(107);
        }
        FilePath filePath = VcsUtil.getFilePath((VirtualFile)file2);
        return ContainerUtil.exists((Object[])IgnoredFileProvider.IGNORE_FILE.getExtensions(), it -> it.isIgnoredFile(this.myProject, filePath));
    }

    @Nullable
    public String getSwitchedBranch(@NotNull VirtualFile file2) {
        if (file2 == null) {
            ChangeListManagerImpl.$$$reportNull$$$0(108);
        }
        return (String)ReadAction.compute(() -> {
            Object object = this.myDataLock;
            synchronized (object) {
                return this.myComposite.getSwitchedFileHolder().getBranchForFile(file2);
            }
        });
    }

    public void waitUntilRefreshed() {
        assert (ApplicationManager.getApplication().isUnitTestMode());
        VcsDirtyScopeVfsListener.getInstance(this.myProject).flushDirt();
        this.myUpdater.waitUntilRefreshed();
        this.waitUpdateAlarm();
    }

    private void waitUpdateAlarm() {
        assert (ApplicationManager.getApplication().isUnitTestMode());
        Semaphore semaphore = new Semaphore();
        semaphore.down();
        this.myScheduler.submit(() -> semaphore.up());
        if (ApplicationManager.getApplication().isDispatchThread()) {
            while (!semaphore.waitFor(100L)) {
                UIUtil.dispatchAllInvocationEvents();
            }
        } else {
            semaphore.waitFor();
        }
    }

    public void stopEveryThingIfInTestMode() {
        assert (ApplicationManager.getApplication().isUnitTestMode());
        this.myScheduler.cancelAll();
    }

    public void waitEverythingDoneInTestMode() {
        assert (ApplicationManager.getApplication().isUnitTestMode());
        this.myScheduler.awaitAll();
    }

    public void forceGoInTestMode() {
        assert (ApplicationManager.getApplication().isUnitTestMode());
        this.myUpdater.forceGo();
    }

    public boolean ensureUpToDate(boolean canBeCanceled) {
        assert (ApplicationManager.getApplication().isUnitTestMode());
        if (ApplicationManager.getApplication().isDispatchThread()) {
            this.updateImmediately();
            return true;
        }
        VcsDirtyScopeVfsListener.getInstance(this.myProject).flushDirt();
        this.myUpdater.waitUntilRefreshed();
        this.waitUpdateAlarm();
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getChangeListsNumber() {
        Object object = this.myDataLock;
        synchronized (object) {
            return this.myWorker.getChangeListsNumber();
        }
    }

    public void showLocalChangesInvalidated() {
        this.myShowLocalChangesInvalidated = true;
    }

    public ChangelistConflictTracker getConflictTracker() {
        return this.myConflictTracker;
    }

    public boolean isFreezedWithNotification(@Nullable String modalTitle) {
        String freezeReason = this.isFreezed();
        if (freezeReason == null) {
            return false;
        }
        if (modalTitle != null) {
            Messages.showErrorDialog((Project)this.myProject, (String)freezeReason, (String)modalTitle);
        } else {
            VcsBalloonProblemNotifier.showOverChangesView(this.myProject, freezeReason, MessageType.WARNING, new NamedRunnable[0]);
        }
        return true;
    }

    public void replaceCommitMessage(@NotNull String oldMessage, @NotNull String newMessage) {
        if (oldMessage == null) {
            ChangeListManagerImpl.$$$reportNull$$$0(109);
        }
        if (newMessage == null) {
            ChangeListManagerImpl.$$$reportNull$$$0(110);
        }
        this.myConfig.replaceMessage(oldMessage, newMessage);
        for (LocalChangeList changeList : this.getChangeLists()) {
            if (!oldMessage.equals(changeList.getComment())) continue;
            this.editComment(changeList.getName(), newMessage);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: 
            case 19: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 36: 
            case 50: 
            case 51: 
            case 57: 
            case 59: 
            case 61: 
            case 62: 
            case 66: 
            case 68: 
            case 70: 
            case 71: 
            case 73: 
            case 80: 
            case 81: 
            case 84: 
            case 88: 
            case 89: 
            case 101: 
            case 106: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: 
            case 19: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 36: 
            case 50: 
            case 51: 
            case 57: 
            case 59: 
            case 61: 
            case 62: 
            case 66: 
            case 68: 
            case 70: 
            case 71: 
            case 73: 
            case 80: 
            case 81: 
            case 84: 
            case 88: 
            case 89: 
            case 101: 
            case 106: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 38: 
            case 41: 
            case 42: 
            case 48: 
            case 75: 
            case 77: {
                objectArray2 = objectArray3;
                objectArray3[0] = "list";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "oldList";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "config";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lists";
                break;
            }
            case 6: 
            case 19: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 36: 
            case 50: 
            case 51: 
            case 57: 
            case 59: 
            case 61: 
            case 62: 
            case 66: 
            case 68: 
            case 70: 
            case 71: 
            case 73: 
            case 80: 
            case 81: 
            case 84: 
            case 88: 
            case 89: 
            case 101: 
            case 106: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/vcs/changes/ChangeListManagerImpl";
                break;
            }
            case 7: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filePath";
                break;
            }
            case 8: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tracker";
                break;
            }
            case 11: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "afterUpdate";
                break;
            }
            case 12: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mode";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reason";
                break;
            }
            case 16: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "r";
                break;
            }
            case 18: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indicator";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 22: 
            case 85: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vcs";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataHolder";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "gate";
                break;
            }
            case 33: 
            case 55: 
            case 60: 
            case 64: 
            case 65: 
            case 107: 
            case 108: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 34: 
            case 35: 
            case 37: 
            case 39: 
            case 40: 
            case 43: 
            case 46: 
            case 47: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 44: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fromName";
                break;
            }
            case 45: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toName";
                break;
            }
            case 49: 
            case 56: 
            case 96: 
            case 98: {
                objectArray2 = objectArray3;
                objectArray3[0] = "changes";
                break;
            }
            case 52: 
            case 103: 
            case 104: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 53: {
                objectArray2 = objectArray3;
                objectArray3[0] = "beforeChangeListsIds";
                break;
            }
            case 54: {
                objectArray2 = objectArray3;
                objectArray3[0] = "afterChangeListsIds";
                break;
            }
            case 58: 
            case 63: 
            case 74: {
                objectArray2 = objectArray3;
                objectArray3[0] = "change";
                break;
            }
            case 67: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dir";
                break;
            }
            case 69: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vf";
                break;
            }
            case 72: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dirPath";
                break;
            }
            case 76: 
            case 78: {
                objectArray2 = objectArray3;
                objectArray3[0] = "files";
                break;
            }
            case 79: {
                objectArray2 = objectArray3;
                objectArray3[0] = "statusChecker";
                break;
            }
            case 82: 
            case 86: {
                objectArray2 = objectArray3;
                objectArray3[0] = "items";
                break;
            }
            case 83: 
            case 87: {
                objectArray2 = objectArray3;
                objectArray3[0] = "condition";
                break;
            }
            case 90: 
            case 92: 
            case 93: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 91: {
                objectArray2 = objectArray3;
                objectArray3[0] = "disposable";
                break;
            }
            case 94: {
                objectArray2 = objectArray3;
                objectArray3[0] = "executor";
                break;
            }
            case 95: 
            case 97: {
                objectArray2 = objectArray3;
                objectArray3[0] = "changeList";
                break;
            }
            case 99: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 100: {
                objectArray2 = objectArray3;
                objectArray3[0] = "paths";
                break;
            }
            case 102: 
            case 105: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filesToIgnore";
                break;
            }
            case 109: {
                objectArray2 = objectArray3;
                objectArray3[0] = "oldMessage";
                break;
            }
            case 110: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newMessage";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/vcs/changes/ChangeListManagerImpl";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getComponentName";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "createProgressIndicator";
                break;
            }
            case 26: 
            case 59: 
            case 61: 
            case 62: {
                objectArray = objectArray2;
                objectArray2[1] = "getChangeLists";
                break;
            }
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "getAffectedPaths";
                break;
            }
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "getAffectedFiles";
                break;
            }
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllChanges";
                break;
            }
            case 30: {
                objectArray = objectArray2;
                objectArray2[1] = "getUnversionedFiles";
                break;
            }
            case 31: {
                objectArray = objectArray2;
                objectArray2[1] = "getModifiedWithoutEditing";
                break;
            }
            case 32: {
                objectArray = objectArray2;
                objectArray2[1] = "getIgnoredFiles";
                break;
            }
            case 36: {
                objectArray = objectArray2;
                objectArray2[1] = "addChangeList";
                break;
            }
            case 50: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultChangeList";
                break;
            }
            case 51: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultListName";
                break;
            }
            case 57: {
                objectArray = objectArray2;
                objectArray2[1] = "getAffectedLists";
                break;
            }
            case 66: {
                objectArray = objectArray2;
                objectArray2[1] = "getStatus";
                break;
            }
            case 68: 
            case 73: {
                objectArray = objectArray2;
                objectArray2[1] = "getChangesIn";
                break;
            }
            case 70: 
            case 71: {
                objectArray = objectArray2;
                objectArray2[1] = "haveChangesUnder";
                break;
            }
            case 80: {
                objectArray = objectArray2;
                objectArray2[1] = "addUnversionedFiles";
                break;
            }
            case 81: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultUnversionedFileCondition";
                break;
            }
            case 84: {
                objectArray = objectArray2;
                objectArray2[1] = "getUnversionedDescendantsRecursively";
                break;
            }
            case 88: 
            case 89: {
                objectArray = objectArray2;
                objectArray2[1] = "getUnversionedParents";
                break;
            }
            case 101: {
                objectArray = objectArray2;
                objectArray2[1] = "getRegisteredExecutors";
                break;
            }
            case 106: {
                objectArray = objectArray2;
                objectArray2[1] = "getFilesToIgnore";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "scheduleAutomaticEmptyChangeListDeletion";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "showRemoveEmptyChangeListsProposal";
                break;
            }
            case 6: 
            case 19: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 36: 
            case 50: 
            case 51: 
            case 57: 
            case 59: 
            case 61: 
            case 62: 
            case 66: 
            case 68: 
            case 70: 
            case 71: 
            case 73: 
            case 80: 
            case 81: 
            case 84: 
            case 88: 
            case 89: 
            case 101: 
            case 106: {
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "registerChangeTracker";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "unregisterChangeTracker";
                break;
            }
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "invokeAfterUpdate";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "freeze";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "executeOnUpdaterThread";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "executeUnderDataLock";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "iterateScopes";
                break;
            }
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "actualUpdate";
                break;
            }
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "isFileAffected";
                break;
            }
            case 34: 
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "addChangeList";
                break;
            }
            case 37: 
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "removeChangeList";
                break;
            }
            case 39: 
            case 40: 
            case 41: 
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "setDefaultChangeList";
                break;
            }
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "setReadOnly";
                break;
            }
            case 44: 
            case 45: {
                objectArray = objectArray;
                objectArray[2] = "editName";
                break;
            }
            case 46: {
                objectArray = objectArray;
                objectArray[2] = "editComment";
                break;
            }
            case 47: {
                objectArray = objectArray;
                objectArray[2] = "editChangeListData";
                break;
            }
            case 48: 
            case 49: {
                objectArray = objectArray;
                objectArray[2] = "moveChangesTo";
                break;
            }
            case 52: 
            case 53: 
            case 54: {
                objectArray = objectArray;
                objectArray[2] = "notifyChangelistsChanged";
                break;
            }
            case 55: {
                objectArray = objectArray;
                objectArray[2] = "getChange";
                break;
            }
            case 56: {
                objectArray = objectArray;
                objectArray[2] = "getAffectedLists";
                break;
            }
            case 58: 
            case 60: {
                objectArray = objectArray;
                objectArray[2] = "getChangeLists";
                break;
            }
            case 63: 
            case 64: {
                objectArray = objectArray;
                objectArray[2] = "getChangeList";
                break;
            }
            case 65: {
                objectArray = objectArray;
                objectArray[2] = "getStatus";
                break;
            }
            case 67: 
            case 72: {
                objectArray = objectArray;
                objectArray[2] = "getChangesIn";
                break;
            }
            case 69: {
                objectArray = objectArray;
                objectArray[2] = "haveChangesUnder";
                break;
            }
            case 74: {
                objectArray = objectArray;
                objectArray[2] = "getVcsFor";
                break;
            }
            case 75: 
            case 76: 
            case 77: 
            case 78: 
            case 79: {
                objectArray = objectArray;
                objectArray[2] = "addUnversionedFiles";
                break;
            }
            case 82: 
            case 83: {
                objectArray = objectArray;
                objectArray[2] = "getUnversionedDescendantsRecursively";
                break;
            }
            case 85: 
            case 86: 
            case 87: {
                objectArray = objectArray;
                objectArray[2] = "getUnversionedParents";
                break;
            }
            case 90: 
            case 91: 
            case 92: {
                objectArray = objectArray;
                objectArray[2] = "addChangeListListener";
                break;
            }
            case 93: {
                objectArray = objectArray;
                objectArray[2] = "removeChangeListListener";
                break;
            }
            case 94: {
                objectArray = objectArray;
                objectArray[2] = "registerCommitExecutor";
                break;
            }
            case 95: 
            case 96: {
                objectArray = objectArray;
                objectArray[2] = "commitChanges";
                break;
            }
            case 97: 
            case 98: {
                objectArray = objectArray;
                objectArray[2] = "commitChangesSynchronouslyWithResult";
                break;
            }
            case 99: {
                objectArray = objectArray;
                objectArray[2] = "loadState";
                break;
            }
            case 100: {
                objectArray = objectArray;
                objectArray[2] = "reopenFiles";
                break;
            }
            case 102: {
                objectArray = objectArray;
                objectArray[2] = "addFilesToIgnore";
                break;
            }
            case 103: {
                objectArray = objectArray;
                objectArray[2] = "addDirectoryToIgnoreImplicitly";
                break;
            }
            case 104: {
                objectArray = objectArray;
                objectArray[2] = "removeImplicitlyIgnoredDirectory";
                break;
            }
            case 105: {
                objectArray = objectArray;
                objectArray[2] = "setFilesToIgnore";
                break;
            }
            case 107: {
                objectArray = objectArray;
                objectArray[2] = "isIgnoredFile";
                break;
            }
            case 108: {
                objectArray = objectArray;
                objectArray[2] = "getSwitchedBranch";
                break;
            }
            case 109: 
            case 110: {
                objectArray = objectArray;
                objectArray[2] = "replaceCommitMessage";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: 
            case 19: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 36: 
            case 50: 
            case 51: 
            case 57: 
            case 59: 
            case 61: 
            case 62: 
            case 66: 
            case 68: 
            case 70: 
            case 71: 
            case 73: 
            case 80: 
            case 81: 
            case 84: 
            case 88: 
            case 89: 
            case 101: 
            case 106: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    static class Scheduler {
        private final ScheduledExecutorService myExecutor = AppExecutorUtil.createBoundedScheduledExecutorService((String)"ChangeListManagerImpl Pool", (int)1);
        private final boolean myUnitTestMode = ApplicationManager.getApplication().isUnitTestMode();
        private final ArrayDeque<Future> myFutures = new ArrayDeque();

        Scheduler() {
        }

        /*
         * WARNING - void declaration
         */
        public void schedule(@NotNull Runnable command, long delay, @NotNull TimeUnit timeUnit) {
            void unit;
            if (command == null) {
                Scheduler.$$$reportNull$$$0(0);
            }
            if (timeUnit == null) {
                Scheduler.$$$reportNull$$$0(1);
            }
            ScheduledFuture<?> future2 = this.myExecutor.schedule(command, delay, (TimeUnit)unit);
            if (this.myUnitTestMode) {
                this.addFuture(future2);
            }
        }

        public void submit(@NotNull Runnable command) {
            if (command == null) {
                Scheduler.$$$reportNull$$$0(2);
            }
            Future<?> future2 = this.myExecutor.submit(command);
            if (this.myUnitTestMode) {
                this.addFuture(future2);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void addFuture(Future<?> future2) {
            assert (ApplicationManager.getApplication().isUnitTestMode());
            ArrayDeque<Future> arrayDeque = this.myFutures;
            synchronized (arrayDeque) {
                this.myFutures.add(future2);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void cancelAll() {
            ArrayDeque<Future> arrayDeque = this.myFutures;
            synchronized (arrayDeque) {
                for (Future future2 : this.myFutures) {
                    future2.cancel(true);
                }
                this.myFutures.clear();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         * Converted monitor instructions to comments
         * Lifted jumps to return sites
         */
        private void awaitAll() {
            long start2 = System.currentTimeMillis();
            while (true) {
                if (System.currentTimeMillis() - start2 > TimeUnit.MINUTES.toMillis(10L)) {
                    throw new IllegalStateException("Too long waiting for VCS update");
                }
                ArrayDeque<Future> arrayDeque = this.myFutures;
                // MONITORENTER : arrayDeque
                Future future2 = this.myFutures.peek();
                // MONITOREXIT : arrayDeque
                if (future2 == null) {
                    return;
                }
                if (ApplicationManager.getApplication().isDispatchThread()) {
                    UIUtil.dispatchAllInvocationEvents();
                }
                try {
                    future2.get(10L, TimeUnit.MILLISECONDS);
                    arrayDeque = this.myFutures;
                    // MONITORENTER : arrayDeque
                    this.myFutures.remove(future2);
                    // MONITOREXIT : arrayDeque
                    continue;
                }
                catch (TimeoutException timeoutException) {
                    continue;
                }
                catch (CancellationException e) {
                    ArrayDeque<Future> arrayDeque2 = this.myFutures;
                    // MONITORENTER : arrayDeque2
                    this.myFutures.remove(future2);
                    // MONITOREXIT : arrayDeque2
                    continue;
                }
                catch (InterruptedException | ExecutionException e) {
                    LOG.error((Throwable)e);
                    return;
                }
                break;
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "command";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "unit";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/openapi/vcs/changes/ChangeListManagerImpl$Scheduler";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "schedule";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "submit";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class MyChangesDeltaForwarder
    implements ChangeListDeltaListener {
        private final RemoteRevisionsCache myRevisionsCache;
        private final ProjectLevelVcsManager myVcsManager;
        private final Project myProject;
        private final Scheduler myScheduler;

        MyChangesDeltaForwarder(Project project, @NotNull Scheduler scheduler) {
            if (scheduler == null) {
                MyChangesDeltaForwarder.$$$reportNull$$$0(0);
            }
            this.myProject = project;
            this.myScheduler = scheduler;
            this.myRevisionsCache = RemoteRevisionsCache.getInstance(project);
            this.myVcsManager = ProjectLevelVcsManager.getInstance((Project)project);
        }

        @Override
        public void modified(@NotNull BaseRevision was, @NotNull BaseRevision become) {
            if (was == null) {
                MyChangesDeltaForwarder.$$$reportNull$$$0(1);
            }
            if (become == null) {
                MyChangesDeltaForwarder.$$$reportNull$$$0(2);
            }
            this.doModify(was, become);
        }

        @Override
        public void added(@NotNull BaseRevision baseRevision) {
            if (baseRevision == null) {
                MyChangesDeltaForwarder.$$$reportNull$$$0(3);
            }
            this.doModify(baseRevision, baseRevision);
        }

        @Override
        public void removed(@NotNull BaseRevision baseRevision) {
            if (baseRevision == null) {
                MyChangesDeltaForwarder.$$$reportNull$$$0(4);
            }
            this.myScheduler.submit(() -> {
                AbstractVcs vcs = this.getVcs(baseRevision);
                if (vcs != null) {
                    this.myRevisionsCache.changeRemoved(baseRevision.getPath(), vcs);
                }
                BackgroundTaskUtil.syncPublisher(this.myProject, VcsAnnotationRefresher.LOCAL_CHANGES_CHANGED).dirty(baseRevision.getPath());
            });
        }

        private void doModify(BaseRevision was, BaseRevision become) {
            this.myScheduler.submit(() -> {
                AbstractVcs vcs = this.getVcs(was);
                if (vcs != null) {
                    this.myRevisionsCache.changeUpdated(was.getPath(), vcs);
                }
                BackgroundTaskUtil.syncPublisher(this.myProject, VcsAnnotationRefresher.LOCAL_CHANGES_CHANGED).dirty(become);
            });
        }

        @Nullable
        private AbstractVcs getVcs(@NotNull BaseRevision baseRevision) {
            AbstractVcs vcs;
            if (baseRevision == null) {
                MyChangesDeltaForwarder.$$$reportNull$$$0(5);
            }
            if ((vcs = baseRevision.getVcs()) != null) {
                return vcs;
            }
            return this.myVcsManager.getVcsFor(baseRevision.getFilePath());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "scheduler";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "was";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "become";
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "baseRevision";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/openapi/vcs/changes/ChangeListManagerImpl$MyChangesDeltaForwarder";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "modified";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "added";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "removed";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[2] = "getVcs";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static class DefaultIgnoredFileProvider
    implements IgnoredFileProvider {
        public boolean isIgnoredFile(@NotNull Project project, @NotNull FilePath filePath) {
            if (project == null) {
                DefaultIgnoredFileProvider.$$$reportNull$$$0(0);
            }
            if (filePath == null) {
                DefaultIgnoredFileProvider.$$$reportNull$$$0(1);
            }
            return ChangeListManagerImpl.getInstanceImpl(project).myIgnoredIdeaLevel.isIgnoredFile(filePath);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "project";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "filePath";
                    break;
                }
            }
            objectArray[1] = "com/intellij/openapi/vcs/changes/ChangeListManagerImpl$DefaultIgnoredFileProvider";
            objectArray[2] = "isIgnoredFile";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private class DataHolder {
        private final boolean myWasEverythingDirty;
        private final FileHolderComposite myComposite;
        private final ChangeListWorker.ChangeListUpdater myChangeListUpdater;

        private DataHolder(FileHolderComposite composite, ChangeListWorker.ChangeListUpdater changeListUpdater, boolean wasEverythingDirty) {
            this.myComposite = composite;
            this.myChangeListUpdater = changeListUpdater;
            this.myWasEverythingDirty = wasEverythingDirty;
        }

        private void notifyStart() {
            if (this.myWasEverythingDirty) {
                this.myComposite.cleanAll();
                this.myChangeListUpdater.notifyStartProcessingChanges(null);
            }
        }

        private void notifyStartProcessingChanges(@NotNull VcsModifiableDirtyScope scope) {
            if (scope == null) {
                DataHolder.$$$reportNull$$$0(0);
            }
            if (!this.myWasEverythingDirty) {
                this.myComposite.cleanAndAdjustScope(scope);
                this.myChangeListUpdater.notifyStartProcessingChanges(scope);
            }
            this.myComposite.notifyVcsStarted(scope.getVcs());
        }

        private void notifyDoneProcessingChanges() {
            if (!this.myWasEverythingDirty) {
                this.myChangeListUpdater.notifyDoneProcessingChanges(ChangeListManagerImpl.this.myDelayedNotificator);
            }
        }

        void notifyEnd() {
            if (this.myWasEverythingDirty) {
                this.myChangeListUpdater.notifyDoneProcessingChanges(ChangeListManagerImpl.this.myDelayedNotificator);
            }
        }

        public FileHolderComposite getComposite() {
            return this.myComposite;
        }

        public ChangeListWorker.ChangeListUpdater getChangeListUpdater() {
            return this.myChangeListUpdater;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/intellij/openapi/vcs/changes/ChangeListManagerImpl$DataHolder", "notifyStartProcessingChanges"));
        }
    }
}

