/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.findUsages;

import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.usages.UsageTarget;
import com.intellij.usages.impl.rules.UsageType;
import com.intellij.usages.impl.rules.UsageTypeProviderEx;
import com.jetbrains.python.psi.PyCallExpression;
import com.jetbrains.python.psi.PyClass;
import com.jetbrains.python.psi.PyElement;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyImportStatementBase;
import com.jetbrains.python.psi.PyQualifiedExpression;
import com.jetbrains.python.psi.PyReferenceExpression;
import com.jetbrains.python.psi.PySequenceExpression;
import com.jetbrains.python.psi.impl.PyPsiUtils;
import com.jetbrains.python.psi.types.PyStructuralType;
import com.jetbrains.python.psi.types.PyType;
import com.jetbrains.python.psi.types.TypeEvalContext;
import org.jetbrains.annotations.NotNull;

public class PyUsageTypeProvider
implements UsageTypeProviderEx {
    private static final UsageType IN_IMPORT = new UsageType("Usage in import statement");
    private static final UsageType UNTYPED = new UsageType("Untyped (probable) usage");
    private static final UsageType USAGE_IN_ISINSTANCE = new UsageType("Usage in isinstance()");
    private static final UsageType USAGE_IN_SUPERCLASS = new UsageType("Usage in superclass list");

    public UsageType getUsageType(PsiElement element) {
        return this.getUsageType(element, UsageTarget.EMPTY_ARRAY);
    }

    public UsageType getUsageType(PsiElement element, @NotNull UsageTarget[] targets) {
        if (targets == null) {
            PyUsageTypeProvider.$$$reportNull$$$0(0);
        }
        if (element instanceof PyElement) {
            TypeEvalContext context;
            PyType type;
            PyExpression qualifier;
            if (PsiTreeUtil.getParentOfType((PsiElement)element, PyImportStatementBase.class) != null) {
                return IN_IMPORT;
            }
            if (element instanceof PyQualifiedExpression && (qualifier = ((PyQualifiedExpression)element).getQualifier()) != null && ((type = (context = TypeEvalContext.userInitiated(element.getProject(), element.getContainingFile())).getType(qualifier)) == null || type instanceof PyStructuralType)) {
                return UNTYPED;
            }
            if (element instanceof PyReferenceExpression) {
                PyClass pyClass;
                PyExpression[] args;
                PyCallExpression call = (PyCallExpression)PsiTreeUtil.getParentOfType((PsiElement)element, PyCallExpression.class);
                if (call != null && call.isCalleeText("isinstance") && (args = call.getArguments()).length == 2) {
                    PyExpression typeExpression = args[1];
                    if (element == typeExpression) {
                        return USAGE_IN_ISINSTANCE;
                    }
                    if ((typeExpression = PyPsiUtils.flattenParens(typeExpression)) instanceof PySequenceExpression && element.getParent() == typeExpression) {
                        return USAGE_IN_ISINSTANCE;
                    }
                }
                if ((pyClass = (PyClass)PsiTreeUtil.getParentOfType((PsiElement)element, PyClass.class)) != null && PsiTreeUtil.isAncestor((PsiElement)pyClass.getSuperClassExpressionList(), (PsiElement)element, (boolean)true)) {
                    return USAGE_IN_SUPERCLASS;
                }
            }
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "targets", "com/jetbrains/python/findUsages/PyUsageTypeProvider", "getUsageType"));
    }
}

