/*
 * Decompiled with CFR 0.152.
 */
package processing.app.contrib;

import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.util.ArrayList;
import processing.app.Base;
import processing.app.Library;
import processing.app.Messages;
import processing.app.Util;
import processing.app.contrib.ExamplesContribution;
import processing.app.contrib.LocalContribution;
import processing.app.contrib.ModeContribution;
import processing.app.contrib.StatusPanel;
import processing.app.contrib.ToolContribution;
import processing.app.ui.Editor;

public enum ContributionType {
    LIBRARY,
    MODE,
    TOOL,
    EXAMPLES;


    public String toString() {
        switch (this) {
            case LIBRARY: {
                return "library";
            }
            case MODE: {
                return "mode";
            }
            case TOOL: {
                return "tool";
            }
            case EXAMPLES: {
                return "examples";
            }
        }
        return null;
    }

    public String getTitle() {
        String lower = this.toString();
        return String.valueOf(Character.toUpperCase(lower.charAt(0))) + lower.substring(1);
    }

    public String getPluralTitle() {
        switch (this) {
            case LIBRARY: {
                return "Libraries";
            }
            case MODE: {
                return "Modes";
            }
            case TOOL: {
                return "Tools";
            }
            case EXAMPLES: {
                return "Examples";
            }
        }
        return null;
    }

    public String getPropertiesName() {
        return String.valueOf(this.toString()) + ".properties";
    }

    public File createTempFolder() throws IOException {
        return Util.createTempFolder(this.toString(), "tmp", this.getSketchbookFolder());
    }

    public File[] listTempFolders() throws IOException {
        File base = this.getSketchbookFolder();
        return base.listFiles(new FileFilter(){

            @Override
            public boolean accept(File file) {
                String name = file.getName();
                return file.isDirectory() && name.startsWith(this.toString()) && name.endsWith("tmp");
            }
        });
    }

    public boolean isTempFolderName(String name) {
        return name.startsWith(this.toString()) && name.endsWith("tmp");
    }

    public static ContributionType fromName(String s) {
        if (s != null) {
            if ("library".equalsIgnoreCase(s)) {
                return LIBRARY;
            }
            if ("mode".equalsIgnoreCase(s)) {
                return MODE;
            }
            if ("tool".equalsIgnoreCase(s)) {
                return TOOL;
            }
            if ("examples".equalsIgnoreCase(s)) {
                return EXAMPLES;
            }
        }
        return null;
    }

    public File getSketchbookFolder() {
        switch (this) {
            case LIBRARY: {
                return Base.getSketchbookLibrariesFolder();
            }
            case TOOL: {
                return Base.getSketchbookToolsFolder();
            }
            case MODE: {
                return Base.getSketchbookModesFolder();
            }
            case EXAMPLES: {
                return Base.getSketchbookExamplesFolder();
            }
        }
        return null;
    }

    boolean isCandidate(File potential) {
        return potential.isDirectory() && new File(potential, this.toString()).exists() && !this.isTempFolderName(potential.getName());
    }

    public File[] listCandidates(File folder) {
        return folder.listFiles(new FileFilter(){

            @Override
            public boolean accept(File potential) {
                return ContributionType.this.isCandidate(potential);
            }
        });
    }

    File findCandidate(File folder) {
        File[] folders = this.listCandidates(folder);
        if (folders.length == 0) {
            return null;
        }
        if (folders.length > 1) {
            Messages.log("More than one " + this.toString() + " found inside " + folder.getAbsolutePath());
        }
        return folders[0];
    }

    boolean requiresRestart() {
        return this == TOOL || this == MODE;
    }

    LocalContribution load(Base base, File folder) {
        switch (this) {
            case LIBRARY: {
                return Library.load(folder);
            }
            case TOOL: {
                return ToolContribution.load(folder);
            }
            case MODE: {
                return ModeContribution.load(base, folder);
            }
            case EXAMPLES: {
                return ExamplesContribution.load(folder);
            }
        }
        return null;
    }

    ArrayList<LocalContribution> listContributions(Editor editor) {
        ArrayList<LocalContribution> contribs = new ArrayList<LocalContribution>();
        switch (this) {
            case LIBRARY: {
                contribs.addAll(editor.getMode().contribLibraries);
                break;
            }
            case TOOL: {
                contribs.addAll(editor.getBase().getToolContribs());
                break;
            }
            case MODE: {
                contribs.addAll(editor.getBase().getModeContribs());
                break;
            }
            case EXAMPLES: {
                contribs.addAll(editor.getBase().getExampleContribs());
            }
        }
        return contribs;
    }

    File getBackupFolder() {
        return new File(this.getSketchbookFolder(), "old");
    }

    File createBackupFolder(StatusPanel status) {
        File backupFolder = this.getBackupFolder();
        if (!backupFolder.exists() && !backupFolder.mkdirs()) {
            status.setErrorMessage("Could not create a backup folder in the sketchbook " + this.toString() + " folder.");
            return null;
        }
        return backupFolder;
    }
}

