/*
 * Decompiled with CFR 0.152.
 */
package org.sejda.model.parameter;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.sejda.model.input.MergeInput;
import org.sejda.model.input.PdfMergeInput;
import org.sejda.model.outline.CatalogPageLabelsPolicy;
import org.sejda.model.outline.OutlinePolicy;
import org.sejda.model.output.SingleTaskOutput;
import org.sejda.model.parameter.base.AbstractPdfOutputParameters;
import org.sejda.model.parameter.base.SingleOutputTaskParameters;
import org.sejda.model.pdf.form.AcroFormPolicy;
import org.sejda.model.toc.ToCPolicy;
import org.sejda.model.validation.constraint.NotEmpty;
import org.sejda.model.validation.constraint.SingleOutputAllowedExtensions;

@SingleOutputAllowedExtensions
public class MergeParameters
extends AbstractPdfOutputParameters
implements SingleOutputTaskParameters {
    @NotEmpty
    @Valid
    private List<MergeInput> inputList = new ArrayList<MergeInput>();
    private boolean blankPageIfOdd = false;
    @NotNull
    private OutlinePolicy outlinePolicy = OutlinePolicy.RETAIN;
    @NotNull
    private AcroFormPolicy acroFormPolicy = AcroFormPolicy.MERGE_RENAMING_EXISTING_FIELDS;
    @NotNull
    private CatalogPageLabelsPolicy catalogPageLabelsPolicy = CatalogPageLabelsPolicy.DISCARD;
    @Valid
    @NotNull
    private SingleTaskOutput output;
    @NotNull
    private ToCPolicy tocPolicy = ToCPolicy.NONE;
    private boolean filenameFooter = false;
    private boolean normalizePageSizes = false;
    private boolean firstInputCoverTitle = false;

    @Override
    public SingleTaskOutput getOutput() {
        return this.output;
    }

    @Override
    public void setOutput(SingleTaskOutput output) {
        this.output = output;
    }

    public List<MergeInput> getInputList() {
        return Collections.unmodifiableList(this.inputList);
    }

    public void setInputList(List<MergeInput> inputList) {
        this.inputList = inputList;
    }

    public List<PdfMergeInput> getPdfInputList() {
        return Collections.unmodifiableList(this.inputList.stream().filter(input -> input instanceof PdfMergeInput).map(input -> (PdfMergeInput)input).collect(Collectors.toList()));
    }

    public void addInput(MergeInput input) {
        this.inputList.add(input);
    }

    public boolean isBlankPageIfOdd() {
        return this.blankPageIfOdd;
    }

    public void setBlankPageIfOdd(boolean blankPageIfOdd) {
        this.blankPageIfOdd = blankPageIfOdd;
    }

    public AcroFormPolicy getAcroFormPolicy() {
        return this.acroFormPolicy;
    }

    public void setAcroFormPolicy(AcroFormPolicy acroFormPolicy) {
        this.acroFormPolicy = acroFormPolicy;
    }

    public OutlinePolicy getOutlinePolicy() {
        return this.outlinePolicy;
    }

    public void setOutlinePolicy(OutlinePolicy outlinePolicy) {
        this.outlinePolicy = outlinePolicy;
    }

    public ToCPolicy getTableOfContentsPolicy() {
        return Optional.ofNullable(this.tocPolicy).orElse(ToCPolicy.NONE);
    }

    public void setTableOfContentsPolicy(ToCPolicy tocPolicy) {
        this.tocPolicy = tocPolicy;
    }

    public boolean isFilenameFooter() {
        return this.filenameFooter;
    }

    public void setFilenameFooter(boolean filenameFooter) {
        this.filenameFooter = filenameFooter;
    }

    public boolean isNormalizePageSizes() {
        return this.normalizePageSizes;
    }

    public void setNormalizePageSizes(boolean normalizePageSizes) {
        this.normalizePageSizes = normalizePageSizes;
    }

    public CatalogPageLabelsPolicy getCatalogPageLabelsPolicy() {
        return this.catalogPageLabelsPolicy;
    }

    public void setCatalogPageLabelsPolicy(CatalogPageLabelsPolicy catalogPageLabelsPolicy) {
        this.catalogPageLabelsPolicy = catalogPageLabelsPolicy;
    }

    public boolean isFirstInputCoverTitle() {
        return this.firstInputCoverTitle;
    }

    public void setFirstInputCoverTitle(boolean firstInputCoverTitle) {
        this.firstInputCoverTitle = firstInputCoverTitle;
    }

    @Override
    public int hashCode() {
        return new HashCodeBuilder().appendSuper(super.hashCode()).append(this.inputList).append((Object)this.acroFormPolicy).append(this.blankPageIfOdd).append((Object)this.outlinePolicy).append((Object)this.tocPolicy).append((Object)this.output).append(this.filenameFooter).append(this.normalizePageSizes).append((Object)this.catalogPageLabelsPolicy).append(this.firstInputCoverTitle).toHashCode();
    }

    @Override
    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof MergeParameters)) {
            return false;
        }
        MergeParameters params = (MergeParameters)other;
        return new EqualsBuilder().appendSuper(super.equals(other)).append(this.inputList, params.inputList).append((Object)this.acroFormPolicy, (Object)params.getAcroFormPolicy()).append(this.blankPageIfOdd, params.isBlankPageIfOdd()).append((Object)this.outlinePolicy, (Object)params.getOutlinePolicy()).append((Object)this.tocPolicy, (Object)params.getTableOfContentsPolicy()).append((Object)this.output, (Object)params.getOutput()).append(this.filenameFooter, params.isFilenameFooter()).append(this.normalizePageSizes, params.isNormalizePageSizes()).append((Object)this.catalogPageLabelsPolicy, (Object)params.catalogPageLabelsPolicy).append(this.firstInputCoverTitle, params.firstInputCoverTitle).isEquals();
    }
}

