/*
 * Decompiled with CFR 0.152.
 */
package org.sejda.impl.sambox.component;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.sejda.impl.sambox.util.PageLabelUtils;
import org.sejda.model.outline.CatalogPageLabelsPolicy;
import org.sejda.sambox.pdmodel.PDDocument;
import org.sejda.sambox.pdmodel.common.PDPageLabelRange;
import org.sejda.sambox.pdmodel.common.PDPageLabels;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CatalogPageLabelsMerger {
    private static final Logger LOG = LoggerFactory.getLogger(CatalogPageLabelsMerger.class);
    private int totalPages = 0;
    private PDPageLabels mergedPageLabels = new PDPageLabels();
    private final CatalogPageLabelsPolicy policy;

    public CatalogPageLabelsMerger(CatalogPageLabelsPolicy policy) {
        this.policy = policy;
        if (policy == CatalogPageLabelsPolicy.DISCARD) {
            this.mergedPageLabels = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(PDDocument doc, Set<Integer> pagesToImport) {
        if (this.policy == CatalogPageLabelsPolicy.DISCARD) {
            return;
        }
        try {
            PDPageLabels docLabels = doc.getDocumentCatalog().getPageLabels();
            if (docLabels == null) {
                docLabels = new PDPageLabels();
            }
            if (pagesToImport.size() < doc.getNumberOfPages()) {
                List<Integer> pagesToRemove = CatalogPageLabelsMerger.computePagesToRemove(doc, pagesToImport);
                docLabels = PageLabelUtils.removePages(docLabels, pagesToRemove, doc.getNumberOfPages());
            }
            for (Map.Entry entry : docLabels.getLabels().entrySet()) {
                PDPageLabelRange range = (PDPageLabelRange)entry.getValue();
                int pageIndex = (Integer)entry.getKey();
                int newPageIndex = pageIndex + this.totalPages;
                this.mergedPageLabels.setLabelItem(newPageIndex, range);
            }
        }
        catch (Exception ex) {
            LOG.warn("An error occurred retrieving /PageLabels of document {}, will not be merged", (Object)doc);
        }
        finally {
            this.totalPages += pagesToImport.size();
        }
    }

    private static List<Integer> computePagesToRemove(PDDocument doc, Set<Integer> pagesToImport) {
        if (doc.getNumberOfPages() == pagesToImport.size()) {
            return new ArrayList<Integer>();
        }
        ArrayList<Integer> pagesToRemove = new ArrayList<Integer>();
        for (int i = 1; i <= doc.getNumberOfPages(); ++i) {
            if (pagesToImport.contains(i)) continue;
            pagesToRemove.add(i);
        }
        return pagesToRemove;
    }

    public boolean hasPageLabels() {
        return this.mergedPageLabels != null;
    }

    public PDPageLabels getMergedPageLabels() {
        return this.mergedPageLabels;
    }
}

