module ExploitServlet

  def self.api_path
    '/api/v1/exploits'
  end

  def self.registered(app)
    app.post ExploitServlet.api_path, &report_exploit
  end

  #######
  private
  #######

  def self.report_exploit
    lambda {
      warden.authenticate!
      job = lambda { |opts|
        case opts[:exploit_report_type]
          when "attempt"
            get_db.report_exploit_attempt(opts[:host], opts)
          when "failure"
            get_db.report_exploit_failure(opts)
          when "success"
            get_db.report_exploit_success(opts)
        end
        get_db.report_host(opts)
      }
      exec_report_job(request, &job)
    }
  end
end