/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.kapt3.base.incremental;

import com.sun.tools.javac.processing.JavacProcessingEnvironment;
import java.io.File;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.TypeIntrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.kapt3.base.incremental.Changes;
import org.jetbrains.kotlin.kapt3.base.incremental.SourceFileStructure;
import org.jetbrains.kotlin.kapt3.base.incremental.SourcesToReprocess;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010!\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\n\n\u0002\u0010\"\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00052\u0006\u0010\u0011\u001a\u00020\tJ\u000e\u0010\u0012\u001a\u00020\u000f2\u0006\u0010\u0013\u001a\u00020\rJ\u0017\u0010\u0014\u001a\u0004\u0018\u00010\r2\u0006\u0010\u0015\u001a\u00020\tH\u0000\u00a2\u0006\u0002\b\u0016J\r\u0010\u0017\u001a\u00020\u000fH\u0000\u00a2\u0006\u0002\b\u0018J\u001a\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\t0\u001a2\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00050\u001aJ\u000e\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001fJ\u001a\u0010 \u001a\b\u0012\u0004\u0012\u00020\u00050\u001a2\f\u0010!\u001a\b\u0012\u0004\u0012\u00020\t0\"J\u000e\u0010#\u001a\u00020$2\u0006\u0010\u0015\u001a\u00020\u0007J\u0010\u0010%\u001a\u00020\u000f2\u0006\u0010&\u001a\u00020'H\u0002J\u0010\u0010(\u001a\u00020\u000f2\u0006\u0010)\u001a\u00020*H\u0002R \u0010\u0003\u001a\u0014\u0012\u0004\u0012\u00020\u0005\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\u00060\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R \u0010\b\u001a\u0014\u0012\u0004\u0012\u00020\t\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00050\n0\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R \u0010\u000b\u001a\u0014\u0012\u0004\u0012\u00020\u0005\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\u00060\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\r0\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006+"}, d2={"Lorg/jetbrains/kotlin/kapt3/base/incremental/JavaClassCache;", "Ljava/io/Serializable;", "()V", "dependencyCache", "", "", "", "Ljava/net/URI;", "generatedTypes", "Ljava/io/File;", "", "nonTransitiveCache", "sourceCache", "Lorg/jetbrains/kotlin/kapt3/base/incremental/SourceFileStructure;", "addGeneratedType", "", "type", "generatedFile", "addSourceStructure", "sourceStructure", "getStructure", "sourceFile", "getStructure$kotlin_annotation_processing_base", "invalidateAll", "invalidateAll$kotlin_annotation_processing_base", "invalidateEntriesAnnotatedWith", "", "annotations", "invalidateEntriesForChangedFiles", "Lorg/jetbrains/kotlin/kapt3/base/incremental/SourcesToReprocess;", "changes", "Lorg/jetbrains/kotlin/kapt3/base/incremental/Changes;", "invalidateGeneratedTypes", "files", "", "isAlreadyProcessed", "", "readObject", "input", "Ljava/io/ObjectInputStream;", "writeObject", "output", "Ljava/io/ObjectOutputStream;", "kotlin-annotation-processing-base"})
public final class JavaClassCache
implements Serializable {
    private Map<URI, SourceFileStructure> sourceCache;
    private Map<File, List<String>> generatedTypes;
    private transient Map<String, Set<URI>> dependencyCache;
    private transient Map<String, Set<URI>> nonTransitiveCache;

    public final void addSourceStructure(@NotNull SourceFileStructure sourceStructure) {
        Intrinsics.checkParameterIsNotNull((Object)sourceStructure, (String)"sourceStructure");
        this.sourceCache.put(sourceStructure.getSourceFile(), sourceStructure);
    }

    public final void addGeneratedType(@NotNull String type, @NotNull File generatedFile) {
        Intrinsics.checkParameterIsNotNull((Object)type, (String)"type");
        Intrinsics.checkParameterIsNotNull((Object)generatedFile, (String)"generatedFile");
        List list = this.generatedTypes.get(generatedFile);
        if (list == null) {
            list = new ArrayList(1);
        }
        List typesInFile = list;
        typesInFile.add((String)type);
        this.generatedTypes.put(generatedFile, typesInFile);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Set<String> invalidateGeneratedTypes(@NotNull List<? extends File> files) {
        void $this$mapNotNullTo$iv$iv;
        Intrinsics.checkParameterIsNotNull(files, (String)"files");
        Iterable $this$mapNotNull$iv = files;
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            List<String> list;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            File it = (File)element$iv$iv;
            boolean bl2 = false;
            if (this.generatedTypes.remove(it) == null) continue;
            boolean bl3 = false;
            boolean bl4 = false;
            List<String> it$iv$iv = list;
            boolean bl5 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return CollectionsKt.toSet((Iterable)CollectionsKt.flatten((Iterable)((List)destination$iv$iv)));
    }

    private final void readObject(ObjectInputStream input) {
        Set dependants;
        boolean bl;
        Object object = input.readObject();
        if (object == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.collections.MutableMap<java.net.URI, org.jetbrains.kotlin.kapt3.base.incremental.SourceFileStructure>");
        }
        this.sourceCache = TypeIntrinsics.asMutableMap((Object)object);
        Object object2 = input.readObject();
        if (object2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.collections.MutableMap<java.io.File, kotlin.collections.MutableList<kotlin.String>>");
        }
        this.generatedTypes = TypeIntrinsics.asMutableMap((Object)object2);
        this.dependencyCache = new HashMap(this.sourceCache.size() * 4);
        for (SourceFileStructure sourceInfo : this.sourceCache.values()) {
            for (String mentionedType : sourceInfo.getMentionedTypes()) {
                Set set = this.dependencyCache.get(mentionedType);
                if (set == null) {
                    bl = false;
                    set = new LinkedHashSet();
                }
                dependants = set;
                dependants.add((URI)sourceInfo.getSourceFile());
                this.dependencyCache.put(mentionedType, dependants);
            }
        }
        this.nonTransitiveCache = new HashMap(this.sourceCache.size() * 2);
        for (SourceFileStructure sourceInfo : this.sourceCache.values()) {
            for (String privateType : sourceInfo.getPrivateTypes()) {
                Set set = this.nonTransitiveCache.get(privateType);
                if (set == null) {
                    bl = false;
                    set = new LinkedHashSet();
                }
                dependants = set;
                dependants.add((URI)sourceInfo.getSourceFile());
                this.nonTransitiveCache.put(privateType, dependants);
            }
        }
    }

    private final void writeObject(ObjectOutputStream output) {
        output.writeObject(this.sourceCache);
        output.writeObject(this.generatedTypes);
    }

    public final boolean isAlreadyProcessed(@NotNull URI sourceFile) {
        Intrinsics.checkParameterIsNotNull((Object)sourceFile, (String)"sourceFile");
        return this.sourceCache.containsKey(sourceFile);
    }

    @Nullable
    public final SourceFileStructure getStructure$kotlin_annotation_processing_base(@NotNull File sourceFile) {
        Intrinsics.checkParameterIsNotNull((Object)sourceFile, (String)"sourceFile");
        return this.sourceCache.get(sourceFile.toURI());
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final SourcesToReprocess invalidateEntriesForChangedFiles(@NotNull Changes changes) {
        Collection<File> collection;
        void $this$mapTo$iv$iv;
        Iterator structure;
        Iterator $this$mapTo$iv$iv22;
        Intrinsics.checkParameterIsNotNull((Object)changes, (String)"changes");
        boolean bl = false;
        Set allDirtyFiles = new LinkedHashSet();
        Iterable $this$map$iv = changes.getSourceChanges();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo2 = false;
        Iterator iterator = $this$mapTo$iv$iv22.iterator();
        while (iterator.hasNext()) {
            void it;
            Object item$iv$iv = iterator.next();
            File file = (File)item$iv$iv;
            Collection collection2 = destination$iv$iv;
            boolean bl2 = false;
            URI uRI = it.toURI();
            collection2.add(uRI);
        }
        List currentDirtyFiles = (List)destination$iv$iv;
        $i$f$map = false;
        Set allDirtyTypes = new LinkedHashSet();
        for (URI sourceChange : currentDirtyFiles) {
            if (this.sourceCache.get(sourceChange) == null) {
                continue;
            }
            Map<String, Object> $i$f$mapTo2 = ((SourceFileStructure)((Object)structure)).getDefinedConstants();
            boolean bl3 = false;
            if (!(!$i$f$mapTo2.isEmpty())) continue;
            this.invalidateAll$kotlin_annotation_processing_base();
            return SourcesToReprocess.FullRebuild.INSTANCE;
        }
        while (true) {
            void $this$filterTo$iv$iv;
            Collection sourceChange = currentDirtyFiles;
            boolean $this$mapTo$iv$iv22 = false;
            if (!(!sourceChange.isEmpty())) break;
            $this$mapTo$iv$iv22 = false;
            Set nextRound = new LinkedHashSet();
            structure = currentDirtyFiles.iterator();
            while (structure.hasNext()) {
                SourceFileStructure structure2;
                URI dirtyFile;
                URI uRI = dirtyFile = (URI)structure.next();
                Intrinsics.checkExpressionValueIsNotNull((Object)uRI, (String)"dirtyFile");
                allDirtyFiles.add(uRI);
                if (this.sourceCache.remove(dirtyFile) == null) {
                    continue;
                }
                Set<String> dirtyTypes = structure2.getDeclaredTypes();
                allDirtyTypes.addAll((Collection)dirtyTypes);
                Iterable $this$forEach$iv = dirtyTypes;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    Set<URI> it;
                    Set<URI> set;
                    boolean bl4;
                    boolean bl5;
                    String type = (String)element$iv;
                    boolean bl6 = false;
                    if (this.nonTransitiveCache.get(type) != null) {
                        bl5 = false;
                        bl4 = false;
                        it = set;
                        boolean bl7 = false;
                        allDirtyFiles.addAll((Collection)it);
                    }
                    if (this.dependencyCache.get(type) == null) continue;
                    bl5 = false;
                    bl4 = false;
                    it = set;
                    boolean bl8 = false;
                    nextRound.addAll((Collection)it);
                }
            }
            Iterable $this$filter$iv = nextRound;
            boolean $i$f$filter = false;
            Iterable structure2 = $this$filter$iv;
            Collection destination$iv$iv2 = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                URI it = (URI)element$iv$iv;
                boolean bl9 = false;
                if (!(!allDirtyFiles.contains(it))) continue;
                destination$iv$iv2.add(element$iv$iv);
            }
            currentDirtyFiles = (List)destination$iv$iv2;
        }
        Iterable $this$map$iv2 = allDirtyFiles;
        boolean $i$f$map2 = false;
        Iterable $i$f$filter = $this$map$iv2;
        Collection destination$iv$iv3 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
        boolean $i$f$mapTo3 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            URI element$iv$iv = (URI)item$iv$iv;
            collection = destination$iv$iv3;
            boolean bl10 = false;
            File file = new File((URI)it);
            collection.add(file);
        }
        collection = (List)destination$iv$iv3;
        Set set = allDirtyTypes;
        List list = collection;
        return new SourcesToReprocess.Incremental(list, set);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Set<File> invalidateEntriesAnnotatedWith(@NotNull Set<String> annotations) {
        void $this$mapTo$iv$iv;
        Object $this$any$iv;
        Serializable serializable;
        Collection collection;
        Intrinsics.checkParameterIsNotNull(annotations, (String)"annotations");
        Iterable $this$map$iv = annotations;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo232 = false;
        for (Object item$iv$iv : iterable) {
            void it;
            String string = (String)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            serializable = JavacProcessingEnvironment.validImportStringToPattern((String)it);
            collection.add(serializable);
        }
        List patterns = (List)destination$iv$iv;
        Function1 matchesAnyPattern2 = (Function1)new Function1<String, Boolean>(patterns){
            final /* synthetic */ List $patterns;

            public final boolean invoke(@NotNull String name) {
                boolean bl;
                block3: {
                    Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
                    Iterable $this$any$iv = this.$patterns;
                    boolean $i$f$any = false;
                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                        bl = false;
                    } else {
                        for (T element$iv : $this$any$iv) {
                            Pattern it = (Pattern)element$iv;
                            boolean bl2 = false;
                            if (!it.matcher(name).matches()) continue;
                            bl = true;
                            break block3;
                        }
                        bl = false;
                    }
                }
                return bl;
            }
            {
                this.$patterns = list;
                super(1);
            }
        };
        boolean bl = false;
        Set toReprocess = new LinkedHashSet();
        Map<URI, SourceFileStructure> $i$f$mapTo232 = this.sourceCache;
        boolean bl2 = false;
        for (Map.Entry entry : $i$f$mapTo232.entrySet()) {
            boolean bl3;
            block7: {
                $this$any$iv = ((SourceFileStructure)entry.getValue()).getMentionedAnnotations();
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl3 = false;
                } else {
                    Object item$iv$iv;
                    item$iv$iv = $this$any$iv.iterator();
                    while (item$iv$iv.hasNext()) {
                        Object element$iv = item$iv$iv.next();
                        if (!((Boolean)matchesAnyPattern2.invoke(element$iv)).booleanValue()) continue;
                        bl3 = true;
                        break block7;
                    }
                    bl3 = false;
                }
            }
            if (!bl3) continue;
            toReprocess.add(entry.getKey());
        }
        Iterable iterable2 = toReprocess;
        boolean $i$f$forEach = false;
        for (Object element$iv : iterable2) {
            URI it = (URI)element$iv;
            boolean bl3 = false;
            this.sourceCache.remove(it);
        }
        Iterable iterable3 = toReprocess;
        boolean $i$f$map2 = false;
        $this$any$iv = iterable3;
        Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)iterable3, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            URI uRI = (URI)item$iv$iv;
            collection = destination$iv$iv2;
            boolean bl4 = false;
            serializable = new File((URI)it);
            collection.add(serializable);
        }
        return CollectionsKt.toSet((Iterable)((List)destination$iv$iv2));
    }

    public final void invalidateAll$kotlin_annotation_processing_base() {
        this.sourceCache.clear();
        this.generatedTypes.clear();
    }

    public JavaClassCache() {
        Map map;
        JavaClassCache javaClassCache = this;
        boolean bl = false;
        javaClassCache.sourceCache = map = (Map)new LinkedHashMap();
        javaClassCache = this;
        bl = false;
        javaClassCache.generatedTypes = map = (Map)new LinkedHashMap();
        javaClassCache = this;
        bl = false;
        javaClassCache.dependencyCache = map = (Map)new LinkedHashMap();
        javaClassCache = this;
        bl = false;
        javaClassCache.nonTransitiveCache = map = (Map)new LinkedHashMap();
    }
}

