/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.awt;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.net.URL;
import java.net.URLConnection;
import java.security.AccessControlException;
import javajs.api.GenericFileInterface;
import javajs.util.PT;
import org.jmol.viewer.Viewer;

class AwtFile
extends File
implements GenericFileInterface {
    private static final String[] urlPrefixPairs = new String[]{"http:", "http://", "www.", "http://www.", "https:", "https://", "ftp:", "ftp://", "file:", "file:///"};

    AwtFile(String string) {
        super(string);
    }

    @Override
    public GenericFileInterface getParentAsFile() {
        AwtFile awtFile = null;
        try {
            File file = this.getParentFile();
            awtFile = new AwtFile(file.getAbsolutePath());
        }
        catch (AccessControlException accessControlException) {
            // empty catch block
        }
        return awtFile;
    }

    static Object getBufferedFileInputStream(String string) {
        File file = new File(string);
        try {
            return new BufferedInputStream(new FileInputStream(file));
        }
        catch (IOException iOException) {
            return iOException.toString();
        }
    }

    static Object getURLContents(URL uRL, byte[] byArray, String string) {
        URLConnection uRLConnection = null;
        try {
            uRLConnection = uRL.openConnection();
            String string2 = null;
            if (byArray != null) {
                string2 = "application/octet-stream;";
            } else if (string != null) {
                string2 = "application/x-www-form-urlencoded";
            }
            uRLConnection.setRequestProperty("User-Agent", Viewer.getJmolVersion());
            if (string2 != null) {
                uRLConnection.setRequestProperty("Content-Type", string2);
                uRLConnection.setDoOutput(true);
                if (byArray == null) {
                    OutputStreamWriter outputStreamWriter = new OutputStreamWriter(uRLConnection.getOutputStream());
                    outputStreamWriter.write(string);
                    outputStreamWriter.flush();
                } else {
                    uRLConnection.getOutputStream().write(byArray);
                    uRLConnection.getOutputStream().flush();
                }
            }
            return new BufferedInputStream(uRLConnection.getInputStream());
        }
        catch (IOException iOException) {
            return iOException.toString();
        }
    }

    @Override
    public String getFullPath() {
        try {
            return this.getAbsolutePath();
        }
        catch (Exception exception) {
            return null;
        }
    }

    static String getLocalUrl(GenericFileInterface genericFileInterface) {
        if (genericFileInterface.getName().startsWith("=")) {
            return genericFileInterface.getName();
        }
        String string = genericFileInterface.getFullPath();
        if (string == null) {
            return null;
        }
        string = string.replace('\\', '/');
        int n = 0;
        while (n < urlPrefixPairs.length) {
            if (string.indexOf(urlPrefixPairs[n]) == 0) {
                return null;
            }
            ++n;
        }
        n = 0;
        while (n < urlPrefixPairs.length) {
            if (string.indexOf(urlPrefixPairs[n]) > 0) {
                return String.valueOf(urlPrefixPairs[n + 1]) + PT.trim(string.substring(string.indexOf(urlPrefixPairs[n]) + urlPrefixPairs[n].length()), "/");
            }
            n += 2;
        }
        return null;
    }
}

