/*
 * Decompiled with CFR 0.152.
 */
package tim.prune.function;

import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.Clip;
import tim.prune.App;
import tim.prune.GenericFunction;
import tim.prune.data.AudioClip;

public class PlayAudioFunction
extends GenericFunction
implements Runnable {
    private Clip _clip = null;

    public PlayAudioFunction(App app) {
        super(app);
    }

    public String getNameKey() {
        return "function.playaudio";
    }

    public void begin() {
        if (this._clip == null) {
            new Thread(this).start();
        }
    }

    public void run() {
        AudioClip audioClip = this._app.getTrackInfo().getCurrentAudio();
        File file = audioClip.getFile();
        boolean bl = false;
        if (file != null && file.exists() && file.isFile() && file.canRead()) {
            bl = this.playClip(audioClip);
            if (!bl) {
                bl = this.playAudioFile(file);
            }
        } else if (file == null && audioClip.getByteData() != null && !(bl = this.playClip(audioClip))) {
            try {
                String string = PlayAudioFunction.getSuffix(audioClip.getName());
                File file2 = File.createTempFile("gpsaudio", string);
                file2.deleteOnExit();
                BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(file2));
                bufferedOutputStream.write(audioClip.getByteData(), 0, audioClip.getByteData().length);
                bufferedOutputStream.close();
                bl = this.playAudioFile(file2);
            }
            catch (IOException iOException) {
                System.err.println("Error: " + iOException.getClass().getName() + " - " + iOException.getMessage());
            }
        }
        if (!bl) {
            this._app.showErrorMessage(this.getNameKey(), "error.playaudiofailed");
        }
    }

    private boolean playClip(AudioClip audioClip) {
        boolean bl;
        block17: {
            AudioInputStream audioInputStream;
            block14: {
                block15: {
                    bl = false;
                    audioInputStream = null;
                    this._clip = null;
                    if (audioClip.getFile() != null) {
                        audioInputStream = AudioSystem.getAudioInputStream(audioClip.getFile());
                        break block14;
                    }
                    if (audioClip.getByteData() == null) break block15;
                    audioInputStream = AudioSystem.getAudioInputStream(new ByteArrayInputStream(audioClip.getByteData()));
                    break block14;
                }
                try {
                    this._clip.close();
                    audioInputStream.close();
                }
                catch (Exception exception) {}
                this._clip = null;
                return false;
            }
            try {
                try {
                    this._clip = AudioSystem.getClip();
                    this._clip.open(audioInputStream);
                    this._clip.start();
                    this._clip.drain();
                    bl = true;
                }
                catch (Exception exception) {
                    System.err.println(String.valueOf(exception.getClass().getName()) + " - " + exception.getMessage());
                    try {
                        this._clip.close();
                        audioInputStream.close();
                    }
                    catch (Exception exception2) {}
                    this._clip = null;
                    break block17;
                }
            }
            catch (Throwable throwable) {
                try {
                    this._clip.close();
                    audioInputStream.close();
                }
                catch (Exception exception) {}
                this._clip = null;
                throw throwable;
            }
            try {
                this._clip.close();
                audioInputStream.close();
            }
            catch (Exception exception) {}
            this._clip = null;
        }
        return bl;
    }

    private boolean playAudioFile(File file) {
        Object object;
        boolean bl = false;
        if (!bl) {
            try {
                object = Class.forName("java.awt.Desktop");
                ((Class)object).getDeclaredMethod("open", File.class).invoke(((Class)object).getDeclaredMethod("getDesktop", new Class[0]).invoke(null, new Object[0]), file);
                bl = true;
            }
            catch (InvocationTargetException invocationTargetException) {
                System.err.println("ITE: " + invocationTargetException.getCause().getClass().getName() + " - " + invocationTargetException.getCause().getMessage());
                bl = false;
            }
            catch (Exception exception) {
                System.err.println(String.valueOf(exception.getClass().getName()) + " - " + exception.getMessage());
                bl = false;
            }
        }
        if (!bl) {
            boolean bl2;
            object = System.getProperty("os.name").toLowerCase();
            boolean bl3 = bl2 = ((String)object).indexOf("mac os") >= 0 || ((String)object).indexOf("darwin") >= 0;
            if (bl2) {
                String[] stringArray = new String[]{"open", file.getAbsolutePath()};
                try {
                    Runtime.getRuntime().exec(stringArray);
                    bl = true;
                }
                catch (IOException iOException) {}
            }
        }
        return bl;
    }

    public void stopClip() {
        if (this._clip != null && this._clip.isActive()) {
            try {
                this._clip.stop();
                this._clip.flush();
            }
            catch (Exception exception) {}
        }
    }

    public int getPercentage() {
        long l;
        int n = -1;
        if (this._clip != null && this._clip.isActive() && (l = this._clip.getMicrosecondLength()) > 0L) {
            n = (int)((double)this._clip.getMicrosecondPosition() * 100.0 / (double)l);
        }
        return n;
    }

    private static final String getSuffix(String string) {
        if (string == null || string.equals("")) {
            return ".tmp";
        }
        int n = string.lastIndexOf(46);
        if (n < 0) {
            return string;
        }
        return string.substring(n);
    }
}

