/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xml.xpath.core.util;

import javax.xml.transform.TransformerException;
import javax.xml.xpath.XPathExpressionException;
import org.apache.xalan.templates.FuncDocument;
import org.apache.xalan.templates.FuncFormatNumb;
import org.apache.xalan.templates.FuncKey;
import org.apache.xml.utils.PrefixResolver;
import org.apache.xml.utils.PrefixResolverDefault;
import org.apache.xpath.XPath;
import org.apache.xpath.XPathContext;
import org.apache.xpath.compiler.FunctionTable;
import org.apache.xpath.functions.FuncCurrent;
import org.apache.xpath.functions.FuncExtElementAvailable;
import org.apache.xpath.functions.FuncExtFunctionAvailable;
import org.apache.xpath.functions.FuncGenerateId;
import org.apache.xpath.functions.FuncSystemProperty;
import org.apache.xpath.functions.FuncUnparsedEntityURI;
import org.apache.xpath.objects.XObject;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.traversal.NodeIterator;

public class XSLTXPathHelper {
    public static Node selectSingleNode(Node contextNode, String str) throws TransformerException {
        return XSLTXPathHelper.selectSingleNode(contextNode, str, contextNode);
    }

    public static Node selectSingleNode(Node contextNode, String str, Node namespaceNode) throws TransformerException {
        NodeIterator nl = XSLTXPathHelper.selectNodeIterator(contextNode, str, namespaceNode);
        return nl.nextNode();
    }

    public static NodeIterator selectNodeIterator(Node contextNode, String str) throws TransformerException {
        return XSLTXPathHelper.selectNodeIterator(contextNode, str, contextNode);
    }

    public static NodeIterator selectNodeIterator(Node contextNode, String str, Node namespaceNode) throws TransformerException {
        XObject list = XSLTXPathHelper.eval(contextNode, str, namespaceNode);
        return list.nodeset();
    }

    public static NodeList selectNodeList(Node contextNode, String str) throws TransformerException {
        return XSLTXPathHelper.selectNodeList(contextNode, str, contextNode);
    }

    public static NodeList selectNodeList(Node contextNode, String str, Node namespaceNode) throws TransformerException {
        XObject list = XSLTXPathHelper.eval(contextNode, str, namespaceNode);
        return list.nodelist();
    }

    public static XObject eval(Node contextNode, String str) throws TransformerException {
        return XSLTXPathHelper.eval(contextNode, str, contextNode);
    }

    public static XObject eval(Node contextNode, String str, Node namespaceNode) throws TransformerException {
        XPathContext xpathSupport = new XPathContext();
        PrefixResolverDefault prefixResolver = new PrefixResolverDefault(namespaceNode.getNodeType() == 9 ? ((Document)namespaceNode).getDocumentElement() : namespaceNode);
        XPath xpath = new XPath(str, null, (PrefixResolver)prefixResolver, 0, null, XSLTXPathHelper.getFunctionTable());
        int ctxtNode = xpathSupport.getDTMHandleFromNode(contextNode);
        return xpath.execute(xpathSupport, ctxtNode, (PrefixResolver)prefixResolver);
    }

    public static XObject eval(Node contextNode, String str, PrefixResolver prefixResolver) throws TransformerException {
        XPath xpath = new XPath(str, null, prefixResolver, 0, null, XSLTXPathHelper.getFunctionTable());
        XPathContext xpathSupport = new XPathContext();
        int ctxtNode = xpathSupport.getDTMHandleFromNode(contextNode);
        return xpath.execute(xpathSupport, ctxtNode, prefixResolver);
    }

    public static void compile(String expression) throws XPathExpressionException {
        try {
            new XPath(expression, null, null, 0, null, XSLTXPathHelper.getFunctionTable());
        }
        catch (TransformerException te) {
            throw new XPathExpressionException(te);
        }
    }

    protected static FunctionTable getFunctionTable() {
        FunctionTable functionTable = new FunctionTable();
        functionTable.installFunction("key", FuncKey.class);
        functionTable.installFunction("format-number", FuncFormatNumb.class);
        functionTable.installFunction("document", FuncDocument.class);
        functionTable.installFunction("element-available", FuncExtElementAvailable.class);
        functionTable.installFunction("function-available", FuncExtFunctionAvailable.class);
        functionTable.installFunction("current", FuncCurrent.class);
        functionTable.installFunction("unparsed-entity-string", FuncUnparsedEntityURI.class);
        functionTable.installFunction("generate-id", FuncGenerateId.class);
        functionTable.installFunction("system-property", FuncSystemProperty.class);
        return functionTable;
    }

    public static String calculateXPathToNode(Node node) {
        Node xpathNode = node;
        StringBuffer sb = new StringBuffer();
        while (xpathNode != null) {
            switch (xpathNode.getNodeType()) {
                case 2: {
                    sb.insert(0, xpathNode.getNodeName());
                    sb.insert(0, "/@");
                    xpathNode = ((Attr)xpathNode).getOwnerElement();
                    break;
                }
                case 1: {
                    Node sibling = xpathNode;
                    int position = 1;
                    while ((sibling = sibling.getPreviousSibling()) != null) {
                        if (sibling.getNodeType() != 1 || !sibling.getNodeName().equals(xpathNode.getNodeName())) continue;
                        ++position;
                    }
                    if (position > 1) {
                        sb.insert(0, "[" + position + "]");
                    } else {
                        sibling = xpathNode.getNextSibling();
                        boolean following = false;
                        while (sibling != null) {
                            if (sibling.getNodeType() == 1 && sibling.getNodeName().equals(xpathNode.getNodeName())) {
                                following = true;
                                break;
                            }
                            sibling = sibling.getNextSibling();
                        }
                        if (following) {
                            sb.insert(0, "[1]");
                        }
                    }
                    sb.insert(0, xpathNode.getNodeName());
                    sb.insert(0, "/");
                    xpathNode = xpathNode.getParentNode();
                    break;
                }
                default: {
                    xpathNode = xpathNode.getParentNode();
                }
            }
        }
        return sb.toString();
    }
}

