/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.common.internal.strategy;

import java.util.Iterator;
import org.eclipse.jst.jsf.common.JSFCommonPlugin;
import org.eclipse.jst.jsf.common.internal.strategy.IIdentifiableStrategy;
import org.eclipse.jst.jsf.common.internal.strategy.ISimpleStrategy;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class StrategyComposite<INPUT, OUTPUT, RESULTOUTPUT, IDTYPE, STRATEGYTYPE extends IIdentifiableStrategy<INPUT, OUTPUT, IDTYPE>>
implements ISimpleStrategy<INPUT, RESULTOUTPUT> {
    private final AbstractCompositionStrategy<INPUT, OUTPUT, RESULTOUTPUT, STRATEGYTYPE> _compositionStrategy;

    protected StrategyComposite(AbstractCompositionStrategy<INPUT, OUTPUT, RESULTOUTPUT, STRATEGYTYPE> compositionStrategy) {
        this._compositionStrategy = compositionStrategy;
    }

    protected StrategyComposite() {
        this(new DefaultCompositionStrategy());
    }

    @Override
    public final RESULTOUTPUT perform(INPUT input) {
        Iterator<STRATEGYTYPE> sIt = this.getIterator();
        RESULTOUTPUT result = this.getNoResult();
        boolean finishedComposing = false;
        while (sIt.hasNext()) {
            IIdentifiableStrategy strategy = (IIdentifiableStrategy)sIt.next();
            try {
                finishedComposing = this._compositionStrategy.compose(new CompositionArguments(strategy, input));
                if (!finishedComposing) continue;
                result = this._compositionStrategy.getComposedResult();
                break;
            }
            catch (Exception e) {
                JSFCommonPlugin.log(e);
            }
        }
        if (finishedComposing) {
            return result;
        }
        return this.getNoResult();
    }

    @Override
    public abstract RESULTOUTPUT getNoResult();

    public abstract Iterator<STRATEGYTYPE> getIterator();

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static abstract class AbstractCompositionStrategy<INPUT, OUTPUT, RESULTOUTPUT, STRATEGY extends ISimpleStrategy<INPUT, OUTPUT>>
    implements ISimpleStrategy<CompositionArguments<INPUT, OUTPUT, STRATEGY>, Boolean> {
        private final Boolean _noResultValue = null;

        protected AbstractCompositionStrategy() {
            this.reset();
        }

        public abstract boolean compose(CompositionArguments<INPUT, OUTPUT, STRATEGY> var1) throws Exception;

        @Override
        public final Boolean perform(CompositionArguments<INPUT, OUTPUT, STRATEGY> input) throws Exception {
            return this.compose(input);
        }

        public abstract RESULTOUTPUT getComposedResult();

        @Override
        public Boolean getNoResult() {
            return this._noResultValue;
        }

        public abstract void reset();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class CompositionArguments<INPUT, OUTPUT, STRATEGY extends ISimpleStrategy<INPUT, OUTPUT>> {
        private final STRATEGY _strategy;
        private final INPUT _input;

        public CompositionArguments(STRATEGY strategy, INPUT input) {
            this._strategy = strategy;
            this._input = input;
        }

        public STRATEGY getStrategy() {
            return this._strategy;
        }

        public INPUT getInput() {
            return this._input;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class DefaultCompositionStrategy<INPUT, OUTPUT, RESULTOUTPUT, STRATEGY extends ISimpleStrategy<INPUT, OUTPUT>>
    extends AbstractCompositionStrategy<INPUT, OUTPUT, RESULTOUTPUT, STRATEGY> {
        private RESULTOUTPUT _result;

        @Override
        public boolean compose(CompositionArguments<INPUT, OUTPUT, STRATEGY> arg) throws Exception {
            Object result = arg.getStrategy().perform(arg.getInput());
            if (result != arg.getStrategy().getNoResult()) {
                this._result = result;
                return true;
            }
            return false;
        }

        @Override
        public RESULTOUTPUT getComposedResult() {
            return this._result;
        }

        @Override
        public void reset() {
            this._result = null;
        }
    }
}

