/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.json.core.cleanup;

import java.io.IOException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.wst.json.core.contenttype.ContentTypeIdForJSON;
import org.eclipse.wst.json.core.document.IJSONDocument;
import org.eclipse.wst.json.core.document.IJSONModel;
import org.eclipse.wst.json.core.internal.format.IJSONSourceFormatter;
import org.eclipse.wst.json.core.internal.format.JSONFormatUtil;
import org.eclipse.wst.json.core.internal.format.JSONSourceFormatterFactory;
import org.eclipse.wst.sse.core.internal.cleanup.AbstractStructuredCleanupProcessor;
import org.eclipse.wst.sse.core.internal.cleanup.IStructuredCleanupHandler;
import org.eclipse.wst.sse.core.internal.format.IStructuredFormatProcessor;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.w3c.dom.Node;

public class CleanupProcessorJSON
extends AbstractStructuredCleanupProcessor {
    public void cleanupModel(IStructuredModel structuredModel, int start, int length) {
        JSONFormatUtil formatUtil = JSONFormatUtil.getInstance();
        if (structuredModel instanceof IJSONModel) {
            IJSONDocument doc = ((IJSONModel)structuredModel).getDocument();
            IJSONSourceFormatter formatter = JSONSourceFormatterFactory.getInstance().getSourceFormatter(doc);
            StringBuilder buf = formatter.cleanup(doc);
            if (buf != null) {
                int startOffset = doc.getStartOffset();
                int endOffset = doc.getEndOffset();
                formatUtil.replaceSource(doc.getModel(), startOffset, endOffset - startOffset, buf.toString());
            }
        }
    }

    protected String getContentType() {
        return ContentTypeIdForJSON.ContentTypeID_JSON;
    }

    public void cleanupModel(IStructuredModel structuredModel) {
        int start = 0;
        int length = structuredModel.getStructuredDocument().getLength();
        this.cleanupModel(structuredModel, start, length);
    }

    public void cleanupDocument(IDocument document) throws IOException, CoreException {
    }

    public void cleanupDocument(IDocument document, int start, int length) throws IOException, CoreException {
    }

    protected IStructuredCleanupHandler getCleanupHandler(Node node) {
        return null;
    }

    protected IStructuredFormatProcessor getFormatProcessor() {
        return null;
    }

    protected void refreshCleanupPreferences() {
    }
}

