/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.arduino.ui.internal.project;

import org.eclipse.cdt.arduino.core.internal.board.ArduinoManager;
import org.eclipse.cdt.arduino.ui.internal.Activator;
import org.eclipse.cdt.arduino.ui.internal.LibraryTree;
import org.eclipse.cdt.arduino.ui.internal.Messages;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.PropertyPage;

public class LibrariesPropertyPage
extends PropertyPage {
    private static ArduinoManager manager = Activator.getService(ArduinoManager.class);
    private LibraryTree libraryTree;

    protected Control createContents(Composite parent) {
        Composite comp = new Composite(parent, 0);
        comp.setLayout((Layout)new GridLayout());
        Text desc = new Text(comp, 72);
        GridData layoutData = new GridData(16384, 4, true, false);
        layoutData.widthHint = 500;
        desc.setLayoutData((Object)layoutData);
        desc.setBackground(parent.getBackground());
        desc.setText(Messages.LibrariesPropertyPage_desc);
        this.libraryTree = new LibraryTree(comp);
        this.libraryTree.setLayoutData(new GridData(1808));
        try {
            IProject project = (IProject)this.getElement().getAdapter(IProject.class);
            this.libraryTree.setIncludePlatforms(true);
            this.libraryTree.setChecked(manager.getLibraries(project));
            this.libraryTree.getViewer().setInput((Object)manager.getInstalledLibraries());
        }
        catch (CoreException e) {
            Activator.log((Exception)((Object)e));
        }
        return comp;
    }

    private IProject getProject() {
        return (IProject)this.getElement().getAdapter(IProject.class);
    }

    public boolean performOk() {
        try {
            manager.setLibraries(this.getProject(), this.libraryTree.getChecked());
        }
        catch (CoreException e) {
            Activator.log((Exception)((Object)e));
        }
        return true;
    }
}

