/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.build.gcc.ui.internal;

import org.eclipse.cdt.build.gcc.ui.internal.Messages;
import org.eclipse.cdt.core.envvar.EnvironmentVariable;
import org.eclipse.cdt.core.envvar.IEnvironmentVariable;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class NewEnvVarDialog
extends Dialog {
    private Text nameText;
    private Label valueLabel;
    private Text valueText;
    private Label delimiterLabel;
    private Text delimiterText;
    private Button replaceButton;
    private Button prependButton;
    private Button appendButton;
    private Button removeButton;
    private IEnvironmentVariable envvar;

    public NewEnvVarDialog(Shell parentShell) {
        super(parentShell);
    }

    public NewEnvVarDialog(Shell parentShell, IEnvironmentVariable var) {
        super(parentShell);
        this.envvar = var;
    }

    protected boolean isResizable() {
        return true;
    }

    protected Control createDialogArea(Composite parent) {
        if (this.envvar == null) {
            this.getShell().setText(Messages.NewEnvVarDialog_New);
        } else {
            this.getShell().setText(Messages.NewEnvVarDialog_Edit);
        }
        Composite comp = new Composite(parent, 0);
        GridData layoutData = new GridData(4, 4, true, true);
        layoutData.widthHint = 400;
        comp.setLayoutData((Object)layoutData);
        comp.setLayout((Layout)new GridLayout(3, false));
        Group opGroup = new Group(comp, 0);
        opGroup.setText(Messages.NewEnvVarDialog_Operation);
        opGroup.setLayout((Layout)new GridLayout(4, false));
        layoutData = new GridData(4, 4, true, false);
        layoutData.horizontalSpan = 3;
        opGroup.setLayoutData((Object)layoutData);
        this.replaceButton = new Button((Composite)opGroup, 16);
        this.replaceButton.setText(Messages.NewEnvVarDialog_Replace);
        this.prependButton = new Button((Composite)opGroup, 16);
        this.prependButton.setText(Messages.NewEnvVarDialog_Prepend);
        this.prependButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                NewEnvVarDialog.this.updateEnablement();
            }
        });
        this.appendButton = new Button((Composite)opGroup, 16);
        this.appendButton.setText(Messages.NewEnvVarDialog_Append);
        this.appendButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                NewEnvVarDialog.this.updateEnablement();
            }
        });
        this.removeButton = new Button((Composite)opGroup, 16);
        this.removeButton.setText(Messages.NewEnvVarDialog_Unset);
        this.removeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                NewEnvVarDialog.this.updateEnablement();
            }
        });
        if (this.envvar == null) {
            this.replaceButton.setSelection(true);
        } else {
            switch (this.envvar.getOperation()) {
                case 1: {
                    this.replaceButton.setSelection(true);
                    break;
                }
                case 3: {
                    this.prependButton.setSelection(true);
                    break;
                }
                case 4: {
                    this.appendButton.setSelection(true);
                    break;
                }
                default: {
                    this.removeButton.setSelection(true);
                }
            }
        }
        Label label = new Label(comp, 0);
        label.setText(Messages.NewEnvVarDialog_Name);
        this.nameText = new Text(comp, 2048);
        layoutData = new GridData(4, 0x1000000, true, false);
        layoutData.horizontalSpan = 2;
        this.nameText.setLayoutData((Object)layoutData);
        if (this.envvar != null) {
            this.nameText.setText(this.envvar.getName());
        }
        this.valueLabel = new Label(comp, 0);
        this.valueLabel.setText(Messages.NewEnvVarDialog_Value);
        this.valueText = new Text(comp, 2048);
        layoutData = new GridData(4, 0x1000000, true, false);
        layoutData.horizontalSpan = 2;
        this.valueText.setLayoutData((Object)layoutData);
        if (this.envvar != null && this.envvar.getValue() != null) {
            this.valueText.setText(this.envvar.getValue());
        }
        this.delimiterLabel = new Label(comp, 0);
        this.delimiterLabel.setText(Messages.NewEnvVarDialog_Delimiter);
        this.delimiterText = new Text(comp, 2048);
        layoutData = new GridData(4, 0x1000000, true, false);
        layoutData.horizontalSpan = 2;
        this.delimiterText.setLayoutData((Object)layoutData);
        if (this.envvar != null && this.envvar.getDelimiter() != null) {
            this.delimiterText.setText(this.envvar.getDelimiter());
        }
        this.updateEnablement();
        return comp;
    }

    private void updateEnablement() {
        this.valueLabel.setEnabled(!this.removeButton.getSelection());
        this.valueText.setEnabled(!this.removeButton.getSelection());
        this.delimiterLabel.setEnabled(this.prependButton.getSelection() || this.appendButton.getSelection());
        this.delimiterText.setEnabled(this.prependButton.getSelection() || this.appendButton.getSelection());
    }

    protected void okPressed() {
        String delimiter;
        String value;
        String name = this.nameText.getText().trim();
        int operation = this.replaceButton.getSelection() ? 1 : (this.prependButton.getSelection() ? 3 : (this.appendButton.getSelection() ? 4 : 2));
        if (this.valueText.isEnabled()) {
            value = this.valueText.getText().trim();
            if (value.isEmpty()) {
                value = null;
            }
        } else {
            value = null;
        }
        if (this.delimiterText.isEnabled()) {
            delimiter = this.delimiterText.getText().trim();
            if (delimiter.isEmpty()) {
                delimiter = null;
            }
        } else {
            delimiter = null;
        }
        this.envvar = new EnvironmentVariable(name, value, operation, delimiter);
        super.okPressed();
    }

    public IEnvironmentVariable getEnvVar() {
        return this.envvar;
    }
}

