/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.callgraph;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.linuxtools.internal.callgraph.StapGraph;
import org.eclipse.linuxtools.internal.callgraph.StapNode;

public class StapData {
    public static final int NOT_PART_OF_COLLAPSED_NODE = -10;
    public boolean isCollapsed;
    public boolean marked;
    public boolean onlyChildWithThisName;
    public int id;
    public int timesCalled;
    public int parent;
    public int style;
    public int levelOfRecursion;
    public int collapsedParent;
    public int uncollapsedPiece;
    public int partOfCollapsedNode;
    private long time;
    public String markedMessage;
    public String name;
    public List<Integer> children;
    public List<Integer> collapsedChildren;
    private StapGraph graph;

    public StapData(StapGraph graphModel, int style, String txt, long time, int called, int currentID, int parent, boolean isMarked) {
        this.time = time;
        this.style = style;
        this.timesCalled = called;
        this.children = new ArrayList<Integer>();
        this.collapsedChildren = new ArrayList<Integer>();
        this.id = currentID;
        this.name = txt;
        this.graph = graphModel;
        this.isCollapsed = false;
        this.onlyChildWithThisName = false;
        this.partOfCollapsedNode = -10;
        this.collapsedParent = -1;
        this.parent = parent;
        this.levelOfRecursion = 0;
        this.marked = isMarked;
        this.uncollapsedPiece = -1;
        if (this.parent != -1 && graphModel.getNodeData(this.parent) != null) {
            graphModel.getNodeData(this.parent).addCallee(this.id);
            this.levelOfRecursion = graphModel.getNodeData((int)this.parent).levelOfRecursion + 1;
        }
        if (graphModel.levels.get(this.levelOfRecursion) == null) {
            graphModel.levels.put(this.levelOfRecursion, new ArrayList());
        }
        graphModel.levels.get(this.levelOfRecursion).add(this.id);
        if (this.levelOfRecursion > graphModel.getLowestLevelOfNodesAdded()) {
            graphModel.setLowestLevelOfNodesAdded(this.levelOfRecursion);
        }
    }

    private int addCallee(int id) {
        this.children.add(id);
        return id;
    }

    public StapNode makeNode(StapGraph graphModel) {
        return new StapNode(graphModel, this.style, this);
    }

    public void setPartOfCollapsedNode(int partOfCollapsedNode) {
        this.partOfCollapsedNode = partOfCollapsedNode;
    }

    public void setMarked() {
        this.marked = true;
    }

    public boolean isMarked() {
        return this.marked || this.markedMessage != null && this.markedMessage.length() > 0;
    }

    public boolean isOnlyChildWithThisName() {
        return this.onlyChildWithThisName;
    }

    public long getTime() {
        if (this.time > 1200000000000000000L) {
            return this.graph.getEndTime() - this.time;
        }
        return this.time;
    }

    public void setTime(long time) {
        this.time = time;
    }

    public StapData setMessage(String message) {
        if (message == null || message.length() < 1) {
            return this;
        }
        this.markedMessage = message;
        this.marked = true;
        return this;
    }

    public StapData insertMessage(String message) {
        if (message == null || message.length() < 1) {
            return this;
        }
        String tmp = message;
        if (this.markedMessage != null && this.markedMessage.length() > 0) {
            tmp = String.valueOf(this.markedMessage) + tmp;
        }
        this.markedMessage = tmp;
        this.marked = true;
        return this;
    }

    public boolean isPartOfCollapsedNode() {
        return this.partOfCollapsedNode != -10;
    }

    public int getPartOfCollapsedNode() {
        return this.partOfCollapsedNode;
    }
}

