/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.managedbuilder.core;

import java.lang.reflect.InvocationTargetException;
import java.util.Map;
import org.eclipse.cdt.build.internal.core.scannerconfig.CfgDiscoveredPathManager;
import org.eclipse.cdt.managedbuilder.core.IBuilder;
import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.cdt.managedbuilder.core.ResourceChangeHandler2;
import org.eclipse.cdt.managedbuilder.internal.buildmodel.BuildStateManager;
import org.eclipse.cdt.managedbuilder.internal.buildmodel.DbgUtil;
import org.eclipse.cdt.managedbuilder.internal.core.BuilderFactory;
import org.eclipse.cdt.managedbuilder.internal.core.GeneratedMakefileBuilder;
import org.eclipse.cdt.managedbuilder.internal.dataprovider.ProjectConverter;
import org.eclipse.cdt.managedbuilder.internal.scannerconfig.ManagedBuildCPathEntryContainer;
import org.eclipse.cdt.managedbuilder.internal.scannerconfig.ManagedBuildPathEntryContainerInitializer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.osgi.framework.BundleContext;

public class ManagedBuilderCorePlugin
extends Plugin {
    public static final String PLUGIN_ID = "org.eclipse.cdt.managedbuilder.core";
    private static ManagedBuilderCorePlugin plugin;
    public static final String MAKEGEN_ID = "makefileGenerator";
    public static final String COMMANDLINEGEN_ID = "commandlineGenerator";
    public static final String MANAGED_MAKE_PROJECT_ID;
    private static ResourceChangeHandler2 listener;
    private static final String PATH_ENTRY;
    private static final String PATH_ENTRY_INIT;
    private static final String BUILDER;
    private static final String BUILD_MODEL;

    static {
        MANAGED_MAKE_PROJECT_ID = String.valueOf(ManagedBuilderCorePlugin.getUniqueIdentifier()) + ".managedMake";
        PATH_ENTRY = String.valueOf(ManagedBuilderCorePlugin.getUniqueIdentifier()) + "/debug/pathEntry";
        PATH_ENTRY_INIT = String.valueOf(ManagedBuilderCorePlugin.getUniqueIdentifier()) + "/debug/pathEntryInit";
        BUILDER = String.valueOf(ManagedBuilderCorePlugin.getUniqueIdentifier()) + "/debug/builder";
        BUILD_MODEL = String.valueOf(ManagedBuilderCorePlugin.getUniqueIdentifier()) + "/debug/buildModel";
    }

    public ManagedBuilderCorePlugin() {
        plugin = this;
    }

    public static String getUniqueIdentifier() {
        if (ManagedBuilderCorePlugin.getDefault() == null) {
            return PLUGIN_ID;
        }
        return ManagedBuilderCorePlugin.getDefault().getBundle().getSymbolicName();
    }

    public static ManagedBuilderCorePlugin getDefault() {
        return plugin;
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        this.configurePluginDebugOptions();
        listener = new ResourceChangeHandler2();
        ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)listener, 7);
        BuildStateManager.getInstance().startup();
    }

    public void stop(BundleContext context) throws Exception {
        IProject[] projects;
        BuildStateManager.getInstance().shutdown();
        CfgDiscoveredPathManager.stop();
        ResourcesPlugin.getWorkspace().removeResourceChangeListener((IResourceChangeListener)listener);
        IProject[] iProjectArray = projects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        int n = projects.length;
        int n2 = 0;
        while (n2 < n) {
            IProject project = iProjectArray[n2];
            listener.sendClose(project);
            ++n2;
        }
        listener = null;
        super.stop(context);
    }

    public static void log(IStatus status) {
        ResourcesPlugin.getPlugin().getLog().log(status);
    }

    public static void log(Throwable e) {
        if (e instanceof InvocationTargetException) {
            e = ((InvocationTargetException)e).getTargetException();
        }
        Status status = null;
        status = e instanceof CoreException ? new Status(((CoreException)e).getStatus().getSeverity(), ManagedBuilderCorePlugin.getUniqueIdentifier(), e.getMessage(), e) : new Status(4, ManagedBuilderCorePlugin.getUniqueIdentifier(), 0, e.getMessage(), e);
        ManagedBuilderCorePlugin.log((IStatus)status);
    }

    public static void error(String str) {
        ManagedBuilderCorePlugin.log((IStatus)new Status(4, ManagedBuilderCorePlugin.getUniqueIdentifier(), 0, str, (Throwable)new Exception()));
    }

    public static void info(String str) {
        ManagedBuilderCorePlugin.log((IStatus)new Status(1, ManagedBuilderCorePlugin.getUniqueIdentifier(), 0, str, (Throwable)new Exception()));
    }

    private void configurePluginDebugOptions() {
        if (this.isDebugging()) {
            String buildModel;
            String builder;
            String pathCalc;
            String pathInit = Platform.getDebugOption((String)PATH_ENTRY_INIT);
            if (pathInit != null) {
                ManagedBuildPathEntryContainerInitializer.VERBOSE = pathInit.equalsIgnoreCase("true");
            }
            if ((pathCalc = Platform.getDebugOption((String)PATH_ENTRY)) != null) {
                ManagedBuildCPathEntryContainer.VERBOSE = pathCalc.equalsIgnoreCase("true");
            }
            if ((builder = Platform.getDebugOption((String)BUILDER)) != null) {
                GeneratedMakefileBuilder.VERBOSE = builder.equalsIgnoreCase("true");
            }
            if ((buildModel = Platform.getDebugOption((String)BUILD_MODEL)) != null) {
                DbgUtil.DEBUG = buildModel.equalsIgnoreCase("true");
            }
        }
    }

    public static IBuilder[] createBuilders(IProject project, Map<String, String> args) {
        return BuilderFactory.createBuilders(project, args);
    }

    public static IBuilder createCustomBuilder(IConfiguration cfg, String builderId) throws CoreException {
        return BuilderFactory.createCustomBuilder(cfg, builderId);
    }

    public static IBuilder createCustomBuilder(IConfiguration cfg, IBuilder base) {
        return BuilderFactory.createCustomBuilder(cfg, base);
    }

    public static IBuilder createBuilderForEclipseBuilder(IConfiguration cfg, String eclipseBuilderID) throws CoreException {
        return BuilderFactory.createBuilderForEclipseBuilder(cfg, eclipseBuilderID);
    }

    public boolean isOldStyleMakeProject(IProject project) {
        return ProjectConverter.isOldStyleMakeProject(project);
    }

    public void convertOldStdMakeToNewStyle(IProject project, IProgressMonitor monitor) throws CoreException {
        ProjectConverter.convertOldStdMakeToNewStyle(project, monitor);
    }
}

