/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.net.ssh;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import net.schmizz.sshj.Config;
import net.schmizz.sshj.DefaultConfig;
import net.schmizz.sshj.SSHClient;
import net.schmizz.sshj.common.LoggerFactory;
import net.schmizz.sshj.connection.channel.direct.LocalPortForwarder;
import net.schmizz.sshj.transport.verification.HostKeyVerifier;
import net.schmizz.sshj.transport.verification.PromiscuousVerifier;
import net.schmizz.sshj.userauth.keyprovider.KeyProvider;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.net.DBWHandlerConfiguration;
import org.jkiss.dbeaver.model.net.ssh.SSHImplementationAbstract;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.utils.RuntimeUtils;
import org.jkiss.utils.CommonUtils;

public class SSHImplementationSshj
extends SSHImplementationAbstract {
    private static final Log log = Log.getLog(SSHImplementationSshj.class);
    private transient SSHClient sshClient;
    private transient LocalPortListener portListener;

    protected void setupTunnel(DBRProgressMonitor monitor, DBWHandlerConfiguration configuration, String dbHost, String sshHost, String aliveInterval, int sshPortNum, File privKeyFile, int connectTimeout, int dbPort, int localPort) throws DBException, IOException {
        try {
            DefaultConfig clientConfig = new DefaultConfig();
            clientConfig.setLoggerFactory(LoggerFactory.DEFAULT);
            this.sshClient = new SSHClient((Config)clientConfig);
            this.sshClient.addHostKeyVerifier((HostKeyVerifier)new PromiscuousVerifier());
            String sshUser = configuration.getUserName();
            String sshPassword = configuration.getPassword();
            try {
                this.sshClient.loadKnownHosts();
            }
            catch (IOException e) {
                log.debug((Object)("Error loading known hosts: " + e.getMessage()));
            }
            this.sshClient.connect(sshHost, sshPortNum);
            if (privKeyFile != null) {
                if (!CommonUtils.isEmpty((String)sshPassword)) {
                    KeyProvider keyProvider = this.sshClient.loadKeys(privKeyFile.getAbsolutePath(), sshPassword.toCharArray());
                    this.sshClient.authPublickey(sshUser, new KeyProvider[]{keyProvider});
                } else {
                    this.sshClient.authPublickey(sshUser, new String[]{privKeyFile.getAbsolutePath()});
                }
            } else {
                this.sshClient.authPassword(sshUser, sshPassword);
            }
            log.debug((Object)"Instantiate SSH tunnel");
            LocalPortForwarder.Parameters params = new LocalPortForwarder.Parameters("127.0.0.1", localPort, dbHost, dbPort);
            this.portListener = new LocalPortListener(params);
            this.portListener.start();
            RuntimeUtils.pause((int)100);
        }
        catch (Exception e) {
            throw new DBException("Cannot establish tunnel", (Throwable)e);
        }
    }

    public void closeTunnel(DBRProgressMonitor monitor) throws DBException, IOException {
        if (this.portListener != null) {
            this.portListener.stopServer();
        }
        if (this.sshClient != null) {
            RuntimeUtils.runTask(monitor1 -> {
                try {
                    this.sshClient.disconnect();
                }
                catch (Exception e) {
                    throw new InvocationTargetException(e);
                }
            }, (String)"Close SSH client", (long)1000L);
            this.sshClient = null;
        }
    }

    public String getClientVersion() {
        return this.sshClient == null ? null : this.sshClient.getTransport().getClientVersion();
    }

    public String getServerVersion() {
        return this.sshClient == null ? null : this.sshClient.getTransport().getServerVersion();
    }

    public void invalidateTunnel(DBRProgressMonitor monitor) throws DBException, IOException {
        boolean isAlive = false;
        if (isAlive) {
            try {
                this.sshClient.isConnected();
            }
            catch (Exception exception) {
                isAlive = false;
            }
        }
        if (!isAlive) {
            this.closeTunnel(monitor);
            this.initTunnel(monitor, null, this.savedConfiguration, this.savedConnectionInfo);
        }
    }

    private class LocalPortListener
    extends Thread {
        private LocalPortForwarder.Parameters params;
        private LocalPortForwarder portForwarder;

        LocalPortListener(LocalPortForwarder.Parameters params) {
            this.params = params;
        }

        @Override
        public void run() {
            this.setName("Local port forwarder " + this.params.getRemoteHost() + ":" + this.params.getRemotePort() + " socket listener");
            LocalPortForwarder.Parameters params = new LocalPortForwarder.Parameters(this.params.getLocalHost(), this.params.getLocalPort(), this.params.getRemoteHost(), this.params.getRemotePort());
            try {
                ServerSocket serverSocket = new ServerSocket();
                serverSocket.setReuseAddress(true);
                serverSocket.bind(new InetSocketAddress(params.getLocalHost(), params.getLocalPort()));
                this.portForwarder = SSHImplementationSshj.this.sshClient.newLocalPortForwarder(params, serverSocket);
                this.portForwarder.listen();
            }
            catch (IOException e) {
                log.error((Object)e);
            }
            log.debug((Object)"Server socket closed. Tunnel is terminated");
        }

        void stopServer() {
            if (this.portForwarder != null) {
                try {
                    this.portForwarder.close();
                }
                catch (IOException e) {
                    log.error((Object)"Error closing port forwarder", (Throwable)e);
                }
                this.portForwarder = null;
            }
        }
    }
}

