/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.tools.transfer.wizard;

import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.tools.transfer.IDataTransferNode;
import org.jkiss.dbeaver.tools.transfer.internal.DTMessages;
import org.jkiss.dbeaver.tools.transfer.wizard.DataTransferPipe;
import org.jkiss.dbeaver.tools.transfer.wizard.DataTransferSettings;
import org.jkiss.dbeaver.tools.transfer.wizard.DataTransferWizard;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.dialogs.ActiveWizardPage;

class DataTransferPageSettings
extends ActiveWizardPage<DataTransferWizard> {
    private static final Log log = Log.getLog(DataTransferPageSettings.class);
    private IWizardPage producerSettingsPage;
    private IWizardPage consumerSettingsPage;

    DataTransferPageSettings() {
        super(DTMessages.data_transfer_wizard_settings_name);
        this.setTitle(DTMessages.data_transfer_wizard_settings_title);
        this.setDescription(DTMessages.data_transfer_wizard_settings_description);
        this.setPageComplete(false);
    }

    public void createControl(Composite parent) {
        this.initializeDialogUnits((Control)parent);
        Composite composite = new Composite(parent, 0);
        GridLayout gl = new GridLayout(1, true);
        gl.marginHeight = 0;
        gl.marginWidth = 0;
        composite.setLayout((Layout)gl);
        composite.setLayoutData((Object)new GridData(1808));
        this.setControl((Control)composite);
    }

    private void createSettingsPages(Composite composite) {
        DataTransferSettings dtSettings = ((DataTransferWizard)this.getWizard()).getSettings();
        DataTransferPipe dataPipe = dtSettings.getDataPipes().get(0);
        StringBuilder title = new StringBuilder();
        title.append(DTMessages.data_transfer_wizard_settings_title).append(" (").append(dtSettings.getProducer().getName()).append(" to ").append(dtSettings.getConsumer().getName());
        if (dtSettings.getProcessor() != null) {
            title.append(", ").append(dtSettings.getProcessor().getName());
        }
        title.append(")");
        this.setTitle(title.toString());
        this.producerSettingsPage = this.getSettingsPage(dataPipe.getProducer());
        this.consumerSettingsPage = this.getSettingsPage(dataPipe.getConsumer());
        Composite settingsComposite = composite;
        if (this.producerSettingsPage != null && this.consumerSettingsPage != null) {
            SashForm sash = new SashForm(composite, 256);
            sash.setLayoutData((Object)new GridData(1808));
            settingsComposite = sash;
        }
        if (this.producerSettingsPage != null) {
            this.producerSettingsPage.setWizard(this.getWizard());
            Composite producerGroup = UIUtils.createPlaceholder((Composite)settingsComposite, (int)1);
            UIUtils.createInfoLabel((Composite)producerGroup, (String)this.producerSettingsPage.getTitle());
            this.producerSettingsPage.createControl(producerGroup);
            if (this.producerSettingsPage instanceof ActiveWizardPage) {
                ((ActiveWizardPage)this.producerSettingsPage).activatePage();
            }
        }
        if (this.consumerSettingsPage != null) {
            this.consumerSettingsPage.setWizard(this.getWizard());
            Composite consumerGroup = UIUtils.createPlaceholder((Composite)settingsComposite, (int)1);
            UIUtils.createInfoLabel((Composite)consumerGroup, (String)this.consumerSettingsPage.getTitle());
            this.consumerSettingsPage.createControl(consumerGroup);
            if (this.consumerSettingsPage instanceof ActiveWizardPage) {
                ((ActiveWizardPage)this.consumerSettingsPage).activatePage();
            }
        }
    }

    private IWizardPage getSettingsPage(IDataTransferNode node) {
        DataTransferSettings.NodeSettings producerInfo = ((DataTransferWizard)this.getWizard()).getSettings().getNodeInfo(node);
        return producerInfo == null ? null : producerInfo.settingsPage;
    }

    public void activatePage() {
        Composite composite = (Composite)this.getControl();
        Control[] controlArray = composite.getChildren();
        int n = controlArray.length;
        int n2 = 0;
        while (n2 < n) {
            Control child = controlArray[n2];
            child.dispose();
            ++n2;
        }
        this.createSettingsPages(composite);
        composite.layout(true, true);
        this.updatePageCompletion();
    }

    public void deactivatePage() {
        if (this.producerSettingsPage instanceof ActiveWizardPage) {
            ((ActiveWizardPage)this.producerSettingsPage).deactivatePage();
        }
        if (this.consumerSettingsPage instanceof ActiveWizardPage) {
            ((ActiveWizardPage)this.consumerSettingsPage).deactivatePage();
        }
    }

    protected boolean determinePageCompletion() {
        return !(this.producerSettingsPage != null && !this.producerSettingsPage.isPageComplete() || this.consumerSettingsPage != null && !this.consumerSettingsPage.isPageComplete());
    }
}

