/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.mysql.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.jface.text.TextAttribute;
import org.eclipse.jface.text.rules.IRule;
import org.eclipse.jface.text.rules.IToken;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCDatabaseMetaData;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCDataSource;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCSQLDialect;
import org.jkiss.dbeaver.model.impl.sql.BasicSQLDialect;
import org.jkiss.dbeaver.model.sql.SQLDialect;
import org.jkiss.dbeaver.runtime.sql.SQLRuleProvider;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.editors.sql.syntax.rules.SQLFullLineRule;
import org.jkiss.dbeaver.ui.editors.sql.syntax.tokens.SQLControlToken;
import org.jkiss.utils.ArrayUtils;

class MySQLDialect
extends JDBCSQLDialect
implements SQLRuleProvider {
    public static final String[] MYSQL_NON_TRANSACTIONAL_KEYWORDS = (String[])ArrayUtils.concatArrays((Object[])BasicSQLDialect.NON_TRANSACTIONAL_KEYWORDS, (Object[])new String[]{"USE", "SHOW", "CREATE", "ALTER", "DROP", "EXPLAIN", "DESCRIBE", "DESC"});
    public static final String[] ADVANCED_KEYWORDS = new String[]{"AUTO_INCREMENT", "DATABASES", "COLUMNS"};
    public static final String[][] MYSQL_QUOTE_STRINGS = new String[][]{{"`", "`"}, {"\"", "\""}};
    private static String[] EXEC_KEYWORDS = new String[]{"CALL"};

    public MySQLDialect() {
        super("MySQL");
    }

    public void initDriverSettings(JDBCDataSource dataSource, JDBCDatabaseMetaData metaData) {
        super.initDriverSettings(dataSource, metaData);
        Collections.addAll(this.tableQueryWords, "EXPLAIN", "DESCRIBE", "DESC");
        this.addFunctions(Arrays.asList("SLEEP"));
        String[] stringArray = ADVANCED_KEYWORDS;
        int n = ADVANCED_KEYWORDS.length;
        int n2 = 0;
        while (n2 < n) {
            String kw = stringArray[n2];
            this.addSQLKeyword(kw);
            ++n2;
        }
        this.removeSQLKeyword("SOURCE");
    }

    @Nullable
    public String[][] getIdentifierQuoteStrings() {
        return MYSQL_QUOTE_STRINGS;
    }

    public String[] getExecuteKeywords() {
        return EXEC_KEYWORDS;
    }

    public int getSchemaUsage() {
        return Integer.MAX_VALUE;
    }

    public char getStringEscapeCharacter() {
        return '\\';
    }

    @Nullable
    public String getScriptDelimiterRedefiner() {
        return "DELIMITER";
    }

    @NotNull
    public String escapeString(String string) {
        return string.replace("'", "''").replace("\\", "\\\\");
    }

    @NotNull
    public String unEscapeString(String string) {
        return string.replace("''", "'").replace("\\\\", "\\");
    }

    @NotNull
    public SQLDialect.MultiValueInsertMode getMultiValueInsertMode() {
        return SQLDialect.MultiValueInsertMode.GROUP_ROWS;
    }

    public boolean supportsAliasInSelect() {
        return true;
    }

    public boolean supportsTableDropCascade() {
        return true;
    }

    public boolean supportsCommentQuery() {
        return true;
    }

    public String[] getSingleLineComments() {
        return new String[]{"-- ", "#"};
    }

    public String getTestSQL() {
        return "SELECT 1";
    }

    @NotNull
    protected String[] getNonTransactionKeywords() {
        return MYSQL_NON_TRANSACTIONAL_KEYWORDS;
    }

    protected boolean useBracketsForExec() {
        return true;
    }

    public void extendRules(@NotNull List<IRule> rules, @NotNull SQLRuleProvider.RulePosition position) {
        if (position == SQLRuleProvider.RulePosition.CONTROL) {
            SQLControlToken sourceToken = new SQLControlToken((Object)new TextAttribute(UIUtils.getGlobalColor((String)"org.jkiss.dbeaver.sql.editor.color.command.foreground"), null, 1), "mysql.source");
            SQLFullLineRule sourceRule2 = new SQLFullLineRule("SOURCE", (IToken)sourceToken);
            rules.add((IRule)sourceRule2);
        }
    }
}

