/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.controls.resultset.valuefilter;

import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Text;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.model.DBPDataKind;
import org.jkiss.dbeaver.model.DBPEvaluationContext;
import org.jkiss.dbeaver.model.data.DBDAttributeBinding;
import org.jkiss.dbeaver.model.data.DBDDisplayFormat;
import org.jkiss.dbeaver.model.data.DBDLabelValuePair;
import org.jkiss.dbeaver.model.exec.DBCLogicalOperator;
import org.jkiss.dbeaver.model.struct.DBSEntityAssociation;
import org.jkiss.dbeaver.model.struct.DBSEntityReferrer;
import org.jkiss.dbeaver.model.struct.DBSTypedObject;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.controls.resultset.ResultSetRow;
import org.jkiss.dbeaver.ui.controls.resultset.ResultSetViewer;
import org.jkiss.dbeaver.ui.controls.resultset.valuefilter.GenericFilterValueEdit;
import org.jkiss.dbeaver.ui.data.editors.ReferenceValueEditor;
import org.jkiss.dbeaver.ui.editors.object.struct.EditDictionaryPage;

public class FilterValueEditPopup
extends Dialog {
    private static final String DIALOG_ID = "DBeaver.FilterValueEditMenu";
    private Object value;
    private GenericFilterValueEdit filter;
    private Point location;

    public FilterValueEditPopup(Shell parentShell, @NotNull ResultSetViewer viewer, @NotNull DBDAttributeBinding attr, @NotNull ResultSetRow[] rows) {
        super(parentShell);
        this.setShellStyle(1264);
        this.filter = new GenericFilterValueEdit(viewer, attr, rows, DBCLogicalOperator.IN);
    }

    protected IDialogSettings getDialogBoundsSettings() {
        return UIUtils.getDialogSettings((String)DIALOG_ID);
    }

    protected boolean isResizable() {
        return true;
    }

    protected Point getInitialLocation(Point initialSize) {
        if (this.location != null) {
            return this.location;
        }
        return super.getInitialLocation(initialSize);
    }

    protected Control createDialogArea(final Composite parent) {
        this.getShell().setText("Filter by '" + this.filter.attr.getFullyQualifiedName(DBPEvaluationContext.UI) + "'");
        final DBSEntityReferrer descReferrer = ReferenceValueEditor.getEnumerableConstraint(this.filter.attr);
        Composite group = (Composite)super.createDialogArea(parent);
        Composite labelComposite = UIUtils.createComposite((Composite)group, (int)2);
        labelComposite.setLayoutData((Object)new GridData(768));
        Label controlLabel = UIUtils.createControlLabel((Composite)labelComposite, (String)"Choose value(s) to filter by");
        controlLabel.setLayoutData((Object)new GridData(768));
        if (descReferrer instanceof DBSEntityAssociation) {
            Link hintLabel = UIUtils.createLink((Composite)labelComposite, (String)"(<a>Define Description</a>)", (SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    EditDictionaryPage editDictionaryPage = new EditDictionaryPage(((DBSEntityAssociation)descReferrer).getAssociatedEntity());
                    if (editDictionaryPage.edit(parent.getShell())) {
                        FilterValueEditPopup.this.filter.loadValues();
                    }
                }
            });
            hintLabel.setLayoutData((Object)new GridData(128));
        } else {
            UIUtils.createEmptyLabel((Composite)labelComposite, (int)1, (int)1);
        }
        Composite tableComposite = new Composite(group, 0);
        GridData gd = new GridData(1808);
        gd.widthHint = 400;
        gd.heightHint = 300;
        tableComposite.setLayoutData((Object)gd);
        tableComposite.setLayout((Layout)new FillLayout());
        this.filter.setupTable(tableComposite, 68356, true, descReferrer != null, new GridData(1808));
        Table table = this.filter.tableViewer.getTable();
        TableViewerColumn resultsetColumn = new TableViewerColumn(this.filter.tableViewer, UIUtils.createTableColumn((Table)table, (int)0, (String)"Value"));
        resultsetColumn.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                return ((FilterValueEditPopup)FilterValueEditPopup.this).filter.attr.getValueHandler().getValueDisplayString((DBSTypedObject)((FilterValueEditPopup)FilterValueEditPopup.this).filter.attr, ((DBDLabelValuePair)element).getValue(), DBDDisplayFormat.UI);
            }
        });
        TableViewerColumn descColumn = null;
        if (descReferrer != null) {
            descColumn = new TableViewerColumn(this.filter.tableViewer, UIUtils.createTableColumn((Table)table, (int)0, (String)"Description"));
            descColumn.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

                public String getText(Object element) {
                    return ((DBDLabelValuePair)element).getLabel();
                }
            });
        }
        UIUtils.asyncExec(() -> UIUtils.packColumns((Table)table, (boolean)true));
        FocusAdapter focusListener = new FocusAdapter(){

            public void focusLost(FocusEvent e) {
                UIUtils.asyncExec(() -> {
                    if (!UIUtils.isParent((Control)FilterValueEditPopup.this.getShell(), (Control)FilterValueEditPopup.this.getShell().getDisplay().getFocusControl())) {
                        FilterValueEditPopup.this.cancelPressed();
                    }
                });
            }
        };
        table.addFocusListener((FocusListener)focusListener);
        this.filter.tableViewer.addSelectionChangedListener(event -> {
            ISelection selection = event.getSelection();
            if (selection instanceof IStructuredSelection) {
                this.value = ((IStructuredSelection)selection).getFirstElement();
            }
        });
        this.filter.tableViewer.addDoubleClickListener(event -> {
            this.value = this.filter.tableViewer.getStructuredSelection().getFirstElement();
            this.okPressed();
        });
        if (this.filter.attr.getDataKind() == DBPDataKind.STRING || descReferrer != null) {
            Text filterTextbox = this.filter.addFilterTextbox(group);
            filterTextbox.setFocus();
            filterTextbox.addTraverseListener(e -> {
                if (e.detail == 32 || e.detail == 64) {
                    if (table.getSelectionIndex() < 0 && table.getItemCount() > 0) {
                        table.setSelection(0);
                    }
                    table.setFocus();
                }
            });
            filterTextbox.addFocusListener((FocusListener)focusListener);
        } else {
            table.setFocus();
        }
        this.filter.filterPattern = null;
        this.filter.loadValues();
        return tableComposite;
    }

    protected Control createButtonBar(Composite parent) {
        return UIUtils.createPlaceholder((Composite)parent, (int)1);
    }

    public void setLocation(Point location) {
        this.location = location;
    }

    public Object getValue() {
        return ((DBDLabelValuePair)this.value).getValue();
    }
}

