/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.editors.object.struct;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.model.DBPEvaluationContext;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.model.DBPNamedObject;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.navigator.DBNDatabaseNode;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.runtime.DBRRunnableWithProgress;
import org.jkiss.dbeaver.model.struct.DBSEntity;
import org.jkiss.dbeaver.model.struct.DBSEntityAttribute;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.ui.DBeaverIcons;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.controls.CustomTableEditor;
import org.jkiss.dbeaver.ui.controls.TableColumnSortListener;
import org.jkiss.dbeaver.ui.editors.internal.EditorsMessages;
import org.jkiss.dbeaver.ui.editors.object.struct.BaseObjectEditPage;
import org.jkiss.utils.CommonUtils;

public abstract class AttributesSelectorPage
extends BaseObjectEditPage {
    protected DBSEntity entity;
    protected Table columnsTable;
    protected List<AttributeInfo> attributes = new ArrayList<AttributeInfo>();
    protected Button toggleButton;
    protected Group columnsGroup;

    public AttributesSelectorPage(String title, DBSEntity entity) {
        super(NLS.bind((String)EditorsMessages.dialog_struct_columns_select_title, (Object)title, (Object)entity.getName()));
        this.entity = entity;
    }

    public Map<String, Object> getAttributeProperties(DBSEntityAttribute attr) {
        for (AttributeInfo attrInfo : this.attributes) {
            if (attrInfo.attribute != attr) continue;
            return attrInfo.properties;
        }
        return Collections.emptyMap();
    }

    public Object getAttributeProperty(DBSEntityAttribute attr, String propName) {
        for (AttributeInfo attrInfo : this.attributes) {
            if (attrInfo.attribute != attr) continue;
            return attrInfo.properties.get(propName);
        }
        return null;
    }

    protected Composite createPageContents(Composite parent) {
        Composite panel = UIUtils.createPlaceholder((Composite)parent, (int)1);
        panel.setLayoutData((Object)new GridData(1808));
        Composite tableGroup = this.createTableNameInput(panel);
        this.createContentsBeforeColumns(tableGroup);
        this.createColumnsGroup(panel);
        this.createContentsAfterColumns(panel);
        this.fillAttributes(this.entity);
        return panel;
    }

    protected void createColumnsGroup(Composite panel) {
        this.columnsGroup = UIUtils.createControlGroup((Composite)panel, (String)EditorsMessages.dialog_struct_columns_select_group_columns, (int)1, (int)1808, (int)0);
        this.columnsTable = new Table((Composite)this.columnsGroup, 67620);
        this.columnsTable.setHeaderVisible(true);
        GridData gd = new GridData(1808);
        this.columnsTable.setLayoutData((Object)gd);
        this.columnsTable.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AttributesSelectorPage.this.handleItemSelect((TableItem)e.item, true);
            }
        });
        this.createAttributeColumns(this.columnsTable);
        new CustomTableEditor(this.columnsTable){

            protected Control createEditor(Table table, int index, TableItem item) {
                return AttributesSelectorPage.this.createCellEditor(table, index, item, (AttributeInfo)item.getData());
            }

            protected void saveEditorValue(Control control, int index, TableItem item) {
                AttributesSelectorPage.this.saveCellValue(control, index, item, (AttributeInfo)item.getData());
            }
        };
        this.toggleButton = new Button((Composite)this.columnsGroup, 8);
        this.toggleButton.setText("Select All");
        gd = new GridData(32);
        gd.widthHint = 120;
        this.toggleButton.setLayoutData((Object)gd);
        this.toggleButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TableItem[] items = AttributesSelectorPage.this.columnsTable.getItems();
                if (AttributesSelectorPage.this.hasCheckedColumns()) {
                    TableItem[] tableItemArray = items;
                    int n = items.length;
                    int n2 = 0;
                    while (n2 < n) {
                        TableItem item = tableItemArray[n2];
                        if (item.getChecked()) {
                            item.setChecked(false);
                            AttributesSelectorPage.this.handleItemSelect(item, true);
                        }
                        ++n2;
                    }
                } else {
                    TableItem[] tableItemArray = items;
                    int n = items.length;
                    int n3 = 0;
                    while (n3 < n) {
                        TableItem item = tableItemArray[n3];
                        if (!item.getChecked()) {
                            item.setChecked(true);
                            AttributesSelectorPage.this.handleItemSelect(item, true);
                        }
                        ++n3;
                    }
                }
            }
        });
    }

    protected void createAttributeColumns(Table columnsTable) {
        TableColumn colName = UIUtils.createTableColumn((Table)columnsTable, (int)0, (String)EditorsMessages.dialog_struct_columns_select_column);
        colName.addListener(13, (Listener)new TableColumnSortListener(columnsTable, 0));
        TableColumn colPosition = UIUtils.createTableColumn((Table)columnsTable, (int)0x1000000, (String)"#");
        colPosition.addListener(13, (Listener)new TableColumnSortListener(columnsTable, 1));
        TableColumn colType = UIUtils.createTableColumn((Table)columnsTable, (int)131072, (String)EditorsMessages.dialog_struct_columns_type);
        colType.addListener(13, (Listener)new TableColumnSortListener(columnsTable, 2));
    }

    protected int fillAttributeColumns(DBSEntityAttribute attribute, AttributeInfo attributeInfo, TableItem columnItem) {
        columnItem.setText(0, attribute.getName());
        columnItem.setText(2, attribute.getFullTypeName());
        return 2;
    }

    protected Control createCellEditor(Table table, int index, TableItem item, AttributeInfo data) {
        return null;
    }

    protected void saveCellValue(Control control, int index, TableItem item, AttributeInfo data) {
    }

    protected void fillAttributes(final DBSEntity entity) {
        final ArrayList attributes = new ArrayList();
        try {
            UIUtils.runInProgressService((DBRRunnableWithProgress)new DBRRunnableWithProgress(){

                public void run(DBRProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    try {
                        for (DBSEntityAttribute attr : CommonUtils.safeCollection((Collection)entity.getAttributes(monitor))) {
                            if (DBUtils.isHiddenObject((Object)attr)) continue;
                            attributes.add(attr);
                        }
                    }
                    catch (DBException e) {
                        throw new InvocationTargetException(e);
                    }
                }
            });
        }
        catch (InvocationTargetException e) {
            DBWorkbench.getPlatformUI().showError(EditorsMessages.dialog_struct_columns_select_error_load_columns_title, EditorsMessages.dialog_struct_columns_select_error_load_columns_message, e.getTargetException());
        }
        catch (InterruptedException interruptedException) {}
        for (DBSEntityAttribute attribute : attributes) {
            TableItem columnItem = new TableItem(this.columnsTable, 0);
            AttributeInfo col = new AttributeInfo(attribute);
            this.attributes.add(col);
            DBNDatabaseNode attributeNode = DBWorkbench.getPlatform().getNavigatorModel().findNode((DBSObject)attribute);
            if (attributeNode != null) {
                columnItem.setImage(0, DBeaverIcons.getImage((DBPImage)attributeNode.getNodeIcon()));
            }
            this.fillAttributeColumns(attribute, col, columnItem);
            columnItem.setData((Object)col);
            if (!this.isColumnSelected(attribute)) continue;
            columnItem.setChecked(true);
            this.handleItemSelect(columnItem, false);
        }
        UIUtils.packColumns((Table)this.columnsTable);
        this.updateToggleButton();
    }

    private Composite createTableNameInput(Composite panel) {
        Composite tableGroup = new Composite(panel, 0);
        tableGroup.setLayout((Layout)new GridLayout(2, false));
        tableGroup.setLayoutData((Object)new GridData(768));
        UIUtils.createLabelText((Composite)tableGroup, (String)EditorsMessages.dialog_struct_columns_select_label_table, (String)DBUtils.getObjectFullName((DBPNamedObject)this.entity, (DBPEvaluationContext)DBPEvaluationContext.UI), (int)2056, (Object)new GridData(768));
        return tableGroup;
    }

    private void handleItemSelect(TableItem item, boolean notify) {
        AttributeInfo col = (AttributeInfo)item.getData();
        if (item.getChecked() && col.position < 0) {
            col.position = 0;
            for (AttributeInfo tmp : this.attributes) {
                if (tmp == col || tmp.position < col.position) continue;
                col.position = tmp.position + 1;
            }
            item.setText(1, String.valueOf(col.position + 1));
        } else if (!item.getChecked() && col.position >= 0) {
            item.setText(1, "");
            TableItem[] allItems = this.columnsTable.getItems();
            block1: for (AttributeInfo tmp : this.attributes) {
                if (tmp == col || tmp.position < col.position) continue;
                --tmp.position;
                TableItem[] tableItemArray = allItems;
                int n = allItems.length;
                int n2 = 0;
                while (n2 < n) {
                    TableItem ai = tableItemArray[n2];
                    if (ai.getData() == tmp) {
                        ai.setText(1, String.valueOf(tmp.position + 1));
                        continue block1;
                    }
                    ++n2;
                }
            }
            col.position = -1;
        }
        if (notify) {
            this.handleColumnsChange();
            this.updateToggleButton();
            this.updatePageState();
        }
    }

    private boolean hasCheckedColumns() {
        boolean hasCheckedColumns = false;
        for (AttributeInfo tmp : this.attributes) {
            if (tmp.position < 0) continue;
            hasCheckedColumns = true;
            break;
        }
        return hasCheckedColumns;
    }

    private void updateToggleButton() {
        if (this.hasCheckedColumns()) {
            this.toggleButton.setText("Clear All");
        } else {
            this.toggleButton.setText("Select All");
        }
    }

    public Collection<DBSEntityAttribute> getSelectedAttributes() {
        ArrayList<DBSEntityAttribute> tableColumns = new ArrayList<DBSEntityAttribute>();
        TreeSet<AttributeInfo> orderedAttributes = new TreeSet<AttributeInfo>(new Comparator<AttributeInfo>(){

            @Override
            public int compare(AttributeInfo o1, AttributeInfo o2) {
                return o1.position - o2.position;
            }
        });
        orderedAttributes.addAll(this.attributes);
        for (AttributeInfo col : orderedAttributes) {
            if (col.position < 0) continue;
            tableColumns.add(col.attribute);
        }
        return tableColumns;
    }

    protected void createContentsBeforeColumns(Composite panel) {
    }

    protected void createContentsAfterColumns(Composite panel) {
    }

    public boolean isColumnSelected(DBSEntityAttribute attribute) {
        return false;
    }

    protected void handleColumnsChange() {
    }

    @Override
    public boolean isPageComplete() {
        TableItem[] tableItemArray = this.columnsTable.getItems();
        int n = tableItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            TableItem item = tableItemArray[n2];
            if (item.getChecked()) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    protected static class AttributeInfo {
        DBSEntityAttribute attribute;
        int position;
        Map<String, Object> properties = new HashMap<String, Object>();

        public AttributeInfo(DBSEntityAttribute attribute) {
            this.attribute = attribute;
            this.position = -1;
        }

        public DBSEntityAttribute getAttribute() {
            return this.attribute;
        }

        public int getPosition() {
            return this.position;
        }

        public Object getProperty(String name) {
            return this.properties.get(name);
        }

        public void setProperty(String name, Object value) {
            if (value == null) {
                this.properties.remove(name);
            } else {
                this.properties.put(name, value);
            }
        }

        public String toString() {
            return this.attribute.getName();
        }
    }
}

