Object.defineProperty(exports, '__esModule', {
  value: true
});
/** @babel */

exports['default'] = {
  activate: function activate() {
    var _this = this;

    this.stack = [];

    this.workspaceSubscription = atom.commands.add('atom-workspace', {
      'symbols-view:toggle-project-symbols': function symbolsViewToggleProjectSymbols() {
        _this.createProjectView().toggle();
      }
    });

    this.editorSubscription = atom.commands.add('atom-text-editor', {
      'symbols-view:toggle-file-symbols': function symbolsViewToggleFileSymbols() {
        _this.createFileView().toggle();
      },
      'symbols-view:go-to-declaration': function symbolsViewGoToDeclaration() {
        _this.createGoToView().toggle();
      },
      'symbols-view:return-from-declaration': function symbolsViewReturnFromDeclaration() {
        _this.createGoBackView().toggle();
      }
    });
  },

  deactivate: function deactivate() {
    if (this.fileView != null) {
      this.fileView.destroy();
      this.fileView = null;
    }

    if (this.projectView != null) {
      this.projectView.destroy();
      this.projectView = null;
    }

    if (this.goToView != null) {
      this.goToView.destroy();
      this.goToView = null;
    }

    if (this.goBackView != null) {
      this.goBackView.destroy();
      this.goBackView = null;
    }

    if (this.workspaceSubscription != null) {
      this.workspaceSubscription.dispose();
      this.workspaceSubscription = null;
    }

    if (this.editorSubscription != null) {
      this.editorSubscription.dispose();
      this.editorSubscription = null;
    }
  },

  createFileView: function createFileView() {
    if (this.fileView) {
      return this.fileView;
    }
    var FileView = require('./file-view');
    this.fileView = new FileView(this.stack);
    return this.fileView;
  },

  createProjectView: function createProjectView() {
    if (this.projectView) {
      return this.projectView;
    }
    var ProjectView = require('./project-view');
    this.projectView = new ProjectView(this.stack);
    return this.projectView;
  },

  createGoToView: function createGoToView() {
    if (this.goToView) {
      return this.goToView;
    }
    var GoToView = require('./go-to-view');
    this.goToView = new GoToView(this.stack);
    return this.goToView;
  },

  createGoBackView: function createGoBackView() {
    if (this.goBackView) {
      return this.goBackView;
    }
    var GoBackView = require('./go-back-view');
    this.goBackView = new GoBackView(this.stack);
    return this.goBackView;
  }
};
module.exports = exports['default'];
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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