Object.defineProperty(exports, '__esModule', {
  value: true
});

var _createClass = (function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ('value' in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; })();

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { 'default': obj }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError('Cannot call a class as a function'); } }

/** @babel */
/** @jsx etch.dom */

var _atom = require('atom');

var _etch = require('etch');

var _etch2 = _interopRequireDefault(_etch);

var _settingsPanel = require('./settings-panel');

var _settingsPanel2 = _interopRequireDefault(_settingsPanel);

var EditorPanel = (function () {
  function EditorPanel() {
    var _this = this;

    _classCallCheck(this, EditorPanel);

    _etch2['default'].initialize(this);
    this.subscriptions = new _atom.CompositeDisposable();
    this.subscriptions.add(atom.commands.add(this.element, {
      'core:move-up': function coreMoveUp() {
        _this.scrollUp();
      },
      'core:move-down': function coreMoveDown() {
        _this.scrollDown();
      },
      'core:page-up': function corePageUp() {
        _this.pageUp();
      },
      'core:page-down': function corePageDown() {
        _this.pageDown();
      },
      'core:move-to-top': function coreMoveToTop() {
        _this.scrollToTop();
      },
      'core:move-to-bottom': function coreMoveToBottom() {
        _this.scrollToBottom();
      }
    }));
  }

  _createClass(EditorPanel, [{
    key: 'destroy',
    value: function destroy() {
      this.subscriptions.dispose();
      return _etch2['default'].destroy(this);
    }
  }, {
    key: 'update',
    value: function update() {}
  }, {
    key: 'render',
    value: function render() {
      return _etch2['default'].dom(
        'div',
        { tabIndex: '0', className: 'panels-item', onclick: this.didClick },
        _etch2['default'].dom(_settingsPanel2['default'], {
          namespace: 'editor',
          icon: 'code',
          note: '<div class="text icon icon-question" id="editor-settings-note" tabindex="-1">These settings are related to text editing. Some of these can be overriden on a per-language basis. Check language settings by clicking its package card in the <a class="link packages-open">Packages list</a>.</div>' })
      );
    }
  }, {
    key: 'focus',
    value: function focus() {
      this.element.focus();
    }
  }, {
    key: 'show',
    value: function show() {
      this.element.style.display = '';
    }
  }, {
    key: 'didClick',
    value: function didClick(event) {
      var target = event.target.closest('.packages-open');
      if (target) {
        atom.workspace.open('atom://config/packages');
      }
    }
  }, {
    key: 'scrollUp',
    value: function scrollUp() {
      this.element.scrollTop -= document.body.offsetHeight / 20;
    }
  }, {
    key: 'scrollDown',
    value: function scrollDown() {
      this.element.scrollTop += document.body.offsetHeight / 20;
    }
  }, {
    key: 'pageUp',
    value: function pageUp() {
      this.element.scrollTop -= this.element.offsetHeight;
    }
  }, {
    key: 'pageDown',
    value: function pageDown() {
      this.element.scrollTop += this.element.offsetHeight;
    }
  }, {
    key: 'scrollToTop',
    value: function scrollToTop() {
      this.element.scrollTop = 0;
    }
  }, {
    key: 'scrollToBottom',
    value: function scrollToBottom() {
      this.element.scrollTop = this.element.scrollHeight;
    }
  }]);

  return EditorPanel;
})();

exports['default'] = EditorPanel;
module.exports = exports['default'];
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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