"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _react = _interopRequireDefault(require("react"));

var _propTypes = _interopRequireDefault(require("prop-types"));

var _donutChart = _interopRequireDefault(require("./donut-chart"));

var _helpers = require("../helpers");

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _extends() { _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

class StatusDonutChart extends _react.default.Component {
  render() {
    const slices = ['pending', 'failure', 'success'].reduce((acc, type) => {
      const count = this.props[type];

      if (count > 0) {
        acc.push({
          type,
          className: type,
          count
        });
      }

      return acc;
    }, []);
    return _react.default.createElement(_donutChart.default, _extends({}, (0, _helpers.unusedProps)(this.props, this.constructor.propTypes), {
      slices: slices
    }));
  }

}

exports.default = StatusDonutChart;

_defineProperty(StatusDonutChart, "propTypes", {
  pending: _propTypes.default.number,
  failure: _propTypes.default.number,
  success: _propTypes.default.number
});
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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