"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _eventKit = require("event-kit");

var _helpers = require("../helpers");

class StyleCalculator {
  constructor(styles, config) {
    (0, _helpers.autobind)(this, 'updateStyles');
    this.styles = styles;
    this.config = config;
  }

  startWatching(sourcePath, configsToWatch, getStylesheetFn) {
    const subscriptions = new _eventKit.CompositeDisposable();

    const updateStyles = () => {
      this.updateStyles(sourcePath, getStylesheetFn);
    };

    configsToWatch.forEach(configToWatch => {
      subscriptions.add(this.config.onDidChange(configToWatch, updateStyles));
    });
    updateStyles();
    return subscriptions;
  }

  updateStyles(sourcePath, getStylesheetFn) {
    const stylesheet = getStylesheetFn(this.config);
    this.styles.addStyleSheet(stylesheet, {
      sourcePath,
      priority: 0
    });
  }

}

exports.default = StyleCalculator;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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