"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _url = require("url");

var _moment = _interopRequireDefault(require("moment"));

var _prStatusesView = require("../views/pr-statuses-view");

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

class Issueish {
  constructor(data) {
    this.number = data.number;
    this.title = data.title;
    this.url = new _url.URL(data.url);
    this.authorLogin = data.author.login;
    this.authorAvatarURL = new _url.URL(data.author.avatarUrl);
    this.createdAt = (0, _moment.default)(data.createdAt, _moment.default.ISO_8601);
    this.headRefName = data.headRefName;
    this.headRepositoryID = data.repository.id;
    this.statusContexts = data.commits.nodes.reduce((acc, node) => {
      const status = node.commit.status;

      if (status !== null) {
        acc.push(...status.contexts);
      }

      return acc;
    }, []);
  }

  getNumber() {
    return this.number;
  }

  getTitle() {
    return this.title;
  }

  getGitHubURL() {
    return this.url.toString();
  }

  getAuthorLogin() {
    return this.authorLogin;
  }

  getAuthorAvatarURL(size = 32) {
    const u = new _url.URL(this.authorAvatarURL.toString());
    u.searchParams.set('s', size);
    return u.toString();
  }

  getCreatedAt() {
    return this.createdAt;
  }

  getHeadRefName() {
    return this.headRefName;
  }

  getHeadRepositoryID() {
    return this.headRepositoryID;
  }

  getStatusCounts() {
    return this.statusContexts.reduce((acc, context) => {
      acc[(0, _prStatusesView.category)(context.state).toLowerCase()]++;
      return acc;
    }, {
      pending: 0,
      failure: 0,
      success: 0
    });
  }

}

exports.default = Issueish;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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