"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.BASE = exports.THEIRS = exports.OURS = void 0;

class Source {
  constructor(name, uiString, cssClass) {
    this.name = name.toLowerCase();
    this.uiString = uiString;
    this.cssClass = cssClass;
  }

  when(actions) {
    const chosen = actions[this.name] || actions.default || (() => {
      throw new Error(`Unexpected conflict side source: ${this.name}`);
    });

    return chosen();
  }

  getName() {
    return this.name;
  }

  getCSSClass() {
    return this.cssClass;
  }

  getBannerCSSClass() {
    return this.cssClass + 'Banner';
  }

  getBlockCSSClass() {
    return this.cssClass + 'Block';
  }

  toUIString() {
    return this.uiString;
  }

  toString() {
    return `<Source: ${this.name.toUpperCase()}>`;
  }

}

const OURS = new Source('OURS', 'our changes', 'github-ConflictOurs');
exports.OURS = OURS;
const THEIRS = new Source('THEIRS', 'their changes', 'github-ConflictTheirs');
exports.THEIRS = THEIRS;
const BASE = new Source('BASE', 'common ancestor', 'github-ConflictBase');
exports.BASE = BASE;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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