"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _react = _interopRequireDefault(require("react"));

var _propTypes = _interopRequireDefault(require("prop-types"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

class ContextMenuInterceptor extends _react.default.Component {
  static handle(event) {
    for (const [element, callback] of ContextMenuInterceptor.registration) {
      if (element.contains(event.target)) {
        callback(event);
      }
    }
  }

  static dispose() {
    document.removeEventListener('contextmenu', contextMenuHandler, {
      capture: true
    });
  }

  componentDidMount() {
    // Helpfully, addEventListener dedupes listeners for us.
    document.addEventListener('contextmenu', contextMenuHandler, {
      capture: true
    });
    ContextMenuInterceptor.registration.set(this.element, (...args) => this.props.onWillShowContextMenu(...args));
  }

  render() {
    return _react.default.createElement("div", {
      ref: e => {
        this.element = e;
      }
    }, this.props.children);
  }

  componentWillUnmount() {
    ContextMenuInterceptor.registration.delete(this.element);
  }

}

exports.default = ContextMenuInterceptor;

_defineProperty(ContextMenuInterceptor, "propTypes", {
  onWillShowContextMenu: _propTypes.default.func.isRequired,
  children: _propTypes.default.element.isRequired
});

_defineProperty(ContextMenuInterceptor, "registration", new Map());

function contextMenuHandler(event) {
  ContextMenuInterceptor.handle(event);
}
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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