"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _react = _interopRequireDefault(require("react"));

var _propTypes = _interopRequireDefault(require("prop-types"));

var _reactRelay = require("react-relay");

var _reporterProxy = require("../reporter-proxy");

var _helpers = require("../helpers");

var _propTypes2 = require("../prop-types");

var _relayNetworkLayerManager = _interopRequireDefault(require("../relay-network-layer-manager"));

var _keytarStrategy = require("../shared/keytar-strategy");

var _remoteController = _interopRequireDefault(require("../controllers/remote-controller"));

var _observeModel = _interopRequireDefault(require("../views/observe-model"));

var _loadingView = _interopRequireDefault(require("../views/loading-view"));

var _queryErrorView = _interopRequireDefault(require("../views/query-error-view"));

var _githubLoginView = _interopRequireDefault(require("../views/github-login-view"));

var _graphql;

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

class RemoteContainer extends _react.default.Component {
  constructor(props) {
    super(props);
    (0, _helpers.autobind)(this, 'fetchToken', 'renderWithToken', 'renderWithResult', 'handleLogin', 'handleLogout');
  }

  fetchToken(loginModel) {
    return loginModel.getToken(this.props.endpoint.getLoginAccount());
  }

  render() {
    return _react.default.createElement(_observeModel.default, {
      model: this.props.loginModel,
      fetchData: this.fetchToken
    }, this.renderWithToken);
  }

  renderWithToken(token) {
    if (token === null) {
      return _react.default.createElement(_loadingView.default, null);
    }

    if (token === _keytarStrategy.UNAUTHENTICATED) {
      return _react.default.createElement(_githubLoginView.default, {
        onLogin: this.handleLogin
      });
    }

    if (token === _keytarStrategy.INSUFFICIENT) {
      return _react.default.createElement(_githubLoginView.default, {
        onLogin: this.handleLogin
      }, _react.default.createElement("p", null, "Your token no longer has sufficient authorizations. Please re-authenticate and generate a new one."));
    }

    const environment = _relayNetworkLayerManager.default.getEnvironmentForHost(this.props.endpoint, token);

    const query = _graphql || (_graphql = function () {
      const node = require("./__generated__/remoteContainerQuery.graphql");

      if (node.hash && node.hash !== "b83aa6c27c5d7e1c499badf2e6bfab6b") {
        console.error("The definition of 'remoteContainerQuery' appears to have changed. Run `relay-compiler` to update the generated files to receive the expected data.");
      }

      return require("./__generated__/remoteContainerQuery.graphql");
    });

    const variables = {
      owner: this.props.remote.getOwner(),
      name: this.props.remote.getRepo()
    };
    return _react.default.createElement(_reactRelay.QueryRenderer, {
      environment: environment,
      variables: variables,
      query: query,
      render: result => this.renderWithResult(result, token)
    });
  }

  renderWithResult({
    error,
    props,
    retry
  }, token) {
    if (error) {
      return _react.default.createElement(_queryErrorView.default, {
        error: error,
        login: this.handleLogin,
        retry: retry,
        logout: this.handleLogout
      });
    }

    if (props === null) {
      return _react.default.createElement(_loadingView.default, null);
    }

    return _react.default.createElement(_remoteController.default, {
      endpoint: this.props.endpoint,
      token: token,
      repository: props.repository,
      remoteOperationObserver: this.props.remoteOperationObserver,
      workingDirectory: this.props.workingDirectory,
      workspace: this.props.workspace,
      remote: this.props.remote,
      remotes: this.props.remotes,
      branches: this.props.branches,
      aheadCount: this.props.aheadCount,
      pushInProgress: this.props.pushInProgress,
      onPushBranch: this.props.onPushBranch
    });
  }

  handleLogin(token) {
    (0, _reporterProxy.incrementCounter)('github-login');
    this.props.loginModel.setToken(this.props.endpoint.getLoginAccount(), token);
  }

  handleLogout() {
    (0, _reporterProxy.incrementCounter)('github-logout');
    this.props.loginModel.removeToken(this.props.endpoint.getLoginAccount());
  }

}

exports.default = RemoteContainer;

_defineProperty(RemoteContainer, "propTypes", {
  // Connection
  loginModel: _propTypes.default.object.isRequired,
  endpoint: _propTypes2.EndpointPropType.isRequired,
  // Repository attributes
  remoteOperationObserver: _propTypes2.OperationStateObserverPropType.isRequired,
  pushInProgress: _propTypes.default.bool.isRequired,
  workingDirectory: _propTypes.default.string.isRequired,
  workspace: _propTypes.default.object.isRequired,
  remote: _propTypes2.RemotePropType.isRequired,
  remotes: _propTypes2.RemoteSetPropType.isRequired,
  branches: _propTypes2.BranchSetPropType.isRequired,
  aheadCount: _propTypes.default.number,
  // Action methods
  onPushBranch: _propTypes.default.func.isRequired
});
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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