"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _react = _interopRequireDefault(require("react"));

var _propTypes = _interopRequireDefault(require("prop-types"));

var _yubikiri = _interopRequireDefault(require("yubikiri"));

var _helpers = require("../helpers");

var _commit = require("../models/commit");

var _branch = require("../models/branch");

var _observeModel = _interopRequireDefault(require("../views/observe-model"));

var _gitTabController = _interopRequireDefault(require("../controllers/git-tab-controller"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _extends() { _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

const DEFAULT_REPO_DATA = {
  lastCommit: _commit.nullCommit,
  recentCommits: [],
  isMerging: false,
  isRebasing: false,
  hasUndoHistory: false,
  currentBranch: _branch.nullBranch,
  unstagedChanges: [],
  stagedChanges: [],
  mergeConflicts: [],
  workingDirectoryPath: null,
  mergeMessage: null,
  fetchInProgress: true
};

class GitTabContainer extends _react.default.Component {
  constructor(props) {
    super(props);
    (0, _helpers.autobind)(this, 'fetchData');
  }

  fetchData(repository) {
    return (0, _yubikiri.default)({
      lastCommit: repository.getLastCommit(),
      recentCommits: repository.getRecentCommits({
        max: 10
      }),
      isMerging: repository.isMerging(),
      isRebasing: repository.isRebasing(),
      hasUndoHistory: repository.hasDiscardHistory(),
      currentBranch: repository.getCurrentBranch(),
      unstagedChanges: repository.getUnstagedChanges(),
      stagedChanges: repository.getStagedChanges(),
      mergeConflicts: repository.getMergeConflicts(),
      workingDirectoryPath: repository.getWorkingDirectoryPath(),
      mergeMessage: async query => {
        const isMerging = await query.isMerging;
        return isMerging ? repository.getMergeMessage() : null;
      },
      fetchInProgress: false
    });
  }

  render() {
    return _react.default.createElement(_observeModel.default, {
      model: this.props.repository,
      fetchData: this.fetchData
    }, data => _react.default.createElement(_gitTabController.default, _extends({}, this.props, data || DEFAULT_REPO_DATA)));
  }

}

exports.default = GitTabContainer;

_defineProperty(GitTabContainer, "propTypes", {
  repository: _propTypes.default.object.isRequired
});
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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