"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _react = _interopRequireDefault(require("react"));

var _reactDom = _interopRequireDefault(require("react-dom"));

var _propTypes = _interopRequireDefault(require("prop-types"));

var _eventKit = require("event-kit");

var _propTypes2 = require("../prop-types");

var _helpers = require("../helpers");

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

const VERBATIM_OPTION_PROPS = ['title', 'html', 'placement', 'trigger', 'keyBindingCommand', 'keyBindingTarget'];
const OPTION_PROPS = [...VERBATIM_OPTION_PROPS, 'tooltips', 'className', 'showDelay', 'hideDelay'];

class Tooltip extends _react.default.Component {
  constructor(props, context) {
    super(props, context);
    this.refSub = new _eventKit.Disposable();
    this.tipSub = new _eventKit.Disposable();
    this.domNode = null;

    if (this.props.children !== undefined) {
      this.domNode = document.createElement('div');
      this.domNode.className = 'react-atom-tooltip';
    }

    this.lastTooltipProps = {};
  }

  componentDidMount() {
    this.setupTooltip();
  }

  render() {
    if (this.props.children !== undefined) {
      return _reactDom.default.createPortal(this.props.children, this.domNode);
    } else {
      return null;
    }
  }

  componentDidUpdate() {
    if (this.shouldRecreateTooltip()) {
      this.refSub.dispose();
      this.tipSub.dispose();
      this.setupTooltip();
    }
  }

  componentWillUnmount() {
    this.refSub.dispose();
    this.tipSub.dispose();
  }

  getTooltipProps() {
    const p = {};

    for (const key of OPTION_PROPS) {
      p[key] = this.props[key];
    }

    return p;
  }

  shouldRecreateTooltip() {
    return OPTION_PROPS.some(key => this.lastTooltipProps[key] !== this.props[key]);
  }

  setupTooltip() {
    this.lastTooltipProps = this.getTooltipProps();
    const options = {};
    VERBATIM_OPTION_PROPS.forEach(key => {
      if (this.props[key] !== undefined) {
        options[key] = this.props[key];
      }
    });

    if (this.props.className !== undefined) {
      options.class = this.props.className;
    }

    if (this.props.showDelay !== undefined || this.props.hideDelay !== undefined) {
      const delayDefaults = (this.props.trigger === 'hover' || this.props.trigger === undefined) && {
        show: 1000,
        hide: 100
      } || {
        show: 0,
        hide: 0
      };
      options.delay = {
        show: this.props.showDelay !== undefined ? this.props.showDelay : delayDefaults.show,
        hide: this.props.hideDelay !== undefined ? this.props.hideDelay : delayDefaults.hide
      };
    }

    if (this.props.children !== undefined) {
      options.item = (0, _helpers.createItem)(this.domNode, this.props.itemHolder);
    }

    this.refSub = this.props.target.observe(t => {
      this.tipSub.dispose();
      this.tipSub = this.props.manager.add(t, options);
    });
  }

}

exports.default = Tooltip;

_defineProperty(Tooltip, "propTypes", {
  manager: _propTypes.default.object.isRequired,
  target: _propTypes2.RefHolderPropType.isRequired,
  title: _propTypes.default.oneOfType([_propTypes.default.string, _propTypes.default.func]),
  html: _propTypes.default.bool,
  className: _propTypes.default.string,
  placement: _propTypes.default.oneOfType([_propTypes.default.string, _propTypes.default.func]),
  trigger: _propTypes.default.oneOf(['hover', 'click', 'focus', 'manual']),
  showDelay: _propTypes.default.number,
  hideDelay: _propTypes.default.number,
  keyBindingCommand: _propTypes.default.string,
  keyBindingTarget: _propTypes.default.element,
  children: _propTypes.default.element,
  itemHolder: _propTypes2.RefHolderPropType
});

_defineProperty(Tooltip, "defaultProps", {
  getItemComponent: () => {}
});
//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbInRvb2x0aXAuanMiXSwibmFtZXMiOlsiVkVSQkFUSU1fT1BUSU9OX1BST1BTIiwiT1BUSU9OX1BST1BTIiwiVG9vbHRpcCIsIlJlYWN0IiwiQ29tcG9uZW50IiwiY29uc3RydWN0b3IiLCJwcm9wcyIsImNvbnRleHQiLCJyZWZTdWIiLCJEaXNwb3NhYmxlIiwidGlwU3ViIiwiZG9tTm9kZSIsImNoaWxkcmVuIiwidW5kZWZpbmVkIiwiZG9jdW1lbnQiLCJjcmVhdGVFbGVtZW50IiwiY2xhc3NOYW1lIiwibGFzdFRvb2x0aXBQcm9wcyIsImNvbXBvbmVudERpZE1vdW50Iiwic2V0dXBUb29sdGlwIiwicmVuZGVyIiwiUmVhY3RET00iLCJjcmVhdGVQb3J0YWwiLCJjb21wb25lbnREaWRVcGRhdGUiLCJzaG91bGRSZWNyZWF0ZVRvb2x0aXAiLCJkaXNwb3NlIiwiY29tcG9uZW50V2lsbFVubW91bnQiLCJnZXRUb29sdGlwUHJvcHMiLCJwIiwia2V5Iiwic29tZSIsIm9wdGlvbnMiLCJmb3JFYWNoIiwiY2xhc3MiLCJzaG93RGVsYXkiLCJoaWRlRGVsYXkiLCJkZWxheURlZmF1bHRzIiwidHJpZ2dlciIsInNob3ciLCJoaWRlIiwiZGVsYXkiLCJpdGVtIiwiaXRlbUhvbGRlciIsInRhcmdldCIsIm9ic2VydmUiLCJ0IiwibWFuYWdlciIsImFkZCIsIlByb3BUeXBlcyIsIm9iamVjdCIsImlzUmVxdWlyZWQiLCJSZWZIb2xkZXJQcm9wVHlwZSIsInRpdGxlIiwib25lT2ZUeXBlIiwic3RyaW5nIiwiZnVuYyIsImh0bWwiLCJib29sIiwicGxhY2VtZW50Iiwib25lT2YiLCJudW1iZXIiLCJrZXlCaW5kaW5nQ29tbWFuZCIsImtleUJpbmRpbmdUYXJnZXQiLCJlbGVtZW50IiwiZ2V0SXRlbUNvbXBvbmVudCJdLCJtYXBwaW5ncyI6Ijs7Ozs7OztBQUFBOztBQUNBOztBQUNBOztBQUNBOztBQUVBOztBQUNBOzs7Ozs7QUFFQSxNQUFNQSxxQkFBcUIsR0FBRyxDQUM1QixPQUQ0QixFQUNuQixNQURtQixFQUNYLFdBRFcsRUFDRSxTQURGLEVBQ2EsbUJBRGIsRUFDa0Msa0JBRGxDLENBQTlCO0FBSUEsTUFBTUMsWUFBWSxHQUFHLENBQ25CLEdBQUdELHFCQURnQixFQUVuQixVQUZtQixFQUVQLFdBRk8sRUFFTSxXQUZOLEVBRW1CLFdBRm5CLENBQXJCOztBQUtlLE1BQU1FLE9BQU4sU0FBc0JDLGVBQU1DLFNBQTVCLENBQXNDO0FBMkJuREMsRUFBQUEsV0FBVyxDQUFDQyxLQUFELEVBQVFDLE9BQVIsRUFBaUI7QUFDMUIsVUFBTUQsS0FBTixFQUFhQyxPQUFiO0FBRUEsU0FBS0MsTUFBTCxHQUFjLElBQUlDLG9CQUFKLEVBQWQ7QUFDQSxTQUFLQyxNQUFMLEdBQWMsSUFBSUQsb0JBQUosRUFBZDtBQUVBLFNBQUtFLE9BQUwsR0FBZSxJQUFmOztBQUNBLFFBQUksS0FBS0wsS0FBTCxDQUFXTSxRQUFYLEtBQXdCQyxTQUE1QixFQUF1QztBQUNyQyxXQUFLRixPQUFMLEdBQWVHLFFBQVEsQ0FBQ0MsYUFBVCxDQUF1QixLQUF2QixDQUFmO0FBQ0EsV0FBS0osT0FBTCxDQUFhSyxTQUFiLEdBQXlCLG9CQUF6QjtBQUNEOztBQUVELFNBQUtDLGdCQUFMLEdBQXdCLEVBQXhCO0FBQ0Q7O0FBRURDLEVBQUFBLGlCQUFpQixHQUFHO0FBQ2xCLFNBQUtDLFlBQUw7QUFDRDs7QUFFREMsRUFBQUEsTUFBTSxHQUFHO0FBQ1AsUUFBSSxLQUFLZCxLQUFMLENBQVdNLFFBQVgsS0FBd0JDLFNBQTVCLEVBQXVDO0FBQ3JDLGFBQU9RLGtCQUFTQyxZQUFULENBQ0wsS0FBS2hCLEtBQUwsQ0FBV00sUUFETixFQUVMLEtBQUtELE9BRkEsQ0FBUDtBQUlELEtBTEQsTUFLTztBQUNMLGFBQU8sSUFBUDtBQUNEO0FBQ0Y7O0FBRURZLEVBQUFBLGtCQUFrQixHQUFHO0FBQ25CLFFBQUksS0FBS0MscUJBQUwsRUFBSixFQUFrQztBQUNoQyxXQUFLaEIsTUFBTCxDQUFZaUIsT0FBWjtBQUNBLFdBQUtmLE1BQUwsQ0FBWWUsT0FBWjtBQUNBLFdBQUtOLFlBQUw7QUFDRDtBQUNGOztBQUVETyxFQUFBQSxvQkFBb0IsR0FBRztBQUNyQixTQUFLbEIsTUFBTCxDQUFZaUIsT0FBWjtBQUNBLFNBQUtmLE1BQUwsQ0FBWWUsT0FBWjtBQUNEOztBQUVERSxFQUFBQSxlQUFlLEdBQUc7QUFDaEIsVUFBTUMsQ0FBQyxHQUFHLEVBQVY7O0FBQ0EsU0FBSyxNQUFNQyxHQUFYLElBQWtCNUIsWUFBbEIsRUFBZ0M7QUFDOUIyQixNQUFBQSxDQUFDLENBQUNDLEdBQUQsQ0FBRCxHQUFTLEtBQUt2QixLQUFMLENBQVd1QixHQUFYLENBQVQ7QUFDRDs7QUFDRCxXQUFPRCxDQUFQO0FBQ0Q7O0FBRURKLEVBQUFBLHFCQUFxQixHQUFHO0FBQ3RCLFdBQU92QixZQUFZLENBQUM2QixJQUFiLENBQWtCRCxHQUFHLElBQUksS0FBS1osZ0JBQUwsQ0FBc0JZLEdBQXRCLE1BQStCLEtBQUt2QixLQUFMLENBQVd1QixHQUFYLENBQXhELENBQVA7QUFDRDs7QUFFRFYsRUFBQUEsWUFBWSxHQUFHO0FBQ2IsU0FBS0YsZ0JBQUwsR0FBd0IsS0FBS1UsZUFBTCxFQUF4QjtBQUVBLFVBQU1JLE9BQU8sR0FBRyxFQUFoQjtBQUNBL0IsSUFBQUEscUJBQXFCLENBQUNnQyxPQUF0QixDQUE4QkgsR0FBRyxJQUFJO0FBQ25DLFVBQUksS0FBS3ZCLEtBQUwsQ0FBV3VCLEdBQVgsTUFBb0JoQixTQUF4QixFQUFtQztBQUNqQ2tCLFFBQUFBLE9BQU8sQ0FBQ0YsR0FBRCxDQUFQLEdBQWUsS0FBS3ZCLEtBQUwsQ0FBV3VCLEdBQVgsQ0FBZjtBQUNEO0FBQ0YsS0FKRDs7QUFLQSxRQUFJLEtBQUt2QixLQUFMLENBQVdVLFNBQVgsS0FBeUJILFNBQTdCLEVBQXdDO0FBQ3RDa0IsTUFBQUEsT0FBTyxDQUFDRSxLQUFSLEdBQWdCLEtBQUszQixLQUFMLENBQVdVLFNBQTNCO0FBQ0Q7O0FBQ0QsUUFBSSxLQUFLVixLQUFMLENBQVc0QixTQUFYLEtBQXlCckIsU0FBekIsSUFBc0MsS0FBS1AsS0FBTCxDQUFXNkIsU0FBWCxLQUF5QnRCLFNBQW5FLEVBQThFO0FBQzVFLFlBQU11QixhQUFhLEdBQUcsQ0FBQyxLQUFLOUIsS0FBTCxDQUFXK0IsT0FBWCxLQUF1QixPQUF2QixJQUFrQyxLQUFLL0IsS0FBTCxDQUFXK0IsT0FBWCxLQUF1QnhCLFNBQTFELEtBQ2pCO0FBQUN5QixRQUFBQSxJQUFJLEVBQUUsSUFBUDtBQUFhQyxRQUFBQSxJQUFJLEVBQUU7QUFBbkIsT0FEaUIsSUFFakI7QUFBQ0QsUUFBQUEsSUFBSSxFQUFFLENBQVA7QUFBVUMsUUFBQUEsSUFBSSxFQUFFO0FBQWhCLE9BRkw7QUFJQVIsTUFBQUEsT0FBTyxDQUFDUyxLQUFSLEdBQWdCO0FBQ2RGLFFBQUFBLElBQUksRUFBRSxLQUFLaEMsS0FBTCxDQUFXNEIsU0FBWCxLQUF5QnJCLFNBQXpCLEdBQXFDLEtBQUtQLEtBQUwsQ0FBVzRCLFNBQWhELEdBQTRERSxhQUFhLENBQUNFLElBRGxFO0FBRWRDLFFBQUFBLElBQUksRUFBRSxLQUFLakMsS0FBTCxDQUFXNkIsU0FBWCxLQUF5QnRCLFNBQXpCLEdBQXFDLEtBQUtQLEtBQUwsQ0FBVzZCLFNBQWhELEdBQTREQyxhQUFhLENBQUNHO0FBRmxFLE9BQWhCO0FBSUQ7O0FBQ0QsUUFBSSxLQUFLakMsS0FBTCxDQUFXTSxRQUFYLEtBQXdCQyxTQUE1QixFQUF1QztBQUNyQ2tCLE1BQUFBLE9BQU8sQ0FBQ1UsSUFBUixHQUFlLHlCQUFXLEtBQUs5QixPQUFoQixFQUF5QixLQUFLTCxLQUFMLENBQVdvQyxVQUFwQyxDQUFmO0FBQ0Q7O0FBRUQsU0FBS2xDLE1BQUwsR0FBYyxLQUFLRixLQUFMLENBQVdxQyxNQUFYLENBQWtCQyxPQUFsQixDQUEwQkMsQ0FBQyxJQUFJO0FBQzNDLFdBQUtuQyxNQUFMLENBQVllLE9BQVo7QUFDQSxXQUFLZixNQUFMLEdBQWMsS0FBS0osS0FBTCxDQUFXd0MsT0FBWCxDQUFtQkMsR0FBbkIsQ0FBdUJGLENBQXZCLEVBQTBCZCxPQUExQixDQUFkO0FBQ0QsS0FIYSxDQUFkO0FBSUQ7O0FBaEhrRDs7OztnQkFBaEM3QixPLGVBQ0E7QUFDakI0QyxFQUFBQSxPQUFPLEVBQUVFLG1CQUFVQyxNQUFWLENBQWlCQyxVQURUO0FBRWpCUCxFQUFBQSxNQUFNLEVBQUVRLDhCQUFrQkQsVUFGVDtBQUdqQkUsRUFBQUEsS0FBSyxFQUFFSixtQkFBVUssU0FBVixDQUFvQixDQUN6QkwsbUJBQVVNLE1BRGUsRUFFekJOLG1CQUFVTyxJQUZlLENBQXBCLENBSFU7QUFPakJDLEVBQUFBLElBQUksRUFBRVIsbUJBQVVTLElBUEM7QUFRakJ6QyxFQUFBQSxTQUFTLEVBQUVnQyxtQkFBVU0sTUFSSjtBQVNqQkksRUFBQUEsU0FBUyxFQUFFVixtQkFBVUssU0FBVixDQUFvQixDQUM3QkwsbUJBQVVNLE1BRG1CLEVBRTdCTixtQkFBVU8sSUFGbUIsQ0FBcEIsQ0FUTTtBQWFqQmxCLEVBQUFBLE9BQU8sRUFBRVcsbUJBQVVXLEtBQVYsQ0FBZ0IsQ0FBQyxPQUFELEVBQVUsT0FBVixFQUFtQixPQUFuQixFQUE0QixRQUE1QixDQUFoQixDQWJRO0FBY2pCekIsRUFBQUEsU0FBUyxFQUFFYyxtQkFBVVksTUFkSjtBQWVqQnpCLEVBQUFBLFNBQVMsRUFBRWEsbUJBQVVZLE1BZko7QUFnQmpCQyxFQUFBQSxpQkFBaUIsRUFBRWIsbUJBQVVNLE1BaEJaO0FBaUJqQlEsRUFBQUEsZ0JBQWdCLEVBQUVkLG1CQUFVZSxPQWpCWDtBQWtCakJuRCxFQUFBQSxRQUFRLEVBQUVvQyxtQkFBVWUsT0FsQkg7QUFtQmpCckIsRUFBQUEsVUFBVSxFQUFFUztBQW5CSyxDOztnQkFEQWpELE8sa0JBdUJHO0FBQ3BCOEQsRUFBQUEsZ0JBQWdCLEVBQUUsTUFBTSxDQUFFO0FBRE4sQyIsInNvdXJjZVJvb3QiOiIvYnVpbGQvYXRvbS9zcmMvYXRvbS0xLjM2LjEvb3V0L2FwcC9ub2RlX21vZHVsZXMvZ2l0aHViIiwic291cmNlc0NvbnRlbnQiOlsiaW1wb3J0IFJlYWN0IGZyb20gJ3JlYWN0JztcbmltcG9ydCBSZWFjdERPTSBmcm9tICdyZWFjdC1kb20nO1xuaW1wb3J0IFByb3BUeXBlcyBmcm9tICdwcm9wLXR5cGVzJztcbmltcG9ydCB7RGlzcG9zYWJsZX0gZnJvbSAnZXZlbnQta2l0JztcblxuaW1wb3J0IHtSZWZIb2xkZXJQcm9wVHlwZX0gZnJvbSAnLi4vcHJvcC10eXBlcyc7XG5pbXBvcnQge2NyZWF0ZUl0ZW19IGZyb20gJy4uL2hlbHBlcnMnO1xuXG5jb25zdCBWRVJCQVRJTV9PUFRJT05fUFJPUFMgPSBbXG4gICd0aXRsZScsICdodG1sJywgJ3BsYWNlbWVudCcsICd0cmlnZ2VyJywgJ2tleUJpbmRpbmdDb21tYW5kJywgJ2tleUJpbmRpbmdUYXJnZXQnLFxuXTtcblxuY29uc3QgT1BUSU9OX1BST1BTID0gW1xuICAuLi5WRVJCQVRJTV9PUFRJT05fUFJPUFMsXG4gICd0b29sdGlwcycsICdjbGFzc05hbWUnLCAnc2hvd0RlbGF5JywgJ2hpZGVEZWxheScsXG5dO1xuXG5leHBvcnQgZGVmYXVsdCBjbGFzcyBUb29sdGlwIGV4dGVuZHMgUmVhY3QuQ29tcG9uZW50IHtcbiAgc3RhdGljIHByb3BUeXBlcyA9IHtcbiAgICBtYW5hZ2VyOiBQcm9wVHlwZXMub2JqZWN0LmlzUmVxdWlyZWQsXG4gICAgdGFyZ2V0OiBSZWZIb2xkZXJQcm9wVHlwZS5pc1JlcXVpcmVkLFxuICAgIHRpdGxlOiBQcm9wVHlwZXMub25lT2ZUeXBlKFtcbiAgICAgIFByb3BUeXBlcy5zdHJpbmcsXG4gICAgICBQcm9wVHlwZXMuZnVuYyxcbiAgICBdKSxcbiAgICBodG1sOiBQcm9wVHlwZXMuYm9vbCxcbiAgICBjbGFzc05hbWU6IFByb3BUeXBlcy5zdHJpbmcsXG4gICAgcGxhY2VtZW50OiBQcm9wVHlwZXMub25lT2ZUeXBlKFtcbiAgICAgIFByb3BUeXBlcy5zdHJpbmcsXG4gICAgICBQcm9wVHlwZXMuZnVuYyxcbiAgICBdKSxcbiAgICB0cmlnZ2VyOiBQcm9wVHlwZXMub25lT2YoWydob3ZlcicsICdjbGljaycsICdmb2N1cycsICdtYW51YWwnXSksXG4gICAgc2hvd0RlbGF5OiBQcm9wVHlwZXMubnVtYmVyLFxuICAgIGhpZGVEZWxheTogUHJvcFR5cGVzLm51bWJlcixcbiAgICBrZXlCaW5kaW5nQ29tbWFuZDogUHJvcFR5cGVzLnN0cmluZyxcbiAgICBrZXlCaW5kaW5nVGFyZ2V0OiBQcm9wVHlwZXMuZWxlbWVudCxcbiAgICBjaGlsZHJlbjogUHJvcFR5cGVzLmVsZW1lbnQsXG4gICAgaXRlbUhvbGRlcjogUmVmSG9sZGVyUHJvcFR5cGUsXG4gIH1cblxuICBzdGF0aWMgZGVmYXVsdFByb3BzID0ge1xuICAgIGdldEl0ZW1Db21wb25lbnQ6ICgpID0+IHt9LFxuICB9XG5cbiAgY29uc3RydWN0b3IocHJvcHMsIGNvbnRleHQpIHtcbiAgICBzdXBlcihwcm9wcywgY29udGV4dCk7XG5cbiAgICB0aGlzLnJlZlN1YiA9IG5ldyBEaXNwb3NhYmxlKCk7XG4gICAgdGhpcy50aXBTdWIgPSBuZXcgRGlzcG9zYWJsZSgpO1xuXG4gICAgdGhpcy5kb21Ob2RlID0gbnVsbDtcbiAgICBpZiAodGhpcy5wcm9wcy5jaGlsZHJlbiAhPT0gdW5kZWZpbmVkKSB7XG4gICAgICB0aGlzLmRvbU5vZGUgPSBkb2N1bWVudC5jcmVhdGVFbGVtZW50KCdkaXYnKTtcbiAgICAgIHRoaXMuZG9tTm9kZS5jbGFzc05hbWUgPSAncmVhY3QtYXRvbS10b29sdGlwJztcbiAgICB9XG5cbiAgICB0aGlzLmxhc3RUb29sdGlwUHJvcHMgPSB7fTtcbiAgfVxuXG4gIGNvbXBvbmVudERpZE1vdW50KCkge1xuICAgIHRoaXMuc2V0dXBUb29sdGlwKCk7XG4gIH1cblxuICByZW5kZXIoKSB7XG4gICAgaWYgKHRoaXMucHJvcHMuY2hpbGRyZW4gIT09IHVuZGVmaW5lZCkge1xuICAgICAgcmV0dXJuIFJlYWN0RE9NLmNyZWF0ZVBvcnRhbChcbiAgICAgICAgdGhpcy5wcm9wcy5jaGlsZHJlbixcbiAgICAgICAgdGhpcy5kb21Ob2RlLFxuICAgICAgKTtcbiAgICB9IGVsc2Uge1xuICAgICAgcmV0dXJuIG51bGw7XG4gICAgfVxuICB9XG5cbiAgY29tcG9uZW50RGlkVXBkYXRlKCkge1xuICAgIGlmICh0aGlzLnNob3VsZFJlY3JlYXRlVG9vbHRpcCgpKSB7XG4gICAgICB0aGlzLnJlZlN1Yi5kaXNwb3NlKCk7XG4gICAgICB0aGlzLnRpcFN1Yi5kaXNwb3NlKCk7XG4gICAgICB0aGlzLnNldHVwVG9vbHRpcCgpO1xuICAgIH1cbiAgfVxuXG4gIGNvbXBvbmVudFdpbGxVbm1vdW50KCkge1xuICAgIHRoaXMucmVmU3ViLmRpc3Bvc2UoKTtcbiAgICB0aGlzLnRpcFN1Yi5kaXNwb3NlKCk7XG4gIH1cblxuICBnZXRUb29sdGlwUHJvcHMoKSB7XG4gICAgY29uc3QgcCA9IHt9O1xuICAgIGZvciAoY29uc3Qga2V5IG9mIE9QVElPTl9QUk9QUykge1xuICAgICAgcFtrZXldID0gdGhpcy5wcm9wc1trZXldO1xuICAgIH1cbiAgICByZXR1cm4gcDtcbiAgfVxuXG4gIHNob3VsZFJlY3JlYXRlVG9vbHRpcCgpIHtcbiAgICByZXR1cm4gT1BUSU9OX1BST1BTLnNvbWUoa2V5ID0+IHRoaXMubGFzdFRvb2x0aXBQcm9wc1trZXldICE9PSB0aGlzLnByb3BzW2tleV0pO1xuICB9XG5cbiAgc2V0dXBUb29sdGlwKCkge1xuICAgIHRoaXMubGFzdFRvb2x0aXBQcm9wcyA9IHRoaXMuZ2V0VG9vbHRpcFByb3BzKCk7XG5cbiAgICBjb25zdCBvcHRpb25zID0ge307XG4gICAgVkVSQkFUSU1fT1BUSU9OX1BST1BTLmZvckVhY2goa2V5ID0+IHtcbiAgICAgIGlmICh0aGlzLnByb3BzW2tleV0gIT09IHVuZGVmaW5lZCkge1xuICAgICAgICBvcHRpb25zW2tleV0gPSB0aGlzLnByb3BzW2tleV07XG4gICAgICB9XG4gICAgfSk7XG4gICAgaWYgKHRoaXMucHJvcHMuY2xhc3NOYW1lICE9PSB1bmRlZmluZWQpIHtcbiAgICAgIG9wdGlvbnMuY2xhc3MgPSB0aGlzLnByb3BzLmNsYXNzTmFtZTtcbiAgICB9XG4gICAgaWYgKHRoaXMucHJvcHMuc2hvd0RlbGF5ICE9PSB1bmRlZmluZWQgfHwgdGhpcy5wcm9wcy5oaWRlRGVsYXkgIT09IHVuZGVmaW5lZCkge1xuICAgICAgY29uc3QgZGVsYXlEZWZhdWx0cyA9ICh0aGlzLnByb3BzLnRyaWdnZXIgPT09ICdob3ZlcicgfHwgdGhpcy5wcm9wcy50cmlnZ2VyID09PSB1bmRlZmluZWQpXG4gICAgICAgICYmIHtzaG93OiAxMDAwLCBoaWRlOiAxMDB9XG4gICAgICAgIHx8IHtzaG93OiAwLCBoaWRlOiAwfTtcblxuICAgICAgb3B0aW9ucy5kZWxheSA9IHtcbiAgICAgICAgc2hvdzogdGhpcy5wcm9wcy5zaG93RGVsYXkgIT09IHVuZGVmaW5lZCA/IHRoaXMucHJvcHMuc2hvd0RlbGF5IDogZGVsYXlEZWZhdWx0cy5zaG93LFxuICAgICAgICBoaWRlOiB0aGlzLnByb3BzLmhpZGVEZWxheSAhPT0gdW5kZWZpbmVkID8gdGhpcy5wcm9wcy5oaWRlRGVsYXkgOiBkZWxheURlZmF1bHRzLmhpZGUsXG4gICAgICB9O1xuICAgIH1cbiAgICBpZiAodGhpcy5wcm9wcy5jaGlsZHJlbiAhPT0gdW5kZWZpbmVkKSB7XG4gICAgICBvcHRpb25zLml0ZW0gPSBjcmVhdGVJdGVtKHRoaXMuZG9tTm9kZSwgdGhpcy5wcm9wcy5pdGVtSG9sZGVyKTtcbiAgICB9XG5cbiAgICB0aGlzLnJlZlN1YiA9IHRoaXMucHJvcHMudGFyZ2V0Lm9ic2VydmUodCA9PiB7XG4gICAgICB0aGlzLnRpcFN1Yi5kaXNwb3NlKCk7XG4gICAgICB0aGlzLnRpcFN1YiA9IHRoaXMucHJvcHMubWFuYWdlci5hZGQodCwgb3B0aW9ucyk7XG4gICAgfSk7XG4gIH1cbn1cbiJdfQ==