/*
 * Decompiled with CFR 0.152.
 */
package cc.arduino.packages;

import cc.arduino.packages.BoardPort;
import cc.arduino.packages.Discovery;
import cc.arduino.packages.discoverers.NetworkDiscovery;
import cc.arduino.packages.discoverers.PluggableDiscovery;
import cc.arduino.packages.discoverers.serial.SerialDiscovery;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import processing.app.I18n;
import processing.app.PreferencesData;
import processing.app.debug.TargetPackage;
import processing.app.debug.TargetPlatform;
import processing.app.helpers.PreferencesMap;
import processing.app.helpers.StringReplacer;

public class DiscoveryManager {
    private final List<Discovery> discoverers;
    private final SerialDiscovery serialDiscoverer = new SerialDiscovery();
    private final NetworkDiscovery networkDiscoverer = new NetworkDiscovery();

    public DiscoveryManager(Map<String, TargetPackage> packages) {
        this.discoverers = new ArrayList<Discovery>();
        this.discoverers.add(this.serialDiscoverer);
        this.discoverers.add(this.networkDiscoverer);
        for (TargetPackage targetPackage : packages.values()) {
            for (TargetPlatform platform : targetPackage.getPlatforms().values()) {
                PreferencesMap prefs = platform.getPreferences().subTree("discovery");
                for (String discoveryName : prefs.firstLevelMap().keySet()) {
                    PreferencesMap discoveryPrefs = prefs.subTree(discoveryName);
                    String pattern = (String)discoveryPrefs.get("pattern");
                    if (pattern == null) {
                        System.out.println(I18n.format(I18n.tr("No recipes defined for discovery '{0}'"), discoveryName));
                        continue;
                    }
                    try {
                        if (PreferencesData.getBoolean("discovery.debug")) {
                            System.out.println("found discovery: " + discoveryName + " -> " + pattern);
                            System.out.println("with preferencess -> " + discoveryPrefs);
                        }
                        pattern = StringReplacer.replaceFromMapping(pattern, PreferencesData.getMap());
                        String[] cmd = StringReplacer.formatAndSplit(pattern, discoveryPrefs);
                        this.discoverers.add(new PluggableDiscovery(discoveryName, cmd));
                    }
                    catch (Exception e) {
                        if (!PreferencesData.getBoolean("discovery.debug")) continue;
                        System.out.println(I18n.format(I18n.tr("Could not start discovery '{0}': {1}"), discoveryName, e.getMessage()));
                    }
                }
            }
        }
        for (Discovery d : this.discoverers) {
            try {
                new Thread(d).start();
            }
            catch (Exception e) {
                System.err.println(I18n.tr("Error starting discovery method: ") + d.toString());
                e.printStackTrace();
            }
        }
        Thread closeHook = new Thread(() -> {
            for (Discovery d : this.discoverers) {
                try {
                    d.stop();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
        closeHook.setName("DiscoveryManager closeHook");
        Runtime.getRuntime().addShutdownHook(closeHook);
    }

    public SerialDiscovery getSerialDiscoverer() {
        return this.serialDiscoverer;
    }

    public List<BoardPort> discovery() {
        ArrayList<BoardPort> res = new ArrayList<BoardPort>();
        for (Discovery d : this.discoverers) {
            res.addAll(d.listDiscoveredBoards());
        }
        return res;
    }

    public List<BoardPort> discovery(boolean complete) {
        ArrayList<BoardPort> res = new ArrayList<BoardPort>();
        for (Discovery d : this.discoverers) {
            res.addAll(d.listDiscoveredBoards(complete));
        }
        return res;
    }

    public BoardPort find(String address) {
        for (BoardPort boardPort : this.discovery()) {
            if (!boardPort.getAddress().equals(address)) continue;
            return boardPort;
        }
        return null;
    }

    public BoardPort find(String address, boolean complete) {
        for (BoardPort boardPort : this.discovery(complete)) {
            if (!boardPort.getAddress().equals(address)) continue;
            return boardPort;
        }
        return null;
    }
}

