/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.swing.tabcontrol;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import javax.swing.Icon;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListDataEvent;
import org.netbeans.swing.tabcontrol.TabData;
import org.netbeans.swing.tabcontrol.TabDataModel;
import org.netbeans.swing.tabcontrol.event.ComplexListDataEvent;
import org.netbeans.swing.tabcontrol.event.ComplexListDataListener;
import org.netbeans.swing.tabcontrol.event.VeryComplexListDataEvent;
import org.openide.util.ChangeSupport;

public class DefaultTabDataModel
implements TabDataModel {
    private transient ArrayList<ComplexListDataListener> listenerList;
    private L list = new L();
    private final ChangeSupport cs = new ChangeSupport((Object)this);
    private final Object LOCK = new Object();

    public DefaultTabDataModel() {
    }

    public DefaultTabDataModel(TabData[] tabDataArray) {
        this.list.addAll(Arrays.asList(tabDataArray));
    }

    @Override
    public List<TabData> getTabs() {
        return Collections.unmodifiableList(this.list);
    }

    @Override
    public TabData getTab(int n) {
        return (TabData)this.list.get(n);
    }

    @Override
    public void setTabs(TabData[] tabDataArray) {
        Object[] objectArray = new TabData[this.list.size()];
        if (Arrays.equals(tabDataArray, objectArray = this.list.toArray(objectArray))) {
            return;
        }
        List<TabData> list = Arrays.asList(tabDataArray);
        this.list.clear();
        this.list.addAll(Arrays.asList(tabDataArray));
        VeryComplexListDataEvent veryComplexListDataEvent = new VeryComplexListDataEvent(this, (TabData[])objectArray, tabDataArray);
        this.fireIndicesChanged(veryComplexListDataEvent);
    }

    @Override
    public void setIcon(int n, Icon icon) {
        boolean[] blArray = new boolean[]{false};
        boolean bl = this._setIcon(n, icon, blArray);
        if (bl) {
            ComplexListDataEvent complexListDataEvent = new ComplexListDataEvent(this, 0, n, n, blArray[0]);
            this.fireContentsChanged(complexListDataEvent);
        }
    }

    private boolean _setIcon(int n, Icon icon, boolean[] blArray) {
        TabData tabData;
        if (icon == null) {
            icon = TabData.NO_ICON;
        }
        if (icon != (tabData = this.getTab(n)).getIcon()) {
            blArray[0] = tabData.getIcon().getIconWidth() != icon.getIconWidth();
            tabData.icon = icon;
            return true;
        }
        return false;
    }

    public void setToolTipTextAt(int n, String string) {
        TabData tabData = this.getTab(n);
        tabData.tip = string;
    }

    @Override
    public void setText(int n, String string) {
        boolean[] blArray = new boolean[]{false};
        boolean bl = this._setText(n, string, blArray);
        if (bl) {
            ComplexListDataEvent complexListDataEvent = new ComplexListDataEvent(this, 0, n, n, blArray[0]);
            this.fireContentsChanged(complexListDataEvent);
        }
    }

    private int[] _setText(int[] nArray, String[] stringArray, boolean[] blArray) {
        blArray[0] = false;
        boolean bl = false;
        boolean[] blArray2 = new boolean[nArray.length];
        int n = 0;
        Arrays.fill(blArray2, false);
        for (int i = 0; i < nArray.length; ++i) {
            boolean[] blArray3 = new boolean[]{false};
            bl |= this._setText(nArray[i], stringArray[i], blArray3);
            blArray[0] = blArray[0] | blArray3[0];
            if (blArray3[0]) {
                ++n;
            }
            blArray2[i] = blArray3[0];
        }
        if (blArray[0] || bl) {
            int[] nArray2;
            if (n == nArray.length) {
                nArray2 = nArray;
            } else {
                nArray2 = new int[n];
                int n2 = 0;
                for (int i = 0; i < nArray.length; ++i) {
                    if (!blArray2[i]) continue;
                    nArray2[n2] = nArray[i];
                    ++n2;
                }
            }
            return nArray2;
        }
        return null;
    }

    private int[] _setIcon(int[] nArray, Icon[] iconArray, boolean[] blArray) {
        blArray[0] = false;
        boolean bl = false;
        boolean[] blArray2 = new boolean[nArray.length];
        int n = 0;
        Arrays.fill(blArray2, false);
        boolean[] blArray3 = new boolean[]{false};
        boolean bl2 = false;
        for (int i = 0; i < nArray.length; ++i) {
            bl2 = this._setIcon(nArray[i], iconArray[i], blArray3);
            bl |= bl2;
            blArray[0] = blArray[0] | blArray3[0];
            if (bl2) {
                ++n;
            }
            blArray2[i] = bl2;
        }
        if (blArray[0] || bl) {
            int[] nArray2;
            if (n == nArray.length) {
                nArray2 = nArray;
            } else {
                nArray2 = new int[n];
                int n2 = 0;
                for (int i = 0; i < nArray.length; ++i) {
                    if (!blArray2[i]) continue;
                    nArray2[n2] = nArray[i];
                    ++n2;
                }
            }
            return nArray2;
        }
        return null;
    }

    @Override
    public void setIconsAndText(int[] nArray, String[] stringArray, Icon[] iconArray) {
        boolean bl;
        boolean[] blArray = new boolean[]{false};
        boolean[] blArray2 = new boolean[]{false};
        int[] nArray2 = this._setIcon(nArray, iconArray, blArray);
        int[] nArray3 = this._setText(nArray, stringArray, blArray2);
        boolean bl2 = blArray[0] || blArray2[0];
        boolean bl3 = bl = bl2 || nArray2 != null || nArray3 != null;
        if (bl) {
            if (nArray == nArray2 && nArray == nArray3) {
                ComplexListDataEvent complexListDataEvent = new ComplexListDataEvent((Object)this, 0, nArray, bl2);
                this.fireContentsChanged(complexListDataEvent);
            } else {
                Integer[] integerArray;
                int n = (nArray2 != null ? nArray2.length : 0) + (nArray3 != null ? nArray3.length : 0);
                HashSet<Integer> hashSet = new HashSet<Integer>(n);
                if (nArray2 != null) {
                    integerArray = this.toObjectArray(nArray2);
                    hashSet.addAll(Arrays.asList(integerArray));
                }
                if (nArray3 != null) {
                    integerArray = this.toObjectArray(nArray3);
                    hashSet.addAll(Arrays.asList(integerArray));
                }
                Integer[] integerArray2 = new Integer[hashSet.size()];
                integerArray2 = hashSet.toArray(integerArray2);
                int[] nArray4 = this.toPrimitiveArray(integerArray2);
                ComplexListDataEvent complexListDataEvent = new ComplexListDataEvent((Object)this, 0, nArray4, bl2);
                this.fireContentsChanged(complexListDataEvent);
            }
        }
    }

    @Override
    public void setIcon(int[] nArray, Icon[] iconArray) {
        boolean[] blArray = new boolean[]{false};
        int[] nArray2 = this._setIcon(nArray, iconArray, blArray);
        if (nArray2 != null) {
            ComplexListDataEvent complexListDataEvent = new ComplexListDataEvent((Object)this, 0, nArray2, blArray[0]);
            this.fireContentsChanged(complexListDataEvent);
        }
    }

    @Override
    public void setText(int[] nArray, String[] stringArray) {
        boolean[] blArray = new boolean[]{false};
        int[] nArray2 = this._setText(nArray, stringArray, blArray);
        if (nArray2 != null) {
            ComplexListDataEvent complexListDataEvent = new ComplexListDataEvent((Object)this, 0, nArray2, blArray[0]);
            this.fireContentsChanged(complexListDataEvent);
        }
    }

    private boolean _setText(int n, String string, boolean[] blArray) {
        TabData tabData = this.getTab(n);
        if (string != tabData.txt) {
            blArray[0] = tabData.getText() != string;
            tabData.txt = string;
            return true;
        }
        return false;
    }

    @Override
    public void setTab(int n, TabData tabData) {
        if (!tabData.equals(this.getTab(n))) {
            TabData tabData2 = this.getTab(n);
            boolean bl = tabData.getText().equals(tabData2.getText());
            boolean bl2 = tabData.getUserObject() != tabData2.getUserObject();
            this.list.set(n, tabData);
            ComplexListDataEvent complexListDataEvent = new ComplexListDataEvent(this, 0, n, n, bl, bl2);
            complexListDataEvent.setAffectedItems(new TabData[]{tabData});
            this.fireContentsChanged(complexListDataEvent);
        }
    }

    @Override
    public void addTab(int n, TabData tabData) {
        this.list.add(n, tabData);
        ComplexListDataEvent complexListDataEvent = new ComplexListDataEvent(this, 1, n, n, true);
        complexListDataEvent.setAffectedItems(new TabData[]{tabData});
        this.fireIntervalAdded(complexListDataEvent);
    }

    @Override
    public void addTabs(int n, TabData[] tabDataArray) {
        this.list.addAll(n, Arrays.asList(tabDataArray));
        ComplexListDataEvent complexListDataEvent = new ComplexListDataEvent(this, 1, n, n + tabDataArray.length - 1, true);
        complexListDataEvent.setAffectedItems(tabDataArray);
        this.fireIntervalAdded(complexListDataEvent);
    }

    @Override
    public void removeTab(int n) {
        TabData[] tabDataArray = new TabData[]{(TabData)this.list.get(n)};
        this.list.remove(n);
        ComplexListDataEvent complexListDataEvent = new ComplexListDataEvent((Object)this, 2, n, n);
        complexListDataEvent.setAffectedItems(tabDataArray);
        this.fireIntervalRemoved(complexListDataEvent);
    }

    @Override
    public void removeTabs(int n, int n2) {
        ArrayList arrayList = new ArrayList(this.list.subList(n, n2));
        if (n == n2) {
            this.list.remove(n);
        } else {
            this.list.removeRange(n, n2);
        }
        ComplexListDataEvent complexListDataEvent = new ComplexListDataEvent((Object)this, 2, n, n2);
        complexListDataEvent.setAffectedItems(arrayList.toArray(new TabData[0]));
        this.fireIntervalRemoved(complexListDataEvent);
    }

    @Override
    public void addTabs(int[] nArray, TabData[] tabDataArray) {
        int n;
        HashMap<Integer, TabData> hashMap = new HashMap<Integer, TabData>(tabDataArray.length);
        for (n = 0; n < tabDataArray.length; ++n) {
            hashMap.put(new Integer(nArray[n]), tabDataArray[n]);
        }
        Arrays.sort(nArray);
        for (n = 0; n < nArray.length; ++n) {
            Integer n2 = new Integer(nArray[n]);
            TabData tabData = (TabData)hashMap.get(n2);
            this.list.add(nArray[n], tabData);
        }
        ComplexListDataEvent complexListDataEvent = new ComplexListDataEvent((Object)this, 3, nArray, true);
        complexListDataEvent.setAffectedItems(tabDataArray);
        this.fireIndicesAdded(complexListDataEvent);
    }

    @Override
    public void removeTabs(int[] nArray) {
        Arrays.sort(nArray);
        TabData[] tabDataArray = new TabData[nArray.length];
        for (int i = nArray.length - 1; i >= 0; --i) {
            tabDataArray[i] = (TabData)this.list.remove(nArray[i]);
        }
        ComplexListDataEvent complexListDataEvent = new ComplexListDataEvent((Object)this, 4, nArray, true);
        complexListDataEvent.setAffectedItems(tabDataArray);
        this.fireIndicesRemoved(complexListDataEvent);
    }

    @Override
    public int size() {
        return this.list.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void addComplexListDataListener(ComplexListDataListener complexListDataListener) {
        Object object = this.LOCK;
        synchronized (object) {
            if (this.listenerList == null) {
                this.listenerList = new ArrayList();
            }
            this.listenerList.add(complexListDataListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void removeComplexListDataListener(ComplexListDataListener complexListDataListener) {
        Object object = this.LOCK;
        synchronized (object) {
            this.listenerList.remove(complexListDataListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireIntervalAdded(ListDataEvent listDataEvent) {
        ArrayList<ComplexListDataListener> arrayList = null;
        Iterator iterator = this.LOCK;
        synchronized (iterator) {
            if (this.listenerList == null) {
                return;
            }
            arrayList = new ArrayList<ComplexListDataListener>(this.listenerList);
        }
        for (ComplexListDataListener complexListDataListener : arrayList) {
            complexListDataListener.intervalAdded(listDataEvent);
        }
        this.cs.fireChange();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireIntervalRemoved(ListDataEvent listDataEvent) {
        ArrayList<ComplexListDataListener> arrayList = null;
        Iterator iterator = this.LOCK;
        synchronized (iterator) {
            if (this.listenerList == null) {
                return;
            }
            arrayList = new ArrayList<ComplexListDataListener>(this.listenerList);
        }
        for (ComplexListDataListener complexListDataListener : arrayList) {
            complexListDataListener.intervalRemoved(listDataEvent);
        }
        this.cs.fireChange();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireContentsChanged(ListDataEvent listDataEvent) {
        ArrayList<ComplexListDataListener> arrayList = null;
        Iterator iterator = this.LOCK;
        synchronized (iterator) {
            if (this.listenerList == null) {
                return;
            }
            arrayList = new ArrayList<ComplexListDataListener>(this.listenerList);
        }
        for (ComplexListDataListener complexListDataListener : arrayList) {
            complexListDataListener.contentsChanged(listDataEvent);
        }
        this.cs.fireChange();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireIndicesAdded(ComplexListDataEvent complexListDataEvent) {
        ArrayList<ComplexListDataListener> arrayList = null;
        Iterator iterator = this.LOCK;
        synchronized (iterator) {
            if (this.listenerList == null) {
                return;
            }
            arrayList = new ArrayList<ComplexListDataListener>(this.listenerList);
        }
        for (ComplexListDataListener complexListDataListener : arrayList) {
            complexListDataListener.indicesAdded(complexListDataEvent);
        }
        this.cs.fireChange();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireIndicesRemoved(ComplexListDataEvent complexListDataEvent) {
        ArrayList<ComplexListDataListener> arrayList = null;
        Iterator iterator = this.LOCK;
        synchronized (iterator) {
            if (this.listenerList == null) {
                return;
            }
            arrayList = new ArrayList<ComplexListDataListener>(this.listenerList);
        }
        for (ComplexListDataListener complexListDataListener : arrayList) {
            complexListDataListener.indicesRemoved(complexListDataEvent);
        }
        this.cs.fireChange();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireIndicesChanged(ComplexListDataEvent complexListDataEvent) {
        ArrayList<ComplexListDataListener> arrayList = null;
        Iterator iterator = this.LOCK;
        synchronized (iterator) {
            if (this.listenerList == null) {
                return;
            }
            arrayList = new ArrayList<ComplexListDataListener>(this.listenerList);
        }
        for (ComplexListDataListener complexListDataListener : arrayList) {
            complexListDataListener.indicesChanged(complexListDataEvent);
        }
        this.cs.fireChange();
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(this.getClass().getName());
        stringBuffer.append(" size =");
        int n = this.size();
        stringBuffer.append(n);
        stringBuffer.append(" - ");
        for (int i = 0; i < n; ++i) {
            TabData tabData = this.getTab(i);
            stringBuffer.append(tabData.toString());
            if (i == n - 1) continue;
            stringBuffer.append(',');
        }
        return stringBuffer.toString();
    }

    @Override
    public void addChangeListener(ChangeListener changeListener) {
        this.cs.addChangeListener(changeListener);
    }

    @Override
    public void removeChangeListener(ChangeListener changeListener) {
        this.cs.removeChangeListener(changeListener);
    }

    @Override
    public int indexOf(TabData tabData) {
        return this.list.indexOf(tabData);
    }

    private Integer[] toObjectArray(int[] nArray) {
        Integer[] integerArray = new Integer[nArray.length];
        for (int i = 0; i < nArray.length; ++i) {
            integerArray[i] = new Integer(nArray[i]);
        }
        return integerArray;
    }

    private int[] toPrimitiveArray(Integer[] integerArray) {
        int[] nArray = new int[integerArray.length];
        for (int i = 0; i < integerArray.length; ++i) {
            nArray[i] = integerArray[i];
        }
        return nArray;
    }

    private class L
    extends ArrayList<TabData> {
        private L() {
        }

        @Override
        public void removeRange(int n, int n2) {
            super.removeRange(n, n2);
        }
    }
}

