/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.ui.components.tree;

import java.util.Collection;
import java.util.HashSet;
import javax.swing.Icon;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;

public class CheckTreeNode
extends DefaultMutableTreeNode {
    public static final int STATE_CHECKED = 1;
    public static final int STATE_UNCHECKED = 2;
    public static final int STATE_PARTIALLY_CHECKED = 4;
    protected int checkState = 2;
    private Icon icon;

    public CheckTreeNode() {
        this(null);
    }

    public CheckTreeNode(Object object) {
        this(object, null);
    }

    public CheckTreeNode(Object object, Icon icon) {
        super(object);
        this.icon = icon;
    }

    public int getCheckState() {
        return this.checkState;
    }

    public Collection setChecked(boolean bl) {
        if (bl) {
            return this.setFullyChecked();
        }
        return this.setUnchecked();
    }

    public boolean isFullyChecked() {
        return this.getCheckState() == 1;
    }

    public Icon getIcon() {
        return this.icon;
    }

    public boolean isPartiallyChecked() {
        return this.getCheckState() == 4;
    }

    public Collection toggleState() {
        if (this.getCheckState() == 1) {
            return this.setUnchecked();
        }
        return this.setFullyChecked();
    }

    protected Collection setPartiallyChecked() {
        HashSet<CheckTreeNode> hashSet = new HashSet<CheckTreeNode>();
        hashSet.add(this);
        if (this.checkState == 4) {
            return hashSet;
        }
        this.checkState = 4;
        TreeNode treeNode = this.getParent();
        if (treeNode != null && treeNode instanceof CheckTreeNode) {
            hashSet.addAll(((CheckTreeNode)treeNode).setPartiallyChecked());
        }
        return hashSet;
    }

    private Collection setFullyChecked() {
        TreeNode treeNode;
        HashSet<CheckTreeNode> hashSet = new HashSet<CheckTreeNode>();
        hashSet.add(this);
        if (this.checkState == 1) {
            return hashSet;
        }
        this.checkState = 1;
        if (!this.isLeaf()) {
            for (int i = 0; i < this.getChildCount(); ++i) {
                TreeNode treeNode2 = this.getChildAt(i);
                if (!(treeNode2 instanceof CheckTreeNode)) continue;
                hashSet.addAll(((CheckTreeNode)treeNode2).setFullyChecked());
            }
        }
        if ((treeNode = this.getParent()) != null && treeNode instanceof CheckTreeNode) {
            if (this.areSiblingsFullyChecked()) {
                hashSet.addAll(((CheckTreeNode)treeNode).setFullyChecked());
            } else {
                hashSet.addAll(((CheckTreeNode)treeNode).setPartiallyChecked());
            }
        }
        return hashSet;
    }

    private Collection setUnchecked() {
        TreeNode treeNode;
        HashSet<CheckTreeNode> hashSet = new HashSet<CheckTreeNode>();
        hashSet.add(this);
        if (this.checkState == 2) {
            return hashSet;
        }
        this.checkState = 2;
        if (!this.isLeaf()) {
            for (int i = 0; i < this.getChildCount(); ++i) {
                TreeNode treeNode2 = this.getChildAt(i);
                if (!(treeNode2 instanceof CheckTreeNode)) continue;
                hashSet.addAll(((CheckTreeNode)treeNode2).setUnchecked());
            }
        }
        if ((treeNode = this.getParent()) != null && treeNode instanceof CheckTreeNode) {
            if (this.areSiblingsUnchecked()) {
                hashSet.addAll(((CheckTreeNode)treeNode).setUnchecked());
            } else {
                hashSet.addAll(((CheckTreeNode)treeNode).setPartiallyChecked());
            }
        }
        return hashSet;
    }

    private boolean areSiblingsFullyChecked() {
        TreeNode treeNode = this.getParent();
        for (int i = 0; i < treeNode.getChildCount(); ++i) {
            TreeNode treeNode2 = treeNode.getChildAt(i);
            if (treeNode2 == this || treeNode2 instanceof CheckTreeNode && ((CheckTreeNode)treeNode2).getCheckState() == 1) continue;
            return false;
        }
        return true;
    }

    private boolean areSiblingsUnchecked() {
        TreeNode treeNode = this.getParent();
        for (int i = 0; i < treeNode.getChildCount(); ++i) {
            TreeNode treeNode2 = treeNode.getChildAt(i);
            if (treeNode2 == this || treeNode2 instanceof CheckTreeNode && ((CheckTreeNode)treeNode2).getCheckState() == 2) continue;
            return false;
        }
        return true;
    }
}

