/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.tools.packager.mac;

import com.oracle.tools.packager.BundlerParamInfo;
import com.oracle.tools.packager.ConfigException;
import com.oracle.tools.packager.IOUtils;
import com.oracle.tools.packager.Log;
import com.oracle.tools.packager.RelativeFileSet;
import com.oracle.tools.packager.StandardBundlerParam;
import com.oracle.tools.packager.UnsupportedPlatformException;
import com.oracle.tools.packager.mac.MacAppBundler;
import com.oracle.tools.packager.mac.MacBaseInstallerBundler;
import com.oracle.tools.packager.mac.MacResources;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Writer;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;

public class MacDmgBundler
extends MacBaseInstallerBundler {
    private static final ResourceBundle I18N = ResourceBundle.getBundle(MacDmgBundler.class.getName());
    static final String DEFAULT_BACKGROUND_IMAGE = "background_dmg.png";
    static final String DEFAULT_DMG_SETUP_SCRIPT = "DMGsetup.scpt";
    static final String TEMPLATE_BUNDLE_ICON = "GenericApp.icns";
    static final String DEFAULT_LICENSE_PLIST = "lic_template.plist";
    public static final BundlerParamInfo<Boolean> SIMPLE_DMG = new StandardBundlerParam<Boolean>(I18N.getString("param.simple-dmg.name"), I18N.getString("param.simple-dmg.description"), "mac.dmg.simple", Boolean.class, params -> Boolean.FALSE, (s, p) -> Boolean.parseBoolean(s));
    public static final BundlerParamInfo<String> INSTALLER_SUFFIX = new StandardBundlerParam<String>(I18N.getString("param.installer-suffix.name"), I18N.getString("param.installer-suffix.description"), "mac.dmg.installerName.suffix", String.class, params -> "", (s, p) -> s);
    private static final String hdiutil = "/usr/bin/hdiutil";

    public MacDmgBundler() {
        this.baseResourceLoader = MacResources.class;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public File bundle(Map<String, ? super Object> params, File outdir) {
        File appImageDir;
        block36: {
            Log.info(MessageFormat.format(I18N.getString("message.building-dmg"), StandardBundlerParam.APP_NAME.fetchFrom(params)));
            if (!outdir.isDirectory() && !outdir.mkdirs()) {
                throw new RuntimeException(MessageFormat.format(I18N.getString("error.cannot-create-output-dir"), outdir.getAbsolutePath()));
            }
            if (!outdir.canWrite()) {
                throw new RuntimeException(MessageFormat.format(I18N.getString("error.cannot-write-to-output-dir"), outdir.getAbsolutePath()));
            }
            appImageDir = (File)this.APP_IMAGE_BUILD_ROOT.fetchFrom(params);
            appImageDir.mkdirs();
            if (this.prepareAppBundle(params) == null || !this.prepareConfigFiles(params)) break block36;
            File configScript = this.getConfig_Script(params);
            if (configScript.exists()) {
                Log.info(MessageFormat.format(I18N.getString("message.running-script"), configScript.getAbsolutePath()));
                IOUtils.run("bash", configScript, (Boolean)StandardBundlerParam.VERBOSE.fetchFrom(params));
            }
            File file = this.buildDMG(params, outdir);
            try {
                if (appImageDir != null && !Log.isDebug()) {
                    IOUtils.deleteRecursive(appImageDir);
                } else if (appImageDir != null) {
                    Log.info(MessageFormat.format(I18N.getString("message.intermediate-image-location"), appImageDir.getAbsolutePath()));
                }
                if (!((Boolean)StandardBundlerParam.VERBOSE.fetchFrom(params)).booleanValue()) {
                    this.cleanupConfigFiles(params);
                } else {
                    Log.info(MessageFormat.format(I18N.getString("message.config-save-location"), ((File)CONFIG_ROOT.fetchFrom(params)).getAbsolutePath()));
                }
            }
            catch (FileNotFoundException ex) {
                Log.debug(ex);
                return null;
            }
            return file;
        }
        File configScript = null;
        try {
            if (appImageDir != null && !Log.isDebug()) {
                IOUtils.deleteRecursive(appImageDir);
            } else if (appImageDir != null) {
                Log.info(MessageFormat.format(I18N.getString("message.intermediate-image-location"), appImageDir.getAbsolutePath()));
            }
            if (!((Boolean)StandardBundlerParam.VERBOSE.fetchFrom(params)).booleanValue()) {
                this.cleanupConfigFiles(params);
            } else {
                Log.info(MessageFormat.format(I18N.getString("message.config-save-location"), ((File)CONFIG_ROOT.fetchFrom(params)).getAbsolutePath()));
            }
        }
        catch (FileNotFoundException ex) {
            Log.debug(ex);
            return null;
        }
        return configScript;
        catch (IOException ex) {
            File file;
            try {
                Log.verbose(ex);
                file = null;
            }
            catch (Throwable throwable) {
                try {
                    if (appImageDir != null && !Log.isDebug()) {
                        IOUtils.deleteRecursive(appImageDir);
                    } else if (appImageDir != null) {
                        Log.info(MessageFormat.format(I18N.getString("message.intermediate-image-location"), appImageDir.getAbsolutePath()));
                    }
                    if (!((Boolean)StandardBundlerParam.VERBOSE.fetchFrom(params)).booleanValue()) {
                        this.cleanupConfigFiles(params);
                    } else {
                        Log.info(MessageFormat.format(I18N.getString("message.config-save-location"), ((File)CONFIG_ROOT.fetchFrom(params)).getAbsolutePath()));
                    }
                }
                catch (FileNotFoundException ex2) {
                    Log.debug(ex2);
                    return null;
                }
                throw throwable;
            }
            try {
                if (appImageDir != null && !Log.isDebug()) {
                    IOUtils.deleteRecursive(appImageDir);
                } else if (appImageDir != null) {
                    Log.info(MessageFormat.format(I18N.getString("message.intermediate-image-location"), appImageDir.getAbsolutePath()));
                }
                if (!((Boolean)StandardBundlerParam.VERBOSE.fetchFrom(params)).booleanValue()) {
                    this.cleanupConfigFiles(params);
                } else {
                    Log.info(MessageFormat.format(I18N.getString("message.config-save-location"), ((File)CONFIG_ROOT.fetchFrom(params)).getAbsolutePath()));
                }
            }
            catch (FileNotFoundException ex3) {
                Log.debug(ex3);
                return null;
            }
            return file;
        }
    }

    protected void cleanupConfigFiles(Map<String, ? super Object> params) {
        if (this.getConfig_VolumeBackground(params) != null) {
            this.getConfig_VolumeBackground(params).delete();
        }
        if (this.getConfig_VolumeIcon(params) != null) {
            this.getConfig_VolumeIcon(params).delete();
        }
        if (this.getConfig_VolumeScript(params) != null) {
            this.getConfig_VolumeScript(params).delete();
        }
        if (this.getConfig_Script(params) != null) {
            this.getConfig_Script(params).delete();
        }
        if (this.getConfig_LicenseFile(params) != null) {
            this.getConfig_LicenseFile(params).delete();
        }
        ((MacAppBundler)APP_BUNDLER.fetchFrom(params)).cleanupConfigFiles(params);
    }

    private void prepareDMGSetupScript(String volumeName, Map<String, ? super Object> p) throws IOException {
        boolean systemWide;
        File dmgSetup = this.getConfig_VolumeScript(p);
        Log.verbose(MessageFormat.format(I18N.getString("message.preparing-dmg-setup"), dmgSetup.getAbsolutePath()));
        HashMap<String, String> data = new HashMap<String, String>();
        data.put("DEPLOY_ACTUAL_VOLUME_NAME", volumeName);
        data.put("DEPLOY_APPLICATION_NAME", (String)StandardBundlerParam.APP_NAME.fetchFrom(p));
        boolean bl = systemWide = StandardBundlerParam.SYSTEM_WIDE.fetchFrom(p) == null || (Boolean)StandardBundlerParam.SYSTEM_WIDE.fetchFrom(p) != false;
        if (systemWide) {
            data.put("DEPLOY_INSTALL_LOCATION", "POSIX file \"/Applications\"");
            data.put("DEPLOY_INSTALL_NAME", "Applications");
        } else {
            data.put("DEPLOY_INSTALL_LOCATION", "(path to desktop folder)");
            data.put("DEPLOY_INSTALL_NAME", "Desktop");
        }
        BufferedWriter w = new BufferedWriter(new FileWriter(dmgSetup));
        w.write(this.preprocessTextResource(MacAppBundler.MAC_BUNDLER_PREFIX + dmgSetup.getName(), I18N.getString("resource.dmg-setup-script"), DEFAULT_DMG_SETUP_SCRIPT, data, (Boolean)StandardBundlerParam.VERBOSE.fetchFrom(p), (File)StandardBundlerParam.DROP_IN_RESOURCES_ROOT.fetchFrom(p)));
        ((Writer)w).close();
    }

    private File getConfig_VolumeScript(Map<String, ? super Object> params) {
        return new File((File)CONFIG_ROOT.fetchFrom(params), (String)StandardBundlerParam.APP_NAME.fetchFrom(params) + "-dmg-setup.scpt");
    }

    private File getConfig_VolumeBackground(Map<String, ? super Object> params) {
        return new File((File)CONFIG_ROOT.fetchFrom(params), (String)StandardBundlerParam.APP_NAME.fetchFrom(params) + "-background.png");
    }

    private File getConfig_VolumeIcon(Map<String, ? super Object> params) {
        return new File((File)CONFIG_ROOT.fetchFrom(params), (String)StandardBundlerParam.APP_NAME.fetchFrom(params) + "-volume.icns");
    }

    private File getConfig_LicenseFile(Map<String, ? super Object> params) {
        return new File((File)CONFIG_ROOT.fetchFrom(params), (String)StandardBundlerParam.APP_NAME.fetchFrom(params) + "-license.plist");
    }

    private void prepareLicense(Map<String, ? super Object> params) {
        try {
            File licFile = null;
            List licFiles = (List)StandardBundlerParam.LICENSE_FILE.fetchFrom(params);
            if (licFiles.isEmpty()) {
                return;
            }
            String licFileStr = (String)licFiles.get(0);
            for (RelativeFileSet rfs : (List)StandardBundlerParam.APP_RESOURCES_LIST.fetchFrom(params)) {
                if (!rfs.contains(licFileStr)) continue;
                licFile = new File(rfs.getBaseDirectory(), licFileStr);
                break;
            }
            if (licFile == null) {
                return;
            }
            byte[] licenseContentOriginal = IOUtils.readFully(licFile);
            String licenseInBase64 = Base64.getEncoder().encodeToString(licenseContentOriginal);
            HashMap<String, String> data = new HashMap<String, String>();
            data.put("APPLICATION_LICENSE_TEXT", licenseInBase64);
            BufferedWriter w = new BufferedWriter(new FileWriter(this.getConfig_LicenseFile(params)));
            w.write(this.preprocessTextResource(MacAppBundler.MAC_BUNDLER_PREFIX + this.getConfig_LicenseFile(params).getName(), I18N.getString("resource.license-setup"), DEFAULT_LICENSE_PLIST, data, (Boolean)StandardBundlerParam.VERBOSE.fetchFrom(params), (File)StandardBundlerParam.DROP_IN_RESOURCES_ROOT.fetchFrom(params)));
            ((Writer)w).close();
        }
        catch (IOException ex) {
            Log.verbose(ex);
        }
    }

    private boolean prepareConfigFiles(Map<String, ? super Object> params) throws IOException {
        File bgTarget = this.getConfig_VolumeBackground(params);
        this.fetchResource(MacAppBundler.MAC_BUNDLER_PREFIX + bgTarget.getName(), I18N.getString("resource.dmg-background"), DEFAULT_BACKGROUND_IMAGE, bgTarget, (boolean)((Boolean)StandardBundlerParam.VERBOSE.fetchFrom(params)), (File)StandardBundlerParam.DROP_IN_RESOURCES_ROOT.fetchFrom(params));
        File iconTarget = this.getConfig_VolumeIcon(params);
        if (MacAppBundler.ICON_ICNS.fetchFrom(params) == null || !MacAppBundler.ICON_ICNS.fetchFrom(params).exists()) {
            this.fetchResource(MacAppBundler.MAC_BUNDLER_PREFIX + iconTarget.getName(), I18N.getString("resource.volume-icon"), TEMPLATE_BUNDLE_ICON, iconTarget, (boolean)((Boolean)StandardBundlerParam.VERBOSE.fetchFrom(params)), (File)StandardBundlerParam.DROP_IN_RESOURCES_ROOT.fetchFrom(params));
        } else {
            this.fetchResource(MacAppBundler.MAC_BUNDLER_PREFIX + iconTarget.getName(), I18N.getString("resource.volume-icon"), MacAppBundler.ICON_ICNS.fetchFrom(params), iconTarget, (boolean)((Boolean)StandardBundlerParam.VERBOSE.fetchFrom(params)), (File)StandardBundlerParam.DROP_IN_RESOURCES_ROOT.fetchFrom(params));
        }
        this.fetchResource(MacAppBundler.MAC_BUNDLER_PREFIX + this.getConfig_Script(params).getName(), I18N.getString("resource.post-install-script"), (String)null, this.getConfig_Script(params), (boolean)((Boolean)StandardBundlerParam.VERBOSE.fetchFrom(params)), (File)StandardBundlerParam.DROP_IN_RESOURCES_ROOT.fetchFrom(params));
        this.prepareLicense(params);
        this.prepareDMGSetupScript((String)StandardBundlerParam.APP_NAME.fetchFrom(params), params);
        return true;
    }

    private File getConfig_Script(Map<String, ? super Object> params) {
        return new File((File)CONFIG_ROOT.fetchFrom(params), (String)StandardBundlerParam.APP_NAME.fetchFrom(params) + "-post-image.sh");
    }

    private String findSetFileUtility() {
        String[] typicalPaths;
        for (String path : typicalPaths = new String[]{"/Developer/Tools/SetFile", "/usr/bin/SetFile", "/Developer/usr/bin/SetFile"}) {
            File f = new File(path);
            if (!f.exists() || !f.canExecute()) continue;
            return path;
        }
        try {
            File f;
            ProcessBuilder pb = new ProcessBuilder("xcrun", "-find", "SetFile");
            Process p = pb.start();
            InputStreamReader isr = new InputStreamReader(p.getInputStream());
            BufferedReader br = new BufferedReader(isr);
            String lineRead = br.readLine();
            if (lineRead != null && (f = new File(lineRead)).exists() && f.canExecute()) {
                return f.getAbsolutePath();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return null;
    }

    private File buildDMG(Map<String, ? super Object> p, File outdir) throws IOException {
        String setFileUtility;
        File imagesRoot = (File)IMAGES_ROOT.fetchFrom(p);
        if (!imagesRoot.exists()) {
            imagesRoot.mkdirs();
        }
        File protoDMG = new File(imagesRoot, (String)StandardBundlerParam.APP_NAME.fetchFrom(p) + "-tmp.dmg");
        File finalDMG = new File(outdir, (String)INSTALLER_NAME.fetchFrom(p) + INSTALLER_SUFFIX.fetchFrom(p) + ".dmg");
        File srcFolder = (File)this.APP_IMAGE_BUILD_ROOT.fetchFrom(p);
        File predefinedImage = MacDmgBundler.getPredefinedImage(p);
        if (predefinedImage != null) {
            srcFolder = predefinedImage;
        }
        Log.verbose(MessageFormat.format(I18N.getString("message.creating-dmg-file"), finalDMG.getAbsolutePath()));
        protoDMG.delete();
        if (finalDMG.exists() && !finalDMG.delete()) {
            throw new IOException(MessageFormat.format(I18N.getString("message.dmg-cannot-be-overwritten"), finalDMG.getAbsolutePath()));
        }
        protoDMG.getParentFile().mkdirs();
        finalDMG.getParentFile().mkdirs();
        String hdiUtilVerbosityFlag = Log.isDebug() ? "-verbose" : "-quiet";
        ProcessBuilder pb = new ProcessBuilder(hdiutil, "create", hdiUtilVerbosityFlag, "-srcfolder", srcFolder.getAbsolutePath(), "-volname", (String)StandardBundlerParam.APP_NAME.fetchFrom(p), "-ov", protoDMG.getAbsolutePath(), "-format", "UDRW");
        IOUtils.exec(pb, (Boolean)StandardBundlerParam.VERBOSE.fetchFrom(p));
        pb = new ProcessBuilder(hdiutil, "attach", protoDMG.getAbsolutePath(), hdiUtilVerbosityFlag, "-mountroot", imagesRoot.getAbsolutePath());
        IOUtils.exec(pb, (Boolean)StandardBundlerParam.VERBOSE.fetchFrom(p));
        File mountedRoot = new File(imagesRoot.getAbsolutePath(), (String)StandardBundlerParam.APP_NAME.fetchFrom(p));
        File volumeIconFile = new File(mountedRoot, ".VolumeIcon.icns");
        IOUtils.copyFile(this.getConfig_VolumeIcon(p), volumeIconFile);
        if (!SIMPLE_DMG.fetchFrom(p).booleanValue()) {
            File bgdir = new File(mountedRoot, ".background");
            bgdir.mkdirs();
            IOUtils.copyFile(this.getConfig_VolumeBackground(p), new File(bgdir, "background.png"));
            pb = new ProcessBuilder("osascript", this.getConfig_VolumeScript(p).getAbsolutePath());
            IOUtils.exec(pb, (Boolean)StandardBundlerParam.VERBOSE.fetchFrom(p));
        }
        if ((setFileUtility = this.findSetFileUtility()) != null) {
            volumeIconFile.setWritable(true);
            pb = new ProcessBuilder(setFileUtility, "-c", "icnC", volumeIconFile.getAbsolutePath());
            IOUtils.exec(pb, (Boolean)StandardBundlerParam.VERBOSE.fetchFrom(p));
            volumeIconFile.setReadOnly();
            pb = new ProcessBuilder(setFileUtility, "-a", "C", mountedRoot.getAbsolutePath());
            IOUtils.exec(pb, (Boolean)StandardBundlerParam.VERBOSE.fetchFrom(p));
        } else {
            Log.verbose("Skip enabling custom icon as SetFile utility is not found");
        }
        pb = new ProcessBuilder(hdiutil, "detach", hdiUtilVerbosityFlag, mountedRoot.getAbsolutePath());
        IOUtils.exec(pb, (Boolean)StandardBundlerParam.VERBOSE.fetchFrom(p));
        pb = new ProcessBuilder(hdiutil, "convert", protoDMG.getAbsolutePath(), hdiUtilVerbosityFlag, "-format", "UDZO", "-o", finalDMG.getAbsolutePath());
        IOUtils.exec(pb, (Boolean)StandardBundlerParam.VERBOSE.fetchFrom(p));
        if (this.getConfig_LicenseFile(p).exists()) {
            pb = new ProcessBuilder(hdiutil, "unflatten", finalDMG.getAbsolutePath());
            IOUtils.exec(pb, (Boolean)StandardBundlerParam.VERBOSE.fetchFrom(p));
            pb = new ProcessBuilder(hdiutil, "udifrez", finalDMG.getAbsolutePath(), "-xml", this.getConfig_LicenseFile(p).getAbsolutePath());
            IOUtils.exec(pb, (Boolean)StandardBundlerParam.VERBOSE.fetchFrom(p));
            pb = new ProcessBuilder(hdiutil, "flatten", finalDMG.getAbsolutePath());
            IOUtils.exec(pb, (Boolean)StandardBundlerParam.VERBOSE.fetchFrom(p));
        }
        protoDMG.delete();
        Log.info(MessageFormat.format(I18N.getString("message.output-to-location"), StandardBundlerParam.APP_NAME.fetchFrom(p), finalDMG.getAbsolutePath()));
        return finalDMG;
    }

    @Override
    public String getName() {
        return I18N.getString("bundler.name");
    }

    @Override
    public String getDescription() {
        return I18N.getString("bundler.description");
    }

    @Override
    public String getID() {
        return "dmg";
    }

    @Override
    public Collection<BundlerParamInfo<?>> getBundleParameters() {
        LinkedHashSet results = new LinkedHashSet();
        results.addAll(MacAppBundler.getAppBundleParameters());
        results.addAll(this.getDMGBundleParameters());
        return results;
    }

    public Collection<BundlerParamInfo<?>> getDMGBundleParameters() {
        LinkedHashSet results = new LinkedHashSet();
        results.addAll(MacAppBundler.getAppBundleParameters());
        results.addAll(Arrays.asList(INSTALLER_SUFFIX, StandardBundlerParam.LICENSE_FILE, SIMPLE_DMG, StandardBundlerParam.SYSTEM_WIDE));
        return results;
    }

    @Override
    public boolean validate(Map<String, ? super Object> params) throws UnsupportedPlatformException, ConfigException {
        try {
            if (params == null) {
                throw new ConfigException(I18N.getString("error.parameters-null"), I18N.getString("error.parameters-null.advice"));
            }
            this.validateAppImageAndBundeler(params);
            if (((Boolean)StandardBundlerParam.SERVICE_HINT.fetchFrom(params)).booleanValue()) {
                throw new ConfigException(I18N.getString("error.dmg-does-not-do-daemons"), I18N.getString("error.dmg-does-not-do-daemons.advice"));
            }
            if (params.containsKey(StandardBundlerParam.LICENSE_FILE.getID())) {
                List appResourcesList = (List)StandardBundlerParam.APP_RESOURCES_LIST.fetchFrom(params);
                for (String license : (List)StandardBundlerParam.LICENSE_FILE.fetchFrom(params)) {
                    boolean found = false;
                    for (RelativeFileSet appResources : appResourcesList) {
                        found = found || appResources.contains(license);
                    }
                    if (found) continue;
                    throw new ConfigException(I18N.getString("error.license-missing"), MessageFormat.format(I18N.getString("error.license-missing.advice"), license));
                }
            }
            return true;
        }
        catch (RuntimeException re) {
            if (re.getCause() instanceof ConfigException) {
                throw (ConfigException)re.getCause();
            }
            throw new ConfigException(re);
        }
    }

    @Override
    public File execute(Map<String, ? super Object> params, File outputParentDir) {
        return this.bundle(params, outputParentDir);
    }
}

