/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.tools.packager;

import com.oracle.tools.packager.AbstractBundler;
import com.oracle.tools.packager.BundlerParamInfo;
import com.oracle.tools.packager.ConfigException;
import com.oracle.tools.packager.Log;
import com.oracle.tools.packager.RelativeFileSet;
import com.oracle.tools.packager.StandardBundlerParam;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public abstract class AbstractImageBundler
extends AbstractBundler {
    private static final ResourceBundle I18N = ResourceBundle.getBundle(AbstractImageBundler.class.getName());
    public static final String CFG_FORMAT_PROPERTIES = "prop";
    public static final String CFG_FORMAT_INI = "ini";
    public static final BundlerParamInfo<String> LAUNCHER_CFG_FORMAT = new StandardBundlerParam<String>(I18N.getString("param.launcher-cfg-format.name"), I18N.getString("param.launcher-cfg-format.description"), "launcher-cfg-format", String.class, params -> "ini", (s, p) -> s);

    public void testRuntime(RelativeFileSet runtime, String[] file) throws ConfigException {
        if (runtime == null) {
            return;
        }
        Pattern[] weave = (Pattern[])Arrays.stream(file).map(Pattern::compile).toArray(Pattern[]::new);
        if (!runtime.getIncludedFiles().stream().anyMatch(s -> Arrays.stream(weave).anyMatch(pattern -> pattern.matcher((CharSequence)s).matches()))) {
            throw new ConfigException(MessageFormat.format(I18N.getString("error.jre-missing-file"), Arrays.toString(file)), I18N.getString("error.jre-missing-file.advice"));
        }
    }

    public void imageBundleValidation(Map<String, ? super Object> p) throws ConfigException {
        StandardBundlerParam.validateMainClassInfoFromAppResources(p);
        Map userJvmOptions = (Map)StandardBundlerParam.USER_JVM_OPTIONS.fetchFrom(p);
        if (userJvmOptions != null) {
            for (Map.Entry entry : userJvmOptions.entrySet()) {
                if (entry.getValue() != null && !((String)entry.getValue()).isEmpty()) continue;
                throw new ConfigException(MessageFormat.format(I18N.getString("error.empty-user-jvm-option-value"), entry.getKey()), I18N.getString("error.empty-user-jvm-option-value.advice"));
            }
        }
        if (StandardBundlerParam.MAIN_JAR.fetchFrom(p) == null) {
            throw new ConfigException(I18N.getString("error.no-application-jar"), I18N.getString("error.no-application-jar.advice"));
        }
        this.extractRuntimeFlags(p);
        if (((Boolean)StandardBundlerParam.ENABLE_APP_CDS.fetchFrom(p)).booleanValue()) {
            if (((Boolean)StandardBundlerParam.UNLOCK_COMMERCIAL_FEATURES.fetchFrom(p)).booleanValue()) {
                if (p.containsKey("runtime") && p.get("runtime") == null) {
                    throw new ConfigException(I18N.getString("error.app-cds-requires-runtime"), I18N.getString("error.app-cds-requires-runtime.advice"));
                }
                Object majorV = p.get(".runtime.version.major");
                Object minorV = p.get(".runtime.version.minor");
                if (majorV != null && minorV != null) {
                    try {
                        int major = Integer.parseInt(majorV.toString());
                        int minor = Integer.parseInt(minorV.toString());
                        if (major < 8 || major == 8 && minor < 40) {
                            throw new ConfigException(I18N.getString("error.app-cds-bad-version"), I18N.getString("error.app-cds-bad-version.advice"));
                        }
                    }
                    catch (NumberFormatException numberFormatException) {}
                }
            } else {
                throw new ConfigException(I18N.getString("error.app-cds-no-commercial-unlock"), I18N.getString("error.app-cds-no-commercial-unlock.advice"));
            }
        }
    }

    public void writeCfgFile(Map<String, ? super Object> params, File cfgFileName, String runtimeLocation) throws IOException {
        cfgFileName.delete();
        boolean appCDEnabled = (Boolean)StandardBundlerParam.UNLOCK_COMMERCIAL_FEATURES.fetchFrom(params) != false && (Boolean)StandardBundlerParam.ENABLE_APP_CDS.fetchFrom(params) != false;
        String appCDSCacheMode = (String)StandardBundlerParam.APP_CDS_CACHE_MODE.fetchFrom(params);
        PrintStream out = new PrintStream(cfgFileName);
        out.println("[Application]");
        out.println("app.name=" + (String)StandardBundlerParam.APP_NAME.fetchFrom(params));
        out.println("app.mainjar=" + ((RelativeFileSet)StandardBundlerParam.MAIN_JAR.fetchFrom(params)).getIncludedFiles().iterator().next());
        out.println("app.version=" + (String)StandardBundlerParam.VERSION.fetchFrom(params));
        out.println("app.preferences.id=" + (String)StandardBundlerParam.PREFERENCES_ID.fetchFrom(params));
        out.println("app.mainclass=" + ((String)StandardBundlerParam.MAIN_CLASS.fetchFrom(params)).replaceAll("\\.", "/"));
        out.println("app.classpath=" + String.join((CharSequence)File.pathSeparator, ((String)StandardBundlerParam.CLASSPATH.fetchFrom(params)).split("[ :;]")));
        out.println("app.runtime=" + runtimeLocation);
        out.println("app.identifier=" + (String)StandardBundlerParam.IDENTIFIER.fetchFrom(params));
        if (appCDEnabled) {
            out.println("app.appcds.cache=" + appCDSCacheMode.split("\\+")[0]);
        }
        out.println();
        out.println("[JVMOptions]");
        List jvmargs = (List)StandardBundlerParam.JVM_OPTIONS.fetchFrom(params);
        for (Object arg : jvmargs) {
            out.println((String)arg);
        }
        Map jvmProps = (Map)StandardBundlerParam.JVM_PROPERTIES.fetchFrom(params);
        for (Map.Entry entry : jvmProps.entrySet()) {
            out.println("-D" + (String)entry.getKey() + "=" + (String)entry.getValue());
        }
        String preloader = (String)StandardBundlerParam.PRELOADER_CLASS.fetchFrom(params);
        if (preloader != null) {
            out.println("-Djavafx.preloader=" + preloader);
        }
        out.println();
        out.println("[JVMUserOptions]");
        Map map = (Map)StandardBundlerParam.USER_JVM_OPTIONS.fetchFrom(params);
        for (Map.Entry arg : map.entrySet()) {
            if (arg.getKey() == null || arg.getValue() == null) {
                Log.info(I18N.getString("message.jvm-user-arg-is-null"));
                continue;
            }
            out.println(((String)arg.getKey()).replaceAll("([\\=])", "\\\\$1") + "=" + (String)arg.getValue());
        }
        if (appCDEnabled) {
            this.prepareAppCDS(params, out);
        }
        out.println();
        out.println("[ArgOptions]");
        List args = (List)StandardBundlerParam.ARGUMENTS.fetchFrom(params);
        for (String arg : args) {
            if (arg.endsWith("=") && arg.indexOf("=") == arg.lastIndexOf("=")) {
                out.print(arg.substring(0, arg.length() - 1));
                out.println("\\=");
                continue;
            }
            out.println(arg);
        }
        out.close();
    }

    protected abstract String getCacheLocation(Map<String, ? super Object> var1);

    void prepareAppCDS(Map<String, ? super Object> params, PrintStream out) throws IOException {
        File tempDir = Files.createTempDirectory("javapackager", new FileAttribute[0]).toFile();
        tempDir.deleteOnExit();
        File classList = new File(tempDir, (String)StandardBundlerParam.APP_FS_NAME.fetchFrom(params) + ".classlist");
        try (FileOutputStream fos = new FileOutputStream(classList);
             PrintStream ps = new PrintStream(fos);){
            for (String className : (List)StandardBundlerParam.APP_CDS_CLASS_ROOTS.fetchFrom(params)) {
                String slashyName = className.replace(".", "/");
                ps.println(slashyName);
            }
        }
        ((List)StandardBundlerParam.APP_RESOURCES_LIST.fetchFrom(params)).add(new RelativeFileSet(classList.getParentFile(), Arrays.asList(classList)));
        out.println();
        out.println("[AppCDSJVMOptions]");
        out.println("-XX:+UnlockCommercialFeatures");
        out.print("-XX:SharedArchiveFile=");
        out.print(this.getCacheLocation(params));
        out.print((String)StandardBundlerParam.APP_FS_NAME.fetchFrom(params));
        out.println(".jpa");
        out.println("-Xshare:auto");
        out.println("-XX:+UseAppCDS");
        if (Log.isDebug()) {
            out.println("-verbose:class");
            out.println("-XX:+TraceClassPaths");
            out.println("-XX:+UnlockDiagnosticVMOptions");
        }
        out.println("");
        out.println("[AppCDSGenerateCacheJVMOptions]");
        out.println("-XX:+UnlockCommercialFeatures");
        out.println("-Xshare:dump");
        out.println("-XX:+UseAppCDS");
        out.print("-XX:SharedArchiveFile=");
        out.print(this.getCacheLocation(params));
        out.print((String)StandardBundlerParam.APP_FS_NAME.fetchFrom(params));
        out.println(".jpa");
        out.println("-XX:SharedClassListFile=$PACKAGEDIR/" + (String)StandardBundlerParam.APP_FS_NAME.fetchFrom(params) + ".classlist");
        if (Log.isDebug()) {
            out.println("-XX:+UnlockDiagnosticVMOptions");
        }
    }

    public abstract void extractRuntimeFlags(Map<String, ? super Object> var1);

    public static void extractFlagsFromVersion(Map<String, ? super Object> params, String versionOutput) {
        Pattern bitArchPattern = Pattern.compile("(\\d*)[- ]?[bB]it");
        Matcher matcher = bitArchPattern.matcher(versionOutput);
        if (matcher.find()) {
            params.put(".runtime.bit-arch", matcher.group(1));
        } else {
            params.put(".runtime.bit-arch", "32");
        }
        Pattern oldVersionMatcher = Pattern.compile("java version \"((\\d+.(\\d+).\\d+)(_(\\d+)))?(-(.*))?\"");
        matcher = oldVersionMatcher.matcher(versionOutput);
        if (matcher.find()) {
            params.put(".runtime.version", matcher.group(1));
            params.put(".runtime.version.release", matcher.group(2));
            params.put(".runtime.version.major", matcher.group(3));
            params.put(".runtime.version.update", matcher.group(5));
            params.put(".runtime.version.minor", matcher.group(5));
            params.put(".runtime.version.security", matcher.group(5));
            params.put(".runtime.version.patch", "0");
            params.put(".runtime.version.modifiers", matcher.group(7));
            return;
        }
        Pattern macJreVersionMatcher = Pattern.compile("java version \"(1.(\\d+).(\\d+).(\\d+))\"");
        matcher = macJreVersionMatcher.matcher(versionOutput);
        if (matcher.find()) {
            params.put(".runtime.version", matcher.group(1));
            params.put(".runtime.version.release", matcher.group(1));
            params.put(".runtime.version.major", matcher.group(2));
            params.put(".runtime.version.update", matcher.group(3));
            params.put(".runtime.version.minor", matcher.group(3));
            params.put(".runtime.version.security", matcher.group(3));
            params.put(".runtime.version.patch", matcher.group(4));
            params.put(".runtime.version.modifiers", "");
            return;
        }
        Pattern newVersionMatcher = Pattern.compile("java version \"((\\d+).(\\d+).(\\d+).(\\d+))(-(.*))?(\\+[^\"]*)?\"");
        matcher = newVersionMatcher.matcher(versionOutput);
        if (matcher.find()) {
            params.put(".runtime.version", matcher.group(1));
            params.put(".runtime.version.release", matcher.group(1));
            params.put(".runtime.version.major", matcher.group(2));
            params.put(".runtime.version.update", matcher.group(3));
            params.put(".runtime.version.minor", matcher.group(3));
            params.put(".runtime.version.security", matcher.group(4));
            params.put(".runtime.version.patch", matcher.group(5));
            params.put(".runtime.version.modifiers", matcher.group(7));
            return;
        }
        params.put(".runtime.version", "");
        params.put(".runtime.version.release", "");
        params.put(".runtime.version.major", "");
        params.put(".runtime.version.update", "");
        params.put(".runtime.version.minor", "");
        params.put(".runtime.version.security", "");
        params.put(".runtime.version.patch", "");
        params.put(".runtime.version.modifiers", "");
    }
}

