/*
 * Decompiled with CFR 0.152.
 */
package javafx.scene.input;

import com.sun.javafx.scene.input.InputEventUtils;
import java.io.IOException;
import java.io.ObjectInputStream;
import javafx.beans.NamedArg;
import javafx.event.EventTarget;
import javafx.event.EventType;
import javafx.geometry.Point3D;
import javafx.scene.input.InputEvent;
import javafx.scene.input.PickResult;

public class ContextMenuEvent
extends InputEvent {
    private static final long serialVersionUID = 20121107L;
    public static final EventType<ContextMenuEvent> CONTEXT_MENU_REQUESTED = new EventType<InputEvent>(InputEvent.ANY, "CONTEXTMENUREQUESTED");
    public static final EventType<ContextMenuEvent> ANY = CONTEXT_MENU_REQUESTED;
    private final boolean keyboardTrigger;
    private transient double x;
    private transient double y;
    private transient double z;
    private final double screenX;
    private final double screenY;
    private final double sceneX;
    private final double sceneY;
    private PickResult pickResult;

    public ContextMenuEvent(@NamedArg(value="source") Object source, @NamedArg(value="target") EventTarget target, @NamedArg(value="eventType") EventType<ContextMenuEvent> eventType, @NamedArg(value="x") double x, @NamedArg(value="y") double y, @NamedArg(value="screenX") double screenX, @NamedArg(value="screenY") double screenY, @NamedArg(value="keyboardTrigger") boolean keyboardTrigger, @NamedArg(value="pickResult") PickResult pickResult) {
        super(source, target, (EventType<? extends InputEvent>)eventType);
        this.screenX = screenX;
        this.screenY = screenY;
        this.sceneX = x;
        this.sceneY = y;
        this.x = x;
        this.y = y;
        this.pickResult = pickResult != null ? pickResult : new PickResult(target, x, y);
        Point3D p = InputEventUtils.recomputeCoordinates(this.pickResult, null);
        this.x = p.getX();
        this.y = p.getY();
        this.z = p.getZ();
        this.keyboardTrigger = keyboardTrigger;
    }

    public ContextMenuEvent(@NamedArg(value="eventType") EventType<ContextMenuEvent> eventType, @NamedArg(value="x") double x, @NamedArg(value="y") double y, @NamedArg(value="screenX") double screenX, @NamedArg(value="screenY") double screenY, @NamedArg(value="keyboardTrigger") boolean keyboardTrigger, @NamedArg(value="pickResult") PickResult pickResult) {
        this(null, null, eventType, x, y, screenX, screenY, keyboardTrigger, pickResult);
    }

    private void recomputeCoordinatesToSource(ContextMenuEvent newEvent, Object newSource) {
        Point3D newCoordinates = InputEventUtils.recomputeCoordinates(this.pickResult, newSource);
        newEvent.x = newCoordinates.getX();
        newEvent.y = newCoordinates.getY();
        newEvent.z = newCoordinates.getZ();
    }

    @Override
    public ContextMenuEvent copyFor(Object newSource, EventTarget newTarget) {
        ContextMenuEvent e = (ContextMenuEvent)super.copyFor(newSource, newTarget);
        this.recomputeCoordinatesToSource(e, newSource);
        return e;
    }

    public EventType<ContextMenuEvent> getEventType() {
        return super.getEventType();
    }

    public boolean isKeyboardTrigger() {
        return this.keyboardTrigger;
    }

    public final double getX() {
        return this.x;
    }

    public final double getY() {
        return this.y;
    }

    public final double getZ() {
        return this.z;
    }

    public final double getScreenX() {
        return this.screenX;
    }

    public final double getScreenY() {
        return this.screenY;
    }

    public final double getSceneX() {
        return this.sceneX;
    }

    public final double getSceneY() {
        return this.sceneY;
    }

    public final PickResult getPickResult() {
        return this.pickResult;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("ContextMenuEvent [");
        sb.append("source = ").append(this.getSource());
        sb.append(", target = ").append(this.getTarget());
        sb.append(", eventType = ").append(this.getEventType());
        sb.append(", consumed = ").append(this.isConsumed());
        sb.append(", x = ").append(this.getX()).append(", y = ").append(this.getY()).append(", z = ").append(this.getZ());
        sb.append(", pickResult = ").append(this.getPickResult());
        return sb.append("]").toString();
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.x = this.sceneX;
        this.y = this.sceneY;
    }
}

