#ifndef _EFL_UI_POPUP_ALERT_SCROLL_EO_H_
#define _EFL_UI_POPUP_ALERT_SCROLL_EO_H_

#ifndef _EFL_UI_POPUP_ALERT_SCROLL_EO_CLASS_TYPE
#define _EFL_UI_POPUP_ALERT_SCROLL_EO_CLASS_TYPE

typedef Eo Efl_Ui_Popup_Alert_Scroll;

#endif

#ifndef _EFL_UI_POPUP_ALERT_SCROLL_EO_TYPES
#define _EFL_UI_POPUP_ALERT_SCROLL_EO_TYPES


#endif
/** EFL UI Popup Alert Scroll class
 *
 * @ingroup Efl_Ui_Popup_Alert_Scroll
 */
#define EFL_UI_POPUP_ALERT_SCROLL_CLASS efl_ui_popup_alert_scroll_class_get()

EWAPI const Efl_Class *efl_ui_popup_alert_scroll_class_get(void);

#ifdef EFL_UI_POPUP_ALERT_SCROLL_BETA
/**
 * @brief Set the expandable max size of popup.
 *
 * If the given max_size is -1, then a popup appears with its size. However, if
 * the given max_size is bigger than 0 the popup size is up to the given
 * max_size. If popup content's min size is bigger than the given max_size the
 * scroller appears in the popup content area.
 *
 * @param[in] obj The object.
 * @param[in] max_size A 2D max size in pixel units.
 *
 * @ingroup Efl_Ui_Popup_Alert_Scroll
 */
EOAPI void efl_ui_popup_alert_scroll_expandable_set(Eo *obj, Eina_Size2D max_size);
#endif

#ifdef EFL_UI_POPUP_ALERT_SCROLL_BETA
/**
 * @brief Get the expandable max size of popup.
 *
 * If the given max_size is -1, then popup appears with its size. However, if
 * the given max_size is bigger than 0 the popup size is up to the given
 * max_size. If popup content's min size is bigger than the given max_size the
 * scroller appears in the popup content area.
 *
 * @param[in] obj The object.
 *
 * @return A 2D max size in pixel units.
 *
 * @ingroup Efl_Ui_Popup_Alert_Scroll
 */
EOAPI Eina_Size2D efl_ui_popup_alert_scroll_expandable_get(const Eo *obj);
#endif

#endif
