declare enum BackendType {
    DEV = "DEV",
    EDGE = "EDGE",
    INTERNAL = "INTERNAL",
    LOCALHOST = "LOCALHOST",
    PRODUCTION = "PRODUCTION",
    RC = "RC"
}
declare enum BackendTypeLabel {
    DEV = "Development",
    EDGE = "Edge",
    INTERNAL = "Internal",
    LOCALHOST = "Localhost",
    PRODUCTION = "Production",
    RC = "RC"
}
declare const URL_LEGAL: string;
declare const URL_LICENSES: string;
declare const URL_PRIVACY: string;
declare const URL_SUPPORT: string;
declare const URL_WEBAPP: {
    DEV: string;
    EDGE: string;
    INTERNAL: string;
    LOCALHOST: string;
    PRODUCTION: string;
    RC: string;
};
declare const app: {
    ENV: string;
    IS_DEVELOPMENT: boolean;
    IS_PRODUCTION: boolean;
    UPDATE_URL_WIN: string;
};
declare const getEnvironment: () => BackendType;
declare const platform: {
    IS_LINUX: boolean;
    IS_MAC_OS: boolean;
    IS_WINDOWS: boolean;
};
declare const linuxDesktop: {
    isGnome: boolean;
    isPopOS: boolean;
    isUbuntuUnity: boolean;
};
declare const setEnvironment: (env: BackendType) => void;
declare const web: {
    getAdminUrl: (path?: string | undefined) => string;
    getWebappUrl: (env?: string | undefined) => string;
    getWebsiteUrl: (path?: string | undefined) => string;
};
export { app, BackendType, BackendTypeLabel, getEnvironment, linuxDesktop, platform, setEnvironment, URL_LEGAL, URL_LICENSES, URL_PRIVACY, URL_SUPPORT, URL_WEBAPP, web, };
