// Three.js r37 - http://github.com/mrdoob/three.js
var THREE=THREE||{};THREE.Color=function(a){this.setHex(a)};
THREE.Color.prototype={autoUpdate:!0,copy:function(a){this.r=a.r;this.g=a.g;this.b=a.b;this.hex=a.hex;this.__styleString=a.__styleString},setRGB:function(a,c,b){this.r=a;this.g=c;this.b=b;if(this.autoUpdate){this.updateHex();this.updateStyleString()}},setHSV:function(a,c,b){var e,f,g,j,k,m;if(b==0)e=f=g=0;else{j=Math.floor(a*6);k=a*6-j;a=b*(1-c);m=b*(1-c*k);c=b*(1-c*(1-k));switch(j){case 1:e=m;f=b;g=a;break;case 2:e=a;f=b;g=c;break;case 3:e=a;f=m;g=b;break;case 4:e=c;f=a;g=b;break;case 5:e=b;f=a;
g=m;break;case 6:case 0:e=b;f=c;g=a}}this.r=e;this.g=f;this.b=g;if(this.autoUpdate){this.updateHex();this.updateStyleString()}},setHex:function(a){this.hex=~~a&16777215;if(this.autoUpdate){this.updateRGB();this.updateStyleString()}},updateHex:function(){this.hex=~~(this.r*255)<<16^~~(this.g*255)<<8^~~(this.b*255)},updateRGB:function(){this.r=(this.hex>>16&255)/255;this.g=(this.hex>>8&255)/255;this.b=(this.hex&255)/255},updateStyleString:function(){this.__styleString="rgb("+~~(this.r*255)+","+~~(this.g*
255)+","+~~(this.b*255)+")"},clone:function(){return new THREE.Color(this.hex)}};THREE.Vector2=function(a,c){this.set(a||0,c||0)};
THREE.Vector2.prototype={set:function(a,c){this.x=a;this.y=c;return this},copy:function(a){this.set(a.x,a.y);return this},addSelf:function(a){this.set(this.x+a.x,this.y+a.y);return this},add:function(a,c){this.set(a.x+c.x,a.y+c.y);return this},subSelf:function(a){this.set(this.x-a.x,this.y-a.y);return this},sub:function(a,c){this.set(a.x-c.x,a.y-c.y);return this},multiplyScalar:function(a){this.set(this.x*a,this.y*a);return this},negate:function(){this.set(-this.x,-this.y);return this},unit:function(){this.multiplyScalar(1/
this.length());return this},length:function(){return Math.sqrt(this.lengthSq())},lengthSq:function(){return this.x*this.x+this.y*this.y},clone:function(){return new THREE.Vector2(this.x,this.y)}};THREE.Vector3=function(a,c,b){this.set(a||0,c||0,b||0)};
THREE.Vector3.prototype={set:function(a,c,b){this.x=a;this.y=c;this.z=b;return this},copy:function(a){this.set(a.x,a.y,a.z);return this},add:function(a,c){this.set(a.x+c.x,a.y+c.y,a.z+c.z);return this},addSelf:function(a){this.set(this.x+a.x,this.y+a.y,this.z+a.z);return this},addScalar:function(a){this.set(this.x+a,this.y+a,this.z+a);return this},sub:function(a,c){this.set(a.x-c.x,a.y-c.y,a.z-c.z);return this},subSelf:function(a){this.set(this.x-a.x,this.y-a.y,this.z-a.z);return this},cross:function(a,
c){this.set(a.y*c.z-a.z*c.y,a.z*c.x-a.x*c.z,a.x*c.y-a.y*c.x);return this},crossSelf:function(a){var c=this.x,b=this.y,e=this.z;this.set(b*a.z-e*a.y,e*a.x-c*a.z,c*a.y-b*a.x);return this},multiply:function(a,c){this.set(a.x*c.x,a.y*c.y,a.z*c.z);return this},multiplySelf:function(a){this.set(this.x*a.x,this.y*a.y,this.z*a.z);return this},multiplyScalar:function(a){this.set(this.x*a,this.y*a,this.z*a);return this},divideSelf:function(a){this.set(this.x/a.x,this.y/a.y,this.z/a.z);return this},divideScalar:function(a){this.set(this.x/
a,this.y/a,this.z/a);return this},negate:function(){this.set(-this.x,-this.y,-this.z);return this},dot:function(a){return this.x*a.x+this.y*a.y+this.z*a.z},distanceTo:function(a){return Math.sqrt(this.distanceToSquared(a))},distanceToSquared:function(a){var c=this.x-a.x,b=this.y-a.y;a=this.z-a.z;return c*c+b*b+a*a},length:function(){return Math.sqrt(this.lengthSq())},lengthSq:function(){return this.x*this.x+this.y*this.y+this.z*this.z},lengthManhattan:function(){return this.x+this.y+this.z},normalize:function(){var a=
this.length();a>0?this.multiplyScalar(1/a):this.set(0,0,0);return this},setPositionFromMatrix:function(a){this.x=a.n14;this.y=a.n24;this.z=a.n34},setRotationFromMatrix:function(a){this.y=Math.asin(a.n13);var c=Math.cos(this.y);if(Math.abs(c)>1.0E-5){this.x=Math.atan2(-a.n23/c,a.n33/c);this.z=Math.atan2(-a.n13/c,a.n11/c)}else{this.x=0;this.z=Math.atan2(a.n21,a.n22)}},setLength:function(a){return this.normalize().multiplyScalar(a)},isZero:function(){return Math.abs(this.x)<1.0E-4&&Math.abs(this.y)<
1.0E-4&&Math.abs(this.z)<1.0E-4},clone:function(){return new THREE.Vector3(this.x,this.y,this.z)}};THREE.Vector4=function(a,c,b,e){this.set(a||0,c||0,b||0,e||1)};
THREE.Vector4.prototype={set:function(a,c,b,e){this.x=a;this.y=c;this.z=b;this.w=e;return this},copy:function(a){this.set(a.x,a.y,a.z,a.w||1);return this},add:function(a,c){this.set(a.x+c.x,a.y+c.y,a.z+c.z,a.w+c.w);return this},addSelf:function(a){this.set(this.x+a.x,this.y+a.y,this.z+a.z,this.w+a.w);return this},sub:function(a,c){this.set(a.x-c.x,a.y-c.y,a.z-c.z,a.w-c.w);return this},subSelf:function(a){this.set(this.x-a.x,this.y-a.y,this.z-a.z,this.w-a.w);return this},multiplyScalar:function(a){this.set(this.x*
a,this.y*a,this.z*a,this.w*a);return this},divideScalar:function(a){this.set(this.x/a,this.y/a,this.z/a,this.w/a);return this},lerpSelf:function(a,c){this.set(this.x+(a.x-this.x)*c,this.y+(a.y-this.y)*c,this.z+(a.z-this.z)*c,this.w+(a.w-this.w)*c)},clone:function(){return new THREE.Vector4(this.x,this.y,this.z,this.w)}};THREE.Ray=function(a,c){this.origin=a||new THREE.Vector3;this.direction=c||new THREE.Vector3};
THREE.Ray.prototype={intersectScene:function(a){var c,b,e=a.objects,f=[];a=0;for(c=e.length;a<c;a++){b=e[a];b instanceof THREE.Mesh&&(f=f.concat(this.intersectObject(b)))}f.sort(function(g,j){return g.distance-j.distance});return f},intersectObject:function(a){function c(I,F,M,D){D=D.clone().subSelf(F);M=M.clone().subSelf(F);var Q=I.clone().subSelf(F);I=D.dot(D);F=D.dot(M);D=D.dot(Q);var R=M.dot(M);M=M.dot(Q);Q=1/(I*R-F*F);R=(R*D-F*M)*Q;I=(I*M-F*D)*Q;return R>0&&I>0&&R+I<1}var b,e,f,g,j,k,m,n,o,x,
z,y=a.geometry,B=y.vertices,H=[];b=0;for(e=y.faces.length;b<e;b++){f=y.faces[b];x=this.origin.clone();z=this.direction.clone();m=a.matrixWorld;g=m.multiplyVector3(B[f.a].position.clone());j=m.multiplyVector3(B[f.b].position.clone());k=m.multiplyVector3(B[f.c].position.clone());m=f instanceof THREE.Face4?m.multiplyVector3(B[f.d].position.clone()):null;n=a.matrixRotationWorld.multiplyVector3(f.normal.clone());o=z.dot(n);if(o<0){n=n.dot((new THREE.Vector3).sub(g,x))/o;x=x.addSelf(z.multiplyScalar(n));
if(f instanceof THREE.Face3){if(c(x,g,j,k)){f={distance:this.origin.distanceTo(x),point:x,face:f,object:a};H.push(f)}}else if(f instanceof THREE.Face4&&(c(x,g,j,m)||c(x,j,k,m))){f={distance:this.origin.distanceTo(x),point:x,face:f,object:a};H.push(f)}}}return H}};
THREE.Rectangle=function(){function a(){g=e-c;j=f-b}var c,b,e,f,g,j,k=!0;this.getX=function(){return c};this.getY=function(){return b};this.getWidth=function(){return g};this.getHeight=function(){return j};this.getLeft=function(){return c};this.getTop=function(){return b};this.getRight=function(){return e};this.getBottom=function(){return f};this.set=function(m,n,o,x){k=!1;c=m;b=n;e=o;f=x;a()};this.addPoint=function(m,n){if(k){k=!1;c=m;b=n;e=m;f=n}else{c=c<m?c:m;b=b<n?b:n;e=e>m?e:m;f=f>n?f:n}a()};
this.add3Points=function(m,n,o,x,z,y){if(k){k=!1;c=m<o?m<z?m:z:o<z?o:z;b=n<x?n<y?n:y:x<y?x:y;e=m>o?m>z?m:z:o>z?o:z;f=n>x?n>y?n:y:x>y?x:y}else{c=m<o?m<z?m<c?m:c:z<c?z:c:o<z?o<c?o:c:z<c?z:c;b=n<x?n<y?n<b?n:b:y<b?y:b:x<y?x<b?x:b:y<b?y:b;e=m>o?m>z?m>e?m:e:z>e?z:e:o>z?o>e?o:e:z>e?z:e;f=n>x?n>y?n>f?n:f:y>f?y:f:x>y?x>f?x:f:y>f?y:f}a()};this.addRectangle=function(m){if(k){k=!1;c=m.getLeft();b=m.getTop();e=m.getRight();f=m.getBottom()}else{c=c<m.getLeft()?c:m.getLeft();b=b<m.getTop()?b:m.getTop();e=e>m.getRight()?
e:m.getRight();f=f>m.getBottom()?f:m.getBottom()}a()};this.inflate=function(m){c-=m;b-=m;e+=m;f+=m;a()};this.minSelf=function(m){c=c>m.getLeft()?c:m.getLeft();b=b>m.getTop()?b:m.getTop();e=e<m.getRight()?e:m.getRight();f=f<m.getBottom()?f:m.getBottom();a()};this.instersects=function(m){return Math.min(e,m.getRight())-Math.max(c,m.getLeft())>=0&&Math.min(f,m.getBottom())-Math.max(b,m.getTop())>=0};this.empty=function(){k=!0;f=e=b=c=0;a()};this.isEmpty=function(){return k}};
THREE.Matrix3=function(){this.m=[]};THREE.Matrix3.prototype={transpose:function(){var a,c=this.m;a=c[1];c[1]=c[3];c[3]=a;a=c[2];c[2]=c[6];c[6]=a;a=c[5];c[5]=c[7];c[7]=a;return this},transposeIntoArray:function(a){var c=this.m;a[0]=c[0];a[1]=c[3];a[2]=c[6];a[3]=c[1];a[4]=c[4];a[5]=c[7];a[6]=c[2];a[7]=c[5];a[8]=c[8];return this}};
THREE.Matrix4=function(a,c,b,e,f,g,j,k,m,n,o,x,z,y,B,H){this.set(a||1,c||0,b||0,e||0,f||0,g||1,j||0,k||0,m||0,n||0,o||1,x||0,z||0,y||0,B||0,H||1);this.flat=Array(16);this.m33=new THREE.Matrix3};
THREE.Matrix4.prototype={set:function(a,c,b,e,f,g,j,k,m,n,o,x,z,y,B,H){this.n11=a;this.n12=c;this.n13=b;this.n14=e;this.n21=f;this.n22=g;this.n23=j;this.n24=k;this.n31=m;this.n32=n;this.n33=o;this.n34=x;this.n41=z;this.n42=y;this.n43=B;this.n44=H;return this},identity:function(){this.set(1,0,0,0,0,1,0,0,0,0,1,0,0,0,0,1);return this},copy:function(a){this.set(a.n11,a.n12,a.n13,a.n14,a.n21,a.n22,a.n23,a.n24,a.n31,a.n32,a.n33,a.n34,a.n41,a.n42,a.n43,a.n44);return this},lookAt:function(a,c,b){var e=THREE.Matrix4.__v1,
f=THREE.Matrix4.__v2,g=THREE.Matrix4.__v3;g.sub(a,c).normalize();if(g.length()===0)g.z=1;e.cross(b,g).normalize();if(e.length()===0){g.x+=1.0E-4;e.cross(b,g).normalize()}f.cross(g,e).normalize();this.n11=e.x;this.n12=f.x;this.n13=g.x;this.n21=e.y;this.n22=f.y;this.n23=g.y;this.n31=e.z;this.n32=f.z;this.n33=g.z;return this},multiplyVector3:function(a){var c=a.x,b=a.y,e=a.z,f=1/(this.n41*c+this.n42*b+this.n43*e+this.n44);a.x=(this.n11*c+this.n12*b+this.n13*e+this.n14)*f;a.y=(this.n21*c+this.n22*b+this.n23*
e+this.n24)*f;a.z=(this.n31*c+this.n32*b+this.n33*e+this.n34)*f;return a},multiplyVector4:function(a){var c=a.x,b=a.y,e=a.z,f=a.w;a.x=this.n11*c+this.n12*b+this.n13*e+this.n14*f;a.y=this.n21*c+this.n22*b+this.n23*e+this.n24*f;a.z=this.n31*c+this.n32*b+this.n33*e+this.n34*f;a.w=this.n41*c+this.n42*b+this.n43*e+this.n44*f;return a},rotateAxis:function(a){var c=a.x,b=a.y,e=a.z;a.x=c*this.n11+b*this.n12+e*this.n13;a.y=c*this.n21+b*this.n22+e*this.n23;a.z=c*this.n31+b*this.n32+e*this.n33;a.normalize();
return a},crossVector:function(a){var c=new THREE.Vector4;c.x=this.n11*a.x+this.n12*a.y+this.n13*a.z+this.n14*a.w;c.y=this.n21*a.x+this.n22*a.y+this.n23*a.z+this.n24*a.w;c.z=this.n31*a.x+this.n32*a.y+this.n33*a.z+this.n34*a.w;c.w=a.w?this.n41*a.x+this.n42*a.y+this.n43*a.z+this.n44*a.w:1;return c},multiply:function(a,c){var b=a.n11,e=a.n12,f=a.n13,g=a.n14,j=a.n21,k=a.n22,m=a.n23,n=a.n24,o=a.n31,x=a.n32,z=a.n33,y=a.n34,B=a.n41,H=a.n42,I=a.n43,F=a.n44,M=c.n11,D=c.n12,Q=c.n13,R=c.n14,P=c.n21,ka=c.n22,
d=c.n23,fa=c.n24,X=c.n31,ca=c.n32,Y=c.n33,ua=c.n34;this.n11=b*M+e*P+f*X;this.n12=b*D+e*ka+f*ca;this.n13=b*Q+e*d+f*Y;this.n14=b*R+e*fa+f*ua+g;this.n21=j*M+k*P+m*X;this.n22=j*D+k*ka+m*ca;this.n23=j*Q+k*d+m*Y;this.n24=j*R+k*fa+m*ua+n;this.n31=o*M+x*P+z*X;this.n32=o*D+x*ka+z*ca;this.n33=o*Q+x*d+z*Y;this.n34=o*R+x*fa+z*ua+y;this.n41=B*M+H*P+I*X;this.n42=B*D+H*ka+I*ca;this.n43=B*Q+H*d+I*Y;this.n44=B*R+H*fa+I*ua+F;return this},multiplyToArray:function(a,c,b){this.multiply(a,c);b[0]=this.n11;b[1]=this.n21;
b[2]=this.n31;b[3]=this.n41;b[4]=this.n12;b[5]=this.n22;b[6]=this.n32;b[7]=this.n42;b[8]=this.n13;b[9]=this.n23;b[10]=this.n33;b[11]=this.n43;b[12]=this.n14;b[13]=this.n24;b[14]=this.n34;b[15]=this.n44;return this},multiplySelf:function(a){this.multiply(this,a);return this},multiplyScalar:function(a){this.n11*=a;this.n12*=a;this.n13*=a;this.n14*=a;this.n21*=a;this.n22*=a;this.n23*=a;this.n24*=a;this.n31*=a;this.n32*=a;this.n33*=a;this.n34*=a;this.n41*=a;this.n42*=a;this.n43*=a;this.n44*=a;return this},
determinant:function(){var a=this.n11,c=this.n12,b=this.n13,e=this.n14,f=this.n21,g=this.n22,j=this.n23,k=this.n24,m=this.n31,n=this.n32,o=this.n33,x=this.n34,z=this.n41,y=this.n42,B=this.n43,H=this.n44;return e*j*n*z-b*k*n*z-e*g*o*z+c*k*o*z+b*g*x*z-c*j*x*z-e*j*m*y+b*k*m*y+e*f*o*y-a*k*o*y-b*f*x*y+a*j*x*y+e*g*m*B-c*k*m*B-e*f*n*B+a*k*n*B+c*f*x*B-a*g*x*B-b*g*m*H+c*j*m*H+b*f*n*H-a*j*n*H-c*f*o*H+a*g*o*H},transpose:function(){var a;a=this.n21;this.n21=this.n12;this.n12=a;a=this.n31;this.n31=this.n13;this.n13=
a;a=this.n32;this.n32=this.n23;this.n23=a;a=this.n41;this.n41=this.n14;this.n14=a;a=this.n42;this.n42=this.n24;this.n24=a;a=this.n43;this.n43=this.n34;this.n43=a;return this},clone:function(){var a=new THREE.Matrix4;a.n11=this.n11;a.n12=this.n12;a.n13=this.n13;a.n14=this.n14;a.n21=this.n21;a.n22=this.n22;a.n23=this.n23;a.n24=this.n24;a.n31=this.n31;a.n32=this.n32;a.n33=this.n33;a.n34=this.n34;a.n41=this.n41;a.n42=this.n42;a.n43=this.n43;a.n44=this.n44;return a},flatten:function(){this.flat[0]=this.n11;
this.flat[1]=this.n21;this.flat[2]=this.n31;this.flat[3]=this.n41;this.flat[4]=this.n12;this.flat[5]=this.n22;this.flat[6]=this.n32;this.flat[7]=this.n42;this.flat[8]=this.n13;this.flat[9]=this.n23;this.flat[10]=this.n33;this.flat[11]=this.n43;this.flat[12]=this.n14;this.flat[13]=this.n24;this.flat[14]=this.n34;this.flat[15]=this.n44;return this.flat},flattenToArray:function(a){a[0]=this.n11;a[1]=this.n21;a[2]=this.n31;a[3]=this.n41;a[4]=this.n12;a[5]=this.n22;a[6]=this.n32;a[7]=this.n42;a[8]=this.n13;
a[9]=this.n23;a[10]=this.n33;a[11]=this.n43;a[12]=this.n14;a[13]=this.n24;a[14]=this.n34;a[15]=this.n44;return a},flattenToArrayOffset:function(a,c){a[c]=this.n11;a[c+1]=this.n21;a[c+2]=this.n31;a[c+3]=this.n41;a[c+4]=this.n12;a[c+5]=this.n22;a[c+6]=this.n32;a[c+7]=this.n42;a[c+8]=this.n13;a[c+9]=this.n23;a[c+10]=this.n33;a[c+11]=this.n43;a[c+12]=this.n14;a[c+13]=this.n24;a[c+14]=this.n34;a[c+15]=this.n44;return a},setTranslation:function(a,c,b){this.set(1,0,0,a,0,1,0,c,0,0,1,b,0,0,0,1);return this},
setScale:function(a,c,b){this.set(a,0,0,0,0,c,0,0,0,0,b,0,0,0,0,1);return this},setRotationX:function(a){var c=Math.cos(a);a=Math.sin(a);this.set(1,0,0,0,0,c,-a,0,0,a,c,0,0,0,0,1);return this},setRotationY:function(a){var c=Math.cos(a);a=Math.sin(a);this.set(c,0,a,0,0,1,0,0,-a,0,c,0,0,0,0,1);return this},setRotationZ:function(a){var c=Math.cos(a);a=Math.sin(a);this.set(c,-a,0,0,a,c,0,0,0,0,1,0,0,0,0,1);return this},setRotationAxis:function(a,c){var b=Math.cos(c),e=Math.sin(c),f=1-b,g=a.x,j=a.y,k=
a.z,m=f*g,n=f*j;this.set(m*g+b,m*j-e*k,m*k+e*j,0,m*j+e*k,n*j+b,n*k-e*g,0,m*k-e*j,n*k+e*g,f*k*k+b,0,0,0,0,1);return this},setPosition:function(a){this.n14=a.x;this.n24=a.y;this.n34=a.z;return this},setRotationFromEuler:function(a){var c=a.x,b=a.y,e=a.z;a=Math.cos(c);c=Math.sin(c);var f=Math.cos(b);b=Math.sin(b);var g=Math.cos(e);e=Math.sin(e);var j=a*b,k=c*b;this.n11=f*g;this.n12=-f*e;this.n13=b;this.n21=k*g+a*e;this.n22=-k*e+a*g;this.n23=-c*f;this.n31=-j*g+c*e;this.n32=j*e+c*g;this.n33=a*f;return this},
setRotationFromQuaternion:function(a){var c=a.x,b=a.y,e=a.z,f=a.w,g=c+c,j=b+b,k=e+e;a=c*g;var m=c*j;c*=k;var n=b*j;b*=k;e*=k;g*=f;j*=f;f*=k;this.n11=1-(n+e);this.n12=m-f;this.n13=c+j;this.n21=m+f;this.n22=1-(a+e);this.n23=b-g;this.n31=c-j;this.n32=b+g;this.n33=1-(a+n);return this},scale:function(a){var c=a.x,b=a.y;a=a.z;this.n11*=c;this.n12*=b;this.n13*=a;this.n21*=c;this.n22*=b;this.n23*=a;this.n31*=c;this.n32*=b;this.n33*=a;this.n41*=c;this.n42*=b;this.n43*=a;return this},extractPosition:function(a){this.n14=
a.n14;this.n24=a.n24;this.n34=a.n34},extractRotation:function(a,c){var b=1/c.x,e=1/c.y,f=1/c.z;this.n11=a.n11*b;this.n21=a.n21*b;this.n31=a.n31*b;this.n12=a.n12*e;this.n22=a.n22*e;this.n32=a.n32*e;this.n13=a.n13*f;this.n23=a.n23*f;this.n33=a.n33*f}};
THREE.Matrix4.makeInvert=function(a,c){var b=a.n11,e=a.n12,f=a.n13,g=a.n14,j=a.n21,k=a.n22,m=a.n23,n=a.n24,o=a.n31,x=a.n32,z=a.n33,y=a.n34,B=a.n41,H=a.n42,I=a.n43,F=a.n44;c===undefined&&(c=new THREE.Matrix4);c.n11=m*y*H-n*z*H+n*x*I-k*y*I-m*x*F+k*z*F;c.n12=g*z*H-f*y*H-g*x*I+e*y*I+f*x*F-e*z*F;c.n13=f*n*H-g*m*H+g*k*I-e*n*I-f*k*F+e*m*F;c.n14=g*m*x-f*n*x-g*k*z+e*n*z+f*k*y-e*m*y;c.n21=n*z*B-m*y*B-n*o*I+j*y*I+m*o*F-j*z*F;c.n22=f*y*B-g*z*B+g*o*I-b*y*I-f*o*F+b*z*F;c.n23=g*m*B-f*n*B-g*j*I+b*n*I+f*j*F-b*m*F;
c.n24=f*n*o-g*m*o+g*j*z-b*n*z-f*j*y+b*m*y;c.n31=k*y*B-n*x*B+n*o*H-j*y*H-k*o*F+j*x*F;c.n32=g*x*B-e*y*B-g*o*H+b*y*H+e*o*F-b*x*F;c.n33=f*n*B-g*k*B+g*j*H-b*n*H-e*j*F+b*k*F;c.n34=g*k*o-e*n*o-g*j*x+b*n*x+e*j*y-b*k*y;c.n41=m*x*B-k*z*B-m*o*H+j*z*H+k*o*I-j*x*I;c.n42=e*z*B-f*x*B+f*o*H-b*z*H-e*o*I+b*x*I;c.n43=f*k*B-e*m*B-f*j*H+b*m*H+e*j*I-b*k*I;c.n44=e*m*o-f*k*o+f*j*x-b*m*x-e*j*z+b*k*z;c.multiplyScalar(1/a.determinant());return c};
THREE.Matrix4.makeInvert3x3=function(a){var c=a.m33,b=c.m,e=a.n33*a.n22-a.n32*a.n23,f=-a.n33*a.n21+a.n31*a.n23,g=a.n32*a.n21-a.n31*a.n22,j=-a.n33*a.n12+a.n32*a.n13,k=a.n33*a.n11-a.n31*a.n13,m=-a.n32*a.n11+a.n31*a.n12,n=a.n23*a.n12-a.n22*a.n13,o=-a.n23*a.n11+a.n21*a.n13,x=a.n22*a.n11-a.n21*a.n12;a=a.n11*e+a.n21*j+a.n31*n;if(a==0)throw"matrix not invertible";a=1/a;b[0]=a*e;b[1]=a*f;b[2]=a*g;b[3]=a*j;b[4]=a*k;b[5]=a*m;b[6]=a*n;b[7]=a*o;b[8]=a*x;return c};
THREE.Matrix4.makeFrustum=function(a,c,b,e,f,g){var j;j=new THREE.Matrix4;j.n11=2*f/(c-a);j.n12=0;j.n13=(c+a)/(c-a);j.n14=0;j.n21=0;j.n22=2*f/(e-b);j.n23=(e+b)/(e-b);j.n24=0;j.n31=0;j.n32=0;j.n33=-(g+f)/(g-f);j.n34=-2*g*f/(g-f);j.n41=0;j.n42=0;j.n43=-1;j.n44=0;return j};THREE.Matrix4.makePerspective=function(a,c,b,e){var f;a=b*Math.tan(a*Math.PI/360);f=-a;return THREE.Matrix4.makeFrustum(f*c,a*c,f,a,b,e)};
THREE.Matrix4.makeOrtho=function(a,c,b,e,f,g){var j,k,m,n;j=new THREE.Matrix4;k=c-a;m=b-e;n=g-f;j.n11=2/k;j.n12=0;j.n13=0;j.n14=-((c+a)/k);j.n21=0;j.n22=2/m;j.n23=0;j.n24=-((b+e)/m);j.n31=0;j.n32=0;j.n33=-2/n;j.n34=-((g+f)/n);j.n41=0;j.n42=0;j.n43=0;j.n44=1;return j};THREE.Matrix4.__v1=new THREE.Vector3;THREE.Matrix4.__v2=new THREE.Vector3;THREE.Matrix4.__v3=new THREE.Vector3;
THREE.Object3D=function(){this.parent=undefined;this.children=[];this.up=new THREE.Vector3(0,1,0);this.position=new THREE.Vector3;this.rotation=new THREE.Vector3;this.scale=new THREE.Vector3(1,1,1);this.rotationAutoUpdate=!0;this.matrix=new THREE.Matrix4;this.matrixWorld=new THREE.Matrix4;this.matrixRotationWorld=new THREE.Matrix4;this.matrixAutoUpdate=!0;this.matrixWorldNeedsUpdate=!0;this.quaternion=new THREE.Quaternion;this.useQuaternion=!1;this.boundRadius=0;this.boundRadiusScale=1;this.visible=
!0;this._vector=new THREE.Vector3};
THREE.Object3D.prototype={translate:function(a,c){this.matrix.rotateAxis(c);this.position.addSelf(c.multiplyScalar(a))},translateX:function(a){this.translate(a,this._vector.set(1,0,0))},translateY:function(a){this.translate(a,this._vector.set(0,1,0))},translateZ:function(a){this.translate(a,this._vector.set(0,0,1))},lookAt:function(a){this.matrix.lookAt(this.position,a,this.up);this.rotationAutoUpdate&&this.rotation.setRotationFromMatrix(this.matrix)},addChild:function(a){if(this.children.indexOf(a)===-1){a.parent!==
undefined&&a.parent.removeChild(a);a.parent=this;this.children.push(a);for(var c=this;c instanceof THREE.Scene===!1&&c!==undefined;)c=c.parent;c!==undefined&&c.addChildRecurse(a)}},removeChild:function(a){var c=this.children.indexOf(a);if(c!==-1){a.parent=undefined;this.children.splice(c,1)}},updateMatrix:function(){this.matrix.setPosition(this.position);this.useQuaternion?this.matrix.setRotationFromQuaternion(this.quaternion):this.matrix.setRotationFromEuler(this.rotation);if(this.scale.x!==1||this.scale.y!==
1||this.scale.z!==1){this.matrix.scale(this.scale);this.boundRadiusScale=Math.max(this.scale.x,Math.max(this.scale.y,this.scale.z))}this.matrixWorldNeedsUpdate=!0},update:function(a,c,b){this.matrixAutoUpdate&&this.updateMatrix();if(this.matrixWorldNeedsUpdate||c){a?this.matrixWorld.multiply(a,this.matrix):this.matrixWorld.copy(this.matrix);this.matrixRotationWorld.extractRotation(this.matrixWorld,this.scale);this.matrixWorldNeedsUpdate=!1;c=!0}a=0;for(var e=this.children.length;a<e;a++)this.children[a].update(this.matrixWorld,
c,b)}};THREE.Quaternion=function(a,c,b,e){this.set(a||0,c||0,b||0,e!==undefined?e:1)};
THREE.Quaternion.prototype={set:function(a,c,b,e){this.x=a;this.y=c;this.z=b;this.w=e;return this},setFromEuler:function(a){var c=0.5*Math.PI/360,b=a.x*c,e=a.y*c,f=a.z*c;a=Math.cos(e);e=Math.sin(e);c=Math.cos(-f);f=Math.sin(-f);var g=Math.cos(b);b=Math.sin(b);var j=a*c,k=e*f;this.w=j*g-k*b;this.x=j*b+k*g;this.y=e*c*g+a*f*b;this.z=a*f*g-e*c*b;return this},calculateW:function(){this.w=-Math.sqrt(Math.abs(1-this.x*this.x-this.y*this.y-this.z*this.z));return this},inverse:function(){this.x*=-1;this.y*=
-1;this.z*=-1;return this},length:function(){return Math.sqrt(this.x*this.x+this.y*this.y+this.z*this.z+this.w*this.w)},normalize:function(){var a=Math.sqrt(this.x*this.x+this.y*this.y+this.z*this.z+this.w*this.w);if(a==0)this.w=this.z=this.y=this.x=0;else{a=1/a;this.x*=a;this.y*=a;this.z*=a;this.w*=a}return this},multiplySelf:function(a){var c=this.x,b=this.y,e=this.z,f=this.w,g=a.x,j=a.y,k=a.z;a=a.w;this.x=c*a+f*g+b*k-e*j;this.y=b*a+f*j+e*g-c*k;this.z=e*a+f*k+c*j-b*g;this.w=f*a-c*g-b*j-e*k;return this},
multiplyVector3:function(a,c){c||(c=a);var b=a.x,e=a.y,f=a.z,g=this.x,j=this.y,k=this.z,m=this.w,n=m*b+j*f-k*e,o=m*e+k*b-g*f,x=m*f+g*e-j*b;b=-g*b-j*e-k*f;c.x=n*m+b*-g+o*-k-x*-j;c.y=o*m+b*-j+x*-g-n*-k;c.z=x*m+b*-k+n*-j-o*-g;return c}};
THREE.Quaternion.slerp=function(a,c,b,e){var f=a.w*c.w+a.x*c.x+a.y*c.y+a.z*c.z;if(Math.abs(f)>=1){b.w=a.w;b.x=a.x;b.y=a.y;b.z=a.z;return b}var g=Math.acos(f),j=Math.sqrt(1-f*f);if(Math.abs(j)<0.0010){b.w=0.5*(a.w+c.w);b.x=0.5*(a.x+c.x);b.y=0.5*(a.y+c.y);b.z=0.5*(a.z+c.z);return b}f=Math.sin((1-e)*g)/j;e=Math.sin(e*g)/j;b.w=a.w*f+c.w*e;b.x=a.x*f+c.x*e;b.y=a.y*f+c.y*e;b.z=a.z*f+c.z*e;return b};THREE.Vertex=function(a){this.position=a||new THREE.Vector3};
THREE.Face3=function(a,c,b,e,f,g){this.a=a;this.b=c;this.c=b;this.normal=e instanceof THREE.Vector3?e:new THREE.Vector3;this.vertexNormals=e instanceof Array?e:[];this.color=f instanceof THREE.Color?f:new THREE.Color;this.vertexColors=f instanceof Array?f:[];this.vertexTangents=[];this.materials=g instanceof Array?g:[g];this.centroid=new THREE.Vector3};
THREE.Face4=function(a,c,b,e,f,g,j){this.a=a;this.b=c;this.c=b;this.d=e;this.normal=f instanceof THREE.Vector3?f:new THREE.Vector3;this.vertexNormals=f instanceof Array?f:[];this.color=g instanceof THREE.Color?g:new THREE.Color;this.vertexColors=g instanceof Array?g:[];this.vertexTangents=[];this.materials=j instanceof Array?j:[j];this.centroid=new THREE.Vector3};THREE.UV=function(a,c){this.set(a||0,c||0)};
THREE.UV.prototype={set:function(a,c){this.u=a;this.v=c;return this},copy:function(a){this.set(a.u,a.v);return this}};THREE.Geometry=function(){this.id="Geometry"+THREE.GeometryIdCounter++;this.vertices=[];this.colors=[];this.faces=[];this.faceUvs=[[]];this.faceVertexUvs=[[]];this.morphTargets=[];this.skinWeights=[];this.skinIndices=[];this.boundingSphere=this.boundingBox=null;this.hasTangents=!1};
THREE.Geometry.prototype={computeCentroids:function(){var a,c,b;a=0;for(c=this.faces.length;a<c;a++){b=this.faces[a];b.centroid.set(0,0,0);if(b instanceof THREE.Face3){b.centroid.addSelf(this.vertices[b.a].position);b.centroid.addSelf(this.vertices[b.b].position);b.centroid.addSelf(this.vertices[b.c].position);b.centroid.divideScalar(3)}else if(b instanceof THREE.Face4){b.centroid.addSelf(this.vertices[b.a].position);b.centroid.addSelf(this.vertices[b.b].position);b.centroid.addSelf(this.vertices[b.c].position);
b.centroid.addSelf(this.vertices[b.d].position);b.centroid.divideScalar(4)}}},computeFaceNormals:function(a){var c,b,e,f,g,j,k=new THREE.Vector3,m=new THREE.Vector3;e=0;for(f=this.faces.length;e<f;e++){g=this.faces[e];if(a&&g.vertexNormals.length){k.set(0,0,0);c=0;for(b=g.vertexNormals.length;c<b;c++)k.addSelf(g.vertexNormals[c]);k.divideScalar(3)}else{c=this.vertices[g.a];b=this.vertices[g.b];j=this.vertices[g.c];k.sub(j.position,b.position);m.sub(c.position,b.position);k.crossSelf(m)}k.isZero()||
k.normalize();g.normal.copy(k)}},computeVertexNormals:function(){var a,c,b,e;if(this.__tmpVertices==undefined){e=this.__tmpVertices=Array(this.vertices.length);a=0;for(c=this.vertices.length;a<c;a++)e[a]=new THREE.Vector3;a=0;for(c=this.faces.length;a<c;a++){b=this.faces[a];if(b instanceof THREE.Face3)b.vertexNormals=[new THREE.Vector3,new THREE.Vector3,new THREE.Vector3];else if(b instanceof THREE.Face4)b.vertexNormals=[new THREE.Vector3,new THREE.Vector3,new THREE.Vector3,new THREE.Vector3]}}else{e=
this.__tmpVertices;a=0;for(c=this.vertices.length;a<c;a++)e[a].set(0,0,0)}a=0;for(c=this.faces.length;a<c;a++){b=this.faces[a];if(b instanceof THREE.Face3){e[b.a].addSelf(b.normal);e[b.b].addSelf(b.normal);e[b.c].addSelf(b.normal)}else if(b instanceof THREE.Face4){e[b.a].addSelf(b.normal);e[b.b].addSelf(b.normal);e[b.c].addSelf(b.normal);e[b.d].addSelf(b.normal)}}a=0;for(c=this.vertices.length;a<c;a++)e[a].normalize();a=0;for(c=this.faces.length;a<c;a++){b=this.faces[a];if(b instanceof THREE.Face3){b.vertexNormals[0].copy(e[b.a]);
b.vertexNormals[1].copy(e[b.b]);b.vertexNormals[2].copy(e[b.c])}else if(b instanceof THREE.Face4){b.vertexNormals[0].copy(e[b.a]);b.vertexNormals[1].copy(e[b.b]);b.vertexNormals[2].copy(e[b.c]);b.vertexNormals[3].copy(e[b.d])}}},computeTangents:function(){function a(W,ia,Z,S,N,ha,ra){k=W.vertices[ia].position;m=W.vertices[Z].position;n=W.vertices[S].position;o=j[N];x=j[ha];z=j[ra];y=m.x-k.x;B=n.x-k.x;H=m.y-k.y;I=n.y-k.y;F=m.z-k.z;M=n.z-k.z;D=x.u-o.u;Q=z.u-o.u;R=x.v-o.v;P=z.v-o.v;ka=1/(D*P-Q*R);ca.set((P*
y-R*B)*ka,(P*H-R*I)*ka,(P*F-R*M)*ka);Y.set((D*B-Q*y)*ka,(D*I-Q*H)*ka,(D*M-Q*F)*ka);fa[ia].addSelf(ca);fa[Z].addSelf(ca);fa[S].addSelf(ca);X[ia].addSelf(Y);X[Z].addSelf(Y);X[S].addSelf(Y)}var c,b,e,f,g,j,k,m,n,o,x,z,y,B,H,I,F,M,D,Q,R,P,ka,d,fa=[],X=[],ca=new THREE.Vector3,Y=new THREE.Vector3,ua=new THREE.Vector3,va=new THREE.Vector3,za=new THREE.Vector3;c=0;for(b=this.vertices.length;c<b;c++){fa[c]=new THREE.Vector3;X[c]=new THREE.Vector3}c=0;for(b=this.faces.length;c<b;c++){g=this.faces[c];j=this.faceVertexUvs[0][c];
if(g instanceof THREE.Face3)a(this,g.a,g.b,g.c,0,1,2);else if(g instanceof THREE.Face4){a(this,g.a,g.b,g.c,0,1,2);a(this,g.a,g.b,g.d,0,1,3)}}var ma=["a","b","c","d"];c=0;for(b=this.faces.length;c<b;c++){g=this.faces[c];for(e=0;e<g.vertexNormals.length;e++){za.copy(g.vertexNormals[e]);f=g[ma[e]];d=fa[f];ua.copy(d);ua.subSelf(za.multiplyScalar(za.dot(d))).normalize();va.cross(g.vertexNormals[e],d);f=va.dot(X[f]);f=f<0?-1:1;g.vertexTangents[e]=new THREE.Vector4(ua.x,ua.y,ua.z,f)}}this.hasTangents=!0},
computeBoundingBox:function(){var a;if(this.vertices.length>0){this.boundingBox={x:[this.vertices[0].position.x,this.vertices[0].position.x],y:[this.vertices[0].position.y,this.vertices[0].position.y],z:[this.vertices[0].position.z,this.vertices[0].position.z]};for(var c=1,b=this.vertices.length;c<b;c++){a=this.vertices[c];if(a.position.x<this.boundingBox.x[0])this.boundingBox.x[0]=a.position.x;else if(a.position.x>this.boundingBox.x[1])this.boundingBox.x[1]=a.position.x;if(a.position.y<this.boundingBox.y[0])this.boundingBox.y[0]=
a.position.y;else if(a.position.y>this.boundingBox.y[1])this.boundingBox.y[1]=a.position.y;if(a.position.z<this.boundingBox.z[0])this.boundingBox.z[0]=a.position.z;else if(a.position.z>this.boundingBox.z[1])this.boundingBox.z[1]=a.position.z}}},computeBoundingSphere:function(){for(var a=this.boundingSphere===null?0:this.boundingSphere.radius,c=0,b=this.vertices.length;c<b;c++)a=Math.max(a,this.vertices[c].position.length());this.boundingSphere={radius:a}}};THREE.GeometryIdCounter=0;
THREE.Spline=function(a){function c(y,B,H,I,F,M,D){y=(H-y)*0.5;I=(I-B)*0.5;return(2*(B-H)+y+I)*D+(-3*(B-H)-2*y-I)*M+y*F+B}this.points=a;var b=[],e={x:0,y:0,z:0},f,g,j,k,m,n,o,x,z;this.initFromArray=function(y){this.points=[];for(var B=0;B<y.length;B++)this.points[B]={x:y[B][0],y:y[B][1],z:y[B][2]}};this.getPoint=function(y){f=(this.points.length-1)*y;g=Math.floor(f);j=f-g;b[0]=g==0?g:g-1;b[1]=g;b[2]=g>this.points.length-2?g:g+1;b[3]=g>this.points.length-3?g:g+2;n=this.points[b[0]];o=this.points[b[1]];
x=this.points[b[2]];z=this.points[b[3]];k=j*j;m=j*k;e.x=c(n.x,o.x,x.x,z.x,j,k,m);e.y=c(n.y,o.y,x.y,z.y,j,k,m);e.z=c(n.z,o.z,x.z,z.z,j,k,m);return e};this.getControlPointsArray=function(){var y,B,H=this.points.length,I=[];for(y=0;y<H;y++){B=this.points[y];I[y]=[B.x,B.y,B.z]}return I};this.getLength=function(y){var B,H,I=B=B=0,F=new THREE.Vector3,M=new THREE.Vector3,D=[],Q=0;D[0]=0;y||(y=100);H=this.points.length*y;F.copy(this.points[0]);for(y=1;y<H;y++){B=y/H;position=this.getPoint(B);M.copy(position);
Q+=M.distanceTo(F);F.copy(position);B*=this.points.length-1;B=Math.floor(B);if(B!=I){D[B]=Q;I=B}}D[D.length]=Q;return{chunks:D,total:Q}};this.reparametrizeByArcLength=function(y){var B,H,I,F,M,D,Q=[],R=new THREE.Vector3,P=this.getLength();Q.push(R.copy(this.points[0]).clone());for(B=1;B<this.points.length;B++){H=P.chunks[B]-P.chunks[B-1];D=Math.ceil(y*H/P.total);F=(B-1)/(this.points.length-1);M=B/(this.points.length-1);for(H=1;H<D-1;H++){I=F+H*(1/D)*(M-F);position=this.getPoint(I);Q.push(R.copy(position).clone())}Q.push(R.copy(this.points[B]).clone())}this.points=
Q}};
THREE.AnimationHandler=function(){var a=[],c={},b={};b.update=function(f){for(var g=0;g<a.length;g++)a[g].update(f)};b.addToUpdate=function(f){a.indexOf(f)===-1&&a.push(f)};b.removeFromUpdate=function(f){f=a.indexOf(f);f!==-1&&a.splice(f,1)};b.add=function(f){c[f.name]!==undefined&&console.log("THREE.AnimationHandler.add: Warning! "+f.name+" already exists in library. Overwriting.");c[f.name]=f;if(f.initialized!==!0){for(var g=0;g<f.hierarchy.length;g++){for(var j=0;j<f.hierarchy[g].keys.length;j++){if(f.hierarchy[g].keys[j].time<0)f.hierarchy[g].keys[j].time=
0;if(f.hierarchy[g].keys[j].rot!==undefined&&!(f.hierarchy[g].keys[j].rot instanceof THREE.Quaternion)){var k=f.hierarchy[g].keys[j].rot;f.hierarchy[g].keys[j].rot=new THREE.Quaternion(k[0],k[1],k[2],k[3])}}if(f.hierarchy[g].keys[0].morphTargets!==undefined){k={};for(j=0;j<f.hierarchy[g].keys.length;j++)for(var m=0;m<f.hierarchy[g].keys[j].morphTargets.length;m++){var n=f.hierarchy[g].keys[j].morphTargets[m];k[n]=-1}f.hierarchy[g].usedMorphTargets=k;for(j=0;j<f.hierarchy[g].keys.length;j++){var o=
{};for(n in k){for(m=0;m<f.hierarchy[g].keys[j].morphTargets.length;m++)if(f.hierarchy[g].keys[j].morphTargets[m]===n){o[n]=f.hierarchy[g].keys[j].morphTargetsInfluences[m];break}m===f.hierarchy[g].keys[j].morphTargets.length&&(o[n]=0)}f.hierarchy[g].keys[j].morphTargetsInfluences=o}}for(j=1;j<f.hierarchy[g].keys.length;j++)if(f.hierarchy[g].keys[j].time===f.hierarchy[g].keys[j-1].time){f.hierarchy[g].keys.splice(j,1);j--}for(j=1;j<f.hierarchy[g].keys.length;j++)f.hierarchy[g].keys[j].index=j}j=parseInt(f.length*
f.fps,10);f.JIT={};f.JIT.hierarchy=[];for(g=0;g<f.hierarchy.length;g++)f.JIT.hierarchy.push(Array(j));f.initialized=!0}};b.get=function(f){if(typeof f==="string")if(c[f])return c[f];else{console.log("THREE.AnimationHandler.get: Couldn't find animation "+f);return null}};b.parse=function(f){var g=[];if(f instanceof THREE.SkinnedMesh)for(var j=0;j<f.bones.length;j++)g.push(f.bones[j]);else e(f,g);return g};var e=function(f,g){g.push(f);for(var j=0;j<f.children.length;j++)e(f.children[j],g)};b.LINEAR=
0;b.CATMULLROM=1;b.CATMULLROM_FORWARD=2;return b}();THREE.Animation=function(a,c,b,e){this.root=a;this.data=THREE.AnimationHandler.get(c);this.hierarchy=THREE.AnimationHandler.parse(a);this.currentTime=0;this.timeScale=1;this.isPlaying=!1;this.isPaused=!0;this.loop=!0;this.interpolationType=b!==undefined?b:THREE.AnimationHandler.LINEAR;this.JITCompile=e!==undefined?e:!0;this.points=[];this.target=new THREE.Vector3};
THREE.Animation.prototype.play=function(a,c){if(!this.isPlaying){this.isPlaying=!0;this.loop=a!==undefined?a:!0;this.currentTime=c!==undefined?c:0;var b,e=this.hierarchy.length,f;for(b=0;b<e;b++){f=this.hierarchy[b];if(this.interpolationType!==THREE.AnimationHandler.CATMULLROM_FORWARD)f.useQuaternion=!0;f.matrixAutoUpdate=!0;if(f.animationCache===undefined){f.animationCache={};f.animationCache.prevKey={pos:0,rot:0,scl:0};f.animationCache.nextKey={pos:0,rot:0,scl:0};f.animationCache.originalMatrix=
f instanceof THREE.Bone?f.skinMatrix:f.matrix}var g=f.animationCache.prevKey;f=f.animationCache.nextKey;g.pos=this.data.hierarchy[b].keys[0];g.rot=this.data.hierarchy[b].keys[0];g.scl=this.data.hierarchy[b].keys[0];f.pos=this.getNextKeyWith("pos",b,1);f.rot=this.getNextKeyWith("rot",b,1);f.scl=this.getNextKeyWith("scl",b,1)}this.update(0)}this.isPaused=!1;THREE.AnimationHandler.addToUpdate(this)};
THREE.Animation.prototype.pause=function(){this.isPaused?THREE.AnimationHandler.addToUpdate(this):THREE.AnimationHandler.removeFromUpdate(this);this.isPaused=!this.isPaused};
THREE.Animation.prototype.stop=function(){this.isPlaying=!1;this.isPaused=!1;THREE.AnimationHandler.removeFromUpdate(this);for(var a=0;a<this.hierarchy.length;a++)if(this.hierarchy[a].animationCache!==undefined){if(this.hierarchy[a]instanceof THREE.Bone)this.hierarchy[a].skinMatrix=this.hierarchy[a].animationCache.originalMatrix;else this.hierarchy[a].matrix=this.hierarchy[a].animationCache.originalMatrix;delete this.hierarchy[a].animationCache}};
THREE.Animation.prototype.update=function(a){if(this.isPlaying){var c=["pos","rot","scl"],b,e,f,g,j,k,m,n,o=this.data.JIT.hierarchy,x,z;this.currentTime+=a*this.timeScale;z=this.currentTime;x=this.currentTime%=this.data.length;n=parseInt(Math.min(x*this.data.fps,this.data.length*this.data.fps),10);for(var y=0,B=this.hierarchy.length;y<B;y++){a=this.hierarchy[y];m=a.animationCache;if(this.JITCompile&&o[y][n]!==undefined)if(a instanceof THREE.Bone){a.skinMatrix=o[y][n];a.matrixAutoUpdate=!1;a.matrixWorldNeedsUpdate=
!1}else{a.matrix=o[y][n];a.matrixAutoUpdate=!1;a.matrixWorldNeedsUpdate=!0}else{if(this.JITCompile)if(a instanceof THREE.Bone)a.skinMatrix=a.animationCache.originalMatrix;else a.matrix=a.animationCache.originalMatrix;for(var H=0;H<3;H++){b=c[H];j=m.prevKey[b];k=m.nextKey[b];if(k.time<=z){if(x<z)if(this.loop){j=this.data.hierarchy[y].keys[0];for(k=this.getNextKeyWith(b,y,1);k.time<x;){j=k;k=this.getNextKeyWith(b,y,k.index+1)}}else{this.stop();return}else{do{j=k;k=this.getNextKeyWith(b,y,k.index+1)}while(k.time<
x)}m.prevKey[b]=j;m.nextKey[b]=k}a.matrixAutoUpdate=!0;a.matrixWorldNeedsUpdate=!0;e=(x-j.time)/(k.time-j.time);f=j[b];g=k[b];if(e<0||e>1){console.log("THREE.Animation.update: Warning! Scale out of bounds:"+e+" on bone "+y);e=e<0?0:1}if(b==="pos"){b=a.position;if(this.interpolationType===THREE.AnimationHandler.LINEAR){b.x=f[0]+(g[0]-f[0])*e;b.y=f[1]+(g[1]-f[1])*e;b.z=f[2]+(g[2]-f[2])*e}else if(this.interpolationType===THREE.AnimationHandler.CATMULLROM||this.interpolationType===THREE.AnimationHandler.CATMULLROM_FORWARD){this.points[0]=
this.getPrevKeyWith("pos",y,j.index-1).pos;this.points[1]=f;this.points[2]=g;this.points[3]=this.getNextKeyWith("pos",y,k.index+1).pos;e=e*0.33+0.33;f=this.interpolateCatmullRom(this.points,e);b.x=f[0];b.y=f[1];b.z=f[2];if(this.interpolationType===THREE.AnimationHandler.CATMULLROM_FORWARD){e=this.interpolateCatmullRom(this.points,e*1.01);this.target.set(e[0],e[1],e[2]);this.target.subSelf(b);this.target.y=0;this.target.normalize();e=Math.atan2(this.target.x,this.target.z);a.rotation.set(0,e,0)}}}else if(b===
"rot")THREE.Quaternion.slerp(f,g,a.quaternion,e);else if(b==="scl"){b=a.scale;b.x=f[0]+(g[0]-f[0])*e;b.y=f[1]+(g[1]-f[1])*e;b.z=f[2]+(g[2]-f[2])*e}}}}if(this.JITCompile&&o[0][n]===undefined){this.hierarchy[0].update(undefined,!0);for(y=0;y<this.hierarchy.length;y++)o[y][n]=this.hierarchy[y]instanceof THREE.Bone?this.hierarchy[y].skinMatrix.clone():this.hierarchy[y].matrix.clone()}}};
THREE.Animation.prototype.interpolateCatmullRom=function(a,c){var b=[],e=[],f,g,j,k,m,n;f=(a.length-1)*c;g=Math.floor(f);f-=g;b[0]=g==0?g:g-1;b[1]=g;b[2]=g>a.length-2?g:g+1;b[3]=g>a.length-3?g:g+2;g=a[b[0]];k=a[b[1]];m=a[b[2]];n=a[b[3]];b=f*f;j=f*b;e[0]=this.interpolate(g[0],k[0],m[0],n[0],f,b,j);e[1]=this.interpolate(g[1],k[1],m[1],n[1],f,b,j);e[2]=this.interpolate(g[2],k[2],m[2],n[2],f,b,j);return e};
THREE.Animation.prototype.interpolate=function(a,c,b,e,f,g,j){a=(b-a)*0.5;e=(e-c)*0.5;return(2*(c-b)+a+e)*j+(-3*(c-b)-2*a-e)*g+a*f+c};THREE.Animation.prototype.getNextKeyWith=function(a,c,b){var e=this.data.hierarchy[c].keys;if(this.interpolationType===THREE.AnimationHandler.CATMULLROM||this.interpolationType===THREE.AnimationHandler.CATMULLROM_FORWARD)b=b<e.length-1?b:e.length-1;else b%=e.length;for(;b<e.length;b++)if(e[b][a]!==undefined)return e[b];return this.data.hierarchy[c].keys[0]};
THREE.Animation.prototype.getPrevKeyWith=function(a,c,b){var e=this.data.hierarchy[c].keys;for(b=this.interpolationType===THREE.AnimationHandler.CATMULLROM||this.interpolationType===THREE.AnimationHandler.CATMULLROM_FORWARD?b>0?b:0:b>=0?b:b+e.length;b>=0;b--)if(e[b][a]!==undefined)return e[b];return this.data.hierarchy[c].keys[e.length-1]};
THREE.Camera=function(a,c,b,e,f){THREE.Object3D.call(this);this.fov=a||50;this.aspect=c||1;this.near=b||0.1;this.far=e||2E3;this.target=f||new THREE.Object3D;this.useTarget=!0;this.matrixWorldInverse=new THREE.Matrix4;this.projectionMatrix=null;this.updateProjectionMatrix()};THREE.Camera.prototype=new THREE.Object3D;THREE.Camera.prototype.constructor=THREE.Camera;THREE.Camera.prototype.supr=THREE.Object3D.prototype;
THREE.Camera.prototype.translate=function(a,c){this.matrix.rotateAxis(c);this.position.addSelf(c.multiplyScalar(a));this.target.position.addSelf(c.multiplyScalar(a))};THREE.Camera.prototype.updateProjectionMatrix=function(){this.projectionMatrix=THREE.Matrix4.makePerspective(this.fov,this.aspect,this.near,this.far)};THREE.Camera.prototype.updateMatrix=function(){this.update(undefined,!0)};
THREE.Camera.prototype.update=function(a,c,b){if(this.useTarget){this.matrix.lookAt(this.position,this.target.position,this.up);this.matrix.setPosition(this.position);a?this.matrixWorld.multiply(a,this.matrix):this.matrixWorld.copy(this.matrix);THREE.Matrix4.makeInvert(this.matrixWorld,this.matrixWorldInverse);c=!0}else{this.matrixAutoUpdate&&(c|=this.updateMatrix());if(c||this.matrixWorldNeedsUpdate){a?this.matrixWorld.multiply(a,this.matrix):this.matrixWorld.copy(this.matrix);this.matrixWorldNeedsUpdate=
!1;c=!0;THREE.Matrix4.makeInvert(this.matrixWorld,this.matrixWorldInverse)}}for(a=0;a<this.children.length;a++)this.children[a].update(this.matrixWorld,c,b)};THREE.Light=function(a){THREE.Object3D.call(this);this.color=new THREE.Color(a)};THREE.Light.prototype=new THREE.Object3D;THREE.Light.prototype.constructor=THREE.Light;THREE.Light.prototype.supr=THREE.Object3D.prototype;THREE.AmbientLight=function(a){THREE.Light.call(this,a)};THREE.AmbientLight.prototype=new THREE.Light;
THREE.AmbientLight.prototype.constructor=THREE.AmbientLight;THREE.DirectionalLight=function(a,c){THREE.Light.call(this,a);this.position=new THREE.Vector3(0,1,0);this.intensity=c||1};THREE.DirectionalLight.prototype=new THREE.Light;THREE.DirectionalLight.prototype.constructor=THREE.DirectionalLight;THREE.PointLight=function(a,c){THREE.Light.call(this,a);this.position=new THREE.Vector3;this.intensity=c||1};THREE.PointLight.prototype=new THREE.Light;THREE.PointLight.prototype.constructor=THREE.PointLight;
THREE.NoShading=0;THREE.FlatShading=1;THREE.SmoothShading=2;THREE.NoColors=0;THREE.FaceColors=1;THREE.VertexColors=2;THREE.NormalBlending=0;THREE.AdditiveBlending=1;THREE.SubtractiveBlending=2;THREE.MultiplyBlending=3;THREE.MaterialCounter={value:0};THREE.CubeReflectionMapping=function(){};THREE.CubeRefractionMapping=function(){};THREE.LatitudeReflectionMapping=function(){};THREE.LatitudeRefractionMapping=function(){};THREE.SphericalReflectionMapping=function(){};
THREE.SphericalRefractionMapping=function(){};THREE.UVMapping=function(){};
THREE.LineBasicMaterial=function(a){this.id=THREE.MaterialCounter.value++;this.color=new THREE.Color(16777215);this.opacity=1;this.blending=THREE.NormalBlending;this.depthTest=!0;this.linewidth=1;this.linejoin=this.linecap="round";this.vertexColors=!1;if(a){a.color!==undefined&&this.color.setHex(a.color);if(a.opacity!==undefined)this.opacity=a.opacity;if(a.blending!==undefined)this.blending=a.blending;if(a.depthTest!==undefined)this.depthTest=a.depthTest;if(a.linewidth!==undefined)this.linewidth=
a.linewidth;if(a.linecap!==undefined)this.linecap=a.linecap;if(a.linejoin!==undefined)this.linejoin=a.linejoin;if(a.vertexColors!==undefined)this.vertexColors=a.vertexColors}};
THREE.MeshBasicMaterial=function(a){this.id=THREE.MaterialCounter.value++;this.color=new THREE.Color(16777215);this.opacity=1;this.envMap=this.lightMap=this.map=null;this.combine=THREE.MultiplyOperation;this.reflectivity=1;this.refractionRatio=0.98;this.fog=!0;this.shading=THREE.SmoothShading;this.blending=THREE.NormalBlending;this.depthTest=!0;this.wireframe=!1;this.wireframeLinewidth=1;this.wireframeLinejoin=this.wireframeLinecap="round";this.vertexColors=!1;this.skinning=!1;this.morphTargets=!1;
if(a){a.color!==undefined&&this.color.setHex(a.color);if(a.opacity!==undefined)this.opacity=a.opacity;if(a.map!==undefined)this.map=a.map;if(a.lightMap!==undefined)this.lightMap=a.lightMap;if(a.envMap!==undefined)this.envMap=a.envMap;if(a.combine!==undefined)this.combine=a.combine;if(a.reflectivity!==undefined)this.reflectivity=a.reflectivity;if(a.refractionRatio!==undefined)this.refractionRatio=a.refractionRatio;if(a.fog!==undefined)this.fog=a.fog;if(a.shading!==undefined)this.shading=a.shading;
if(a.blending!==undefined)this.blending=a.blending;if(a.depthTest!==undefined)this.depthTest=a.depthTest;if(a.wireframe!==undefined)this.wireframe=a.wireframe;if(a.wireframeLinewidth!==undefined)this.wireframeLinewidth=a.wireframeLinewidth;if(a.wireframeLinecap!==undefined)this.wireframeLinecap=a.wireframeLinecap;if(a.wireframeLinejoin!==undefined)this.wireframeLinejoin=a.wireframeLinejoin;if(a.vertexColors!==undefined)this.vertexColors=a.vertexColors;if(a.skinning!==undefined)this.skinning=a.skinning;
if(a.morphTargets!==undefined)this.morphTargets=a.morphTargets}};
THREE.MeshLambertMaterial=function(a){this.id=THREE.MaterialCounter.value++;this.color=new THREE.Color(16777215);this.opacity=1;this.envMap=this.lightMap=this.map=null;this.combine=THREE.MultiplyOperation;this.reflectivity=1;this.refractionRatio=0.98;this.fog=!0;this.shading=THREE.SmoothShading;this.blending=THREE.NormalBlending;this.depthTest=!0;this.wireframe=!1;this.wireframeLinewidth=1;this.wireframeLinejoin=this.wireframeLinecap="round";this.vertexColors=!1;this.skinning=!1;this.morphTargets=
!1;if(a){a.color!==undefined&&this.color.setHex(a.color);if(a.opacity!==undefined)this.opacity=a.opacity;if(a.map!==undefined)this.map=a.map;if(a.lightMap!==undefined)this.lightMap=a.lightMap;if(a.envMap!==undefined)this.envMap=a.envMap;if(a.combine!==undefined)this.combine=a.combine;if(a.reflectivity!==undefined)this.reflectivity=a.reflectivity;if(a.refractionRatio!==undefined)this.refractionRatio=a.refractionRatio;if(a.fog!==undefined)this.fog=a.fog;if(a.shading!==undefined)this.shading=a.shading;
if(a.blending!==undefined)this.blending=a.blending;if(a.depthTest!==undefined)this.depthTest=a.depthTest;if(a.wireframe!==undefined)this.wireframe=a.wireframe;if(a.wireframeLinewidth!==undefined)this.wireframeLinewidth=a.wireframeLinewidth;if(a.wireframeLinecap!==undefined)this.wireframeLinecap=a.wireframeLinecap;if(a.wireframeLinejoin!==undefined)this.wireframeLinejoin=a.wireframeLinejoin;if(a.vertexColors!==undefined)this.vertexColors=a.vertexColors;if(a.skinning!==undefined)this.skinning=a.skinning;
if(a.morphTargets!==undefined)this.morphTargets=a.morphTargets}};
THREE.MeshPhongMaterial=function(a){this.id=THREE.MaterialCounter.value++;this.color=new THREE.Color(16777215);this.ambient=new THREE.Color(328965);this.specular=new THREE.Color(1118481);this.shininess=30;this.opacity=1;this.envMap=this.lightMap=this.map=null;this.combine=THREE.MultiplyOperation;this.reflectivity=1;this.refractionRatio=0.98;this.fog=!0;this.shading=THREE.SmoothShading;this.blending=THREE.NormalBlending;this.depthTest=!0;this.wireframe=!1;this.wireframeLinewidth=1;this.wireframeLinejoin=
this.wireframeLinecap="round";this.vertexColors=!1;this.skinning=!1;this.morphTargets=!1;if(a){if(a.color!==undefined)this.color=new THREE.Color(a.color);if(a.ambient!==undefined)this.ambient=new THREE.Color(a.ambient);if(a.specular!==undefined)this.specular=new THREE.Color(a.specular);if(a.shininess!==undefined)this.shininess=a.shininess;if(a.opacity!==undefined)this.opacity=a.opacity;if(a.lightMap!==undefined)this.lightMap=a.lightMap;if(a.map!==undefined)this.map=a.map;if(a.envMap!==undefined)this.envMap=
a.envMap;if(a.combine!==undefined)this.combine=a.combine;if(a.reflectivity!==undefined)this.reflectivity=a.reflectivity;if(a.refractionRatio!==undefined)this.refractionRatio=a.refractionRatio;if(a.fog!==undefined)this.fog=a.fog;if(a.shading!==undefined)this.shading=a.shading;if(a.blending!==undefined)this.blending=a.blending;if(a.depthTest!==undefined)this.depthTest=a.depthTest;if(a.wireframe!==undefined)this.wireframe=a.wireframe;if(a.wireframeLinewidth!==undefined)this.wireframeLinewidth=a.wireframeLinewidth;
if(a.wireframeLinecap!==undefined)this.wireframeLinecap=a.wireframeLinecap;if(a.wireframeLinejoin!==undefined)this.wireframeLinejoin=a.wireframeLinejoin;if(a.vertexColors!==undefined)this.vertexColors=a.vertexColors;if(a.skinning!==undefined)this.skinning=a.skinning;if(a.morphTargets!==undefined)this.morphTargets=a.morphTargets}};
THREE.MeshDepthMaterial=function(a){this.id=THREE.MaterialCounter.value++;this.opacity=1;this.shading=THREE.SmoothShading;this.blending=THREE.NormalBlending;this.depthTest=!0;this.wireframe=!1;this.wireframeLinewidth=1;if(a){if(a.opacity!==undefined)this.opacity=a.opacity;if(a.shading!==undefined)this.shading=a.shading;if(a.blending!==undefined)this.blending=a.blending;if(a.depthTest!==undefined)this.depthTest=a.depthTest;if(a.wireframe!==undefined)this.wireframe=a.wireframe;if(a.wireframeLinewidth!==
undefined)this.wireframeLinewidth=a.wireframeLinewidth}};
THREE.MeshNormalMaterial=function(a){this.id=THREE.MaterialCounter.value++;this.opacity=1;this.shading=THREE.FlatShading;this.blending=THREE.NormalBlending;this.depthTest=!0;this.wireframe=!1;this.wireframeLinewidth=1;if(a){if(a.opacity!==undefined)this.opacity=a.opacity;if(a.shading!==undefined)this.shading=a.shading;if(a.blending!==undefined)this.blending=a.blending;if(a.depthTest!==undefined)this.depthTest=a.depthTest;if(a.wireframe!==undefined)this.wireframe=a.wireframe;if(a.wireframeLinewidth!==
undefined)this.wireframeLinewidth=a.wireframeLinewidth}};THREE.MeshFaceMaterial=function(){};
THREE.MeshShaderMaterial=function(a){this.id=THREE.MaterialCounter.value++;this.vertexShader=this.fragmentShader="void main() {}";this.uniforms={};this.opacity=1;this.shading=THREE.SmoothShading;this.blending=THREE.NormalBlending;this.depthTest=!0;this.wireframe=!1;this.wireframeLinewidth=1;this.wireframeLinejoin=this.wireframeLinecap="round";this.lights=!1;this.vertexColors=!1;this.skinning=!1;this.morphTargets=!1;if(a){if(a.fragmentShader!==undefined)this.fragmentShader=a.fragmentShader;if(a.vertexShader!==
undefined)this.vertexShader=a.vertexShader;if(a.uniforms!==undefined)this.uniforms=a.uniforms;if(a.opacity!==undefined)this.opacity=a.opacity;if(a.shading!==undefined)this.shading=a.shading;if(a.blending!==undefined)this.blending=a.blending;if(a.depthTest!==undefined)this.depthTest=a.depthTest;if(a.wireframe!==undefined)this.wireframe=a.wireframe;if(a.wireframeLinewidth!==undefined)this.wireframeLinewidth=a.wireframeLinewidth;if(a.wireframeLinecap!==undefined)this.wireframeLinecap=a.wireframeLinecap;
if(a.wireframeLinejoin!==undefined)this.wireframeLinejoin=a.wireframeLinejoin;if(a.lights!==undefined)this.lights=a.lights;if(a.vertexColors!==undefined)this.vertexColors=a.vertexColors;if(a.skinning!==undefined)this.skinning=a.skinning;if(a.morphTargets!==undefined)this.morphTargets=a.morphTargets}};
THREE.ShadowVolumeDynamicMaterial=function(){this.id=THREE.MaterialCounter.value++;this.color=new THREE.Color(16777215);this.opacity=1;this.envMap=this.lightMap=this.map=null;this.combine=THREE.MultiplyOperation;this.reflectivity=1;this.refractionRatio=0.98;this.fog=!0;this.shading=THREE.FlatShading;this.blending=THREE.NormalBlending;this.depthTest=!0;this.wireframe=!1;this.wireframeLinewidth=1;this.wireframeLinejoin=this.wireframeLinecap="round";this.vertexColors=!1;this.skinning=!1;this.morphTargets=
!1};
THREE.ParticleBasicMaterial=function(a){this.id=THREE.MaterialCounter.value++;this.color=new THREE.Color(16777215);this.opacity=1;this.map=null;this.size=1;this.sizeAttenuation=!0;this.blending=THREE.NormalBlending;this.depthTest=!0;this.offset=new THREE.Vector2;this.vertexColors=!1;if(a){a.color!==undefined&&this.color.setHex(a.color);if(a.opacity!==undefined)this.opacity=a.opacity;if(a.map!==undefined)this.map=a.map;if(a.size!==undefined)this.size=a.size;if(a.sizeAttenuation!==undefined)this.sizeAttenuation=a.sizeAttenuation;
if(a.blending!==undefined)this.blending=a.blending;if(a.depthTest!==undefined)this.depthTest=a.depthTest;if(a.vertexColors!==undefined)this.vertexColors=a.vertexColors}};
THREE.ParticleCanvasMaterial=function(a){this.id=THREE.MaterialCounter.value++;this.color=new THREE.Color(16777215);this.program=function(){};this.opacity=1;this.blending=THREE.NormalBlending;if(a){a.color!==undefined&&this.color.setHex(a.color);if(a.program!==undefined)this.program=a.program;if(a.opacity!==undefined)this.opacity=a.opacity;if(a.blending!==undefined)this.blending=a.blending}};THREE.ParticleDOMMaterial=function(a){this.id=THREE.MaterialCounter.value++;this.domElement=a};
THREE.Texture=function(a,c,b,e,f,g){this.image=a;this.mapping=c!==undefined?c:new THREE.UVMapping;this.wrapS=b!==undefined?b:THREE.ClampToEdgeWrapping;this.wrapT=e!==undefined?e:THREE.ClampToEdgeWrapping;this.magFilter=f!==undefined?f:THREE.LinearFilter;this.minFilter=g!==undefined?g:THREE.LinearMipMapLinearFilter;this.needsUpdate=!1};THREE.Texture.prototype={clone:function(){return new THREE.Texture(this.image,this.mapping,this.wrapS,this.wrapT,this.magFilter,this.minFilter)}};
THREE.MultiplyOperation=0;THREE.MixOperation=1;THREE.RepeatWrapping=0;THREE.ClampToEdgeWrapping=1;THREE.MirroredRepeatWrapping=2;THREE.NearestFilter=3;THREE.NearestMipMapNearestFilter=4;THREE.NearestMipMapLinearFilter=5;THREE.LinearFilter=6;THREE.LinearMipMapNearestFilter=7;THREE.LinearMipMapLinearFilter=8;THREE.ByteType=9;THREE.UnsignedByteType=10;THREE.ShortType=11;THREE.UnsignedShortType=12;THREE.IntType=13;THREE.UnsignedIntType=14;THREE.FloatType=15;THREE.AlphaFormat=16;THREE.RGBFormat=17;
THREE.RGBAFormat=18;THREE.LuminanceFormat=19;THREE.LuminanceAlphaFormat=20;
THREE.RenderTarget=function(a,c,b){this.width=a;this.height=c;b=b||{};this.wrapS=b.wrapS!==undefined?b.wrapS:THREE.ClampToEdgeWrapping;this.wrapT=b.wrapT!==undefined?b.wrapT:THREE.ClampToEdgeWrapping;this.magFilter=b.magFilter!==undefined?b.magFilter:THREE.LinearFilter;this.minFilter=b.minFilter!==undefined?b.minFilter:THREE.LinearMipMapLinearFilter;this.format=b.format!==undefined?b.format:THREE.RGBFormat;this.type=b.type!==undefined?b.type:THREE.UnsignedByteType};
var Uniforms={clone:function(a){var c,b,e,f={};for(c in a){f[c]={};for(b in a[c]){e=a[c][b];f[c][b]=e instanceof THREE.Color||e instanceof THREE.Vector3||e instanceof THREE.Texture?e.clone():e}}return f},merge:function(a){var c,b,e,f={};for(c=0;c<a.length;c++){e=this.clone(a[c]);for(b in e)f[b]=e[b]}return f}};THREE.Particle=function(a){THREE.Object3D.call(this);this.materials=a instanceof Array?a:[a];this.matrixAutoUpdate=!1};THREE.Particle.prototype=new THREE.Object3D;
THREE.Particle.prototype.constructor=THREE.Particle;THREE.ParticleSystem=function(a,c){THREE.Object3D.call(this);this.geometry=a;this.materials=c instanceof Array?c:[c];this.sortParticles=!1};THREE.ParticleSystem.prototype=new THREE.Object3D;THREE.ParticleSystem.prototype.constructor=THREE.ParticleSystem;THREE.Line=function(a,c,b){THREE.Object3D.call(this);this.geometry=a;this.materials=c instanceof Array?c:[c];this.type=b!=undefined?b:THREE.LineStrip};THREE.LineStrip=0;THREE.LinePieces=1;
THREE.Line.prototype=new THREE.Object3D;THREE.Line.prototype.constructor=THREE.Line;
THREE.Mesh=function(a,c){THREE.Object3D.call(this);this.geometry=a;this.materials=c&&c.length?c:[c];this.flipSided=!1;this.doubleSided=!1;this.overdraw=!1;if(this.geometry){this.geometry.boundingSphere||this.geometry.computeBoundingSphere();this.boundRadius=a.boundingSphere.radius;if(this.geometry.morphTargets.length){this.morphTargetBase=-1;this.morphTargetForcedOrder=[];this.morphTargetInfluences=[];this.morphTargetDictionary={};for(var b=0;b<this.geometry.morphTargets.length;b++){this.morphTargetInfluences.push(0);
this.morphTargetDictionary[this.geometry.morphTargets[b].name]=b}}}};THREE.Mesh.prototype=new THREE.Object3D;THREE.Mesh.prototype.constructor=THREE.Mesh;THREE.Mesh.prototype.supr=THREE.Object3D.prototype;THREE.Mesh.prototype.getMorphTargetIndexByName=function(a){if(this.morphTargetDictionary[a]!==undefined)return this.morphTargetDictionary[a];console.log("THREE.Mesh.getMorphTargetIndexByName: morph target "+a+" does not exist. Returning 0.");return 0};
THREE.Bone=function(a){THREE.Object3D.call(this);this.skin=a;this.skinMatrix=new THREE.Matrix4;this.hasNoneBoneChildren=!1};THREE.Bone.prototype=new THREE.Object3D;THREE.Bone.prototype.constructor=THREE.Bone;THREE.Bone.prototype.supr=THREE.Object3D.prototype;
THREE.Bone.prototype.update=function(a,c,b){this.matrixAutoUpdate&&(c|=this.updateMatrix());if(c||this.matrixWorldNeedsUpdate){a?this.skinMatrix.multiply(a,this.matrix):this.skinMatrix.copy(this.matrix);this.matrixWorldNeedsUpdate=!1;c=!0}var e,f=this.children.length;if(this.hasNoneBoneChildren){this.matrixWorld.multiply(this.skin.matrixWorld,this.skinMatrix);for(e=0;e<f;e++){a=this.children[e];a instanceof THREE.Bone?a.update(this.skinMatrix,c,b):a.update(this.matrixWorld,!0,b)}}else for(e=0;e<f;e++)this.children[e].update(this.skinMatrix,
c,b)};THREE.Bone.prototype.addChild=function(a){if(this.children.indexOf(a)===-1){a.parent!==undefined&&a.parent.removeChild(a);a.parent=this;this.children.push(a);if(!(a instanceof THREE.Bone))this.hasNoneBoneChildren=!0}};if(!window.Float32Array)window.Float32Array=Array;
THREE.SkinnedMesh=function(a,c){THREE.Mesh.call(this,a,c);this.identityMatrix=new THREE.Matrix4;this.bones=[];this.boneMatrices=[];var b,e,f,g,j,k;if(this.geometry.bones!==undefined){for(b=0;b<this.geometry.bones.length;b++){f=this.geometry.bones[b];g=f.pos;j=f.rotq;k=f.scl;e=this.addBone();e.name=f.name;e.position.set(g[0],g[1],g[2]);e.quaternion.set(j[0],j[1],j[2],j[3]);e.useQuaternion=!0;k!==undefined?e.scale.set(k[0],k[1],k[2]):e.scale.set(1,1,1)}for(b=0;b<this.bones.length;b++){f=this.geometry.bones[b];
e=this.bones[b];f.parent===-1?this.addChild(e):this.bones[f.parent].addChild(e)}this.boneMatrices=new Float32Array(16*this.bones.length);this.pose()}};THREE.SkinnedMesh.prototype=new THREE.Mesh;THREE.SkinnedMesh.prototype.constructor=THREE.SkinnedMesh;
THREE.SkinnedMesh.prototype.update=function(a,c,b){if(this.visible){this.matrixAutoUpdate&&(c|=this.updateMatrix());if(c||this.matrixWorldNeedsUpdate){a?this.matrixWorld.multiply(a,this.matrix):this.matrixWorld.copy(this.matrix);this.matrixWorldNeedsUpdate=!1;c=!0}var e,f=this.children.length;for(e=0;e<f;e++){a=this.children[e];a instanceof THREE.Bone?a.update(this.identityMatrix,!1,b):a.update(this.matrixWorld,c,b)}b=this.bones.length;ba=this.bones;bm=this.boneMatrices;for(c=0;c<b;c++)ba[c].skinMatrix.flattenToArrayOffset(bm,
c*16)}};THREE.SkinnedMesh.prototype.addBone=function(a){a===undefined&&(a=new THREE.Bone(this));this.bones.push(a);return a};
THREE.SkinnedMesh.prototype.pose=function(){this.update(undefined,!0);for(var a,c=[],b=0;b<this.bones.length;b++){a=this.bones[b];c.push(THREE.Matrix4.makeInvert(a.skinMatrix));a.skinMatrix.flattenToArrayOffset(this.boneMatrices,b*16)}if(this.geometry.skinVerticesA===undefined){this.geometry.skinVerticesA=[];this.geometry.skinVerticesB=[];var e;for(a=0;a<this.geometry.skinIndices.length;a++){b=this.geometry.vertices[a].position;var f=this.geometry.skinIndices[a].x,g=this.geometry.skinIndices[a].y;
e=new THREE.Vector3(b.x,b.y,b.z);this.geometry.skinVerticesA.push(c[f].multiplyVector3(e));e=new THREE.Vector3(b.x,b.y,b.z);this.geometry.skinVerticesB.push(c[g].multiplyVector3(e));if(this.geometry.skinWeights[a].x+this.geometry.skinWeights[a].y!==1){b=(1-(this.geometry.skinWeights[a].x+this.geometry.skinWeights[a].y))*0.5;this.geometry.skinWeights[a].x+=b;this.geometry.skinWeights[a].y+=b}}}};
THREE.Ribbon=function(a,c){THREE.Object3D.call(this);this.geometry=a;this.materials=c instanceof Array?c:[c];this.flipSided=!1;this.doubleSided=!1};THREE.Ribbon.prototype=new THREE.Object3D;THREE.Ribbon.prototype.constructor=THREE.Ribbon;
THREE.Sound=function(a,c,b,e){THREE.Object3D.call(this);this.isLoaded=!1;this.isAddedToDOM=!1;this.isPlaying=!1;this.duration=-1;this.radius=c!==undefined?Math.abs(c):100;this.volume=Math.min(1,Math.max(0,b!==undefined?b:1));this.domElement=document.createElement("audio");this.domElement.volume=0;this.domElement.pan=0;this.domElement.loop=e!==undefined?e:!0;this.sources=a instanceof Array?a:[a];var f;b=this.sources.length;for(a=0;a<b;a++){c=this.sources[a];c.toLowerCase();if(c.indexOf(".mp3")!==-1)f=
"audio/mpeg";else if(c.indexOf(".ogg")!==-1)f="audio/ogg";else c.indexOf(".wav")!==-1&&(f="audio/wav");if(this.domElement.canPlayType(f)){f=document.createElement("source");f.src=this.sources[a];this.domElement.THREESound=this;this.domElement.appendChild(f);this.domElement.addEventListener("canplay",this.onLoad,!0);this.domElement.load();break}}};THREE.Sound.prototype=new THREE.Object3D;THREE.Sound.prototype.constructor=THREE.Sound;THREE.Sound.prototype.supr=THREE.Object3D.prototype;
THREE.Sound.prototype.onLoad=function(){var a=this.THREESound;if(!a.isLoaded){this.removeEventListener("canplay",this.onLoad,!0);a.isLoaded=!0;a.duration=this.duration;a.isPlaying&&a.play()}};THREE.Sound.prototype.addToDOM=function(a){this.isAddedToDOM=!0;a.appendChild(this.domElement)};THREE.Sound.prototype.play=function(a){this.isPlaying=!0;if(this.isLoaded){this.domElement.play();if(a)this.domElement.currentTime=a%this.duration}};THREE.Sound.prototype.pause=function(){this.isPlaying=!1;this.domElement.pause()};
THREE.Sound.prototype.stop=function(){this.isPlaying=!1;this.domElement.pause();this.domElement.currentTime=0};THREE.Sound.prototype.calculateVolumeAndPan=function(a){a=a.length();this.domElement.volume=a<=this.radius?this.volume*(1-a/this.radius):0};
THREE.Sound.prototype.update=function(a,c,b){if(this.matrixAutoUpdate){this.matrix.setPosition(this.position);c=!0}if(c||this.matrixWorldNeedsUpdate){a?this.matrixWorld.multiply(a,this.matrix):this.matrixWorld.copy(this.matrix);this.matrixWorldNeedsUpdate=!1;c=!0}var e=this.children.length;for(a=0;a<e;a++)this.children[a].update(this.matrixWorld,c,b)};THREE.LOD=function(){THREE.Object3D.call(this);this.LODs=[]};THREE.LOD.prototype=new THREE.Object3D;THREE.LOD.prototype.constructor=THREE.LOD;
THREE.LOD.prototype.supr=THREE.Object3D.prototype;THREE.LOD.prototype.add=function(a,c){c===undefined&&(c=0);c=Math.abs(c);for(var b=0;b<this.LODs.length;b++)if(c<this.LODs[b].visibleAtDistance)break;this.LODs.splice(b,0,{visibleAtDistance:c,object3D:a});this.addChild(a)};
THREE.LOD.prototype.update=function(a,c,b){this.matrixAutoUpdate&&(c|=this.updateMatrix());if(c||this.matrixWorldNeedsUpdate){a?this.matrixWorld.multiply(a,this.matrix):this.matrixWorld.copy(this.matrix);this.matrixWorldNeedsUpdate=!1;c=!0}if(this.LODs.length>1){a=b.matrixWorldInverse;a=-(a.n31*this.position.x+a.n32*this.position.y+a.n33*this.position.z+a.n34);this.LODs[0].object3D.visible=!0;for(var e=1;e<this.LODs.length;e++)if(a>=this.LODs[e].visibleAtDistance){this.LODs[e-1].object3D.visible=
!1;this.LODs[e].object3D.visible=!0}else break;for(;e<this.LODs.length;e++)this.LODs[e].object3D.visible=!1}for(a=0;a<this.children.length;a++)this.children[a].update(this.matrixWorld,c,b)};THREE.ShadowVolume=function(a,c){THREE.Mesh.call(this,a.geometry,c?[new THREE.ShadowVolumeDynamicMaterial]:[new THREE.ShadowVolumeDynamicMaterial]);a.addChild(this);this.calculateShadowVolumeGeometry(a.geometry)};THREE.ShadowVolume.prototype=new THREE.Mesh;THREE.ShadowVolume.prototype.constructor=THREE.ShadowVolume;
THREE.ShadowVolume.prototype.supr=THREE.Mesh.prototype;
THREE.ShadowVolume.prototype.calculateShadowVolumeGeometry=function(a){this.geometry=new THREE.Geometry;this.geometry.boundingSphere=a.boundingSphere;this.geometry.edgeFaces=[];var c=this.geometry.vertices,b=this.geometry.faces,e=this.geometry.edgeFaces,f=a.faces;a=a.vertices;var g=f.length,j,k,m,n,o,x=["a","b","c","d"];for(m=0;m<g;m++){k=c.length;j=f[m];if(j instanceof THREE.Face4){n=4;k=new THREE.Face4(k,k+1,k+2,k+3)}else{n=3;k=new THREE.Face3(k,k+1,k+2)}k.normal.copy(j.normal);b.push(k);for(k=
0;k<n;k++){o=a[j[x[k]]];c.push(new THREE.Vertex(o.position.clone()))}}for(g=0;g<f.length-1;g++){a=b[g];for(j=g+1;j<f.length;j++){k=b[j];k=this.facesShareEdge(c,a,k);if(k!==undefined){k=new THREE.Face4(k.indices[0],k.indices[3],k.indices[2],k.indices[1]);k.normal.set(1,0,0);e.push(k)}}}};
THREE.ShadowVolume.prototype.facesShareEdge=function(a,c,b){var e,f,g,j,k,m,n,o,x,z,y,B,H,I=0,F=["a","b","c","d"];e=c instanceof THREE.Face4?4:3;f=b instanceof THREE.Face4?4:3;for(B=0;B<e;B++){g=c[F[B]];k=a[g];for(H=0;H<f;H++){j=b[F[H]];m=a[j];if(Math.abs(k.position.x-m.position.x)<1.0E-4&&Math.abs(k.position.y-m.position.y)<1.0E-4&&Math.abs(k.position.z-m.position.z)<1.0E-4){I++;if(I===1){n=k;o=m;x=g;z=j;y=F[B]}if(I===2){y+=F[B];return y==="ad"||y==="ac"?{faces:[c,b],vertices:[n,o,m,k],indices:[x,
z,j,g],vertexTypes:[1,2,2,1],extrudable:!0}:{faces:[c,b],vertices:[n,k,m,o],indices:[x,g,j,z],vertexTypes:[1,1,2,2],extrudable:!0}}}}}};THREE.Scene=function(){THREE.Object3D.call(this);this.matrixAutoUpdate=!1;this.fog=null;this.objects=[];this.lights=[];this.sounds=[];this.__objectsAdded=[];this.__objectsRemoved=[]};THREE.Scene.prototype=new THREE.Object3D;THREE.Scene.prototype.constructor=THREE.Scene;THREE.Scene.prototype.supr=THREE.Object3D.prototype;
THREE.Scene.prototype.addChild=function(a){this.supr.addChild.call(this,a);this.addChildRecurse(a)};THREE.Scene.prototype.addChildRecurse=function(a){if(a instanceof THREE.Light)this.lights.indexOf(a)===-1&&this.lights.push(a);else if(a instanceof THREE.Sound)this.sounds.indexOf(a)===-1&&this.sounds.push(a);else if(!(a instanceof THREE.Camera||a instanceof THREE.Bone)&&this.objects.indexOf(a)===-1){this.objects.push(a);this.__objectsAdded.push(a)}for(var c=0;c<a.children.length;c++)this.addChildRecurse(a.children[c])};
THREE.Scene.prototype.removeChild=function(a){this.supr.removeChild.call(this,a);this.removeChildRecurse(a)};THREE.Scene.prototype.removeChildRecurse=function(a){if(a instanceof THREE.Light){var c=this.lights.indexOf(a);c!==-1&&this.lights.splice(c,1)}else if(a instanceof THREE.Sound){c=this.sounds.indexOf(a);c!==-1&&this.sounds.splice(c,1)}else if(!(a instanceof THREE.Camera)){c=this.objects.indexOf(a);if(c!==-1){this.objects.splice(c,1);this.__objectsRemoved.push(a)}}for(c=0;c<a.children.length;c++)this.removeChildRecurse(a.children[c])};
THREE.Scene.prototype.addObject=THREE.Scene.prototype.addChild;THREE.Scene.prototype.removeObject=THREE.Scene.prototype.removeChild;THREE.Scene.prototype.addLight=THREE.Scene.prototype.addChild;THREE.Scene.prototype.removeLight=THREE.Scene.prototype.removeChild;THREE.Fog=function(a,c,b){this.color=new THREE.Color(a);this.near=c||1;this.far=b||1E3};THREE.FogExp2=function(a,c){this.color=new THREE.Color(a);this.density=c!==undefined?c:2.5E-4};
THREE.Projector=function(){function a(){var ca=m[k]=m[k]||new THREE.RenderableVertex;k++;return ca}function c(ca,Y){return Y.z-ca.z}function b(ca,Y){var ua=0,va=1,za=ca.z+ca.w,ma=Y.z+Y.w,W=-ca.z+ca.w,ia=-Y.z+Y.w;if(za>=0&&ma>=0&&W>=0&&ia>=0)return!0;else if(za<0&&ma<0||W<0&&ia<0)return!1;else{if(za<0)ua=Math.max(ua,za/(za-ma));else ma<0&&(va=Math.min(va,za/(za-ma)));if(W<0)ua=Math.max(ua,W/(W-ia));else ia<0&&(va=Math.min(va,W/(W-ia)));if(va<ua)return!1;else{ca.lerpSelf(Y,ua);Y.lerpSelf(ca,1-va);return!0}}}
var e,f,g=[],j,k,m=[],n,o,x=[],z,y=[],B,H,I=[],F,M,D=[],Q=new THREE.Vector4,R=new THREE.Vector4,P=new THREE.Matrix4,ka=new THREE.Matrix4,d=[new THREE.Vector4,new THREE.Vector4,new THREE.Vector4,new THREE.Vector4,new THREE.Vector4,new THREE.Vector4],fa=new THREE.Vector4,X=new THREE.Vector4;this.projectVector=function(ca,Y){P.multiply(Y.projectionMatrix,Y.matrixWorldInverse);P.multiplyVector3(ca);return ca};this.unprojectVector=function(ca,Y){P.multiply(Y.matrixWorld,THREE.Matrix4.makeInvert(Y.projectionMatrix));
P.multiplyVector3(ca);return ca};this.projectObjects=function(ca,Y,ua){Y=[];var va,za,ma;f=0;za=ca.objects;ca=0;for(va=za.length;ca<va;ca++){ma=za[ca];var W;if(!(W=!ma.visible))if(W=ma instanceof THREE.Mesh){a:{W=void 0;for(var ia=ma.matrixWorld,Z=-ma.geometry.boundingSphere.radius*Math.max(ma.scale.x,Math.max(ma.scale.y,ma.scale.z)),S=0;S<6;S++){W=d[S].x*ia.n14+d[S].y*ia.n24+d[S].z*ia.n34+d[S].w;if(W<=Z){W=!1;break a}}W=!0}W=!W}if(!W){W=g[f]=g[f]||new THREE.RenderableObject;f++;e=W;Q.copy(ma.position);
P.multiplyVector3(Q);e.object=ma;e.z=Q.z;Y.push(e)}}ua&&Y.sort(c);return Y};this.projectScene=function(ca,Y,ua){var va=[],za=Y.near,ma=Y.far,W,ia,Z,S,N,ha,ra,na,qa,xa,Da,$a,ab,Ia,h,t,w;M=H=z=o=0;Y.matrixAutoUpdate&&Y.updateMatrix();ca.update(undefined,!1,Y);P.multiply(Y.projectionMatrix,Y.matrixWorldInverse);d[0].set(P.n41-P.n11,P.n42-P.n12,P.n43-P.n13,P.n44-P.n14);d[1].set(P.n41+P.n11,P.n42+P.n12,P.n43+P.n13,P.n44+P.n14);d[2].set(P.n41+P.n21,P.n42+P.n22,P.n43+P.n23,P.n44+P.n24);d[3].set(P.n41-P.n21,
P.n42-P.n22,P.n43-P.n23,P.n44-P.n24);d[4].set(P.n41-P.n31,P.n42-P.n32,P.n43-P.n33,P.n44-P.n34);d[5].set(P.n41+P.n31,P.n42+P.n32,P.n43+P.n33,P.n44+P.n34);for(W=0;W<6;W++){qa=d[W];qa.divideScalar(Math.sqrt(qa.x*qa.x+qa.y*qa.y+qa.z*qa.z))}qa=this.projectObjects(ca,Y,!0);ca=0;for(W=qa.length;ca<W;ca++){xa=qa[ca].object;if(xa.visible){Da=xa.matrixWorld;$a=xa.matrixRotationWorld;ab=xa.materials;Ia=xa.overdraw;k=0;if(xa instanceof THREE.Mesh){h=xa.geometry;S=h.vertices;t=h.faces;h=h.faceVertexUvs;ia=0;for(Z=
S.length;ia<Z;ia++){j=a();j.positionWorld.copy(S[ia].position);Da.multiplyVector3(j.positionWorld);j.positionScreen.copy(j.positionWorld);P.multiplyVector4(j.positionScreen);j.positionScreen.x/=j.positionScreen.w;j.positionScreen.y/=j.positionScreen.w;j.visible=j.positionScreen.z>za&&j.positionScreen.z<ma}S=0;for(ia=t.length;S<ia;S++){Z=t[S];if(Z instanceof THREE.Face3){N=m[Z.a];ha=m[Z.b];ra=m[Z.c];if(N.visible&&ha.visible&&ra.visible&&(xa.doubleSided||xa.flipSided!=(ra.positionScreen.x-N.positionScreen.x)*
(ha.positionScreen.y-N.positionScreen.y)-(ra.positionScreen.y-N.positionScreen.y)*(ha.positionScreen.x-N.positionScreen.x)<0)){na=x[o]=x[o]||new THREE.RenderableFace3;o++;n=na;n.v1.copy(N);n.v2.copy(ha);n.v3.copy(ra)}else continue}else if(Z instanceof THREE.Face4){N=m[Z.a];ha=m[Z.b];ra=m[Z.c];na=m[Z.d];if(N.visible&&ha.visible&&ra.visible&&na.visible&&(xa.doubleSided||xa.flipSided!=((na.positionScreen.x-N.positionScreen.x)*(ha.positionScreen.y-N.positionScreen.y)-(na.positionScreen.y-N.positionScreen.y)*
(ha.positionScreen.x-N.positionScreen.x)<0||(ha.positionScreen.x-ra.positionScreen.x)*(na.positionScreen.y-ra.positionScreen.y)-(ha.positionScreen.y-ra.positionScreen.y)*(na.positionScreen.x-ra.positionScreen.x)<0))){w=y[z]=y[z]||new THREE.RenderableFace4;z++;n=w;n.v1.copy(N);n.v2.copy(ha);n.v3.copy(ra);n.v4.copy(na)}else continue}n.normalWorld.copy(Z.normal);$a.multiplyVector3(n.normalWorld);n.centroidWorld.copy(Z.centroid);Da.multiplyVector3(n.centroidWorld);n.centroidScreen.copy(n.centroidWorld);
P.multiplyVector3(n.centroidScreen);ra=Z.vertexNormals;N=0;for(ha=ra.length;N<ha;N++){na=n.vertexNormalsWorld[N];na.copy(ra[N]);$a.multiplyVector3(na)}N=0;for(ha=h.length;N<ha;N++)if(w=h[N][S]){ra=0;for(na=w.length;ra<na;ra++)n.uvs[N][ra]=w[ra]}n.meshMaterials=ab;n.faceMaterials=Z.materials;n.overdraw=Ia;n.z=n.centroidScreen.z;va.push(n)}}else if(xa instanceof THREE.Line){ka.multiply(P,Da);S=xa.geometry.vertices;N=a();N.positionScreen.copy(S[0].position);ka.multiplyVector4(N.positionScreen);ia=1;
for(Z=S.length;ia<Z;ia++){N=a();N.positionScreen.copy(S[ia].position);ka.multiplyVector4(N.positionScreen);ha=m[k-2];fa.copy(N.positionScreen);X.copy(ha.positionScreen);if(b(fa,X)){fa.multiplyScalar(1/fa.w);X.multiplyScalar(1/X.w);Da=I[H]=I[H]||new THREE.RenderableLine;H++;B=Da;B.v1.positionScreen.copy(fa);B.v2.positionScreen.copy(X);B.z=Math.max(fa.z,X.z);B.materials=xa.materials;va.push(B)}}}else if(xa instanceof THREE.Particle){R.set(xa.position.x,xa.position.y,xa.position.z,1);P.multiplyVector4(R);
R.z/=R.w;if(R.z>0&&R.z<1){Da=D[M]=D[M]||new THREE.RenderableParticle;M++;F=Da;F.x=R.x/R.w;F.y=R.y/R.w;F.z=R.z;F.rotation=xa.rotation.z;F.scale.x=xa.scale.x*Math.abs(F.x-(R.x+Y.projectionMatrix.n11)/(R.w+Y.projectionMatrix.n14));F.scale.y=xa.scale.y*Math.abs(F.y-(R.y+Y.projectionMatrix.n22)/(R.w+Y.projectionMatrix.n24));F.materials=xa.materials;va.push(F)}}}}ua&&va.sort(c);return va}};
THREE.DOMRenderer=function(){THREE.Renderer.call(this);var a=null,c=new THREE.Projector,b,e,f,g;this.domElement=document.createElement("div");this.setSize=function(j,k){b=j;e=k;f=b/2;g=e/2};this.render=function(j,k){var m,n,o,x,z,y,B,H;a=c.projectScene(j,k);m=0;for(n=a.length;m<n;m++){z=a[m];if(z instanceof THREE.RenderableParticle){B=z.x*f+f;H=z.y*g+g;o=0;for(x=z.material.length;o<x;o++){y=z.material[o];if(y instanceof THREE.ParticleDOMMaterial){y=y.domElement;y.style.left=B+"px";y.style.top=H+"px"}}}}}};
THREE.CanvasRenderer=function(){function a(U){if(z!=U)n.globalAlpha=z=U}function c(U){if(y!=U){switch(U){case THREE.NormalBlending:n.globalCompositeOperation="source-over";break;case THREE.AdditiveBlending:n.globalCompositeOperation="lighter";break;case THREE.SubtractiveBlending:n.globalCompositeOperation="darker"}y=U}}var b=null,e=new THREE.Projector,f=document.createElement("canvas"),g,j,k,m,n=f.getContext("2d"),o=new THREE.Color(0),x=0,z=1,y=0,B=null,H=null,I=1,F,M,D,Q,R=new THREE.RenderableVertex,
P=new THREE.RenderableVertex,ka,d,fa,X,ca,Y,ua,va,za,ma,W,ia,Z=new THREE.Color,S=new THREE.Color,N=new THREE.Color,ha=new THREE.Color,ra=new THREE.Color,na,qa,xa,Da,$a,ab,Ia,h,t,w,p=new THREE.Rectangle,C=new THREE.Rectangle,G=new THREE.Rectangle,J=!1,E=new THREE.Color,A=new THREE.Color,V=new THREE.Color,K=new THREE.Color,T=new THREE.Vector3,ja,pa,sa,Ba,ya,Fa,ea=16;ja=document.createElement("canvas");ja.width=ja.height=2;pa=ja.getContext("2d");pa.fillStyle="rgba(0,0,0,1)";pa.fillRect(0,0,2,2);sa=pa.getImageData(0,
0,2,2);Ba=sa.data;ya=document.createElement("canvas");ya.width=ya.height=ea;Fa=ya.getContext("2d");Fa.translate(-ea/2,-ea/2);Fa.scale(ea,ea);ea--;this.domElement=f;this.autoClear=!0;this.sortObjects=!0;this.sortElements=!0;this.setSize=function(U,la){g=U;j=la;k=g/2;m=j/2;f.width=g;f.height=j;p.set(-k,-m,k,m);z=1;y=0;H=B=null;I=1};this.setClearColor=function(U,la){o=U;x=la};this.setClearColorHex=function(U,la){o.setHex(U);x=la};this.clear=function(){n.setTransform(1,0,0,-1,k,m);if(!C.isEmpty()){C.inflate(1);
C.minSelf(p);if(o.hex==0&&x==0)n.clearRect(C.getX(),C.getY(),C.getWidth(),C.getHeight());else{c(THREE.NormalBlending);a(1);n.fillStyle="rgba("+Math.floor(o.r*255)+","+Math.floor(o.g*255)+","+Math.floor(o.b*255)+","+x+")";n.fillRect(C.getX(),C.getY(),C.getWidth(),C.getHeight())}C.empty()}};this.render=function(U,la){function Ma(L){var $,oa,da,ta=L.lights;A.setRGB(0,0,0);V.setRGB(0,0,0);K.setRGB(0,0,0);L=0;for($=ta.length;L<$;L++){oa=ta[L];da=oa.color;if(oa instanceof THREE.AmbientLight){A.r+=da.r;
A.g+=da.g;A.b+=da.b}else if(oa instanceof THREE.DirectionalLight){V.r+=da.r;V.g+=da.g;V.b+=da.b}else if(oa instanceof THREE.PointLight){K.r+=da.r;K.g+=da.g;K.b+=da.b}}}function Ha(L,$,oa,da){var ta,Aa,ga,aa,La=L.lights;L=0;for(ta=La.length;L<ta;L++){Aa=La[L];ga=Aa.color;aa=Aa.intensity;if(Aa instanceof THREE.DirectionalLight){Aa=oa.dot(Aa.position)*aa;if(Aa>0){da.r+=ga.r*Aa;da.g+=ga.g*Aa;da.b+=ga.b*Aa}}else if(Aa instanceof THREE.PointLight){T.sub(Aa.position,$);T.normalize();Aa=oa.dot(T)*aa;if(Aa>
0){da.r+=ga.r*Aa;da.g+=ga.g*Aa;da.b+=ga.b*Aa}}}}function fb(L,$,oa){a(oa.opacity);c(oa.blending);var da,ta,Aa,ga,aa,La;if(oa instanceof THREE.ParticleBasicMaterial){if(oa.map){ga=oa.map.image;aa=ga.width>>1;La=ga.height>>1;oa=$.scale.x*k;Aa=$.scale.y*m;da=oa*aa;ta=Aa*La;G.set(L.x-da,L.y-ta,L.x+da,L.y+ta);if(p.instersects(G)){n.save();n.translate(L.x,L.y);n.rotate(-$.rotation);n.scale(oa,-Aa);n.translate(-aa,-La);n.drawImage(ga,0,0);n.restore()}}}else if(oa instanceof THREE.ParticleCanvasMaterial){if(J){E.r=
A.r+V.r+K.r;E.g=A.g+V.g+K.g;E.b=A.b+V.b+K.b;Z.r=oa.color.r*E.r;Z.g=oa.color.g*E.g;Z.b=oa.color.b*E.b;Z.updateStyleString()}else Z.__styleString=oa.color.__styleString;da=$.scale.x*k;ta=$.scale.y*m;G.set(L.x-da,L.y-ta,L.x+da,L.y+ta);if(p.instersects(G)){n.save();n.translate(L.x,L.y);n.rotate(-$.rotation);n.scale(da,ta);oa.program(n,Z);n.restore()}}}function Ua(L,$,oa,da){a(da.opacity);c(da.blending);n.beginPath();n.moveTo(L.positionScreen.x,L.positionScreen.y);n.lineTo($.positionScreen.x,$.positionScreen.y);
n.closePath();if(da instanceof THREE.LineBasicMaterial){Z.__styleString=da.color.__styleString;L=da.linewidth;if(I!=L)n.lineWidth=I=L;L=Z.__styleString;if(B!=L)n.strokeStyle=B=L;n.stroke();G.inflate(da.linewidth*2)}}function Ja(L,$,oa,da,ta,Aa,ga,aa,La){a(aa.opacity);c(aa.blending);ka=L.positionScreen.x;d=L.positionScreen.y;fa=$.positionScreen.x;X=$.positionScreen.y;ca=oa.positionScreen.x;Y=oa.positionScreen.y;cb(ka,d,fa,X,ca,Y);if(aa instanceof THREE.MeshBasicMaterial)if(aa.map){if(aa.map.mapping instanceof
THREE.UVMapping){Da=ga.uvs[0];Ea(ka,d,fa,X,ca,Y,aa.map.image,Da[da].u,Da[da].v,Da[ta].u,Da[ta].v,Da[Aa].u,Da[Aa].v)}}else if(aa.envMap){if(aa.envMap.mapping instanceof THREE.SphericalReflectionMapping){L=la.matrixWorldInverse;T.copy(ga.vertexNormalsWorld[0]);$a=(T.x*L.n11+T.y*L.n12+T.z*L.n13)*0.5+0.5;ab=-(T.x*L.n21+T.y*L.n22+T.z*L.n23)*0.5+0.5;T.copy(ga.vertexNormalsWorld[1]);Ia=(T.x*L.n11+T.y*L.n12+T.z*L.n13)*0.5+0.5;h=-(T.x*L.n21+T.y*L.n22+T.z*L.n23)*0.5+0.5;T.copy(ga.vertexNormalsWorld[2]);t=(T.x*
L.n11+T.y*L.n12+T.z*L.n13)*0.5+0.5;w=-(T.x*L.n21+T.y*L.n22+T.z*L.n23)*0.5+0.5;Ea(ka,d,fa,X,ca,Y,aa.envMap.image,$a,ab,Ia,h,t,w)}}else aa.wireframe?Qa(aa.color.__styleString,aa.wireframeLinewidth):Va(aa.color.__styleString);else if(aa instanceof THREE.MeshLambertMaterial){if(aa.map&&!aa.wireframe){if(aa.map.mapping instanceof THREE.UVMapping){Da=ga.uvs[0];Ea(ka,d,fa,X,ca,Y,aa.map.image,Da[da].u,Da[da].v,Da[ta].u,Da[ta].v,Da[Aa].u,Da[Aa].v)}c(THREE.SubtractiveBlending)}if(J)if(!aa.wireframe&&aa.shading==
THREE.SmoothShading&&ga.vertexNormalsWorld.length==3){S.r=N.r=ha.r=A.r;S.g=N.g=ha.g=A.g;S.b=N.b=ha.b=A.b;Ha(La,ga.v1.positionWorld,ga.vertexNormalsWorld[0],S);Ha(La,ga.v2.positionWorld,ga.vertexNormalsWorld[1],N);Ha(La,ga.v3.positionWorld,ga.vertexNormalsWorld[2],ha);ra.r=(N.r+ha.r)*0.5;ra.g=(N.g+ha.g)*0.5;ra.b=(N.b+ha.b)*0.5;xa=Wa(S,N,ha,ra);Ea(ka,d,fa,X,ca,Y,xa,0,0,1,0,0,1)}else{E.r=A.r;E.g=A.g;E.b=A.b;Ha(La,ga.centroidWorld,ga.normalWorld,E);Z.r=aa.color.r*E.r;Z.g=aa.color.g*E.g;Z.b=aa.color.b*
E.b;Z.updateStyleString();aa.wireframe?Qa(Z.__styleString,aa.wireframeLinewidth):Va(Z.__styleString)}else aa.wireframe?Qa(aa.color.__styleString,aa.wireframeLinewidth):Va(aa.color.__styleString)}else if(aa instanceof THREE.MeshDepthMaterial){na=la.near;qa=la.far;S.r=S.g=S.b=1-Na(L.positionScreen.z,na,qa);N.r=N.g=N.b=1-Na($.positionScreen.z,na,qa);ha.r=ha.g=ha.b=1-Na(oa.positionScreen.z,na,qa);ra.r=(N.r+ha.r)*0.5;ra.g=(N.g+ha.g)*0.5;ra.b=(N.b+ha.b)*0.5;xa=Wa(S,N,ha,ra);Ea(ka,d,fa,X,ca,Y,xa,0,0,1,0,
0,1)}else if(aa instanceof THREE.MeshNormalMaterial){Z.r=O(ga.normalWorld.x);Z.g=O(ga.normalWorld.y);Z.b=O(ga.normalWorld.z);Z.updateStyleString();aa.wireframe?Qa(Z.__styleString,aa.wireframeLinewidth):Va(Z.__styleString)}}function Sa(L,$,oa,da,ta,Aa,ga,aa,La){a(aa.opacity);c(aa.blending);if(aa.map||aa.envMap){Ja(L,$,da,0,1,3,ga,aa,La);Ja(ta,oa,Aa,1,2,3,ga,aa,La)}else{ka=L.positionScreen.x;d=L.positionScreen.y;fa=$.positionScreen.x;X=$.positionScreen.y;ca=oa.positionScreen.x;Y=oa.positionScreen.y;
ua=da.positionScreen.x;va=da.positionScreen.y;za=ta.positionScreen.x;ma=ta.positionScreen.y;W=Aa.positionScreen.x;ia=Aa.positionScreen.y;if(aa instanceof THREE.MeshBasicMaterial){eb(ka,d,fa,X,ca,Y,ua,va);aa.wireframe?Qa(aa.color.__styleString,aa.wireframeLinewidth):Va(aa.color.__styleString)}else if(aa instanceof THREE.MeshLambertMaterial)if(J)if(!aa.wireframe&&aa.shading==THREE.SmoothShading&&ga.vertexNormalsWorld.length==4){S.r=N.r=ha.r=ra.r=A.r;S.g=N.g=ha.g=ra.g=A.g;S.b=N.b=ha.b=ra.b=A.b;Ha(La,
ga.v1.positionWorld,ga.vertexNormalsWorld[0],S);Ha(La,ga.v2.positionWorld,ga.vertexNormalsWorld[1],N);Ha(La,ga.v4.positionWorld,ga.vertexNormalsWorld[3],ha);Ha(La,ga.v3.positionWorld,ga.vertexNormalsWorld[2],ra);xa=Wa(S,N,ha,ra);cb(ka,d,fa,X,ua,va);Ea(ka,d,fa,X,ua,va,xa,0,0,1,0,0,1);cb(za,ma,ca,Y,W,ia);Ea(za,ma,ca,Y,W,ia,xa,1,0,1,1,0,1)}else{E.r=A.r;E.g=A.g;E.b=A.b;Ha(La,ga.centroidWorld,ga.normalWorld,E);Z.r=aa.color.r*E.r;Z.g=aa.color.g*E.g;Z.b=aa.color.b*E.b;Z.updateStyleString();eb(ka,d,fa,X,
ca,Y,ua,va);aa.wireframe?Qa(Z.__styleString,aa.wireframeLinewidth):Va(Z.__styleString)}else{eb(ka,d,fa,X,ca,Y,ua,va);aa.wireframe?Qa(aa.color.__styleString,aa.wireframeLinewidth):Va(aa.color.__styleString)}else if(aa instanceof THREE.MeshNormalMaterial){Z.r=O(ga.normalWorld.x);Z.g=O(ga.normalWorld.y);Z.b=O(ga.normalWorld.z);Z.updateStyleString();eb(ka,d,fa,X,ca,Y,ua,va);aa.wireframe?Qa(Z.__styleString,aa.wireframeLinewidth):Va(Z.__styleString)}else if(aa instanceof THREE.MeshDepthMaterial){na=la.near;
qa=la.far;S.r=S.g=S.b=1-Na(L.positionScreen.z,na,qa);N.r=N.g=N.b=1-Na($.positionScreen.z,na,qa);ha.r=ha.g=ha.b=1-Na(da.positionScreen.z,na,qa);ra.r=ra.g=ra.b=1-Na(oa.positionScreen.z,na,qa);xa=Wa(S,N,ha,ra);cb(ka,d,fa,X,ua,va);Ea(ka,d,fa,X,ua,va,xa,0,0,1,0,0,1);cb(za,ma,ca,Y,W,ia);Ea(za,ma,ca,Y,W,ia,xa,1,0,1,1,0,1)}}}function cb(L,$,oa,da,ta,Aa){n.beginPath();n.moveTo(L,$);n.lineTo(oa,da);n.lineTo(ta,Aa);n.lineTo(L,$);n.closePath()}function eb(L,$,oa,da,ta,Aa,ga,aa){n.beginPath();n.moveTo(L,$);n.lineTo(oa,
da);n.lineTo(ta,Aa);n.lineTo(ga,aa);n.lineTo(L,$);n.closePath()}function Qa(L,$){if(B!=L)n.strokeStyle=B=L;if(I!=$)n.lineWidth=I=$;n.stroke();G.inflate($*2)}function Va(L){if(H!=L)n.fillStyle=H=L;n.fill()}function Ea(L,$,oa,da,ta,Aa,ga,aa,La,Ya,Za,db,hb){var bb,Xa;bb=ga.width-1;Xa=ga.height-1;aa*=bb;La*=Xa;Ya*=bb;Za*=Xa;db*=bb;hb*=Xa;oa-=L;da-=$;ta-=L;Aa-=$;Ya-=aa;Za-=La;db-=aa;hb-=La;bb=Ya*hb-db*Za;if(bb!=0){Xa=1/bb;bb=(hb*oa-Za*ta)*Xa;Za=(hb*da-Za*Aa)*Xa;oa=(Ya*ta-db*oa)*Xa;da=(Ya*Aa-db*da)*Xa;
L=L-bb*aa-oa*La;$=$-Za*aa-da*La;n.save();n.transform(bb,Za,oa,da,L,$);n.clip();n.drawImage(ga,0,0);n.restore()}}function Wa(L,$,oa,da){var ta=~~(L.r*255),Aa=~~(L.g*255);L=~~(L.b*255);var ga=~~($.r*255),aa=~~($.g*255);$=~~($.b*255);var La=~~(oa.r*255),Ya=~~(oa.g*255);oa=~~(oa.b*255);var Za=~~(da.r*255),db=~~(da.g*255);da=~~(da.b*255);Ba[0]=ta<0?0:ta>255?255:ta;Ba[1]=Aa<0?0:Aa>255?255:Aa;Ba[2]=L<0?0:L>255?255:L;Ba[4]=ga<0?0:ga>255?255:ga;Ba[5]=aa<0?0:aa>255?255:aa;Ba[6]=$<0?0:$>255?255:$;Ba[8]=La<0?
0:La>255?255:La;Ba[9]=Ya<0?0:Ya>255?255:Ya;Ba[10]=oa<0?0:oa>255?255:oa;Ba[12]=Za<0?0:Za>255?255:Za;Ba[13]=db<0?0:db>255?255:db;Ba[14]=da<0?0:da>255?255:da;pa.putImageData(sa,0,0);Fa.drawImage(ja,0,0);return ya}function Na(L,$,oa){L=(L-$)/(oa-$);return L*L*(3-2*L)}function O(L){L=(L+1)*0.5;return L<0?0:L>1?1:L}function Oa(L,$){var oa=$.x-L.x,da=$.y-L.y,ta=1/Math.sqrt(oa*oa+da*da);oa*=ta;da*=ta;$.x+=oa;$.y+=da;L.x-=oa;L.y-=da}var Ra,jb,Ca,Ta,Ga,Pa,Ka,wa;this.autoClear?this.clear():n.setTransform(1,
0,0,-1,k,m);b=e.projectScene(U,la,this.sortElements);(J=U.lights.length>0)&&Ma(U);Ra=0;for(jb=b.length;Ra<jb;Ra++){Ca=b[Ra];G.empty();if(Ca instanceof THREE.RenderableParticle){F=Ca;F.x*=k;F.y*=m;Ta=0;for(Ga=Ca.materials.length;Ta<Ga;){wa=Ca.materials[Ta++];wa.opacity!=0&&fb(F,Ca,wa,U)}}else if(Ca instanceof THREE.RenderableLine){F=Ca.v1;M=Ca.v2;F.positionScreen.x*=k;F.positionScreen.y*=m;M.positionScreen.x*=k;M.positionScreen.y*=m;G.addPoint(F.positionScreen.x,F.positionScreen.y);G.addPoint(M.positionScreen.x,
M.positionScreen.y);if(p.instersects(G)){Ta=0;for(Ga=Ca.materials.length;Ta<Ga;){wa=Ca.materials[Ta++];wa.opacity!=0&&Ua(F,M,Ca,wa,U)}}}else if(Ca instanceof THREE.RenderableFace3){F=Ca.v1;M=Ca.v2;D=Ca.v3;F.positionScreen.x*=k;F.positionScreen.y*=m;M.positionScreen.x*=k;M.positionScreen.y*=m;D.positionScreen.x*=k;D.positionScreen.y*=m;if(Ca.overdraw){Oa(F.positionScreen,M.positionScreen);Oa(M.positionScreen,D.positionScreen);Oa(D.positionScreen,F.positionScreen)}G.add3Points(F.positionScreen.x,F.positionScreen.y,
M.positionScreen.x,M.positionScreen.y,D.positionScreen.x,D.positionScreen.y);if(p.instersects(G)){Ta=0;for(Ga=Ca.meshMaterials.length;Ta<Ga;){wa=Ca.meshMaterials[Ta++];if(wa instanceof THREE.MeshFaceMaterial){Pa=0;for(Ka=Ca.faceMaterials.length;Pa<Ka;)(wa=Ca.faceMaterials[Pa++])&&wa.opacity!=0&&Ja(F,M,D,0,1,2,Ca,wa,U)}else wa.opacity!=0&&Ja(F,M,D,0,1,2,Ca,wa,U)}}}else if(Ca instanceof THREE.RenderableFace4){F=Ca.v1;M=Ca.v2;D=Ca.v3;Q=Ca.v4;F.positionScreen.x*=k;F.positionScreen.y*=m;M.positionScreen.x*=
k;M.positionScreen.y*=m;D.positionScreen.x*=k;D.positionScreen.y*=m;Q.positionScreen.x*=k;Q.positionScreen.y*=m;R.positionScreen.copy(M.positionScreen);P.positionScreen.copy(Q.positionScreen);if(Ca.overdraw){Oa(F.positionScreen,M.positionScreen);Oa(M.positionScreen,Q.positionScreen);Oa(Q.positionScreen,F.positionScreen);Oa(D.positionScreen,R.positionScreen);Oa(D.positionScreen,P.positionScreen)}G.addPoint(F.positionScreen.x,F.positionScreen.y);G.addPoint(M.positionScreen.x,M.positionScreen.y);G.addPoint(D.positionScreen.x,
D.positionScreen.y);G.addPoint(Q.positionScreen.x,Q.positionScreen.y);if(p.instersects(G)){Ta=0;for(Ga=Ca.meshMaterials.length;Ta<Ga;){wa=Ca.meshMaterials[Ta++];if(wa instanceof THREE.MeshFaceMaterial){Pa=0;for(Ka=Ca.faceMaterials.length;Pa<Ka;)(wa=Ca.faceMaterials[Pa++])&&wa.opacity!=0&&Sa(F,M,D,Q,R,P,Ca,wa,U)}else wa.opacity!=0&&Sa(F,M,D,Q,R,P,Ca,wa,U)}}}C.addRectangle(G)}n.setTransform(1,0,0,1,0,0)}};
THREE.SVGRenderer=function(){function a(ma,W,ia){var Z,S,N,ha;Z=0;for(S=ma.lights.length;Z<S;Z++){N=ma.lights[Z];if(N instanceof THREE.DirectionalLight){ha=W.normalWorld.dot(N.position)*N.intensity;if(ha>0){ia.r+=N.color.r*ha;ia.g+=N.color.g*ha;ia.b+=N.color.b*ha}}else if(N instanceof THREE.PointLight){fa.sub(N.position,W.centroidWorld);fa.normalize();ha=W.normalWorld.dot(fa)*N.intensity;if(ha>0){ia.r+=N.color.r*ha;ia.g+=N.color.g*ha;ia.b+=N.color.b*ha}}}}function c(ma,W,ia,Z,S,N){Y=e(ua++);Y.setAttribute("d",
"M "+ma.positionScreen.x+" "+ma.positionScreen.y+" L "+W.positionScreen.x+" "+W.positionScreen.y+" L "+ia.positionScreen.x+","+ia.positionScreen.y+"z");if(S instanceof THREE.MeshBasicMaterial)D.__styleString=S.color.__styleString;else if(S instanceof THREE.MeshLambertMaterial)if(M){Q.r=R.r;Q.g=R.g;Q.b=R.b;a(N,Z,Q);D.r=S.color.r*Q.r;D.g=S.color.g*Q.g;D.b=S.color.b*Q.b;D.updateStyleString()}else D.__styleString=S.color.__styleString;else if(S instanceof THREE.MeshDepthMaterial){d=1-S.__2near/(S.__farPlusNear-
Z.z*S.__farMinusNear);D.setRGB(d,d,d)}else S instanceof THREE.MeshNormalMaterial&&D.setRGB(f(Z.normalWorld.x),f(Z.normalWorld.y),f(Z.normalWorld.z));S.wireframe?Y.setAttribute("style","fill: none; stroke: "+D.__styleString+"; stroke-width: "+S.wireframeLinewidth+"; stroke-opacity: "+S.opacity+"; stroke-linecap: "+S.wireframeLinecap+"; stroke-linejoin: "+S.wireframeLinejoin):Y.setAttribute("style","fill: "+D.__styleString+"; fill-opacity: "+S.opacity);k.appendChild(Y)}function b(ma,W,ia,Z,S,N,ha){Y=
e(ua++);Y.setAttribute("d","M "+ma.positionScreen.x+" "+ma.positionScreen.y+" L "+W.positionScreen.x+" "+W.positionScreen.y+" L "+ia.positionScreen.x+","+ia.positionScreen.y+" L "+Z.positionScreen.x+","+Z.positionScreen.y+"z");if(N instanceof THREE.MeshBasicMaterial)D.__styleString=N.color.__styleString;else if(N instanceof THREE.MeshLambertMaterial)if(M){Q.r=R.r;Q.g=R.g;Q.b=R.b;a(ha,S,Q);D.r=N.color.r*Q.r;D.g=N.color.g*Q.g;D.b=N.color.b*Q.b;D.updateStyleString()}else D.__styleString=N.color.__styleString;
else if(N instanceof THREE.MeshDepthMaterial){d=1-N.__2near/(N.__farPlusNear-S.z*N.__farMinusNear);D.setRGB(d,d,d)}else N instanceof THREE.MeshNormalMaterial&&D.setRGB(f(S.normalWorld.x),f(S.normalWorld.y),f(S.normalWorld.z));N.wireframe?Y.setAttribute("style","fill: none; stroke: "+D.__styleString+"; stroke-width: "+N.wireframeLinewidth+"; stroke-opacity: "+N.opacity+"; stroke-linecap: "+N.wireframeLinecap+"; stroke-linejoin: "+N.wireframeLinejoin):Y.setAttribute("style","fill: "+D.__styleString+
"; fill-opacity: "+N.opacity);k.appendChild(Y)}function e(ma){if(X[ma]==null){X[ma]=document.createElementNS("http://www.w3.org/2000/svg","path");za==0&&X[ma].setAttribute("shape-rendering","crispEdges")}return X[ma]}function f(ma){return ma<0?Math.min((1+ma)*0.5,0.5):0.5+Math.min(ma*0.5,0.5)}var g=null,j=new THREE.Projector,k=document.createElementNS("http://www.w3.org/2000/svg","svg"),m,n,o,x,z,y,B,H,I=new THREE.Rectangle,F=new THREE.Rectangle,M=!1,D=new THREE.Color(16777215),Q=new THREE.Color(16777215),
R=new THREE.Color(0),P=new THREE.Color(0),ka=new THREE.Color(0),d,fa=new THREE.Vector3,X=[],ca=[],Y,ua,va,za=1;this.domElement=k;this.autoClear=!0;this.sortObjects=!0;this.sortElements=!0;this.setQuality=function(ma){switch(ma){case "high":za=1;break;case "low":za=0}};this.setSize=function(ma,W){m=ma;n=W;o=m/2;x=n/2;k.setAttribute("viewBox",-o+" "+-x+" "+m+" "+n);k.setAttribute("width",m);k.setAttribute("height",n);I.set(-o,-x,o,x)};this.clear=function(){for(;k.childNodes.length>0;)k.removeChild(k.childNodes[0])};
this.render=function(ma,W){var ia,Z,S,N,ha,ra,na,qa;this.autoClear&&this.clear();g=j.projectScene(ma,W,this.sortElements);va=ua=0;if(M=ma.lights.length>0){na=ma.lights;R.setRGB(0,0,0);P.setRGB(0,0,0);ka.setRGB(0,0,0);ia=0;for(Z=na.length;ia<Z;ia++){S=na[ia];N=S.color;if(S instanceof THREE.AmbientLight){R.r+=N.r;R.g+=N.g;R.b+=N.b}else if(S instanceof THREE.DirectionalLight){P.r+=N.r;P.g+=N.g;P.b+=N.b}else if(S instanceof THREE.PointLight){ka.r+=N.r;ka.g+=N.g;ka.b+=N.b}}}ia=0;for(Z=g.length;ia<Z;ia++){na=
g[ia];F.empty();if(na instanceof THREE.RenderableParticle){z=na;z.x*=o;z.y*=-x;S=0;for(N=na.materials.length;S<N;)S++}else if(na instanceof THREE.RenderableLine){z=na.v1;y=na.v2;z.positionScreen.x*=o;z.positionScreen.y*=-x;y.positionScreen.x*=o;y.positionScreen.y*=-x;F.addPoint(z.positionScreen.x,z.positionScreen.y);F.addPoint(y.positionScreen.x,y.positionScreen.y);if(I.instersects(F)){S=0;for(N=na.materials.length;S<N;)if((qa=na.materials[S++])&&qa.opacity!=0){ha=z;ra=y;var xa=va++;if(ca[xa]==null){ca[xa]=
document.createElementNS("http://www.w3.org/2000/svg","line");za==0&&ca[xa].setAttribute("shape-rendering","crispEdges")}Y=ca[xa];Y.setAttribute("x1",ha.positionScreen.x);Y.setAttribute("y1",ha.positionScreen.y);Y.setAttribute("x2",ra.positionScreen.x);Y.setAttribute("y2",ra.positionScreen.y);if(qa instanceof THREE.LineBasicMaterial){D.__styleString=qa.color.__styleString;Y.setAttribute("style","fill: none; stroke: "+D.__styleString+"; stroke-width: "+qa.linewidth+"; stroke-opacity: "+qa.opacity+
"; stroke-linecap: "+qa.linecap+"; stroke-linejoin: "+qa.linejoin);k.appendChild(Y)}}}}else if(na instanceof THREE.RenderableFace3){z=na.v1;y=na.v2;B=na.v3;z.positionScreen.x*=o;z.positionScreen.y*=-x;y.positionScreen.x*=o;y.positionScreen.y*=-x;B.positionScreen.x*=o;B.positionScreen.y*=-x;F.addPoint(z.positionScreen.x,z.positionScreen.y);F.addPoint(y.positionScreen.x,y.positionScreen.y);F.addPoint(B.positionScreen.x,B.positionScreen.y);if(I.instersects(F)){S=0;for(N=na.meshMaterials.length;S<N;){qa=
na.meshMaterials[S++];if(qa instanceof THREE.MeshFaceMaterial){ha=0;for(ra=na.faceMaterials.length;ha<ra;)(qa=na.faceMaterials[ha++])&&qa.opacity!=0&&c(z,y,B,na,qa,ma)}else qa&&qa.opacity!=0&&c(z,y,B,na,qa,ma)}}}else if(na instanceof THREE.RenderableFace4){z=na.v1;y=na.v2;B=na.v3;H=na.v4;z.positionScreen.x*=o;z.positionScreen.y*=-x;y.positionScreen.x*=o;y.positionScreen.y*=-x;B.positionScreen.x*=o;B.positionScreen.y*=-x;H.positionScreen.x*=o;H.positionScreen.y*=-x;F.addPoint(z.positionScreen.x,z.positionScreen.y);
F.addPoint(y.positionScreen.x,y.positionScreen.y);F.addPoint(B.positionScreen.x,B.positionScreen.y);F.addPoint(H.positionScreen.x,H.positionScreen.y);if(I.instersects(F)){S=0;for(N=na.meshMaterials.length;S<N;){qa=na.meshMaterials[S++];if(qa instanceof THREE.MeshFaceMaterial){ha=0;for(ra=na.faceMaterials.length;ha<ra;)(qa=na.faceMaterials[ha++])&&qa.opacity!=0&&b(z,y,B,H,na,qa,ma)}else qa&&qa.opacity!=0&&b(z,y,B,H,na,qa,ma)}}}}}};
THREE.ShaderChunk={fog_pars_fragment:"#ifdef USE_FOG\nuniform vec3 fogColor;\n#ifdef FOG_EXP2\nuniform float fogDensity;\n#else\nuniform float fogNear;\nuniform float fogFar;\n#endif\n#endif",fog_fragment:"#ifdef USE_FOG\nfloat depth = gl_FragCoord.z / gl_FragCoord.w;\n#ifdef FOG_EXP2\nconst float LOG2 = 1.442695;\nfloat fogFactor = exp2( - fogDensity * fogDensity * depth * depth * LOG2 );\nfogFactor = 1.0 - clamp( fogFactor, 0.0, 1.0 );\n#else\nfloat fogFactor = smoothstep( fogNear, fogFar, depth );\n#endif\ngl_FragColor = mix( gl_FragColor, vec4( fogColor, gl_FragColor.w ), fogFactor );\n#endif",
envmap_pars_fragment:"#ifdef USE_ENVMAP\nvarying vec3 vReflect;\nuniform float reflectivity;\nuniform samplerCube envMap;\nuniform int combine;\n#endif",envmap_fragment:"#ifdef USE_ENVMAP\nvec4 cubeColor = textureCube( envMap, vec3( -vReflect.x, vReflect.yz ) );\nif ( combine == 1 ) {\ngl_FragColor = vec4( mix( gl_FragColor.xyz, cubeColor.xyz, reflectivity ), opacity );\n} else {\ngl_FragColor = gl_FragColor * cubeColor;\n}\n#endif",envmap_pars_vertex:"#ifdef USE_ENVMAP\nvarying vec3 vReflect;\nuniform float refractionRatio;\nuniform bool useRefract;\n#endif",
envmap_vertex:"#ifdef USE_ENVMAP\nvec4 mPosition = objectMatrix * vec4( position, 1.0 );\nvec3 nWorld = mat3( objectMatrix[0].xyz, objectMatrix[1].xyz, objectMatrix[2].xyz ) * normal;\nif ( useRefract ) {\nvReflect = refract( normalize( mPosition.xyz - cameraPosition ), normalize( nWorld.xyz ), refractionRatio );\n} else {\nvReflect = reflect( normalize( mPosition.xyz - cameraPosition ), normalize( nWorld.xyz ) );\n}\n#endif",map_particle_pars_fragment:"#ifdef USE_MAP\nuniform sampler2D map;\n#endif",
map_particle_fragment:"#ifdef USE_MAP\ngl_FragColor = gl_FragColor * texture2D( map, gl_PointCoord );\n#endif",map_pars_fragment:"#ifdef USE_MAP\nvarying vec2 vUv;\nuniform sampler2D map;\n#endif",map_pars_vertex:"#ifdef USE_MAP\nvarying vec2 vUv;\n#endif",map_fragment:"#ifdef USE_MAP\ngl_FragColor = gl_FragColor * texture2D( map, vUv );\n#endif",map_vertex:"#ifdef USE_MAP\nvUv = uv;\n#endif",lightmap_pars_fragment:"#ifdef USE_LIGHTMAP\nvarying vec2 vUv2;\nuniform sampler2D lightMap;\n#endif",lightmap_pars_vertex:"#ifdef USE_LIGHTMAP\nvarying vec2 vUv2;\n#endif",
lightmap_fragment:"#ifdef USE_LIGHTMAP\ngl_FragColor = gl_FragColor * texture2D( lightMap, vUv2 );\n#endif",lightmap_vertex:"#ifdef USE_LIGHTMAP\nvUv2 = uv2;\n#endif",lights_pars_vertex:"uniform bool enableLighting;\nuniform vec3 ambientLightColor;\n#if MAX_DIR_LIGHTS > 0\nuniform vec3 directionalLightColor[ MAX_DIR_LIGHTS ];\nuniform vec3 directionalLightDirection[ MAX_DIR_LIGHTS ];\n#endif\n#if MAX_POINT_LIGHTS > 0\nuniform vec3 pointLightColor[ MAX_POINT_LIGHTS ];\nuniform vec3 pointLightPosition[ MAX_POINT_LIGHTS ];\n#ifdef PHONG\nvarying vec3 vPointLightVector[ MAX_POINT_LIGHTS ];\n#endif\n#endif",
lights_vertex:"if ( !enableLighting ) {\nvLightWeighting = vec3( 1.0 );\n} else {\nvLightWeighting = ambientLightColor;\n#if MAX_DIR_LIGHTS > 0\nfor( int i = 0; i < MAX_DIR_LIGHTS; i++ ) {\nvec4 lDirection = viewMatrix * vec4( directionalLightDirection[ i ], 0.0 );\nfloat directionalLightWeighting = max( dot( transformedNormal, normalize( lDirection.xyz ) ), 0.0 );\nvLightWeighting += directionalLightColor[ i ] * directionalLightWeighting;\n}\n#endif\n#if MAX_POINT_LIGHTS > 0\nfor( int i = 0; i < MAX_POINT_LIGHTS; i++ ) {\nvec4 lPosition = viewMatrix * vec4( pointLightPosition[ i ], 1.0 );\nvec3 pointLightVector = normalize( lPosition.xyz - mvPosition.xyz );\nfloat pointLightWeighting = max( dot( transformedNormal, pointLightVector ), 0.0 );\nvLightWeighting += pointLightColor[ i ] * pointLightWeighting;\n#ifdef PHONG\nvPointLightVector[ i ] = pointLightVector;\n#endif\n}\n#endif\n}",
lights_pars_fragment:"#if MAX_DIR_LIGHTS > 0\nuniform vec3 directionalLightDirection[ MAX_DIR_LIGHTS ];\n#endif\n#if MAX_POINT_LIGHTS > 0\nvarying vec3 vPointLightVector[ MAX_POINT_LIGHTS ];\n#endif\nvarying vec3 vViewPosition;\nvarying vec3 vNormal;",lights_fragment:"vec3 normal = normalize( vNormal );\nvec3 viewPosition = normalize( vViewPosition );\nvec4 mColor = vec4( diffuse, opacity );\nvec4 mSpecular = vec4( specular, opacity );\n#if MAX_POINT_LIGHTS > 0\nvec4 pointDiffuse  = vec4( 0.0 );\nvec4 pointSpecular = vec4( 0.0 );\nfor( int i = 0; i < MAX_POINT_LIGHTS; i++ ) {\nvec3 pointVector = normalize( vPointLightVector[ i ] );\nvec3 pointHalfVector = normalize( vPointLightVector[ i ] + vViewPosition );\nfloat pointDotNormalHalf = dot( normal, pointHalfVector );\nfloat pointDiffuseWeight = max( dot( normal, pointVector ), 0.0 );\nfloat pointSpecularWeight = 0.0;\nif ( pointDotNormalHalf >= 0.0 )\npointSpecularWeight = pow( pointDotNormalHalf, shininess );\npointDiffuse  += mColor * pointDiffuseWeight;\npointSpecular += mSpecular * pointSpecularWeight;\n}\n#endif\n#if MAX_DIR_LIGHTS > 0\nvec4 dirDiffuse  = vec4( 0.0 );\nvec4 dirSpecular = vec4( 0.0 );\nfor( int i = 0; i < MAX_DIR_LIGHTS; i++ ) {\nvec4 lDirection = viewMatrix * vec4( directionalLightDirection[ i ], 0.0 );\nvec3 dirVector = normalize( lDirection.xyz );\nvec3 dirHalfVector = normalize( lDirection.xyz + vViewPosition );\nfloat dirDotNormalHalf = dot( normal, dirHalfVector );\nfloat dirDiffuseWeight = max( dot( normal, dirVector ), 0.0 );\nfloat dirSpecularWeight = 0.0;\nif ( dirDotNormalHalf >= 0.0 )\ndirSpecularWeight = pow( dirDotNormalHalf, shininess );\ndirDiffuse  += mColor * dirDiffuseWeight;\ndirSpecular += mSpecular * dirSpecularWeight;\n}\n#endif\nvec4 totalLight = vec4( ambient, opacity );\n#if MAX_DIR_LIGHTS > 0\ntotalLight += dirDiffuse + dirSpecular;\n#endif\n#if MAX_POINT_LIGHTS > 0\ntotalLight += pointDiffuse + pointSpecular;\n#endif\ngl_FragColor = gl_FragColor * totalLight;",
color_pars_fragment:"#ifdef USE_COLOR\nvarying vec3 vColor;\n#endif",color_fragment:"#ifdef USE_COLOR\ngl_FragColor = gl_FragColor * vec4( vColor, opacity );\n#endif",color_pars_vertex:"#ifdef USE_COLOR\nvarying vec3 vColor;\n#endif",color_vertex:"#ifdef USE_COLOR\nvColor = color;\n#endif",skinning_pars_vertex:"#ifdef USE_SKINNING\nuniform mat4 boneGlobalMatrices[ MAX_BONES ];\n#endif",skinning_vertex:"#ifdef USE_SKINNING\ngl_Position  = ( boneGlobalMatrices[ int( skinIndex.x ) ] * skinVertexA ) * skinWeight.x;\ngl_Position += ( boneGlobalMatrices[ int( skinIndex.y ) ] * skinVertexB ) * skinWeight.y;\ngl_Position  = projectionMatrix * viewMatrix * objectMatrix * gl_Position;\n#endif",
morphtarget_pars_vertex:"#ifdef USE_MORPHTARGETS\nuniform float morphTargetInfluences[ 8 ];\n#endif",morphtarget_vertex:"#ifdef USE_MORPHTARGETS\nvec3 morphed = vec3( 0.0, 0.0, 0.0 );\nmorphed += ( morphTarget0 - position ) * morphTargetInfluences[ 0 ];\nmorphed += ( morphTarget1 - position ) * morphTargetInfluences[ 1 ];\nmorphed += ( morphTarget2 - position ) * morphTargetInfluences[ 2 ];\nmorphed += ( morphTarget3 - position ) * morphTargetInfluences[ 3 ];\nmorphed += ( morphTarget4 - position ) * morphTargetInfluences[ 4 ];\nmorphed += ( morphTarget5 - position ) * morphTargetInfluences[ 5 ];\nmorphed += ( morphTarget6 - position ) * morphTargetInfluences[ 6 ];\nmorphed += ( morphTarget7 - position ) * morphTargetInfluences[ 7 ];\nmorphed += position;\ngl_Position = projectionMatrix * modelViewMatrix * vec4( morphed, 1.0 );\n#endif",
default_vertex:"#ifndef USE_MORPHTARGETS\n#ifndef USE_SKINNING\ngl_Position = projectionMatrix * mvPosition;\n#endif\n#endif"};
THREE.UniformsLib={common:{diffuse:{type:"c",value:new THREE.Color(15658734)},opacity:{type:"f",value:1},map:{type:"t",value:0,texture:null},lightMap:{type:"t",value:2,texture:null},envMap:{type:"t",value:1,texture:null},useRefract:{type:"i",value:0},reflectivity:{type:"f",value:1},refractionRatio:{type:"f",value:0.98},combine:{type:"i",value:0},fogDensity:{type:"f",value:2.5E-4},fogNear:{type:"f",value:1},fogFar:{type:"f",value:2E3},fogColor:{type:"c",value:new THREE.Color(16777215)},morphTargetInfluences:{type:"f",
value:0}},lights:{enableLighting:{type:"i",value:1},ambientLightColor:{type:"fv",value:[]},directionalLightDirection:{type:"fv",value:[]},directionalLightColor:{type:"fv",value:[]},pointLightPosition:{type:"fv",value:[]},pointLightColor:{type:"fv",value:[]}},particle:{psColor:{type:"c",value:new THREE.Color(15658734)},opacity:{type:"f",value:1},size:{type:"f",value:1},scale:{type:"f",value:1},map:{type:"t",value:0,texture:null},fogDensity:{type:"f",value:2.5E-4},fogNear:{type:"f",value:1},fogFar:{type:"f",
value:2E3},fogColor:{type:"c",value:new THREE.Color(16777215)}}};
THREE.ShaderLib={shadowPost:{vertexShader:"uniform \tmat4 \tprojectionMatrix;\nattribute \tvec3 \tposition;\nvoid main(void)\n{\ngl_Position = projectionMatrix * vec4( position, 1.0 );\n}",fragmentShader:"#ifdef GL_ES\nprecision highp float;\n#endif\nvoid main( void )\n{\ngl_FragColor = vec4( 0, 0, 0, 0.5 );\n}"},shadowVolumeDynamic:{uniforms:{directionalLightDirection:{type:"fv",value:[]}},vertexShader:"uniform \tvec3 \tdirectionalLightDirection;\nvoid main() {\nvec4 pos      = objectMatrix * vec4( position, 1.0 );\nvec3 norm     = mat3( objectMatrix[0].xyz, objectMatrix[1].xyz, objectMatrix[2].xyz ) * normal;\nvec4 extruded = vec4( directionalLightDirection * 5000.0 * step( 0.0, dot( directionalLightDirection, norm )), 0.0 );\ngl_Position   = projectionMatrix * viewMatrix * ( pos + extruded );\n}",fragmentShader:"void main() {\ngl_FragColor = vec4( 1, 1, 1, 1 );\n}"},
depth:{uniforms:{mNear:{type:"f",value:1},mFar:{type:"f",value:2E3},opacity:{type:"f",value:1}},fragmentShader:"uniform float mNear;\nuniform float mFar;\nuniform float opacity;\nvoid main() {\nfloat depth = gl_FragCoord.z / gl_FragCoord.w;\nfloat color = 1.0 - smoothstep( mNear, mFar, depth );\ngl_FragColor = vec4( vec3( color ), opacity );\n}",vertexShader:"void main() {\ngl_Position = projectionMatrix * modelViewMatrix * vec4( position, 1.0 );\n}"},normal:{uniforms:{opacity:{type:"f",value:1}},
fragmentShader:"uniform float opacity;\nvarying vec3 vNormal;\nvoid main() {\ngl_FragColor = vec4( 0.5 * normalize( vNormal ) + 0.5, opacity );\n}",vertexShader:"varying vec3 vNormal;\nvoid main() {\nvec4 mvPosition = modelViewMatrix * vec4( position, 1.0 );\nvNormal = normalize( normalMatrix * normal );\ngl_Position = projectionMatrix * mvPosition;\n}"},basic:{uniforms:THREE.UniformsLib.common,fragmentShader:["uniform vec3 diffuse;\nuniform float opacity;",THREE.ShaderChunk.color_pars_fragment,THREE.ShaderChunk.map_pars_fragment,
THREE.ShaderChunk.lightmap_pars_fragment,THREE.ShaderChunk.envmap_pars_fragment,THREE.ShaderChunk.fog_pars_fragment,"void main() {\ngl_FragColor = vec4( diffuse, opacity );",THREE.ShaderChunk.map_fragment,THREE.ShaderChunk.lightmap_fragment,THREE.ShaderChunk.color_fragment,THREE.ShaderChunk.envmap_fragment,THREE.ShaderChunk.fog_fragment,"}"].join("\n"),vertexShader:[THREE.ShaderChunk.map_pars_vertex,THREE.ShaderChunk.lightmap_pars_vertex,THREE.ShaderChunk.envmap_pars_vertex,THREE.ShaderChunk.color_pars_vertex,
THREE.ShaderChunk.skinning_pars_vertex,THREE.ShaderChunk.morphtarget_pars_vertex,"void main() {\nvec4 mvPosition = modelViewMatrix * vec4( position, 1.0 );",THREE.ShaderChunk.map_vertex,THREE.ShaderChunk.lightmap_vertex,THREE.ShaderChunk.envmap_vertex,THREE.ShaderChunk.color_vertex,THREE.ShaderChunk.skinning_vertex,THREE.ShaderChunk.morphtarget_vertex,THREE.ShaderChunk.default_vertex,"}"].join("\n")},lambert:{uniforms:Uniforms.merge([THREE.UniformsLib.common,THREE.UniformsLib.lights]),fragmentShader:["uniform vec3 diffuse;\nuniform float opacity;\nvarying vec3 vLightWeighting;",
THREE.ShaderChunk.color_pars_fragment,THREE.ShaderChunk.map_pars_fragment,THREE.ShaderChunk.lightmap_pars_fragment,THREE.ShaderChunk.envmap_pars_fragment,THREE.ShaderChunk.fog_pars_fragment,"void main() {\ngl_FragColor = vec4( diffuse, opacity );\ngl_FragColor = gl_FragColor * vec4( vLightWeighting, 1.0 );",THREE.ShaderChunk.map_fragment,THREE.ShaderChunk.lightmap_fragment,THREE.ShaderChunk.color_fragment,THREE.ShaderChunk.envmap_fragment,THREE.ShaderChunk.fog_fragment,"}"].join("\n"),vertexShader:["varying vec3 vLightWeighting;",
THREE.ShaderChunk.map_pars_vertex,THREE.ShaderChunk.lightmap_pars_vertex,THREE.ShaderChunk.envmap_pars_vertex,THREE.ShaderChunk.lights_pars_vertex,THREE.ShaderChunk.color_pars_vertex,THREE.ShaderChunk.skinning_pars_vertex,THREE.ShaderChunk.morphtarget_pars_vertex,"void main() {\nvec4 mvPosition = modelViewMatrix * vec4( position, 1.0 );",THREE.ShaderChunk.map_vertex,THREE.ShaderChunk.lightmap_vertex,THREE.ShaderChunk.envmap_vertex,THREE.ShaderChunk.color_vertex,"vec3 transformedNormal = normalize( normalMatrix * normal );",
THREE.ShaderChunk.lights_vertex,THREE.ShaderChunk.skinning_vertex,THREE.ShaderChunk.morphtarget_vertex,THREE.ShaderChunk.default_vertex,"}"].join("\n")},phong:{uniforms:Uniforms.merge([THREE.UniformsLib.common,THREE.UniformsLib.lights,{ambient:{type:"c",value:new THREE.Color(328965)},specular:{type:"c",value:new THREE.Color(1118481)},shininess:{type:"f",value:30}}]),fragmentShader:["uniform vec3 diffuse;\nuniform float opacity;\nuniform vec3 ambient;\nuniform vec3 specular;\nuniform float shininess;\nvarying vec3 vLightWeighting;",
THREE.ShaderChunk.color_pars_fragment,THREE.ShaderChunk.map_pars_fragment,THREE.ShaderChunk.lightmap_pars_fragment,THREE.ShaderChunk.envmap_pars_fragment,THREE.ShaderChunk.fog_pars_fragment,THREE.ShaderChunk.lights_pars_fragment,"void main() {\ngl_FragColor = vec4( vLightWeighting, 1.0 );",THREE.ShaderChunk.lights_fragment,THREE.ShaderChunk.map_fragment,THREE.ShaderChunk.lightmap_fragment,THREE.ShaderChunk.color_fragment,THREE.ShaderChunk.envmap_fragment,THREE.ShaderChunk.fog_fragment,"}"].join("\n"),
vertexShader:["#define PHONG\nvarying vec3 vLightWeighting;\nvarying vec3 vViewPosition;\nvarying vec3 vNormal;",THREE.ShaderChunk.map_pars_vertex,THREE.ShaderChunk.lightmap_pars_vertex,THREE.ShaderChunk.envmap_pars_vertex,THREE.ShaderChunk.lights_pars_vertex,THREE.ShaderChunk.color_pars_vertex,THREE.ShaderChunk.skinning_pars_vertex,THREE.ShaderChunk.morphtarget_pars_vertex,"void main() {\nvec4 mvPosition = modelViewMatrix * vec4( position, 1.0 );",THREE.ShaderChunk.map_vertex,THREE.ShaderChunk.lightmap_vertex,
THREE.ShaderChunk.envmap_vertex,THREE.ShaderChunk.color_vertex,"#ifndef USE_ENVMAP\nvec4 mPosition = objectMatrix * vec4( position, 1.0 );\n#endif\nvViewPosition = cameraPosition - mPosition.xyz;\nvec3 transformedNormal = normalize( normalMatrix * normal );\nvNormal = transformedNormal;",THREE.ShaderChunk.lights_vertex,THREE.ShaderChunk.skinning_vertex,THREE.ShaderChunk.morphtarget_vertex,THREE.ShaderChunk.default_vertex,"}"].join("\n")},particle_basic:{uniforms:THREE.UniformsLib.particle,fragmentShader:["uniform vec3 psColor;\nuniform float opacity;",
THREE.ShaderChunk.color_pars_fragment,THREE.ShaderChunk.map_particle_pars_fragment,THREE.ShaderChunk.fog_pars_fragment,"void main() {\ngl_FragColor = vec4( psColor, opacity );",THREE.ShaderChunk.map_particle_fragment,THREE.ShaderChunk.color_fragment,THREE.ShaderChunk.fog_fragment,"}"].join("\n"),vertexShader:["uniform float size;\nuniform float scale;",THREE.ShaderChunk.color_pars_vertex,"void main() {",THREE.ShaderChunk.color_vertex,"vec4 mvPosition = modelViewMatrix * vec4( position, 1.0 );\n#ifdef USE_SIZEATTENUATION\ngl_PointSize = size * ( scale / length( mvPosition.xyz ) );\n#else\ngl_PointSize = size;\n#endif\ngl_Position = projectionMatrix * mvPosition;\n}"].join("\n")}};
THREE.WebGLRenderer=function(a){function c(h,t,w){var p,C,G,J=h.vertices,E=J.length,A=h.colors,V=A.length,K=h.__vertexArray,T=h.__colorArray,ja=h.__sortArray,pa=h.__dirtyVertices,sa=h.__dirtyColors;if(w.sortParticles){ha.multiplySelf(w.matrixWorld);for(p=0;p<E;p++){C=J[p].position;qa.copy(C);ha.multiplyVector3(qa);ja[p]=[qa.z,p]}ja.sort(function(Ba,ya){return ya[0]-Ba[0]});for(p=0;p<E;p++){C=J[ja[p][1]].position;G=p*3;K[G]=C.x;K[G+1]=C.y;K[G+2]=C.z}for(p=0;p<V;p++){G=p*3;color=A[ja[p][1]];T[G]=color.r;
T[G+1]=color.g;T[G+2]=color.b}}else{if(pa)for(p=0;p<E;p++){C=J[p].position;G=p*3;K[G]=C.x;K[G+1]=C.y;K[G+2]=C.z}if(sa)for(p=0;p<V;p++){color=A[p];G=p*3;T[G]=color.r;T[G+1]=color.g;T[G+2]=color.b}}if(pa||w.sortParticles){d.bindBuffer(d.ARRAY_BUFFER,h.__webglVertexBuffer);d.bufferData(d.ARRAY_BUFFER,K,t)}if(sa||w.sortParticles){d.bindBuffer(d.ARRAY_BUFFER,h.__webglColorBuffer);d.bufferData(d.ARRAY_BUFFER,T,t)}}function b(h,t){h.uniforms=Uniforms.clone(t.uniforms);h.vertexShader=t.vertexShader;h.fragmentShader=
t.fragmentShader}function e(h,t,w,p,C){p.__webglProgram||Y.initMaterial(p,t,w,C);var G=p.program,J=G.uniforms,E=p.uniforms;if(G!=X){d.useProgram(G);X=G}d.uniformMatrix4fv(J.projectionMatrix,!1,ra);if(w&&(p instanceof THREE.MeshBasicMaterial||p instanceof THREE.MeshLambertMaterial||p instanceof THREE.MeshPhongMaterial||p instanceof THREE.LineBasicMaterial||p instanceof THREE.ParticleBasicMaterial)){E.fogColor.value.setHex(w.color.hex);if(w instanceof THREE.Fog){E.fogNear.value=w.near;E.fogFar.value=
w.far}else if(w instanceof THREE.FogExp2)E.fogDensity.value=w.density}if(p instanceof THREE.MeshPhongMaterial||p instanceof THREE.MeshLambertMaterial||p.lights){var A,V,K=0,T=0,ja=0,pa,sa,Ba,ya=xa,Fa=ya.directional.colors,ea=ya.directional.positions,U=ya.point.colors,la=ya.point.positions,Ma=0,Ha=0;w=V=V=0;for(A=t.length;w<A;w++){V=t[w];pa=V.color;sa=V.position;Ba=V.intensity;if(V instanceof THREE.AmbientLight){K+=pa.r;T+=pa.g;ja+=pa.b}else if(V instanceof THREE.DirectionalLight){V=Ma*3;Fa[V]=pa.r*
Ba;Fa[V+1]=pa.g*Ba;Fa[V+2]=pa.b*Ba;ea[V]=sa.x;ea[V+1]=sa.y;ea[V+2]=sa.z;Ma+=1}else if(V instanceof THREE.PointLight){V=Ha*3;U[V]=pa.r*Ba;U[V+1]=pa.g*Ba;U[V+2]=pa.b*Ba;la[V]=sa.x;la[V+1]=sa.y;la[V+2]=sa.z;Ha+=1}}for(w=Ma*3;w<Fa.length;w++)Fa[w]=0;for(w=Ha*3;w<U.length;w++)U[w]=0;ya.point.length=Ha;ya.directional.length=Ma;ya.ambient[0]=K;ya.ambient[1]=T;ya.ambient[2]=ja;w=xa;E.enableLighting.value=w.directional.length+w.point.length;E.ambientLightColor.value=w.ambient;E.directionalLightColor.value=
w.directional.colors;E.directionalLightDirection.value=w.directional.positions;E.pointLightColor.value=w.point.colors;E.pointLightPosition.value=w.point.positions}if(p instanceof THREE.MeshBasicMaterial||p instanceof THREE.MeshLambertMaterial||p instanceof THREE.MeshPhongMaterial){E.diffuse.value.setRGB(p.color.r,p.color.g,p.color.b);E.opacity.value=p.opacity;E.map.texture=p.map;E.lightMap.texture=p.lightMap;E.envMap.texture=p.envMap;E.reflectivity.value=p.reflectivity;E.refractionRatio.value=p.refractionRatio;
E.combine.value=p.combine;E.useRefract.value=p.envMap&&p.envMap.mapping instanceof THREE.CubeRefractionMapping}if(p instanceof THREE.LineBasicMaterial){E.diffuse.value.setRGB(p.color.r,p.color.g,p.color.b);E.opacity.value=p.opacity}else if(p instanceof THREE.ParticleBasicMaterial){E.psColor.value.setRGB(p.color.r,p.color.g,p.color.b);E.opacity.value=p.opacity;E.size.value=p.size;E.scale.value=fa.height/2;E.map.texture=p.map}else if(p instanceof THREE.MeshPhongMaterial){E.ambient.value.setRGB(p.ambient.r,
p.ambient.g,p.ambient.b);E.specular.value.setRGB(p.specular.r,p.specular.g,p.specular.b);E.shininess.value=p.shininess}else if(p instanceof THREE.MeshDepthMaterial){E.mNear.value=h.near;E.mFar.value=h.far;E.opacity.value=p.opacity}else if(p instanceof THREE.MeshNormalMaterial)E.opacity.value=p.opacity;for(var fb in E)if(T=G.uniforms[fb]){A=E[fb];K=A.type;w=A.value;if(K=="i")d.uniform1i(T,w);else if(K=="f")d.uniform1f(T,w);else if(K=="fv1")d.uniform1fv(T,w);else if(K=="fv")d.uniform3fv(T,w);else if(K==
"v2")d.uniform2f(T,w.x,w.y);else if(K=="v3")d.uniform3f(T,w.x,w.y,w.z);else if(K=="c")d.uniform3f(T,w.r,w.g,w.b);else if(K=="t"){d.uniform1i(T,w);if(A=A.texture)if(A.image instanceof Array&&A.image.length==6){if(A.image.length==6){if(A.needsUpdate){if(A.__webglInit){d.bindTexture(d.TEXTURE_CUBE_MAP,A.image.__webglTextureCube);for(K=0;K<6;++K)d.texSubImage2D(d.TEXTURE_CUBE_MAP_POSITIVE_X+K,0,0,0,d.RGBA,d.UNSIGNED_BYTE,A.image[K])}else{A.image.__webglTextureCube=d.createTexture();d.bindTexture(d.TEXTURE_CUBE_MAP,
A.image.__webglTextureCube);for(K=0;K<6;++K)d.texImage2D(d.TEXTURE_CUBE_MAP_POSITIVE_X+K,0,d.RGBA,d.RGBA,d.UNSIGNED_BYTE,A.image[K]);A.__webglInit=!0}D(d.TEXTURE_CUBE_MAP,A,A.image[0]);d.bindTexture(d.TEXTURE_CUBE_MAP,null);A.needsUpdate=!1}d.activeTexture(d.TEXTURE0+w);d.bindTexture(d.TEXTURE_CUBE_MAP,A.image.__webglTextureCube)}}else{if(A.needsUpdate){if(A.__webglInit){d.bindTexture(d.TEXTURE_2D,A.__webglTexture);d.texSubImage2D(d.TEXTURE_2D,0,0,0,d.RGBA,d.UNSIGNED_BYTE,A.image)}else{A.__webglTexture=
d.createTexture();d.bindTexture(d.TEXTURE_2D,A.__webglTexture);d.texImage2D(d.TEXTURE_2D,0,d.RGBA,d.RGBA,d.UNSIGNED_BYTE,A.image);A.__webglInit=!0}D(d.TEXTURE_2D,A,A.image);d.bindTexture(d.TEXTURE_2D,null);A.needsUpdate=!1}d.activeTexture(d.TEXTURE0+w);d.bindTexture(d.TEXTURE_2D,A.__webglTexture)}}}d.uniformMatrix4fv(J.modelViewMatrix,!1,C._modelViewMatrixArray);d.uniformMatrix3fv(J.normalMatrix,!1,C._normalMatrixArray);(p instanceof THREE.MeshShaderMaterial||p instanceof THREE.MeshPhongMaterial||
p.envMap)&&d.uniform3f(J.cameraPosition,h.position.x,h.position.y,h.position.z);(p instanceof THREE.MeshShaderMaterial||p.envMap||p.skinning)&&d.uniformMatrix4fv(J.objectMatrix,!1,C._objectMatrixArray);(p instanceof THREE.MeshPhongMaterial||p instanceof THREE.MeshLambertMaterial||p instanceof THREE.MeshShaderMaterial||p.skinning)&&d.uniformMatrix4fv(J.viewMatrix,!1,na);if(p instanceof THREE.ShadowVolumeDynamicMaterial){h=E.directionalLightDirection.value;h[0]=-t.position.x;h[1]=-t.position.y;h[2]=
-t.position.z;d.uniform3fv(J.directionalLightDirection,h);d.uniformMatrix4fv(J.objectMatrix,!1,C._objectMatrixArray);d.uniformMatrix4fv(J.viewMatrix,!1,na)}if(p.skinning){d.uniformMatrix4fv(J.cameraInverseMatrix,!1,na);d.uniformMatrix4fv(J.boneGlobalMatrices,!1,C.boneMatrices)}return G}function f(h,t,w,p,C,G){if(p.opacity!=0){h=e(h,t,w,p,G).attributes;if(p.morphTargets){t=p.program.attributes;G.morphTargetBase!==-1?d.bindBuffer(d.ARRAY_BUFFER,C.__webglMorphTargetsBuffers[G.morphTargetBase]):d.bindBuffer(d.ARRAY_BUFFER,
C.__webglVertexBuffer);d.vertexAttribPointer(t.position,3,d.FLOAT,!1,0,0);if(G.morphTargetForcedOrder.length){w=0;for(var J=G.morphTargetForcedOrder,E=G.morphTargetInfluences;w<p.numSupportedMorphTargets&&w<J.length;){d.bindBuffer(d.ARRAY_BUFFER,C.__webglMorphTargetsBuffers[J[w]]);d.vertexAttribPointer(t["morphTarget"+w],3,d.FLOAT,!1,0,0);G.__webglMorphTargetInfluences[w]=E[J[w]];w++}}else{J=[];var A=-1,V=0;E=G.morphTargetInfluences;var K,T=E.length;w=0;for(G.morphTargetBase!==-1&&(J[G.morphTargetBase]=
!0);w<p.numSupportedMorphTargets;){for(K=0;K<T;K++)if(!J[K]&&E[K]>A){V=K;A=E[V]}d.bindBuffer(d.ARRAY_BUFFER,C.__webglMorphTargetsBuffers[V]);d.vertexAttribPointer(t["morphTarget"+w],3,d.FLOAT,!1,0,0);G.__webglMorphTargetInfluences[w]=A;J[V]=1;A=-1;w++}}d.uniform1fv(p.program.uniforms.morphTargetInfluences,G.__webglMorphTargetInfluences)}else{d.bindBuffer(d.ARRAY_BUFFER,C.__webglVertexBuffer);d.vertexAttribPointer(h.position,3,d.FLOAT,!1,0,0)}if(h.color>=0){d.bindBuffer(d.ARRAY_BUFFER,C.__webglColorBuffer);
d.vertexAttribPointer(h.color,3,d.FLOAT,!1,0,0)}if(h.normal>=0){d.bindBuffer(d.ARRAY_BUFFER,C.__webglNormalBuffer);d.vertexAttribPointer(h.normal,3,d.FLOAT,!1,0,0)}if(h.tangent>=0){d.bindBuffer(d.ARRAY_BUFFER,C.__webglTangentBuffer);d.vertexAttribPointer(h.tangent,4,d.FLOAT,!1,0,0)}if(h.uv>=0)if(C.__webglUVBuffer){d.bindBuffer(d.ARRAY_BUFFER,C.__webglUVBuffer);d.vertexAttribPointer(h.uv,2,d.FLOAT,!1,0,0);d.enableVertexAttribArray(h.uv)}else d.disableVertexAttribArray(h.uv);if(h.uv2>=0)if(C.__webglUV2Buffer){d.bindBuffer(d.ARRAY_BUFFER,
C.__webglUV2Buffer);d.vertexAttribPointer(h.uv2,2,d.FLOAT,!1,0,0);d.enableVertexAttribArray(h.uv2)}else d.disableVertexAttribArray(h.uv2);if(p.skinning&&h.skinVertexA>=0&&h.skinVertexB>=0&&h.skinIndex>=0&&h.skinWeight>=0){d.bindBuffer(d.ARRAY_BUFFER,C.__webglSkinVertexABuffer);d.vertexAttribPointer(h.skinVertexA,4,d.FLOAT,!1,0,0);d.bindBuffer(d.ARRAY_BUFFER,C.__webglSkinVertexBBuffer);d.vertexAttribPointer(h.skinVertexB,4,d.FLOAT,!1,0,0);d.bindBuffer(d.ARRAY_BUFFER,C.__webglSkinIndicesBuffer);d.vertexAttribPointer(h.skinIndex,
4,d.FLOAT,!1,0,0);d.bindBuffer(d.ARRAY_BUFFER,C.__webglSkinWeightsBuffer);d.vertexAttribPointer(h.skinWeight,4,d.FLOAT,!1,0,0)}if(G instanceof THREE.Mesh)if(p.wireframe){d.lineWidth(p.wireframeLinewidth);d.bindBuffer(d.ELEMENT_ARRAY_BUFFER,C.__webglLineBuffer);d.drawElements(d.LINES,C.__webglLineCount,d.UNSIGNED_SHORT,0)}else{d.bindBuffer(d.ELEMENT_ARRAY_BUFFER,C.__webglFaceBuffer);d.drawElements(d.TRIANGLES,C.__webglFaceCount,d.UNSIGNED_SHORT,0)}else if(G instanceof THREE.Line){G=G.type==THREE.LineStrip?
d.LINE_STRIP:d.LINES;d.lineWidth(p.linewidth);d.drawArrays(G,0,C.__webglLineCount)}else if(G instanceof THREE.ParticleSystem)d.drawArrays(d.POINTS,0,C.__webglParticleCount);else G instanceof THREE.Ribbon&&d.drawArrays(d.TRIANGLE_STRIP,0,C.__webglVertexCount)}}function g(h,t){if(!h.__webglVertexBuffer)h.__webglVertexBuffer=d.createBuffer();if(!h.__webglNormalBuffer)h.__webglNormalBuffer=d.createBuffer();if(h.hasPos){d.bindBuffer(d.ARRAY_BUFFER,h.__webglVertexBuffer);d.bufferData(d.ARRAY_BUFFER,h.positionArray,
d.DYNAMIC_DRAW);d.enableVertexAttribArray(t.attributes.position);d.vertexAttribPointer(t.attributes.position,3,d.FLOAT,!1,0,0)}if(h.hasNormal){d.bindBuffer(d.ARRAY_BUFFER,h.__webglNormalBuffer);d.bufferData(d.ARRAY_BUFFER,h.normalArray,d.DYNAMIC_DRAW);d.enableVertexAttribArray(t.attributes.normal);d.vertexAttribPointer(t.attributes.normal,3,d.FLOAT,!1,0,0)}d.drawArrays(d.TRIANGLES,0,h.count);h.count=0}function j(h){if(ua!=h.doubleSided){h.doubleSided?d.disable(d.CULL_FACE):d.enable(d.CULL_FACE);ua=
h.doubleSided}if(va!=h.flipSided){h.flipSided?d.frontFace(d.CW):d.frontFace(d.CCW);va=h.flipSided}}function k(h){if(ma!=h){h?d.enable(d.DEPTH_TEST):d.disable(d.DEPTH_TEST);ma=h}}function m(h){N[0].set(h.n41-h.n11,h.n42-h.n12,h.n43-h.n13,h.n44-h.n14);N[1].set(h.n41+h.n11,h.n42+h.n12,h.n43+h.n13,h.n44+h.n14);N[2].set(h.n41+h.n21,h.n42+h.n22,h.n43+h.n23,h.n44+h.n24);N[3].set(h.n41-h.n21,h.n42-h.n22,h.n43-h.n23,h.n44-h.n24);N[4].set(h.n41-h.n31,h.n42-h.n32,h.n43-h.n33,h.n44-h.n34);N[5].set(h.n41+h.n31,
h.n42+h.n32,h.n43+h.n33,h.n44+h.n34);var t;for(h=0;h<6;h++){t=N[h];t.divideScalar(Math.sqrt(t.x*t.x+t.y*t.y+t.z*t.z))}}function n(h){for(var t=h.matrixWorld,w=-h.geometry.boundingSphere.radius*Math.max(h.scale.x,Math.max(h.scale.y,h.scale.z)),p=0;p<6;p++){h=N[p].x*t.n14+N[p].y*t.n24+N[p].z*t.n34+N[p].w;if(h<=w)return!1}return!0}function o(h,t){h.list[h.count]=t;h.count+=1}function x(h){var t,w,p=h.object,C=h.opaque,G=h.transparent;G.count=0;h=C.count=0;for(t=p.materials.length;h<t;h++){w=p.materials[h];
w.opacity&&w.opacity<1||w.blending!=THREE.NormalBlending?o(G,w):o(C,w)}}function z(h){var t,w,p,C,G=h.object,J=h.buffer,E=h.opaque,A=h.transparent;A.count=0;h=E.count=0;for(p=G.materials.length;h<p;h++){t=G.materials[h];if(t instanceof THREE.MeshFaceMaterial){t=0;for(w=J.materials.length;t<w;t++)(C=J.materials[t])&&(C.opacity&&C.opacity<1||C.blending!=THREE.NormalBlending?o(A,C):o(E,C))}else{C=t;C.opacity&&C.opacity<1||C.blending!=THREE.NormalBlending?o(A,C):o(E,C)}}}function y(h,t){return t.z-h.z}
function B(h,t){h._modelViewMatrix.multiplyToArray(t.matrixWorldInverse,h.matrixWorld,h._modelViewMatrixArray);THREE.Matrix4.makeInvert3x3(h._modelViewMatrix).transposeIntoArray(h._normalMatrixArray)}function H(h){var t,w,p;if(h instanceof THREE.Mesh){w=h.geometry;for(t in w.geometryGroups){p=w.geometryGroups[t];if(w.__dirtyVertices||w.__dirtyMorphTargets||w.__dirtyElements||w.__dirtyUvs||w.__dirtyNormals||w.__dirtyColors||w.__dirtyTangents){var C=d.DYNAMIC_DRAW,G=void 0,J=void 0,E=void 0,A=void 0;
E=void 0;var V=void 0,K=void 0,T=void 0,ja=void 0,pa=void 0,sa=void 0,Ba=void 0,ya=void 0,Fa=void 0,ea=void 0,U=void 0,la=void 0,Ma=void 0;K=void 0;T=void 0;A=void 0;ja=void 0;A=void 0;ea=void 0;U=void 0;K=void 0;ea=void 0;U=void 0;la=void 0;Ma=void 0;ea=void 0;U=void 0;la=void 0;Ma=void 0;ea=void 0;U=void 0;la=void 0;Ma=void 0;ea=void 0;U=void 0;la=void 0;A=void 0;ja=void 0;V=void 0;E=void 0;E=void 0;var Ha=void 0,fb=void 0,Ua=void 0,Ja=0,Sa=0,cb=0,eb=0,Qa=0,Va=0,Ea=0,Wa=0,Na=0,O=0,Oa=0,Ra=p.__vertexArray,
jb=p.__uvArray,Ca=p.__uv2Array,Ta=p.__normalArray,Ga=p.__tangentArray,Pa=p.__colorArray,Ka=p.__skinVertexAArray,wa=p.__skinVertexBArray,L=p.__skinIndexArray,$=p.__skinWeightArray,oa=p.__morphTargetsArrays,da=p.__faceArray,ta=p.__lineArray,Aa=p.__needsSmoothNormals;sa=p.__vertexColorType;pa=p.__uvType;Ba=p.__normalType;var ga=h.geometry,aa=ga.__dirtyVertices,La=ga.__dirtyElements,Ya=ga.__dirtyUvs,Za=ga.__dirtyNormals,db=ga.__dirtyTangents,hb=ga.__dirtyColors,bb=ga.__dirtyMorphTargets,Xa=ga.vertices,
ob=p.faces,rb=ga.faces,pb=ga.faceVertexUvs[0],qb=ga.faceVertexUvs[1],lb=ga.skinVerticesA,mb=ga.skinVerticesB,nb=ga.skinIndices,ib=ga.skinWeights,kb=ga.edgeFaces,gb=ga.morphTargets;G=0;for(J=ob.length;G<J;G++){E=ob[G];A=rb[E];pb&&(ya=pb[E]);qb&&(Fa=qb[E]);E=A.vertexNormals;V=A.normal;K=A.vertexColors;T=A.color;ja=A.vertexTangents;if(A instanceof THREE.Face3){if(aa){ea=Xa[A.a].position;U=Xa[A.b].position;la=Xa[A.c].position;Ra[Sa]=ea.x;Ra[Sa+1]=ea.y;Ra[Sa+2]=ea.z;Ra[Sa+3]=U.x;Ra[Sa+4]=U.y;Ra[Sa+5]=
U.z;Ra[Sa+6]=la.x;Ra[Sa+7]=la.y;Ra[Sa+8]=la.z;Sa+=9}if(bb){Ha=0;for(fb=gb.length;Ha<fb;Ha++){ea=gb[Ha].vertices[A.a].position;U=gb[Ha].vertices[A.b].position;la=gb[Ha].vertices[A.c].position;Ua=oa[Ha];Ua[Oa+0]=ea.x;Ua[Oa+1]=ea.y;Ua[Oa+2]=ea.z;Ua[Oa+3]=U.x;Ua[Oa+4]=U.y;Ua[Oa+5]=U.z;Ua[Oa+6]=la.x;Ua[Oa+7]=la.y;Ua[Oa+8]=la.z}Oa+=9}if(ib.length){ea=ib[A.a];U=ib[A.b];la=ib[A.c];$[O]=ea.x;$[O+1]=ea.y;$[O+2]=ea.z;$[O+3]=ea.w;$[O+4]=U.x;$[O+5]=U.y;$[O+6]=U.z;$[O+7]=U.w;$[O+8]=la.x;$[O+9]=la.y;$[O+10]=la.z;
$[O+11]=la.w;ea=nb[A.a];U=nb[A.b];la=nb[A.c];L[O]=ea.x;L[O+1]=ea.y;L[O+2]=ea.z;L[O+3]=ea.w;L[O+4]=U.x;L[O+5]=U.y;L[O+6]=U.z;L[O+7]=U.w;L[O+8]=la.x;L[O+9]=la.y;L[O+10]=la.z;L[O+11]=la.w;ea=lb[A.a];U=lb[A.b];la=lb[A.c];Ka[O]=ea.x;Ka[O+1]=ea.y;Ka[O+2]=ea.z;Ka[O+3]=1;Ka[O+4]=U.x;Ka[O+5]=U.y;Ka[O+6]=U.z;Ka[O+7]=1;Ka[O+8]=la.x;Ka[O+9]=la.y;Ka[O+10]=la.z;Ka[O+11]=1;ea=mb[A.a];U=mb[A.b];la=mb[A.c];wa[O]=ea.x;wa[O+1]=ea.y;wa[O+2]=ea.z;wa[O+3]=1;wa[O+4]=U.x;wa[O+5]=U.y;wa[O+6]=U.z;wa[O+7]=1;wa[O+8]=la.x;wa[O+
9]=la.y;wa[O+10]=la.z;wa[O+11]=1;O+=12}if(hb&&sa){if(K.length==3&&sa==THREE.VertexColors){A=K[0];ea=K[1];U=K[2]}else U=ea=A=T;Pa[Na]=A.r;Pa[Na+1]=A.g;Pa[Na+2]=A.b;Pa[Na+3]=ea.r;Pa[Na+4]=ea.g;Pa[Na+5]=ea.b;Pa[Na+6]=U.r;Pa[Na+7]=U.g;Pa[Na+8]=U.b;Na+=9}if(db&&ga.hasTangents){K=ja[0];T=ja[1];A=ja[2];Ga[Ea]=K.x;Ga[Ea+1]=K.y;Ga[Ea+2]=K.z;Ga[Ea+3]=K.w;Ga[Ea+4]=T.x;Ga[Ea+5]=T.y;Ga[Ea+6]=T.z;Ga[Ea+7]=T.w;Ga[Ea+8]=A.x;Ga[Ea+9]=A.y;Ga[Ea+10]=A.z;Ga[Ea+11]=A.w;Ea+=12}if(Za&&Ba)if(E.length==3&&Aa)for(ja=0;ja<
3;ja++){V=E[ja];Ta[Va]=V.x;Ta[Va+1]=V.y;Ta[Va+2]=V.z;Va+=3}else for(ja=0;ja<3;ja++){Ta[Va]=V.x;Ta[Va+1]=V.y;Ta[Va+2]=V.z;Va+=3}if(Ya&&ya!==undefined&&pa)for(ja=0;ja<3;ja++){E=ya[ja];jb[cb]=E.u;jb[cb+1]=E.v;cb+=2}if(Ya&&Fa!==undefined&&pa)for(ja=0;ja<3;ja++){E=Fa[ja];Ca[eb]=E.u;Ca[eb+1]=E.v;eb+=2}if(La){da[Qa]=Ja;da[Qa+1]=Ja+1;da[Qa+2]=Ja+2;Qa+=3;ta[Wa]=Ja;ta[Wa+1]=Ja+1;ta[Wa+2]=Ja;ta[Wa+3]=Ja+2;ta[Wa+4]=Ja+1;ta[Wa+5]=Ja+2;Wa+=6;Ja+=3}}else if(A instanceof THREE.Face4){if(aa){ea=Xa[A.a].position;U=
Xa[A.b].position;la=Xa[A.c].position;Ma=Xa[A.d].position;Ra[Sa]=ea.x;Ra[Sa+1]=ea.y;Ra[Sa+2]=ea.z;Ra[Sa+3]=U.x;Ra[Sa+4]=U.y;Ra[Sa+5]=U.z;Ra[Sa+6]=la.x;Ra[Sa+7]=la.y;Ra[Sa+8]=la.z;Ra[Sa+9]=Ma.x;Ra[Sa+10]=Ma.y;Ra[Sa+11]=Ma.z;Sa+=12}if(bb){Ha=0;for(fb=gb.length;Ha<fb;Ha++){ea=gb[Ha].vertices[A.a].position;U=gb[Ha].vertices[A.b].position;la=gb[Ha].vertices[A.c].position;Ma=gb[Ha].vertices[A.d].position;Ua=oa[Ha];Ua[Oa+0]=ea.x;Ua[Oa+1]=ea.y;Ua[Oa+2]=ea.z;Ua[Oa+3]=U.x;Ua[Oa+4]=U.y;Ua[Oa+5]=U.z;Ua[Oa+6]=
la.x;Ua[Oa+7]=la.y;Ua[Oa+8]=la.z;Ua[Oa+9]=Ma.x;Ua[Oa+10]=Ma.y;Ua[Oa+11]=Ma.z}Oa+=12}if(ib.length){ea=ib[A.a];U=ib[A.b];la=ib[A.c];Ma=ib[A.d];$[O]=ea.x;$[O+1]=ea.y;$[O+2]=ea.z;$[O+3]=ea.w;$[O+4]=U.x;$[O+5]=U.y;$[O+6]=U.z;$[O+7]=U.w;$[O+8]=la.x;$[O+9]=la.y;$[O+10]=la.z;$[O+11]=la.w;$[O+12]=Ma.x;$[O+13]=Ma.y;$[O+14]=Ma.z;$[O+15]=Ma.w;ea=nb[A.a];U=nb[A.b];la=nb[A.c];Ma=nb[A.d];L[O]=ea.x;L[O+1]=ea.y;L[O+2]=ea.z;L[O+3]=ea.w;L[O+4]=U.x;L[O+5]=U.y;L[O+6]=U.z;L[O+7]=U.w;L[O+8]=la.x;L[O+9]=la.y;L[O+10]=la.z;
L[O+11]=la.w;L[O+12]=Ma.x;L[O+13]=Ma.y;L[O+14]=Ma.z;L[O+15]=Ma.w;ea=lb[A.a];U=lb[A.b];la=lb[A.c];Ma=lb[A.d];Ka[O]=ea.x;Ka[O+1]=ea.y;Ka[O+2]=ea.z;Ka[O+3]=1;Ka[O+4]=U.x;Ka[O+5]=U.y;Ka[O+6]=U.z;Ka[O+7]=1;Ka[O+8]=la.x;Ka[O+9]=la.y;Ka[O+10]=la.z;Ka[O+11]=1;Ka[O+12]=Ma.x;Ka[O+13]=Ma.y;Ka[O+14]=Ma.z;Ka[O+15]=1;ea=mb[A.a];U=mb[A.b];la=mb[A.c];A=mb[A.d];wa[O]=ea.x;wa[O+1]=ea.y;wa[O+2]=ea.z;wa[O+3]=1;wa[O+4]=U.x;wa[O+5]=U.y;wa[O+6]=U.z;wa[O+7]=1;wa[O+8]=la.x;wa[O+9]=la.y;wa[O+10]=la.z;wa[O+11]=1;wa[O+12]=A.x;
wa[O+13]=A.y;wa[O+14]=A.z;wa[O+15]=1;O+=16}if(hb&&sa){if(K.length==4&&sa==THREE.VertexColors){A=K[0];ea=K[1];U=K[2];K=K[3]}else K=U=ea=A=T;Pa[Na]=A.r;Pa[Na+1]=A.g;Pa[Na+2]=A.b;Pa[Na+3]=ea.r;Pa[Na+4]=ea.g;Pa[Na+5]=ea.b;Pa[Na+6]=U.r;Pa[Na+7]=U.g;Pa[Na+8]=U.b;Pa[Na+9]=K.r;Pa[Na+10]=K.g;Pa[Na+11]=K.b;Na+=12}if(db&&ga.hasTangents){K=ja[0];T=ja[1];A=ja[2];ja=ja[3];Ga[Ea]=K.x;Ga[Ea+1]=K.y;Ga[Ea+2]=K.z;Ga[Ea+3]=K.w;Ga[Ea+4]=T.x;Ga[Ea+5]=T.y;Ga[Ea+6]=T.z;Ga[Ea+7]=T.w;Ga[Ea+8]=A.x;Ga[Ea+9]=A.y;Ga[Ea+10]=A.z;
Ga[Ea+11]=A.w;Ga[Ea+12]=ja.x;Ga[Ea+13]=ja.y;Ga[Ea+14]=ja.z;Ga[Ea+15]=ja.w;Ea+=16}if(Za&&Ba)if(E.length==4&&Aa)for(ja=0;ja<4;ja++){V=E[ja];Ta[Va]=V.x;Ta[Va+1]=V.y;Ta[Va+2]=V.z;Va+=3}else for(ja=0;ja<4;ja++){Ta[Va]=V.x;Ta[Va+1]=V.y;Ta[Va+2]=V.z;Va+=3}if(Ya&&ya!==undefined&&pa)for(ja=0;ja<4;ja++){E=ya[ja];jb[cb]=E.u;jb[cb+1]=E.v;cb+=2}if(Ya&&Fa!==undefined&&pa)for(ja=0;ja<4;ja++){E=Fa[ja];Ca[eb]=E.u;Ca[eb+1]=E.v;eb+=2}if(La){da[Qa]=Ja;da[Qa+1]=Ja+1;da[Qa+2]=Ja+3;da[Qa+3]=Ja+1;da[Qa+4]=Ja+2;da[Qa+5]=
Ja+3;Qa+=6;ta[Wa]=Ja;ta[Wa+1]=Ja+1;ta[Wa+2]=Ja;ta[Wa+3]=Ja+3;ta[Wa+4]=Ja+1;ta[Wa+5]=Ja+2;ta[Wa+6]=Ja+2;ta[Wa+7]=Ja+3;Wa+=8;Ja+=4}}}if(kb){G=0;for(J=kb.length;G<J;G++){da[Qa]=kb[G].a;da[Qa+1]=kb[G].b;da[Qa+2]=kb[G].c;da[Qa+3]=kb[G].a;da[Qa+4]=kb[G].c;da[Qa+5]=kb[G].d;Qa+=6}}if(aa){d.bindBuffer(d.ARRAY_BUFFER,p.__webglVertexBuffer);d.bufferData(d.ARRAY_BUFFER,Ra,C)}if(bb){Ha=0;for(fb=gb.length;Ha<fb;Ha++){d.bindBuffer(d.ARRAY_BUFFER,p.__webglMorphTargetsBuffers[Ha]);d.bufferData(d.ARRAY_BUFFER,oa[Ha],
C)}}if(hb&&Na>0){d.bindBuffer(d.ARRAY_BUFFER,p.__webglColorBuffer);d.bufferData(d.ARRAY_BUFFER,Pa,C)}if(Za){d.bindBuffer(d.ARRAY_BUFFER,p.__webglNormalBuffer);d.bufferData(d.ARRAY_BUFFER,Ta,C)}if(db&&ga.hasTangents){d.bindBuffer(d.ARRAY_BUFFER,p.__webglTangentBuffer);d.bufferData(d.ARRAY_BUFFER,Ga,C)}if(Ya&&cb>0){d.bindBuffer(d.ARRAY_BUFFER,p.__webglUVBuffer);d.bufferData(d.ARRAY_BUFFER,jb,C)}if(Ya&&eb>0){d.bindBuffer(d.ARRAY_BUFFER,p.__webglUV2Buffer);d.bufferData(d.ARRAY_BUFFER,Ca,C)}if(La){d.bindBuffer(d.ELEMENT_ARRAY_BUFFER,
p.__webglFaceBuffer);d.bufferData(d.ELEMENT_ARRAY_BUFFER,da,C);d.bindBuffer(d.ELEMENT_ARRAY_BUFFER,p.__webglLineBuffer);d.bufferData(d.ELEMENT_ARRAY_BUFFER,ta,C)}if(O>0){d.bindBuffer(d.ARRAY_BUFFER,p.__webglSkinVertexABuffer);d.bufferData(d.ARRAY_BUFFER,Ka,C);d.bindBuffer(d.ARRAY_BUFFER,p.__webglSkinVertexBBuffer);d.bufferData(d.ARRAY_BUFFER,wa,C);d.bindBuffer(d.ARRAY_BUFFER,p.__webglSkinIndicesBuffer);d.bufferData(d.ARRAY_BUFFER,L,C);d.bindBuffer(d.ARRAY_BUFFER,p.__webglSkinWeightsBuffer);d.bufferData(d.ARRAY_BUFFER,
$,C)}}}w.__dirtyVertices=!1;w.__dirtyMorphTargets=!1;w.__dirtyElements=!1;w.__dirtyUvs=!1;w.__dirtyNormals=!1;w.__dirtyTangents=!1;w.__dirtyColors=!1}else if(h instanceof THREE.Ribbon){w=h.geometry;if(w.__dirtyVertices||w.__dirtyColors){h=w;t=d.DYNAMIC_DRAW;Ba=h.vertices;C=h.colors;ya=Ba.length;G=C.length;Fa=h.__vertexArray;J=h.__colorArray;Ja=h.__dirtyColors;if(h.__dirtyVertices){for(pa=0;pa<ya;pa++){sa=Ba[pa].position;p=pa*3;Fa[p]=sa.x;Fa[p+1]=sa.y;Fa[p+2]=sa.z}d.bindBuffer(d.ARRAY_BUFFER,h.__webglVertexBuffer);
d.bufferData(d.ARRAY_BUFFER,Fa,t)}if(Ja){for(pa=0;pa<G;pa++){color=C[pa];p=pa*3;J[p]=color.r;J[p+1]=color.g;J[p+2]=color.b}d.bindBuffer(d.ARRAY_BUFFER,h.__webglColorBuffer);d.bufferData(d.ARRAY_BUFFER,J,t)}}w.__dirtyVertices=!1;w.__dirtyColors=!1}else if(h instanceof THREE.Line){w=h.geometry;if(w.__dirtyVertices||w.__dirtyColors){h=w;t=d.DYNAMIC_DRAW;Ba=h.vertices;C=h.colors;ya=Ba.length;G=C.length;Fa=h.__vertexArray;J=h.__colorArray;Ja=h.__dirtyColors;if(h.__dirtyVertices){for(pa=0;pa<ya;pa++){sa=
Ba[pa].position;p=pa*3;Fa[p]=sa.x;Fa[p+1]=sa.y;Fa[p+2]=sa.z}d.bindBuffer(d.ARRAY_BUFFER,h.__webglVertexBuffer);d.bufferData(d.ARRAY_BUFFER,Fa,t)}if(Ja){for(pa=0;pa<G;pa++){color=C[pa];p=pa*3;J[p]=color.r;J[p+1]=color.g;J[p+2]=color.b}d.bindBuffer(d.ARRAY_BUFFER,h.__webglColorBuffer);d.bufferData(d.ARRAY_BUFFER,J,t)}}w.__dirtyVertices=!1;w.__dirtyColors=!1}else if(h instanceof THREE.ParticleSystem){w=h.geometry;(w.__dirtyVertices||w.__dirtyColors||h.sortParticles)&&c(w,d.DYNAMIC_DRAW,h);w.__dirtyVertices=
!1;w.__dirtyColors=!1}}function I(h){function t(ja){var pa=[];w=0;for(p=ja.length;w<p;w++)ja[w]==undefined?pa.push("undefined"):pa.push(ja[w].id);return pa.join("_")}var w,p,C,G,J,E,A,V,K={},T=h.morphTargets!==undefined?h.morphTargets.length:0;h.geometryGroups={};C=0;for(G=h.faces.length;C<G;C++){J=h.faces[C];E=J.materials;A=t(E);K[A]==undefined&&(K[A]={hash:A,counter:0});V=K[A].hash+"_"+K[A].counter;h.geometryGroups[V]==undefined&&(h.geometryGroups[V]={faces:[],materials:E,vertices:0,numMorphTargets:T});
J=J instanceof THREE.Face3?3:4;if(h.geometryGroups[V].vertices+J>65535){K[A].counter+=1;V=K[A].hash+"_"+K[A].counter;h.geometryGroups[V]==undefined&&(h.geometryGroups[V]={faces:[],materials:E,vertices:0,numMorphTargets:T})}h.geometryGroups[V].faces.push(C);h.geometryGroups[V].vertices+=J}}function F(h,t,w){h.push({buffer:t,object:w,opaque:{list:[],count:0},transparent:{list:[],count:0}})}function M(h){if(h!=za){switch(h){case THREE.AdditiveBlending:d.blendEquation(d.FUNC_ADD);d.blendFunc(d.SRC_ALPHA,
d.ONE);break;case THREE.SubtractiveBlending:d.blendEquation(d.FUNC_ADD);d.blendFunc(d.ZERO,d.ONE_MINUS_SRC_COLOR);break;case THREE.MultiplyBlending:d.blendEquation(d.FUNC_ADD);d.blendFunc(d.ZERO,d.SRC_COLOR);break;default:d.blendEquationSeparate(d.FUNC_ADD,d.FUNC_ADD);d.blendFuncSeparate(d.SRC_ALPHA,d.ONE_MINUS_SRC_ALPHA,d.ONE,d.ONE_MINUS_SRC_ALPHA)}za=h}}function D(h,t,w){if((w.width&w.width-1)==0&&(w.height&w.height-1)==0){d.texParameteri(h,d.TEXTURE_WRAP_S,ka(t.wrapS));d.texParameteri(h,d.TEXTURE_WRAP_T,
ka(t.wrapT));d.texParameteri(h,d.TEXTURE_MAG_FILTER,ka(t.magFilter));d.texParameteri(h,d.TEXTURE_MIN_FILTER,ka(t.minFilter));d.generateMipmap(h)}else{d.texParameteri(h,d.TEXTURE_WRAP_S,d.CLAMP_TO_EDGE);d.texParameteri(h,d.TEXTURE_WRAP_T,d.CLAMP_TO_EDGE);d.texParameteri(h,d.TEXTURE_MAG_FILTER,P(t.magFilter));d.texParameteri(h,d.TEXTURE_MIN_FILTER,P(t.minFilter))}}function Q(h){if(h&&!h.__webglFramebuffer){h.__webglFramebuffer=d.createFramebuffer();h.__webglRenderbuffer=d.createRenderbuffer();h.__webglTexture=
d.createTexture();d.bindRenderbuffer(d.RENDERBUFFER,h.__webglRenderbuffer);d.renderbufferStorage(d.RENDERBUFFER,d.DEPTH_COMPONENT16,h.width,h.height);d.bindTexture(d.TEXTURE_2D,h.__webglTexture);d.texParameteri(d.TEXTURE_2D,d.TEXTURE_WRAP_S,ka(h.wrapS));d.texParameteri(d.TEXTURE_2D,d.TEXTURE_WRAP_T,ka(h.wrapT));d.texParameteri(d.TEXTURE_2D,d.TEXTURE_MAG_FILTER,ka(h.magFilter));d.texParameteri(d.TEXTURE_2D,d.TEXTURE_MIN_FILTER,ka(h.minFilter));d.texImage2D(d.TEXTURE_2D,0,ka(h.format),h.width,h.height,
0,ka(h.format),ka(h.type),null);d.bindFramebuffer(d.FRAMEBUFFER,h.__webglFramebuffer);d.framebufferTexture2D(d.FRAMEBUFFER,d.COLOR_ATTACHMENT0,d.TEXTURE_2D,h.__webglTexture,0);d.framebufferRenderbuffer(d.FRAMEBUFFER,d.DEPTH_ATTACHMENT,d.RENDERBUFFER,h.__webglRenderbuffer);d.bindTexture(d.TEXTURE_2D,null);d.bindRenderbuffer(d.RENDERBUFFER,null);d.bindFramebuffer(d.FRAMEBUFFER,null)}var t,w;if(h){t=h.__webglFramebuffer;w=h.width;h=h.height}else{t=null;w=Z;h=S}if(t!=ca){d.bindFramebuffer(d.FRAMEBUFFER,
t);d.viewport(W,ia,w,h);ca=t}}function R(h,t){var w;if(h=="fragment")w=d.createShader(d.FRAGMENT_SHADER);else h=="vertex"&&(w=d.createShader(d.VERTEX_SHADER));d.shaderSource(w,t);d.compileShader(w);if(!d.getShaderParameter(w,d.COMPILE_STATUS)){console.error(d.getShaderInfoLog(w));console.error(t);return null}return w}function P(h){switch(h){case THREE.NearestFilter:case THREE.NearestMipMapNearestFilter:case THREE.NearestMipMapLinearFilter:return d.NEAREST;default:return d.LINEAR}}function ka(h){switch(h){case THREE.RepeatWrapping:return d.REPEAT;
case THREE.ClampToEdgeWrapping:return d.CLAMP_TO_EDGE;case THREE.MirroredRepeatWrapping:return d.MIRRORED_REPEAT;case THREE.NearestFilter:return d.NEAREST;case THREE.NearestMipMapNearestFilter:return d.NEAREST_MIPMAP_NEAREST;case THREE.NearestMipMapLinearFilter:return d.NEAREST_MIPMAP_LINEAR;case THREE.LinearFilter:return d.LINEAR;case THREE.LinearMipMapNearestFilter:return d.LINEAR_MIPMAP_NEAREST;case THREE.LinearMipMapLinearFilter:return d.LINEAR_MIPMAP_LINEAR;case THREE.ByteType:return d.BYTE;
case THREE.UnsignedByteType:return d.UNSIGNED_BYTE;case THREE.ShortType:return d.SHORT;case THREE.UnsignedShortType:return d.UNSIGNED_SHORT;case THREE.IntType:return d.INT;case THREE.UnsignedShortType:return d.UNSIGNED_INT;case THREE.FloatType:return d.FLOAT;case THREE.AlphaFormat:return d.ALPHA;case THREE.RGBFormat:return d.RGB;case THREE.RGBAFormat:return d.RGBA;case THREE.LuminanceFormat:return d.LUMINANCE;case THREE.LuminanceAlphaFormat:return d.LUMINANCE_ALPHA}return 0}var d,fa=document.createElement("canvas"),
X=null,ca=null,Y=this,ua=null,va=null,za=null,ma=null,W=0,ia=0,Z=0,S=0,N=[new THREE.Vector4,new THREE.Vector4,new THREE.Vector4,new THREE.Vector4,new THREE.Vector4,new THREE.Vector4],ha=new THREE.Matrix4,ra=new Float32Array(16),na=new Float32Array(16),qa=new THREE.Vector4,xa={ambient:[0,0,0],directional:{length:0,colors:[],positions:[]},point:{length:0,colors:[],positions:[]}},Da=!0,$a=new THREE.Color(0),ab=0;if(a){if(a.antialias!==undefined)Da=a.antialias;a.clearColor!==undefined&&$a.setHex(a.clearColor);
if(a.clearAlpha!==undefined)ab=a.clearAlpha}this.maxMorphTargets=8;this.domElement=fa;this.autoClear=!0;this.sortObjects=!0;(function(h,t,w){try{if(!(d=fa.getContext("experimental-webgl",{antialias:h,stencil:!0})))throw"Error creating WebGL context.";}catch(p){console.error(p)}d.clearColor(0,0,0,1);d.clearDepth(1);d.enable(d.DEPTH_TEST);d.depthFunc(d.LEQUAL);d.frontFace(d.CCW);d.cullFace(d.BACK);d.enable(d.CULL_FACE);d.enable(d.BLEND);d.blendEquation(d.FUNC_ADD);d.blendFunc(d.SRC_ALPHA,d.ONE_MINUS_SRC_ALPHA);
d.clearColor(t.r,t.g,t.b,w)})(Da,$a,ab);this.context=d;var Ia={};a=[];Da=[];a[0]=-2;a[1]=-1;a[2]=-1;a[3]=2;a[4]=-1;a[5]=-1;a[6]=2;a[7]=1;a[8]=-1;a[9]=-2;a[10]=1;a[11]=-1;Da[0]=0;Da[1]=1;Da[2]=2;Da[3]=0;Da[4]=2;Da[5]=3;Ia.vertexBuffer=d.createBuffer();Ia.elementBuffer=d.createBuffer();d.bindBuffer(d.ARRAY_BUFFER,Ia.vertexBuffer);d.bufferData(d.ARRAY_BUFFER,new Float32Array(a),d.STATIC_DRAW);d.bindBuffer(d.ELEMENT_ARRAY_BUFFER,Ia.elementBuffer);d.bufferData(d.ELEMENT_ARRAY_BUFFER,new Uint16Array(Da),
d.STATIC_DRAW);Ia.program=d.createProgram();d.attachShader(Ia.program,R("fragment",THREE.ShaderLib.shadowPost.fragmentShader));d.attachShader(Ia.program,R("vertex",THREE.ShaderLib.shadowPost.vertexShader));d.linkProgram(Ia.program);Ia.vertexLocation=d.getAttribLocation(Ia.program,"position");Ia.projectionLocation=d.getUniformLocation(Ia.program,"projectionMatrix");this.setSize=function(h,t){fa.width=h;fa.height=t;this.setViewport(0,0,fa.width,fa.height)};this.setViewport=function(h,t,w,p){W=h;ia=
t;Z=w;S=p;d.viewport(W,ia,Z,S)};this.setScissor=function(h,t,w,p){d.scissor(h,t,w,p)};this.enableScissorTest=function(h){h?d.enable(d.SCISSOR_TEST):d.disable(d.SCISSOR_TEST)};this.enableDepthBufferWrite=function(h){d.depthMask(h)};this.setClearColorHex=function(h,t){var w=new THREE.Color(h);d.clearColor(w.r,w.g,w.b,t)};this.setClearColor=function(h,t){d.clearColor(h.r,h.g,h.b,t)};this.clear=function(){d.clear(d.COLOR_BUFFER_BIT|d.DEPTH_BUFFER_BIT|d.STENCIL_BUFFER_BIT)};this.initMaterial=function(h,
t,w,p){var C,G,J,E;if(h instanceof THREE.MeshDepthMaterial)b(h,THREE.ShaderLib.depth);else if(h instanceof THREE.ShadowVolumeDynamicMaterial)b(h,THREE.ShaderLib.shadowVolumeDynamic);else if(h instanceof THREE.MeshNormalMaterial)b(h,THREE.ShaderLib.normal);else if(h instanceof THREE.MeshBasicMaterial)b(h,THREE.ShaderLib.basic);else if(h instanceof THREE.MeshLambertMaterial)b(h,THREE.ShaderLib.lambert);else if(h instanceof THREE.MeshPhongMaterial)b(h,THREE.ShaderLib.phong);else if(h instanceof THREE.LineBasicMaterial)b(h,
THREE.ShaderLib.basic);else h instanceof THREE.ParticleBasicMaterial&&b(h,THREE.ShaderLib.particle_basic);if(!h.program){var A,V,K;A=K=E=0;for(J=t.length;A<J;A++){V=t[A];V instanceof THREE.DirectionalLight&&K++;V instanceof THREE.PointLight&&E++}if(E+K<=4)t=K;else{t=Math.ceil(4*K/(E+K));E=4-t}E={directional:t,point:E};t=50;if(p!==undefined&&p instanceof THREE.SkinnedMesh)t=p.bones.length;J={map:h.map,envMap:h.envMap,lightMap:h.lightMap,vertexColors:h.vertexColors,fog:w,sizeAttenuation:h.sizeAttenuation,
skinning:h.skinning,morphTargets:h.morphTargets,maxDirLights:E.directional,maxPointLights:E.point,maxBones:t};w=h.fragmentShader;E=h.vertexShader;t=d.createProgram();A=["#ifdef GL_ES\nprecision highp float;\n#endif","#define MAX_DIR_LIGHTS "+J.maxDirLights,"#define MAX_POINT_LIGHTS "+J.maxPointLights,J.fog?"#define USE_FOG":"",J.fog instanceof THREE.FogExp2?"#define FOG_EXP2":"",J.map?"#define USE_MAP":"",J.envMap?"#define USE_ENVMAP":"",J.lightMap?"#define USE_LIGHTMAP":"",J.vertexColors?"#define USE_COLOR":
"","uniform mat4 viewMatrix;\nuniform vec3 cameraPosition;\n"].join("\n");J=[d.getParameter(d.MAX_VERTEX_TEXTURE_IMAGE_UNITS)>0?"#define VERTEX_TEXTURES":"","#define MAX_DIR_LIGHTS "+J.maxDirLights,"#define MAX_POINT_LIGHTS "+J.maxPointLights,"#define MAX_BONES "+J.maxBones,J.map?"#define USE_MAP":"",J.envMap?"#define USE_ENVMAP":"",J.lightMap?"#define USE_LIGHTMAP":"",J.vertexColors?"#define USE_COLOR":"",J.skinning?"#define USE_SKINNING":"",J.morphTargets?"#define USE_MORPHTARGETS":"",J.sizeAttenuation?
"#define USE_SIZEATTENUATION":"","uniform mat4 objectMatrix;\nuniform mat4 modelViewMatrix;\nuniform mat4 projectionMatrix;\nuniform mat4 viewMatrix;\nuniform mat3 normalMatrix;\nuniform vec3 cameraPosition;\nuniform mat4 cameraInverseMatrix;\nattribute vec3 position;\nattribute vec3 normal;\nattribute vec2 uv;\nattribute vec2 uv2;\n#ifdef USE_COLOR\nattribute vec3 color;\n#endif\n#ifdef USE_MORPHTARGETS\nattribute vec3 morphTarget0;\nattribute vec3 morphTarget1;\nattribute vec3 morphTarget2;\nattribute vec3 morphTarget3;\nattribute vec3 morphTarget4;\nattribute vec3 morphTarget5;\nattribute vec3 morphTarget6;\nattribute vec3 morphTarget7;\n#endif\n#ifdef USE_SKINNING\nattribute vec4 skinVertexA;\nattribute vec4 skinVertexB;\nattribute vec4 skinIndex;\nattribute vec4 skinWeight;\n#endif\n"].join("\n");
d.attachShader(t,R("fragment",A+w));d.attachShader(t,R("vertex",J+E));d.linkProgram(t);d.getProgramParameter(t,d.LINK_STATUS)||console.error("Could not initialise shader\nVALIDATE_STATUS: "+d.getProgramParameter(t,d.VALIDATE_STATUS)+", gl error ["+d.getError()+"]");t.uniforms={};t.attributes={};h.program=t;w=["viewMatrix","modelViewMatrix","projectionMatrix","normalMatrix","objectMatrix","cameraPosition","cameraInverseMatrix","boneGlobalMatrices","morphTargetInfluences"];for(C in h.uniforms)w.push(C);
C=h.program;E=0;for(t=w.length;E<t;E++){A=w[E];C.uniforms[A]=d.getUniformLocation(C,A)}w=["position","normal","uv","uv2","tangent","color","skinVertexA","skinVertexB","skinIndex","skinWeight"];for(C=0;C<this.maxMorphTargets;C++)w.push("morphTarget"+C);for(G in h.attributes)w.push(G);G=h.program;C=w;w=0;for(E=C.length;w<E;w++){t=C[w];G.attributes[t]=d.getAttribLocation(G,t)}G=h.program.attributes;d.enableVertexAttribArray(G.position);G.color>=0&&d.enableVertexAttribArray(G.color);G.normal>=0&&d.enableVertexAttribArray(G.normal);
G.tangent>=0&&d.enableVertexAttribArray(G.tangent);if(h.skinning&&G.skinVertexA>=0&&G.skinVertexB>=0&&G.skinIndex>=0&&G.skinWeight>=0){d.enableVertexAttribArray(G.skinVertexA);d.enableVertexAttribArray(G.skinVertexB);d.enableVertexAttribArray(G.skinIndex);d.enableVertexAttribArray(G.skinWeight)}if(h.morphTargets){h.numSupportedMorphTargets=0;if(G.morphTarget0>=0){d.enableVertexAttribArray(G.morphTarget0);h.numSupportedMorphTargets++}if(G.morphTarget1>=0){d.enableVertexAttribArray(G.morphTarget1);
h.numSupportedMorphTargets++}if(G.morphTarget2>=0){d.enableVertexAttribArray(G.morphTarget2);h.numSupportedMorphTargets++}if(G.morphTarget3>=0){d.enableVertexAttribArray(G.morphTarget3);h.numSupportedMorphTargets++}if(G.morphTarget4>=0){d.enableVertexAttribArray(G.morphTarget4);h.numSupportedMorphTargets++}if(G.morphTarget5>=0){d.enableVertexAttribArray(G.morphTarget5);h.numSupportedMorphTargets++}if(G.morphTarget6>=0){d.enableVertexAttribArray(G.morphTarget6);h.numSupportedMorphTargets++}if(G.morphTarget7>=
0){d.enableVertexAttribArray(G.morphTarget7);h.numSupportedMorphTargets++}p.__webglMorphTargetInfluences=new Float32Array(this.maxMorphTargets);C=0;for(G=this.maxMorphTargets;C<G;C++)p.__webglMorphTargetInfluences[C]=0}}h.__webglProgram=!0};this.render=function(h,t,w,p){var C,G,J,E,A,V,K,T,ja=h.lights,pa=h.fog;t.matrixAutoUpdate&&t.updateMatrix();h.update(undefined,!1,t);t.matrixWorldInverse.flattenToArray(na);t.projectionMatrix.flattenToArray(ra);ha.multiply(t.projectionMatrix,t.matrixWorldInverse);
m(ha);this.initWebGLObjects(h);Q(w);(this.autoClear||p)&&this.clear();p=h.__webglObjects.length;for(A=0;A<p;A++){E=h.__webglObjects[A];K=E.object;if(K.visible)if(!(K instanceof THREE.Mesh)||n(K)){K.matrixWorld.flattenToArray(K._objectMatrixArray);B(K,t);z(E);E.render=!0;if(this.sortObjects){qa.copy(K.position);ha.multiplyVector3(qa);E.z=qa.z}}else E.render=!1;else E.render=!1}this.sortObjects&&h.__webglObjects.sort(y);V=h.__webglObjectsImmediate.length;for(A=0;A<V;A++){E=h.__webglObjectsImmediate[A];
K=E.object;if(K.visible){K.matrixAutoUpdate&&K.matrixWorld.flattenToArray(K._objectMatrixArray);B(K,t);x(E)}}M(THREE.NormalBlending);for(A=0;A<p;A++){E=h.__webglObjects[A];if(E.render){K=E.object;T=E.buffer;J=E.opaque;j(K);for(C=0;C<J.count;C++){E=J.list[C];k(E.depthTest);f(t,ja,pa,E,T,K)}}}for(A=0;A<V;A++){E=h.__webglObjectsImmediate[A];K=E.object;if(K.visible){J=E.opaque;j(K);for(C=0;C<J.count;C++){E=J.list[C];k(E.depthTest);G=e(t,ja,pa,E,K);K.render(function(sa){g(sa,G)})}}}for(A=0;A<p;A++){E=
h.__webglObjects[A];if(E.render){K=E.object;T=E.buffer;J=E.transparent;j(K);for(C=0;C<J.count;C++){E=J.list[C];M(E.blending);k(E.depthTest);f(t,ja,pa,E,T,K)}}}for(A=0;A<V;A++){E=h.__webglObjectsImmediate[A];K=E.object;if(K.visible){J=E.transparent;j(K);for(C=0;C<J.count;C++){E=J.list[C];M(E.blending);k(E.depthTest);G=e(t,ja,pa,E,K);K.render(function(sa){g(sa,G)})}}}if(h.__webglShadowVolumes.length&&h.lights.length){d.enable(d.POLYGON_OFFSET_FILL);d.polygonOffset(0.1,1);d.enable(d.STENCIL_TEST);d.depthMask(!1);
d.colorMask(!1,!1,!1,!1);d.stencilFunc(d.ALWAYS,1,255);d.stencilOpSeparate(d.BACK,d.KEEP,d.INCR,d.KEEP);d.stencilOpSeparate(d.FRONT,d.KEEP,d.DECR,d.KEEP);V=h.lights.length;T=[];p=h.__webglShadowVolumes.length;for(t=0;t<V;t++){A=h.lights[t];if(A instanceof THREE.DirectionalLight){T[0]=-A.position.x;T[1]=-A.position.y;T[2]=-A.position.z;for(A=0;A<p;A++){K=h.__webglShadowVolumes[A].object;C=h.__webglShadowVolumes[A].buffer;E=K.materials[0];E.program||Y.initMaterial(E,ja,pa,K);G=E.program;E=G.uniforms;
J=G.attributes;if(X!==G){d.useProgram(G);X=G;d.uniformMatrix4fv(E.projectionMatrix,!1,ra);d.uniformMatrix4fv(E.viewMatrix,!1,na);d.uniform3fv(E.directionalLightDirection,T)}K.matrixWorld.flattenToArray(K._objectMatrixArray);d.uniformMatrix4fv(E.objectMatrix,!1,K._objectMatrixArray);d.bindBuffer(d.ARRAY_BUFFER,C.__webglVertexBuffer);d.vertexAttribPointer(J.position,3,d.FLOAT,!1,0,0);d.bindBuffer(d.ARRAY_BUFFER,C.__webglNormalBuffer);d.vertexAttribPointer(J.normal,3,d.FLOAT,!1,0,0);d.bindBuffer(d.ELEMENT_ARRAY_BUFFER,
C.__webglFaceBuffer);d.cullFace(d.FRONT);d.drawElements(d.TRIANGLES,C.__webglFaceCount,d.UNSIGNED_SHORT,0);d.cullFace(d.BACK);d.drawElements(d.TRIANGLES,C.__webglFaceCount,d.UNSIGNED_SHORT,0)}}}d.disable(d.POLYGON_OFFSET_FILL);d.colorMask(!0,!0,!0,!0);d.stencilFunc(d.NOTEQUAL,0,255);d.stencilOp(d.KEEP,d.KEEP,d.KEEP);d.disable(d.DEPTH_TEST);d.enable(d.BLEND);d.blendFunc(d.ONE,d.ONE_MINUS_SRC_ALPHA);d.blendEquation(d.FUNC_ADD);za="";X=Ia.program;d.useProgram(Ia.program);d.uniformMatrix4fv(Ia.projectionLocation,
!1,ra);d.bindBuffer(d.ARRAY_BUFFER,Ia.vertexBuffer);d.vertexAttribPointer(Ia.vertexLocation,3,d.FLOAT,!1,0,0);d.enableVertexAttribArray(Ia.vertexLocation);d.bindBuffer(d.ELEMENT_ARRAY_BUFFER,Ia.elementBuffer);d.drawElements(d.TRIANGLES,6,d.UNSIGNED_SHORT,0);d.disable(d.STENCIL_TEST);d.enable(d.DEPTH_TEST);d.disable(d.BLEND);d.depthMask(!0)}if(w&&w.minFilter!==THREE.NearestFilter&&w.minFilter!==THREE.LinearFilter){d.bindTexture(d.TEXTURE_2D,w.__webglTexture);d.generateMipmap(d.TEXTURE_2D);d.bindTexture(d.TEXTURE_2D,
null)}};this.initWebGLObjects=function(h){if(!h.__webglObjects){h.__webglObjects=[];h.__webglObjectsImmediate=[];h.__webglShadowVolumes=[]}for(;h.__objectsAdded.length;){var t=h.__objectsAdded[0],w=h,p=void 0,C=void 0,G=void 0;if(t._modelViewMatrix==undefined){t._modelViewMatrix=new THREE.Matrix4;t._normalMatrixArray=new Float32Array(9);t._modelViewMatrixArray=new Float32Array(16);t._objectMatrixArray=new Float32Array(16);t.matrixWorld.flattenToArray(t._objectMatrixArray)}if(t instanceof THREE.Mesh){C=
t.geometry;C.geometryGroups==undefined&&I(C);for(p in C.geometryGroups){G=C.geometryGroups[p];if(!G.__webglVertexBuffer){var J=G;J.__webglVertexBuffer=d.createBuffer();J.__webglNormalBuffer=d.createBuffer();J.__webglTangentBuffer=d.createBuffer();J.__webglColorBuffer=d.createBuffer();J.__webglUVBuffer=d.createBuffer();J.__webglUV2Buffer=d.createBuffer();J.__webglSkinVertexABuffer=d.createBuffer();J.__webglSkinVertexBBuffer=d.createBuffer();J.__webglSkinIndicesBuffer=d.createBuffer();J.__webglSkinWeightsBuffer=
d.createBuffer();J.__webglFaceBuffer=d.createBuffer();J.__webglLineBuffer=d.createBuffer();if(J.numMorphTargets){var E=void 0,A=void 0;J.__webglMorphTargetsBuffers=[];E=0;for(A=J.numMorphTargets;E<A;E++)J.__webglMorphTargetsBuffers.push(d.createBuffer())}J=G;E=t;var V=void 0,K=void 0,T=void 0;T=void 0;var ja=A=0,pa=0;V=void 0;K=void 0;var sa=void 0;K=void 0;var Ba=E.geometry;sa=Ba.faces;var ya=J.faces;V=0;for(K=ya.length;V<K;V++){T=ya[V];T=sa[T];if(T instanceof THREE.Face3){A+=3;ja+=1;pa+=3}else if(T instanceof
THREE.Face4){A+=4;ja+=2;pa+=4}}V=J;K=E;sa=void 0;ya=void 0;var Fa=void 0,ea=void 0;Fa=void 0;T=[];sa=0;for(ya=K.materials.length;sa<ya;sa++){Fa=K.materials[sa];if(Fa instanceof THREE.MeshFaceMaterial){Fa=0;for(l=V.materials.length;Fa<l;Fa++)(ea=V.materials[Fa])&&T.push(ea)}else(ea=Fa)&&T.push(ea)}K=T;a:{V=void 0;sa=void 0;ya=K.length;for(V=0;V<ya;V++){sa=K[V];if(sa.map||sa.lightMap||sa instanceof THREE.MeshShaderMaterial){V=!0;break a}}V=!1}a:{sa=K;ya=void 0;T=void 0;Fa=sa.length;for(ya=0;ya<Fa;ya++){T=
sa[ya];if(!(T instanceof THREE.MeshBasicMaterial&&!T.envMap||T instanceof THREE.MeshDepthMaterial)){sa=T&&T.shading!=undefined&&T.shading==THREE.SmoothShading?THREE.SmoothShading:THREE.FlatShading;break a}}sa=!1}a:{ya=void 0;T=void 0;Fa=K.length;for(ya=0;ya<Fa;ya++){T=K[ya];if(T.vertexColors){K=T.vertexColors;break a}}K=!1}J.__vertexArray=new Float32Array(A*3);if(sa)J.__normalArray=new Float32Array(A*3);if(Ba.hasTangents)J.__tangentArray=new Float32Array(A*4);if(K)J.__colorArray=new Float32Array(A*
3);if(V){if(Ba.faceUvs.length>0||Ba.faceVertexUvs.length>0)J.__uvArray=new Float32Array(A*2);if(Ba.faceUvs.length>1||Ba.faceVertexUvs.length>1)J.__uv2Array=new Float32Array(A*2)}if(E.geometry.skinWeights.length&&E.geometry.skinIndices.length){J.__skinVertexAArray=new Float32Array(A*4);J.__skinVertexBArray=new Float32Array(A*4);J.__skinIndexArray=new Float32Array(A*4);J.__skinWeightArray=new Float32Array(A*4)}J.__faceArray=new Uint16Array(ja*3+(E.geometry.edgeFaces?E.geometry.edgeFaces.length*6:0));
J.__lineArray=new Uint16Array(pa*2);if(J.numMorphTargets){Ba=void 0;ya=void 0;J.__morphTargetsArrays=[];Ba=0;for(ya=J.numMorphTargets;Ba<ya;Ba++)J.__morphTargetsArrays.push(new Float32Array(A*3))}J.__needsSmoothNormals=sa==THREE.SmoothShading;J.__uvType=V;J.__vertexColorType=K;J.__normalType=sa;J.__webglFaceCount=ja*3+(E.geometry.edgeFaces?E.geometry.edgeFaces.length*6:0);J.__webglLineCount=pa*2;C.__dirtyVertices=!0;C.__dirtyMorphTargets=!0;C.__dirtyElements=!0;C.__dirtyUvs=!0;C.__dirtyNormals=!0;
C.__dirtyTangents=!0;C.__dirtyColors=!0}t instanceof THREE.ShadowVolume?F(w.__webglShadowVolumes,G,t):F(w.__webglObjects,G,t)}}else if(t instanceof THREE.Ribbon){C=t.geometry;if(!C.__webglVertexBuffer){p=C;p.__webglVertexBuffer=d.createBuffer();p.__webglColorBuffer=d.createBuffer();p=C;G=p.vertices.length;p.__vertexArray=new Float32Array(G*3);p.__colorArray=new Float32Array(G*3);p.__webglVertexCount=G;C.__dirtyVertices=!0;C.__dirtyColors=!0}F(w.__webglObjects,C,t)}else if(t instanceof THREE.Line){C=
t.geometry;if(!C.__webglVertexBuffer){p=C;p.__webglVertexBuffer=d.createBuffer();p.__webglColorBuffer=d.createBuffer();p=C;G=p.vertices.length;p.__vertexArray=new Float32Array(G*3);p.__colorArray=new Float32Array(G*3);p.__webglLineCount=G;C.__dirtyVertices=!0;C.__dirtyColors=!0}F(w.__webglObjects,C,t)}else if(t instanceof THREE.ParticleSystem){C=t.geometry;if(!C.__webglVertexBuffer){p=C;p.__webglVertexBuffer=d.createBuffer();p.__webglColorBuffer=d.createBuffer();p=C;G=p.vertices.length;p.__vertexArray=
new Float32Array(G*3);p.__colorArray=new Float32Array(G*3);p.__sortArray=[];p.__webglParticleCount=G;C.__dirtyVertices=!0;C.__dirtyColors=!0}F(w.__webglObjects,C,t)}else THREE.MarchingCubes!==undefined&&t instanceof THREE.MarchingCubes&&w.__webglObjectsImmediate.push({object:t,opaque:{list:[],count:0},transparent:{list:[],count:0}});h.__objectsAdded.splice(0,1)}for(;h.__objectsRemoved.length;){t=h.__objectsRemoved[0];w=h;C=void 0;p=void 0;for(C=w.__webglObjects.length-1;C>=0;C--){p=w.__webglObjects[C].object;
t==p&&w.__webglObjects.splice(C,1)}h.__objectsRemoved.splice(0,1)}t=0;for(w=h.__webglObjects.length;t<w;t++)H(h.__webglObjects[t].object,h);t=0;for(w=h.__webglShadowVolumes.length;t<w;t++)H(h.__webglShadowVolumes[t].object,h)};this.setFaceCulling=function(h,t){if(h){!t||t=="ccw"?d.frontFace(d.CCW):d.frontFace(d.CW);if(h=="back")d.cullFace(d.BACK);else h=="front"?d.cullFace(d.FRONT):d.cullFace(d.FRONT_AND_BACK);d.enable(d.CULL_FACE)}else d.disable(d.CULL_FACE)};this.supportsVertexTextures=function(){return d.getParameter(d.MAX_VERTEX_TEXTURE_IMAGE_UNITS)>
0}};THREE.SoundRenderer=function(){this.volume=1;this.domElement=document.createElement("div");this.domElement.id="THREESound";this.cameraPosition=new THREE.Vector3;this.soundPosition=new THREE.Vector3;this.render=function(a,c,b){b&&a.update(undefined,!1,c);b=a.sounds;var e,f=b.length;for(e=0;e<f;e++){a=b[e];this.soundPosition.set(a.matrixWorld.n14,a.matrixWorld.n24,a.matrixWorld.n34);this.soundPosition.subSelf(c.position);if(a.isPlaying&&a.isLoaded){a.isAddedToDOM||a.addToDOM(this.domElement);a.calculateVolumeAndPan(this.soundPosition)}}}};
THREE.RenderableVertex=function(){this.positionWorld=new THREE.Vector3;this.positionScreen=new THREE.Vector4;this.visible=!0};THREE.RenderableVertex.prototype.copy=function(a){this.positionWorld.copy(a.positionWorld);this.positionScreen.copy(a.positionScreen)};
THREE.RenderableFace3=function(){this.v1=new THREE.RenderableVertex;this.v2=new THREE.RenderableVertex;this.v3=new THREE.RenderableVertex;this.centroidWorld=new THREE.Vector3;this.centroidScreen=new THREE.Vector3;this.normalWorld=new THREE.Vector3;this.vertexNormalsWorld=[new THREE.Vector3,new THREE.Vector3,new THREE.Vector3];this.faceMaterials=this.meshMaterials=null;this.overdraw=!1;this.uvs=[[]];this.z=null};
THREE.RenderableFace4=function(){this.v1=new THREE.RenderableVertex;this.v2=new THREE.RenderableVertex;this.v3=new THREE.RenderableVertex;this.v4=new THREE.RenderableVertex;this.centroidWorld=new THREE.Vector3;this.centroidScreen=new THREE.Vector3;this.normalWorld=new THREE.Vector3;this.vertexNormalsWorld=[new THREE.Vector3,new THREE.Vector3,new THREE.Vector3,new THREE.Vector3];this.faceMaterials=this.meshMaterials=null;this.overdraw=!1;this.uvs=[[]];this.z=null};
THREE.RenderableObject=function(){this.z=this.object=null};THREE.RenderableParticle=function(){this.rotation=this.z=this.y=this.x=null;this.scale=new THREE.Vector2;this.materials=null};THREE.RenderableLine=function(){this.z=null;this.v1=new THREE.RenderableVertex;this.v2=new THREE.RenderableVertex;this.materials=null};
var GeometryUtils={merge:function(a,c){var b=c instanceof THREE.Mesh,e=a.vertices.length,f=b?c.geometry:c,g=a.vertices,j=f.vertices,k=a.faces,m=f.faces,n=a.faceVertexUvs[0];f=f.faceVertexUvs[0];b&&c.matrixAutoUpdate&&c.updateMatrix();for(var o=0,x=j.length;o<x;o++){var z=new THREE.Vertex(j[o].position.clone());b&&c.matrix.multiplyVector3(z.position);g.push(z)}o=0;for(x=m.length;o<x;o++){j=m[o];var y,B,H=j.vertexNormals;z=j.vertexColors;if(j instanceof THREE.Face3)y=new THREE.Face3(j.a+e,j.b+e,j.c+
e);else j instanceof THREE.Face4&&(y=new THREE.Face4(j.a+e,j.b+e,j.c+e,j.d+e));y.normal.copy(j.normal);b=0;for(g=H.length;b<g;b++){B=H[b];y.vertexNormals.push(B.clone())}y.color.copy(j.color);b=0;for(g=z.length;b<g;b++){B=z[b];y.vertexColors.push(B.clone())}y.materials=j.materials.slice();y.centroid.copy(j.centroid);k.push(y)}o=0;for(x=f.length;o<x;o++){e=f[o];k=[];b=0;for(g=e.length;b<g;b++)k.push(new THREE.UV(e[b].u,e[b].v));n.push(k)}}},ImageUtils={loadTexture:function(a,c,b){var e=new Image,f=
new THREE.Texture(e,c);e.onload=function(){f.needsUpdate=!0;b&&b(this)};e.src=a;return f},loadTextureCube:function(a,c,b){var e,f=[],g=new THREE.Texture(f,c);c=f.loadCount=0;for(e=a.length;c<e;++c){f[c]=new Image;f[c].onload=function(){f.loadCount+=1;if(f.loadCount==6)g.needsUpdate=!0;b&&b(this)};f[c].src=a[c]}return g}},SceneUtils={loadScene:function(a,c,b,e){var f=new Worker(a);f.postMessage(0);var g=THREE.Loader.prototype.extractUrlbase(a);f.onmessage=function(j){function k(Z,S){return S=="relativeToHTML"?
Z:g+"/"+Z}function m(){for(y in X.objects)if(!W.objects[y]){M=X.objects[y];if(P=W.geometries[M.geometry]){fa=[];for(ia=0;ia<M.materials.length;ia++)fa[ia]=W.materials[M.materials[ia]];D=M.position;r=M.rotation;q=M.quaternion;s=M.scale;q=0;fa.length==0&&(fa[0]=new THREE.MeshFaceMaterial);object=new THREE.Mesh(P,fa);object.position.set(D[0],D[1],D[2]);if(q){object.quaternion.set(q[0],q[1],q[2],q[3]);object.useQuaternion=!0}else object.rotation.set(r[0],r[1],r[2]);object.scale.set(s[0],s[1],s[2]);object.visible=
M.visible;W.scene.addObject(object);W.objects[y]=object}}}function n(Z){return function(S){W.geometries[Z]=S;m();ua-=1;o()}}function o(){e({total_models:za,total_textures:ma,loaded_models:za-ua,loaded_textures:ma-va},W);ua==0&&va==0&&b(W)}var x,z,y,B,H,I,F,M,D,Q,R,P,ka,d,fa,X,ca,Y,ua,va,za,ma,W;X=j.data;ca=new THREE.BinaryLoader;Y=new THREE.JSONLoader;va=ua=0;W={scene:new THREE.Scene,geometries:{},materials:{},textures:{},objects:{},cameras:{},lights:{},fogs:{}};j=function(){va-=1;o()};for(H in X.cameras){Q=
X.cameras[H];if(Q.type=="perspective")ka=new THREE.Camera(Q.fov,Q.aspect,Q.near,Q.far);else if(Q.type=="ortho"){ka=new THREE.Camera;ka.projectionMatrix=THREE.Matrix4.makeOrtho(Q.left,Q.right,Q.top,Q.bottom,Q.near,Q.far)}D=Q.position;Q=Q.target;ka.position.set(D[0],D[1],D[2]);ka.target.position.set(Q[0],Q[1],Q[2]);W.cameras[H]=ka}for(B in X.lights){H=X.lights[B];ka=H.color!==undefined?H.color:16777215;Q=H.intensity!==undefined?H.intensity:1;if(H.type=="directional"){D=H.direction;light=new THREE.DirectionalLight(ka,
Q);light.position.set(D[0],D[1],D[2]);light.position.normalize()}else if(H.type=="point"){D=H.position;light=new THREE.PointLight(ka,Q);light.position.set(D[0],D[1],D[2])}W.scene.addLight(light);W.lights[B]=light}for(I in X.fogs){B=X.fogs[I];if(B.type=="linear")d=new THREE.Fog(0,B.near,B.far);else B.type=="exp2"&&(d=new THREE.FogExp2(0,B.density));Q=B.color;d.color.setRGB(Q[0],Q[1],Q[2]);W.fogs[I]=d}if(W.cameras&&X.defaults.camera)W.currentCamera=W.cameras[X.defaults.camera];if(W.fogs&&X.defaults.fog)W.scene.fog=
W.fogs[X.defaults.fog];Q=X.defaults.bgcolor;W.bgColor=new THREE.Color;W.bgColor.setRGB(Q[0],Q[1],Q[2]);W.bgColorAlpha=X.defaults.bgalpha;for(x in X.geometries){I=X.geometries[x];if(I.type=="bin_mesh"||I.type=="ascii_mesh")ua+=1}za=ua;for(x in X.geometries){I=X.geometries[x];if(I.type=="cube"){P=new Cube(I.width,I.height,I.depth,I.segmentsWidth,I.segmentsHeight,I.segmentsDepth,null,I.flipped,I.sides);W.geometries[x]=P}else if(I.type=="plane"){P=new Plane(I.width,I.height,I.segmentsWidth,I.segmentsHeight);
W.geometries[x]=P}else if(I.type=="sphere"){P=new Sphere(I.radius,I.segmentsWidth,I.segmentsHeight);W.geometries[x]=P}else if(I.type=="cylinder"){P=new Cylinder(I.numSegs,I.topRad,I.botRad,I.height,I.topOffset,I.botOffset);W.geometries[x]=P}else if(I.type=="torus"){P=new Torus(I.radius,I.tube,I.segmentsR,I.segmentsT);W.geometries[x]=P}else if(I.type=="icosahedron"){P=new Icosahedron(I.subdivisions);W.geometries[x]=P}else if(I.type=="bin_mesh")ca.load({model:k(I.url,X.urlBaseType),callback:n(x)});
else I.type=="ascii_mesh"&&Y.load({model:k(I.url,X.urlBaseType),callback:n(x)})}for(F in X.textures){x=X.textures[F];va+=x.url instanceof Array?x.url.length:1}ma=va;for(F in X.textures){x=X.textures[F];if(x.mapping!=undefined&&THREE[x.mapping]!=undefined)x.mapping=new THREE[x.mapping];if(x.url instanceof Array){I=[];for(var ia=0;ia<x.url.length;ia++)I[ia]=k(x.url[ia],X.urlBaseType);I=ImageUtils.loadTextureCube(I,x.mapping,j)}else{I=ImageUtils.loadTexture(k(x.url,X.urlBaseType),x.mapping,j);if(THREE[x.minFilter]!=
undefined)I.minFilter=THREE[x.minFilter];if(THREE[x.magFilter]!=undefined)I.magFilter=THREE[x.magFilter]}W.textures[F]=I}for(z in X.materials){F=X.materials[z];for(R in F.parameters)if(R=="envMap"||R=="map"||R=="lightMap")F.parameters[R]=W.textures[F.parameters[R]];else if(R=="shading")F.parameters[R]=F.parameters[R]=="flat"?THREE.FlatShading:THREE.SmoothShading;else if(R=="blending")F.parameters[R]=THREE[F.parameters[R]]?THREE[F.parameters[R]]:THREE.NormalBlending;else R=="combine"&&(F.parameters[R]=
F.parameters[R]=="MixOperation"?THREE.MixOperation:THREE.MultiplyOperation);F=new THREE[F.type](F.parameters);W.materials[z]=F}m();c(W)}},addMesh:function(a,c,b,e,f,g,j,k,m,n){c=new THREE.Mesh(c,n);c.scale.x=c.scale.y=c.scale.z=b;c.position.x=e;c.position.y=f;c.position.z=g;c.rotation.x=j;c.rotation.y=k;c.rotation.z=m;a.addObject(c);return c},addPanoramaCubeWebGL:function(a,c,b){var e=ShaderUtils.lib.cube;e.uniforms.tCube.texture=b;b=new THREE.MeshShaderMaterial({fragmentShader:e.fragmentShader,vertexShader:e.vertexShader,
uniforms:e.uniforms});c=new THREE.Mesh(new Cube(c,c,c,1,1,1,null,!0),b);a.addObject(c);return c},addPanoramaCube:function(a,c,b){var e=[];e.push(new THREE.MeshBasicMaterial({map:new THREE.Texture(b[0])}));e.push(new THREE.MeshBasicMaterial({map:new THREE.Texture(b[1])}));e.push(new THREE.MeshBasicMaterial({map:new THREE.Texture(b[2])}));e.push(new THREE.MeshBasicMaterial({map:new THREE.Texture(b[3])}));e.push(new THREE.MeshBasicMaterial({map:new THREE.Texture(b[4])}));e.push(new THREE.MeshBasicMaterial({map:new THREE.Texture(b[5])}));
c=new THREE.Mesh(new Cube(c,c,c,1,1,e,!0),new THREE.MeshFaceMaterial);a.addObject(c);return c},addPanoramaCubePlanes:function(a,c,b){var e=c/2;c=new Plane(c,c);var f=Math.PI,g=Math.PI/2;SceneUtils.addMesh(a,c,1,0,0,-e,0,0,0,new THREE.MeshBasicMaterial({map:new THREE.Texture(b[5])}));SceneUtils.addMesh(a,c,1,-e,0,0,0,g,0,new THREE.MeshBasicMaterial({map:new THREE.Texture(b[0])}));SceneUtils.addMesh(a,c,1,e,0,0,0,-g,0,new THREE.MeshBasicMaterial({map:new THREE.Texture(b[1])}));SceneUtils.addMesh(a,
c,1,0,e,0,g,0,f,new THREE.MeshBasicMaterial({map:new THREE.Texture(b[2])}));SceneUtils.addMesh(a,c,1,0,-e,0,-g,0,f,new THREE.MeshBasicMaterial({map:new THREE.Texture(b[3])}))},showHierarchy:function(a,c){SceneUtils.traverseHierarchy(a,function(b){b.visible=c})},traverseHierarchy:function(a,c){var b,e,f=a.children.length;for(e=0;e<f;e++){b=a.children[e];c(b);SceneUtils.traverseHierarchy(b,c)}}},ShaderUtils={lib:{fresnel:{uniforms:{mRefractionRatio:{type:"f",value:1.02},mFresnelBias:{type:"f",value:0.1},
mFresnelPower:{type:"f",value:2},mFresnelScale:{type:"f",value:1},tCube:{type:"t",value:1,texture:null}},fragmentShader:"uniform samplerCube tCube;\nvarying vec3 vReflect;\nvarying vec3 vRefract[3];\nvarying float vReflectionFactor;\nvoid main() {\nvec4 reflectedColor = textureCube( tCube, vec3( -vReflect.x, vReflect.yz ) );\nvec4 refractedColor = vec4( 1.0, 1.0, 1.0, 1.0 );\nrefractedColor.r = textureCube( tCube, vec3( -vRefract[0].x, vRefract[0].yz ) ).r;\nrefractedColor.g = textureCube( tCube, vec3( -vRefract[1].x, vRefract[1].yz ) ).g;\nrefractedColor.b = textureCube( tCube, vec3( -vRefract[2].x, vRefract[2].yz ) ).b;\nrefractedColor.a = 1.0;\ngl_FragColor = mix( refractedColor, reflectedColor, clamp( vReflectionFactor, 0.0, 1.0 ) );\n}",
vertexShader:"uniform float mRefractionRatio;\nuniform float mFresnelBias;\nuniform float mFresnelScale;\nuniform float mFresnelPower;\nvarying vec3 vReflect;\nvarying vec3 vRefract[3];\nvarying float vReflectionFactor;\nvoid main() {\nvec4 mvPosition = modelViewMatrix * vec4( position, 1.0 );\nvec4 mPosition = objectMatrix * vec4( position, 1.0 );\nvec3 nWorld = normalize ( mat3( objectMatrix[0].xyz, objectMatrix[1].xyz, objectMatrix[2].xyz ) * normal );\nvec3 I = mPosition.xyz - cameraPosition;\nvReflect = reflect( I, nWorld );\nvRefract[0] = refract( normalize( I ), nWorld, mRefractionRatio );\nvRefract[1] = refract( normalize( I ), nWorld, mRefractionRatio * 0.99 );\nvRefract[2] = refract( normalize( I ), nWorld, mRefractionRatio * 0.98 );\nvReflectionFactor = mFresnelBias + mFresnelScale * pow( 1.0 + dot( normalize( I ), nWorld ), mFresnelPower );\ngl_Position = projectionMatrix * mvPosition;\n}"},
normal:{uniforms:{enableAO:{type:"i",value:0},enableDiffuse:{type:"i",value:0},tDiffuse:{type:"t",value:0,texture:null},tNormal:{type:"t",value:2,texture:null},tAO:{type:"t",value:3,texture:null},uNormalScale:{type:"f",value:1},tDisplacement:{type:"t",value:4,texture:null},uDisplacementBias:{type:"f",value:-0.5},uDisplacementScale:{type:"f",value:2.5},uPointLightPos:{type:"v3",value:new THREE.Vector3},uPointLightColor:{type:"c",value:new THREE.Color(15658734)},uDirLightPos:{type:"v3",value:new THREE.Vector3},
uDirLightColor:{type:"c",value:new THREE.Color(15658734)},uAmbientLightColor:{type:"c",value:new THREE.Color(328965)},uDiffuseColor:{type:"c",value:new THREE.Color(15658734)},uSpecularColor:{type:"c",value:new THREE.Color(1118481)},uAmbientColor:{type:"c",value:new THREE.Color(328965)},uShininess:{type:"f",value:30}},fragmentShader:"uniform vec3 uDirLightPos;\nuniform vec3 uAmbientLightColor;\nuniform vec3 uDirLightColor;\nuniform vec3 uPointLightColor;\nuniform vec3 uAmbientColor;\nuniform vec3 uDiffuseColor;\nuniform vec3 uSpecularColor;\nuniform float uShininess;\nuniform bool enableDiffuse;\nuniform bool enableAO;\nuniform sampler2D tDiffuse;\nuniform sampler2D tNormal;\nuniform sampler2D tAO;\nuniform float uNormalScale;\nvarying vec3 vTangent;\nvarying vec3 vBinormal;\nvarying vec3 vNormal;\nvarying vec2 vUv;\nvarying vec3 vPointLightVector;\nvarying vec3 vViewPosition;\nvoid main() {\nvec3 diffuseTex = vec3( 1.0, 1.0, 1.0 );\nvec3 aoTex = vec3( 1.0, 1.0, 1.0 );\nvec3 normalTex = texture2D( tNormal, vUv ).xyz * 2.0 - 1.0;\nnormalTex.xy *= uNormalScale;\nnormalTex = normalize( normalTex );\nif( enableDiffuse )\ndiffuseTex = texture2D( tDiffuse, vUv ).xyz;\nif( enableAO )\naoTex = texture2D( tAO, vUv ).xyz;\nmat3 tsb = mat3( vTangent, vBinormal, vNormal );\nvec3 finalNormal = tsb * normalTex;\nvec3 normal = normalize( finalNormal );\nvec3 viewPosition = normalize( vViewPosition );\nvec4 pointDiffuse  = vec4( 0.0, 0.0, 0.0, 0.0 );\nvec4 pointSpecular = vec4( 0.0, 0.0, 0.0, 0.0 );\nvec3 pointVector = normalize( vPointLightVector );\nvec3 pointHalfVector = normalize( vPointLightVector + vViewPosition );\nfloat pointDotNormalHalf = dot( normal, pointHalfVector );\nfloat pointDiffuseWeight = max( dot( normal, pointVector ), 0.0 );\nfloat pointSpecularWeight = 0.0;\nif ( pointDotNormalHalf >= 0.0 )\npointSpecularWeight = pow( pointDotNormalHalf, uShininess );\npointDiffuse  += vec4( uDiffuseColor, 1.0 ) * pointDiffuseWeight;\npointSpecular += vec4( uSpecularColor, 1.0 ) * pointSpecularWeight;\nvec4 dirDiffuse  = vec4( 0.0, 0.0, 0.0, 0.0 );\nvec4 dirSpecular = vec4( 0.0, 0.0, 0.0, 0.0 );\nvec4 lDirection = viewMatrix * vec4( uDirLightPos, 0.0 );\nvec3 dirVector = normalize( lDirection.xyz );\nvec3 dirHalfVector = normalize( lDirection.xyz + vViewPosition );\nfloat dirDotNormalHalf = dot( normal, dirHalfVector );\nfloat dirDiffuseWeight = max( dot( normal, dirVector ), 0.0 );\nfloat dirSpecularWeight = 0.0;\nif ( dirDotNormalHalf >= 0.0 )\ndirSpecularWeight = pow( dirDotNormalHalf, uShininess );\ndirDiffuse  += vec4( uDiffuseColor, 1.0 ) * dirDiffuseWeight;\ndirSpecular += vec4( uSpecularColor, 1.0 ) * dirSpecularWeight;\nvec4 totalLight = vec4( uAmbientLightColor * uAmbientColor, 1.0 );\ntotalLight += vec4( uDirLightColor, 1.0 ) * ( dirDiffuse + dirSpecular );\ntotalLight += vec4( uPointLightColor, 1.0 ) * ( pointDiffuse + pointSpecular );\ngl_FragColor = vec4( totalLight.xyz * aoTex * diffuseTex, 1.0 );\n}",
vertexShader:"attribute vec4 tangent;\nuniform vec3 uPointLightPos;\n#ifdef VERTEX_TEXTURES\nuniform sampler2D tDisplacement;\nuniform float uDisplacementScale;\nuniform float uDisplacementBias;\n#endif\nvarying vec3 vTangent;\nvarying vec3 vBinormal;\nvarying vec3 vNormal;\nvarying vec2 vUv;\nvarying vec3 vPointLightVector;\nvarying vec3 vViewPosition;\nvoid main() {\nvec4 mPosition = objectMatrix * vec4( position, 1.0 );\nvViewPosition = cameraPosition - mPosition.xyz;\nvec4 mvPosition = modelViewMatrix * vec4( position, 1.0 );\nvNormal = normalize( normalMatrix * normal );\nvTangent = normalize( normalMatrix * tangent.xyz );\nvBinormal = cross( vNormal, vTangent ) * tangent.w;\nvBinormal = normalize( vBinormal );\nvUv = uv;\nvec4 lPosition = viewMatrix * vec4( uPointLightPos, 1.0 );\nvPointLightVector = normalize( lPosition.xyz - mvPosition.xyz );\n#ifdef VERTEX_TEXTURES\nvec3 dv = texture2D( tDisplacement, uv ).xyz;\nfloat df = uDisplacementScale * dv.x + uDisplacementBias;\nvec4 displacedPosition = vec4( vNormal.xyz * df, 0.0 ) + mvPosition;\ngl_Position = projectionMatrix * displacedPosition;\n#else\ngl_Position = projectionMatrix * mvPosition;\n#endif\n}"},
cube:{uniforms:{tCube:{type:"t",value:1,texture:null}},vertexShader:"varying vec3 vViewPosition;\nvoid main() {\nvec4 mPosition = objectMatrix * vec4( position, 1.0 );\nvViewPosition = cameraPosition - mPosition.xyz;\ngl_Position = projectionMatrix * modelViewMatrix * vec4( position, 1.0 );\n}",fragmentShader:"uniform samplerCube tCube;\nvarying vec3 vViewPosition;\nvoid main() {\nvec3 wPos = cameraPosition - vViewPosition;\ngl_FragColor = textureCube( tCube, vec3( - wPos.x, wPos.yz ) );\n}"},convolution:{uniforms:{tDiffuse:{type:"t",
value:0,texture:null},uImageIncrement:{type:"v2",value:new THREE.Vector2(0.001953125,0)},cKernel:{type:"fv1",value:[]}},vertexShader:"varying vec2 vUv;\nuniform vec2 uImageIncrement;\nvoid main(void) {\nvUv = uv - ((KERNEL_SIZE - 1.0) / 2.0) * uImageIncrement;\ngl_Position = projectionMatrix * modelViewMatrix * vec4( position, 1.0 );\n}",fragmentShader:"varying vec2 vUv;\nuniform sampler2D tDiffuse;\nuniform vec2 uImageIncrement;\nuniform float cKernel[KERNEL_SIZE];\nvoid main(void) {\nvec2 imageCoord = vUv;\nvec4 sum = vec4( 0.0, 0.0, 0.0, 0.0 );\nfor( int i=0; i<KERNEL_SIZE; ++i ) {\nsum += texture2D( tDiffuse, imageCoord ) * cKernel[i];\nimageCoord += uImageIncrement;\n}\ngl_FragColor = sum;\n}"},
film:{uniforms:{tDiffuse:{type:"t",value:0,texture:null},time:{type:"f",value:0},nIntensity:{type:"f",value:0.5},sIntensity:{type:"f",value:0.05},sCount:{type:"f",value:4096},grayscale:{type:"i",value:1}},vertexShader:"varying vec2 vUv;\nvoid main() {\nvUv = vec2( uv.x, 1.0 - uv.y );\ngl_Position = projectionMatrix * modelViewMatrix * vec4( position, 1.0 );\n}",fragmentShader:"varying vec2 vUv;\nuniform sampler2D tDiffuse;\nuniform float time;\nuniform bool grayscale;\nuniform float nIntensity;\nuniform float sIntensity;\nuniform float sCount;\nvoid main() {\nvec4 cTextureScreen = texture2D( tDiffuse, vUv );\nfloat x = vUv.x * vUv.y * time *  1000.0;\nx = mod( x, 13.0 ) * mod( x, 123.0 );\nfloat dx = mod( x, 0.01 );\nvec3 cResult = cTextureScreen.rgb + cTextureScreen.rgb * clamp( 0.1 + dx * 100.0, 0.0, 1.0 );\nvec2 sc = vec2( sin( vUv.y * sCount ), cos( vUv.y * sCount ) );\ncResult += cTextureScreen.rgb * vec3( sc.x, sc.y, sc.x ) * sIntensity;\ncResult = cTextureScreen.rgb + clamp( nIntensity, 0.0,1.0 ) * ( cResult - cTextureScreen.rgb );\nif( grayscale ) {\ncResult = vec3( cResult.r * 0.3 + cResult.g * 0.59 + cResult.b * 0.11 );\n}\ngl_FragColor =  vec4( cResult, cTextureScreen.a );\n}"},
screen:{uniforms:{tDiffuse:{type:"t",value:0,texture:null},opacity:{type:"f",value:1}},vertexShader:"varying vec2 vUv;\nvoid main() {\nvUv = vec2( uv.x, 1.0 - uv.y );\ngl_Position = projectionMatrix * modelViewMatrix * vec4( position, 1.0 );\n}",fragmentShader:"varying vec2 vUv;\nuniform sampler2D tDiffuse;\nuniform float opacity;\nvoid main() {\nvec4 texel = texture2D( tDiffuse, vUv );\ngl_FragColor = opacity * texel;\n}"},basic:{uniforms:{},vertexShader:"void main() {\ngl_Position = projectionMatrix * modelViewMatrix * vec4( position, 1.0 );\n}",
fragmentShader:"void main() {\ngl_FragColor = vec4( 1.0, 0.0, 0.0, 0.5 );\n}"}},buildKernel:function(a){var c,b,e,f,g=2*Math.ceil(a*3)+1;g>25&&(g=25);f=(g-1)*0.5;b=Array(g);for(c=e=0;c<g;++c){b[c]=Math.exp(-((c-f)*(c-f))/(2*a*a));e+=b[c]}for(c=0;c<g;++c)b[c]/=e;return b}};
THREE.QuakeCamera=function(a){function c(b,e){return function(){e.apply(b,arguments)}}THREE.Camera.call(this,a.fov,a.aspect,a.near,a.far,a.target);this.movementSpeed=1;this.lookSpeed=0.0050;this.noFly=!1;this.lookVertical=!0;this.autoForward=!1;this.dragToLook=!1;this.heightSpeed=!1;this.heightCoef=1;this.heightMin=0;this.domElement=document;if(a){if(a.movementSpeed!==undefined)this.movementSpeed=a.movementSpeed;if(a.lookSpeed!==undefined)this.lookSpeed=a.lookSpeed;if(a.noFly!==undefined)this.noFly=
a.noFly;if(a.lookVertical!==undefined)this.lookVertical=a.lookVertical;if(a.autoForward!==undefined)this.autoForward=a.autoForward;if(a.dragToLook!==undefined)this.dragToLook=a.dragToLook;if(a.heightSpeed!==undefined)this.heightSpeed=a.heightSpeed;if(a.heightCoef!==undefined)this.heightCoef=a.heightCoef;if(a.heightMin!==undefined)this.heightMin=a.heightMin;if(a.heightMax!==undefined)this.heightMax=a.heightMax;if(a.domElement!==undefined)this.domElement=a.domElement}this.theta=this.phi=this.lon=this.lat=
this.mouseY=this.mouseX=this.autoSpeedFactor=0;this.moveForward=!1;this.moveBackward=!1;this.moveLeft=!1;this.moveRight=!1;this.mouseDragOn=!1;this.windowHalfX=window.innerWidth/2;this.windowHalfY=window.innerHeight/2;this.onMouseDown=function(b){b.preventDefault();b.stopPropagation();if(!this.dragToLook)switch(b.button){case 0:this.moveForward=!0;break;case 2:this.moveBackward=!0}this.mouseDragOn=!0};this.onMouseUp=function(b){b.preventDefault();b.stopPropagation();if(!this.dragToLook)switch(b.button){case 0:this.moveForward=
!1;break;case 2:this.moveBackward=!1}this.mouseDragOn=!1};this.onMouseMove=function(b){this.mouseX=b.clientX-this.windowHalfX;this.mouseY=b.clientY-this.windowHalfY};this.onKeyDown=function(b){switch(b.keyCode){case 38:case 87:this.moveForward=!0;break;case 37:case 65:this.moveLeft=!0;break;case 40:case 83:this.moveBackward=!0;break;case 39:case 68:this.moveRight=!0}};this.onKeyUp=function(b){switch(b.keyCode){case 38:case 87:this.moveForward=!1;break;case 37:case 65:this.moveLeft=!1;break;case 40:case 83:this.moveBackward=
!1;break;case 39:case 68:this.moveRight=!1}};this.update=function(){this.autoSpeedFactor=this.heightSpeed?((this.position.y<this.heightMin?this.heightMin:this.position.y>this.heightMax?this.heightMax:this.position.y)-this.heightMin)*this.heightCoef:0;(this.moveForward||this.autoForward)&&this.translateZ(-(this.movementSpeed+this.autoSpeedFactor));this.moveBackward&&this.translateZ(this.movementSpeed);this.moveLeft&&this.translateX(-this.movementSpeed);this.moveRight&&this.translateX(this.movementSpeed);
var b=this.lookSpeed;this.dragToLook&&!this.mouseDragOn&&(b=0);this.lon+=this.mouseX*b;this.lookVertical&&(this.lat-=this.mouseY*b);this.lat=Math.max(-85,Math.min(85,this.lat));this.phi=(90-this.lat)*Math.PI/180;this.theta=this.lon*Math.PI/180;b=this.target.position;var e=this.position;b.x=e.x+100*Math.sin(this.phi)*Math.cos(this.theta);b.y=e.y+100*Math.cos(this.phi);b.z=e.z+100*Math.sin(this.phi)*Math.sin(this.theta);this.supr.update.call(this)};this.domElement.addEventListener("contextmenu",function(b){b.preventDefault()},
!1);this.domElement.addEventListener("mousemove",c(this,this.onMouseMove),!1);this.domElement.addEventListener("mousedown",c(this,this.onMouseDown),!1);this.domElement.addEventListener("mouseup",c(this,this.onMouseUp),!1);this.domElement.addEventListener("keydown",c(this,this.onKeyDown),!1);this.domElement.addEventListener("keyup",c(this,this.onKeyUp),!1)};THREE.QuakeCamera.prototype=new THREE.Camera;THREE.QuakeCamera.prototype.constructor=THREE.QuakeCamera;THREE.QuakeCamera.prototype.supr=THREE.Camera.prototype;
THREE.QuakeCamera.prototype.translate=function(a,c){this.matrix.rotateAxis(c);if(this.noFly)c.y=0;this.position.addSelf(c.multiplyScalar(a));this.target.position.addSelf(c.multiplyScalar(a))};
THREE.PathCamera=function(a){function c(n,o,x,z){var y={name:x,fps:0.6,length:z,hierarchy:[]},B,H=o.getControlPointsArray(),I=o.getLength(),F=H.length,M=0;B=F-1;o={parent:-1,keys:[]};o.keys[0]={time:0,pos:H[0],rot:[0,0,0,1],scl:[1,1,1]};o.keys[B]={time:z,pos:H[B],rot:[0,0,0,1],scl:[1,1,1]};for(B=1;B<F-1;B++){M=z*I.chunks[B]/I.total;o.keys[B]={time:M,pos:H[B]}}y.hierarchy[0]=o;THREE.AnimationHandler.add(y);return new THREE.Animation(n,x,THREE.AnimationHandler.CATMULLROM_FORWARD,!1)}function b(n,o){var x,
z,y=new THREE.Geometry;for(x=0;x<n.points.length*o;x++){z=x/(n.points.length*o);z=n.getPoint(z);y.vertices[x]=new THREE.Vertex(new THREE.Vector3(z.x,z.y,z.z))}return y}function e(n,o){var x=b(o,10),z=b(o,10),y=new THREE.LineBasicMaterial({color:16711680,linewidth:3});lineObj=new THREE.Line(x,y);particleObj=new THREE.ParticleSystem(z,new THREE.ParticleBasicMaterial({color:16755200,size:3}));lineObj.scale.set(1,1,1);n.addChild(lineObj);particleObj.scale.set(1,1,1);n.addChild(particleObj);z=new Sphere(1,
16,8);y=new THREE.MeshBasicMaterial({color:65280});for(i=0;i<o.points.length;i++){x=new THREE.Mesh(z,y);x.position.copy(o.points[i]);x.updateMatrix();n.addChild(x)}}THREE.Camera.call(this,a.fov,a.aspect,a.near,a.far,a.target);this.id="PathCamera"+THREE.PathCameraIdCounter++;this.duration=1E4;this.waypoints=[];this.useConstantSpeed=!0;this.resamplingCoef=50;this.debugPath=new THREE.Object3D;this.debugDummy=new THREE.Object3D;this.animationParent=new THREE.Object3D;this.lookSpeed=0.0050;this.lookVertical=
!0;this.lookHorizontal=!0;this.verticalAngleMap={srcRange:[0,6.28],dstRange:[0,6.28]};this.horizontalAngleMap={srcRange:[0,6.28],dstRange:[0,6.28]};this.domElement=document;if(a){if(a.duration!==undefined)this.duration=a.duration*1E3;if(a.waypoints!==undefined)this.waypoints=a.waypoints;if(a.useConstantSpeed!==undefined)this.useConstantSpeed=a.useConstantSpeed;if(a.resamplingCoef!==undefined)this.resamplingCoef=a.resamplingCoef;if(a.createDebugPath!==undefined)this.createDebugPath=a.createDebugPath;
if(a.createDebugDummy!==undefined)this.createDebugDummy=a.createDebugDummy;if(a.lookSpeed!==undefined)this.lookSpeed=a.lookSpeed;if(a.lookVertical!==undefined)this.lookVertical=a.lookVertical;if(a.lookHorizontal!==undefined)this.lookHorizontal=a.lookHorizontal;if(a.verticalAngleMap!==undefined)this.verticalAngleMap=a.verticalAngleMap;if(a.horizontalAngleMap!==undefined)this.horizontalAngleMap=a.horizontalAngleMap;if(a.domElement!==undefined)this.domElement=a.domElement}this.theta=this.phi=this.lon=
this.lat=this.mouseY=this.mouseX=0;this.windowHalfX=window.innerWidth/2;this.windowHalfY=window.innerHeight/2;var f=Math.PI*2,g=Math.PI/180;this.update=function(n,o,x){var z,y;this.lookHorizontal&&(this.lon+=this.mouseX*this.lookSpeed);this.lookVertical&&(this.lat-=this.mouseY*this.lookSpeed);this.lon=Math.max(0,Math.min(360,this.lon));this.lat=Math.max(-85,Math.min(85,this.lat));this.phi=(90-this.lat)*g;this.theta=this.lon*g;z=this.phi%f;this.phi=z>=0?z:z+f;z=this.verticalAngleMap.srcRange;y=this.verticalAngleMap.dstRange;
this.phi=(this.phi-z[0])*(y[1]-y[0])/(z[1]-z[0])+y[0];z=this.horizontalAngleMap.srcRange;y=this.horizontalAngleMap.dstRange;this.theta=(this.theta-z[0])*(y[1]-y[0])/(z[1]-z[0])+y[0];z=this.target.position;z.x=100*Math.sin(this.phi)*Math.cos(this.theta);z.y=100*Math.cos(this.phi);z.z=100*Math.sin(this.phi)*Math.sin(this.theta);this.supr.update.call(this,n,o,x)};this.onMouseMove=function(n){this.mouseX=n.clientX-this.windowHalfX;this.mouseY=n.clientY-this.windowHalfY};this.spline=new THREE.Spline;this.spline.initFromArray(this.waypoints);
this.useConstantSpeed&&this.spline.reparametrizeByArcLength(this.resamplingCoef);if(this.createDebugDummy){a=new THREE.MeshLambertMaterial({color:30719});var j=new THREE.MeshLambertMaterial({color:65280}),k=new Cube(10,10,20),m=new Cube(2,2,10);this.animationParent=new THREE.Mesh(k,a);a=new THREE.Mesh(m,j);a.position.set(0,10,0);this.animation=c(this.animationParent,this.spline,this.id,this.duration);this.animationParent.addChild(this);this.animationParent.addChild(this.target);this.animationParent.addChild(a)}else{this.animation=
c(this.animationParent,this.spline,this.id,this.duration);this.animationParent.addChild(this.target);this.animationParent.addChild(this)}this.createDebugPath&&e(this.debugPath,this.spline);this.domElement.addEventListener("mousemove",function(n,o){return function(){o.apply(n,arguments)}}(this,this.onMouseMove),!1)};THREE.PathCamera.prototype=new THREE.Camera;THREE.PathCamera.prototype.constructor=THREE.PathCamera;THREE.PathCamera.prototype.supr=THREE.Camera.prototype;THREE.PathCameraIdCounter=0;
var Cube=function(a,c,b,e,f,g,j,k,m){function n(I,F,M,D,Q,R,P,ka){var d,fa,X=e||1,ca=f||1,Y=Q/2,ua=R/2,va=o.vertices.length;if(I=="x"&&F=="y"||I=="y"&&F=="x")d="z";else if(I=="x"&&F=="z"||I=="z"&&F=="x"){d="y";ca=g||1}else if(I=="z"&&F=="y"||I=="y"&&F=="z"){d="x";X=g||1}var za=X+1,ma=ca+1;Q/=X;var W=R/ca;for(fa=0;fa<ma;fa++)for(R=0;R<za;R++){var ia=new THREE.Vector3;ia[I]=(R*Q-Y)*M;ia[F]=(fa*W-ua)*D;ia[d]=P;o.vertices.push(new THREE.Vertex(ia))}for(fa=0;fa<ca;fa++)for(R=0;R<X;R++){o.faces.push(new THREE.Face4(R+
za*fa+va,R+za*(fa+1)+va,R+1+za*(fa+1)+va,R+1+za*fa+va,null,null,ka));o.faceVertexUvs[0].push([new THREE.UV(R/X,fa/ca),new THREE.UV(R/X,(fa+1)/ca),new THREE.UV((R+1)/X,(fa+1)/ca),new THREE.UV((R+1)/X,fa/ca)])}}THREE.Geometry.call(this);var o=this,x=a/2,z=c/2,y=b/2;k=k?-1:1;if(j!==undefined)if(j instanceof Array)this.materials=j;else{this.materials=[];for(var B=0;B<6;B++)this.materials.push([j])}else this.materials=[];this.sides={px:!0,nx:!0,py:!0,ny:!0,pz:!0,nz:!0};if(m!=undefined)for(var H in m)this.sides[H]!=
undefined&&(this.sides[H]=m[H]);this.sides.px&&n("z","y",1*k,-1,b,c,-x,this.materials[0]);this.sides.nx&&n("z","y",-1*k,-1,b,c,x,this.materials[1]);this.sides.py&&n("x","z",1*k,1,a,b,z,this.materials[2]);this.sides.ny&&n("x","z",1*k,-1,a,b,-z,this.materials[3]);this.sides.pz&&n("x","y",1*k,-1,a,c,y,this.materials[4]);this.sides.nz&&n("x","y",-1*k,-1,a,c,-y,this.materials[5]);(function(){for(var I=[],F=[],M=0,D=o.vertices.length;M<D;M++){for(var Q=o.vertices[M],R=!1,P=0,ka=I.length;P<ka;P++){var d=
I[P];if(Q.position.x==d.position.x&&Q.position.y==d.position.y&&Q.position.z==d.position.z){F[M]=P;R=!0;break}}if(!R){F[M]=I.length;I.push(new THREE.Vertex(Q.position.clone()))}}M=0;for(D=o.faces.length;M<D;M++){Q=o.faces[M];Q.a=F[Q.a];Q.b=F[Q.b];Q.c=F[Q.c];Q.d=F[Q.d]}o.vertices=I})();this.computeCentroids();this.computeFaceNormals()};Cube.prototype=new THREE.Geometry;Cube.prototype.constructor=Cube;
var Cylinder=function(a,c,b,e,f,g){function j(o,x,z){k.vertices.push(new THREE.Vertex(new THREE.Vector3(o,x,z)))}THREE.Geometry.call(this);var k=this,m=Math.PI,n=e/2;for(e=0;e<a;e++)j(Math.sin(2*m*e/a)*c,Math.cos(2*m*e/a)*c,-n);for(e=0;e<a;e++)j(Math.sin(2*m*e/a)*b,Math.cos(2*m*e/a)*b,n);for(e=0;e<a;e++)k.faces.push(new THREE.Face4(e,e+a,a+(e+1)%a,(e+1)%a));if(b>0){j(0,0,-n-(g||0));for(e=a;e<a+a/2;e++)k.faces.push(new THREE.Face4(2*a,(2*e-2*a)%a,(2*e-2*a+1)%a,(2*e-2*a+2)%a))}if(c>0){j(0,0,n+(f||0));
for(e=a+a/2;e<2*a;e++)k.faces.push(new THREE.Face4(2*a+1,(2*e-2*a+2)%a+a,(2*e-2*a+1)%a+a,(2*e-2*a)%a+a))}this.computeCentroids();this.computeFaceNormals()};Cylinder.prototype=new THREE.Geometry;Cylinder.prototype.constructor=Cylinder;
var Icosahedron=function(a){function c(x,z,y){var B=Math.sqrt(x*x+z*z+y*y);return f.vertices.push(new THREE.Vertex(new THREE.Vector3(x/B,z/B,y/B)))-1}function b(x,z,y,B){B.faces.push(new THREE.Face3(x,z,y))}function e(x,z){var y=f.vertices[x].position,B=f.vertices[z].position;return c((y.x+B.x)/2,(y.y+B.y)/2,(y.z+B.z)/2)}var f=this,g=new THREE.Geometry,j;this.subdivisions=a||0;THREE.Geometry.call(this);a=(1+Math.sqrt(5))/2;c(-1,a,0);c(1,a,0);c(-1,-a,0);c(1,-a,0);c(0,-1,a);c(0,1,a);c(0,-1,-a);c(0,
1,-a);c(a,0,-1);c(a,0,1);c(-a,0,-1);c(-a,0,1);b(0,11,5,g);b(0,5,1,g);b(0,1,7,g);b(0,7,10,g);b(0,10,11,g);b(1,5,9,g);b(5,11,4,g);b(11,10,2,g);b(10,7,6,g);b(7,1,8,g);b(3,9,4,g);b(3,4,2,g);b(3,2,6,g);b(3,6,8,g);b(3,8,9,g);b(4,9,5,g);b(2,4,11,g);b(6,2,10,g);b(8,6,7,g);b(9,8,1,g);for(a=0;a<this.subdivisions;a++){j=new THREE.Geometry;for(var k in g.faces){var m=e(g.faces[k].a,g.faces[k].b),n=e(g.faces[k].b,g.faces[k].c),o=e(g.faces[k].c,g.faces[k].a);b(g.faces[k].a,m,o,j);b(g.faces[k].b,n,m,j);b(g.faces[k].c,
o,n,j);b(m,n,o,j)}g.faces=j.faces}f.faces=g.faces;delete g;delete j;this.computeCentroids();this.computeFaceNormals();this.computeVertexNormals()};Icosahedron.prototype=new THREE.Geometry;Icosahedron.prototype.constructor=Icosahedron;
function Lathe(a,c,b){THREE.Geometry.call(this);this.steps=c||12;this.angle=b||2*Math.PI;c=this.angle/this.steps;for(var e=[],f=[],g=[],j=[],k=0;k<a.length;k++){this.vertices.push(new THREE.Vertex(a[k]));e[k]=a[k].clone();f[k]=this.vertices.length-1}for(var m=(new THREE.Matrix4).setRotationZ(c),n=0;n<=this.angle+0.0010;n+=c){for(k=0;k<e.length;k++)if(n<this.angle){e[k]=m.multiplyVector3(e[k].clone());this.vertices.push(new THREE.Vertex(e[k]));g[k]=this.vertices.length-1}else g=j;n==0&&(j=f);for(k=
0;k<f.length-1;k++){this.faces.push(new THREE.Face4(g[k],g[k+1],f[k+1],f[k]));this.faceVertexUvs[0].push([new THREE.UV(n/b,k/a.length),new THREE.UV(n/b,(k+1)/a.length),new THREE.UV((n-c)/b,(k+1)/a.length),new THREE.UV((n-c)/b,k/a.length)])}f=g;g=[]}this.computeCentroids();this.computeFaceNormals();this.computeVertexNormals()}Lathe.prototype=new THREE.Geometry;Lathe.prototype.constructor=Lathe;
var Plane=function(a,c,b,e){THREE.Geometry.call(this);var f,g=a/2,j=c/2;b=b||1;e=e||1;var k=b+1,m=e+1;a/=b;var n=c/e;for(f=0;f<m;f++)for(c=0;c<k;c++)this.vertices.push(new THREE.Vertex(new THREE.Vector3(c*a-g,-(f*n-j),0)));for(f=0;f<e;f++)for(c=0;c<b;c++){this.faces.push(new THREE.Face4(c+k*f,c+k*(f+1),c+1+k*(f+1),c+1+k*f));this.faceVertexUvs[0].push([new THREE.UV(c/b,f/e),new THREE.UV(c/b,(f+1)/e),new THREE.UV((c+1)/b,(f+1)/e),new THREE.UV((c+1)/b,f/e)])}this.computeCentroids();this.computeFaceNormals()};
Plane.prototype=new THREE.Geometry;Plane.prototype.constructor=Plane;
var Sphere=function(a,c,b){THREE.Geometry.call(this);var e,f=Math.PI,g=Math.max(3,c||8),j=Math.max(2,b||6);c=[];for(b=0;b<j+1;b++){e=b/j;var k=a*Math.cos(e*f),m=a*Math.sin(e*f),n=[],o=0;for(e=0;e<g;e++){var x=2*e/g,z=m*Math.sin(x*f);x=m*Math.cos(x*f);(b==0||b==j)&&e>0||(o=this.vertices.push(new THREE.Vertex(new THREE.Vector3(x,k,z)))-1);n.push(o)}c.push(n)}var y,B,H;f=c.length;for(b=0;b<f;b++){g=c[b].length;if(b>0)for(e=0;e<g;e++){n=e==g-1;j=c[b][n?0:e+1];k=c[b][n?g-1:e];m=c[b-1][n?g-1:e];n=c[b-1][n?
0:e+1];z=b/(f-1);y=(b-1)/(f-1);B=(e+1)/g;x=e/g;o=new THREE.UV(1-B,z);z=new THREE.UV(1-x,z);x=new THREE.UV(1-x,y);var I=new THREE.UV(1-B,y);if(b<c.length-1){y=this.vertices[j].position.clone();B=this.vertices[k].position.clone();H=this.vertices[m].position.clone();y.normalize();B.normalize();H.normalize();this.faces.push(new THREE.Face3(j,k,m,[new THREE.Vector3(y.x,y.y,y.z),new THREE.Vector3(B.x,B.y,B.z),new THREE.Vector3(H.x,H.y,H.z)]));this.faceVertexUvs[0].push([o,z,x])}if(b>1){y=this.vertices[j].position.clone();
B=this.vertices[m].position.clone();H=this.vertices[n].position.clone();y.normalize();B.normalize();H.normalize();this.faces.push(new THREE.Face3(j,m,n,[new THREE.Vector3(y.x,y.y,y.z),new THREE.Vector3(B.x,B.y,B.z),new THREE.Vector3(H.x,H.y,H.z)]));this.faceVertexUvs[0].push([o,x,I])}}}this.computeCentroids();this.computeFaceNormals();this.computeVertexNormals();this.boundingSphere={radius:a}};Sphere.prototype=new THREE.Geometry;Sphere.prototype.constructor=Sphere;
var Torus=function(a,c,b,e){this.radius=a||100;this.tube=c||40;this.segmentsR=b||8;this.segmentsT=e||6;a=[];THREE.Geometry.call(this);for(c=0;c<=this.segmentsR;++c)for(b=0;b<=this.segmentsT;++b){e=b/this.segmentsT*2*Math.PI;var f=c/this.segmentsR*2*Math.PI;this.vertices.push(new THREE.Vertex(new THREE.Vector3((this.radius+this.tube*Math.cos(f))*Math.cos(e),(this.radius+this.tube*Math.cos(f))*Math.sin(e),this.tube*Math.sin(f))));a.push([b/this.segmentsT,1-c/this.segmentsR])}for(c=1;c<=this.segmentsR;++c)for(b=
1;b<=this.segmentsT;++b){e=(this.segmentsT+1)*c+b;f=(this.segmentsT+1)*c+b-1;var g=(this.segmentsT+1)*(c-1)+b-1,j=(this.segmentsT+1)*(c-1)+b;this.faces.push(new THREE.Face4(e,f,g,j));this.faceVertexUvs[0].push([new THREE.UV(a[e][0],a[e][1]),new THREE.UV(a[f][0],a[f][1]),new THREE.UV(a[g][0],a[g][1]),new THREE.UV(a[j][0],a[j][1])])}delete a;this.computeCentroids();this.computeFaceNormals();this.computeVertexNormals()};Torus.prototype=new THREE.Geometry;Torus.prototype.constructor=Torus;
var TorusKnot=function(a,c,b,e,f,g,j){function k(x,z,y,B,H,I){z=y/B*x;y=Math.cos(z);return new THREE.Vector3(H*(2+y)*0.5*Math.cos(x),H*(2+y)*Math.sin(x)*0.5,I*H*Math.sin(z)*0.5)}THREE.Geometry.call(this);this.radius=a||200;this.tube=c||40;this.segmentsR=b||64;this.segmentsT=e||8;this.p=f||2;this.q=g||3;this.heightScale=j||1;this.grid=Array(this.segmentsR);b=new THREE.Vector3;e=new THREE.Vector3;g=new THREE.Vector3;for(a=0;a<this.segmentsR;++a){this.grid[a]=Array(this.segmentsT);for(c=0;c<this.segmentsT;++c){var m=
a/this.segmentsR*2*this.p*Math.PI;j=c/this.segmentsT*2*Math.PI;f=k(m,j,this.q,this.p,this.radius,this.heightScale);m=k(m+0.01,j,this.q,this.p,this.radius,this.heightScale);b.x=m.x-f.x;b.y=m.y-f.y;b.z=m.z-f.z;e.x=m.x+f.x;e.y=m.y+f.y;e.z=m.z+f.z;g.cross(b,e);e.cross(g,b);g.normalize();e.normalize();m=this.tube*Math.cos(j);j=this.tube*Math.sin(j);f.x+=m*e.x+j*g.x;f.y+=m*e.y+j*g.y;f.z+=m*e.z+j*g.z;this.grid[a][c]=this.vertices.push(new THREE.Vertex(new THREE.Vector3(f.x,f.y,f.z)))-1}}for(a=0;a<this.segmentsR;++a)for(c=
0;c<this.segmentsT;++c){g=(a+1)%this.segmentsR;j=(c+1)%this.segmentsT;f=this.grid[a][c];b=this.grid[g][c];e=this.grid[a][j];g=this.grid[g][j];j=new THREE.UV(a/this.segmentsR,c/this.segmentsT);m=new THREE.UV((a+1)/this.segmentsR,c/this.segmentsT);var n=new THREE.UV(a/this.segmentsR,(c+1)/this.segmentsT),o=new THREE.UV((a+1)/this.segmentsR,(c+1)/this.segmentsT);this.faces.push(new THREE.Face3(f,b,e));this.faceVertexUvs[0].push([j,m,n]);this.faces.push(new THREE.Face3(g,e,b));this.faceVertexUvs[0].push([o,
n,m])}this.computeCentroids();this.computeFaceNormals();this.computeVertexNormals()};TorusKnot.prototype=new THREE.Geometry;TorusKnot.prototype.constructor=TorusKnot;THREE.Loader=function(a){this.statusDomElement=(this.showStatus=a)?THREE.Loader.prototype.addStatusElement():null;this.onLoadStart=function(){};this.onLoadProgress=function(){};this.onLoadComplete=function(){}};
THREE.Loader.prototype={addStatusElement:function(){var a=document.createElement("div");a.style.position="absolute";a.style.right="0px";a.style.top="0px";a.style.fontSize="0.8em";a.style.textAlign="left";a.style.background="rgba(0,0,0,0.25)";a.style.color="#fff";a.style.width="120px";a.style.padding="0.5em 0.5em 0.5em 0.5em";a.style.zIndex=1E3;a.innerHTML="Loading ...";return a},updateProgress:function(a){var c="Loaded ";c+=a.total?(100*a.loaded/a.total).toFixed(0)+"%":(a.loaded/1E3).toFixed(2)+" KB";
this.statusDomElement.innerHTML=c},extractUrlbase:function(a){a=a.split("/");a.pop();return a.join("/")},init_materials:function(a,c,b){a.materials=[];for(var e=0;e<c.length;++e)a.materials[e]=[THREE.Loader.prototype.createMaterial(c[e],b)]},createMaterial:function(a,c){function b(k){k=Math.log(k)/Math.LN2;return Math.floor(k)==k}function e(k,m){var n=new Image;n.onload=function(){if(!b(this.width)||!b(this.height)){var o=Math.pow(2,Math.round(Math.log(this.width)/Math.LN2)),x=Math.pow(2,Math.round(Math.log(this.height)/
Math.LN2));k.image.width=o;k.image.height=x;k.image.getContext("2d").drawImage(this,0,0,o,x)}else k.image=this;k.needsUpdate=!0};n.src=m}var f,g,j;f="MeshLambertMaterial";g={color:15658734,opacity:1,map:null,lightMap:null,vertexColors:a.vertexColors?THREE.VertexColors:!1,wireframe:a.wireframe};if(a.shading)if(a.shading=="Phong")f="MeshPhongMaterial";else a.shading=="Basic"&&(f="MeshBasicMaterial");if(a.mapDiffuse&&c){j=document.createElement("canvas");g.map=new THREE.Texture(j);g.map.sourceFile=a.mapDiffuse;
e(g.map,c+"/"+a.mapDiffuse)}else if(a.colorDiffuse){j=(a.colorDiffuse[0]*255<<16)+(a.colorDiffuse[1]*255<<8)+a.colorDiffuse[2]*255;g.color=j;g.opacity=a.transparency}else if(a.DbgColor)g.color=a.DbgColor;if(a.mapLightmap&&c){j=document.createElement("canvas");g.lightMap=new THREE.Texture(j);g.lightMap.sourceFile=a.mapLightmap;e(g.lightMap,c+"/"+a.mapLightmap)}return new THREE[f](g)}};THREE.JSONLoader=function(a){THREE.Loader.call(this,a)};THREE.JSONLoader.prototype=new THREE.Loader;
THREE.JSONLoader.prototype.constructor=THREE.JSONLoader;THREE.JSONLoader.prototype.supr=THREE.Loader.prototype;THREE.JSONLoader.prototype.load=function(a){var c=this,b=a.model,e=a.callback,f=a.texture_path?a.texture_path:this.extractUrlbase(b);a=new Worker(b);a.onmessage=function(g){c.createModel(g.data,e,f);c.onLoadComplete()};this.onLoadStart();a.postMessage((new Date).getTime())};
THREE.JSONLoader.prototype.createModel=function(a,c,b){var e=new THREE.Geometry;this.init_materials(e,a.materials,b);(function(){if(a.version===undefined||a.version!=2)console.error("Deprecated file format.");else{var f,g,j,k,m,n,o,x,z,y,B=a.faces;x=a.vertices;var H=a.normals,I=a.colors,F=0;for(f=0;f<a.uvs.length;f++)a.uvs[f].length&&F++;for(f=0;f<F;f++){e.faceUvs[f]=[];e.faceVertexUvs[f]=[]}k=0;for(m=x.length;k<m;){z=new THREE.Vertex;z.position.x=x[k++];z.position.y=x[k++];z.position.z=x[k++];e.vertices.push(z)}k=
0;for(m=B.length;k<m;){n=B[k++];o=n&1;j=n&2;f=n&4;g=n&8;x=n&16;z=n&32;y=n&64;n&=128;if(o){o=new THREE.Face4;o.a=B[k++];o.b=B[k++];o.c=B[k++];o.d=B[k++];nVertices=4}else{o=new THREE.Face3;o.a=B[k++];o.b=B[k++];o.c=B[k++];nVertices=3}if(j){materialIndex=B[k++];o.materials=e.materials[materialIndex]}j=e.faces.length;if(f)for(f=0;f<F;f++){uvLayer=a.uvs[f];uvIndex=B[k++];u=uvLayer[uvIndex*2];v=uvLayer[uvIndex*2+1];e.faceUvs[f][j]=new THREE.UV(u,v)}if(g)for(f=0;f<F;f++){uvLayer=a.uvs[f];uvs=[];for(g=0;g<
nVertices;g++){uvIndex=B[k++];u=uvLayer[uvIndex*2];v=uvLayer[uvIndex*2+1];uvs[g]=new THREE.UV(u,v)}e.faceVertexUvs[f][j]=uvs}if(x){normalIndex=B[k++]*3;normal=new THREE.Vector3;normal.x=H[normalIndex++];normal.y=H[normalIndex++];normal.z=H[normalIndex];o.normal=normal}if(z)for(f=0;f<nVertices;f++){normalIndex=B[k++]*3;normal=new THREE.Vector3;normal.x=H[normalIndex++];normal.y=H[normalIndex++];normal.z=H[normalIndex];o.vertexNormals.push(normal)}if(y){color=new THREE.Color(B[k++]);o.color=color}if(n)for(f=
0;f<nVertices;f++){colorIndex=B[k++];color=new THREE.Color(I[colorIndex]);o.vertexColors.push(color)}e.faces.push(o)}}})();(function(){var f,g,j,k;if(a.skinWeights){f=0;for(g=a.skinWeights.length;f<g;f+=2){j=a.skinWeights[f];k=a.skinWeights[f+1];e.skinWeights.push(new THREE.Vector4(j,k,0,0))}}if(a.skinIndices){f=0;for(g=a.skinIndices.length;f<g;f+=2){j=a.skinIndices[f];k=a.skinIndices[f+1];e.skinIndices.push(new THREE.Vector4(j,k,0,0))}}e.bones=a.bones;e.animation=a.animation})();(function(){if(a.morphTargets!==
undefined){var f,g,j,k;f=0;for(g=a.morphTargets.length;f<g;f++){e.morphTargets[f]={};e.morphTargets[f].name=a.morphTargets[f].name;e.morphTargets[f].vertices=[];dstVertices=e.morphTargets[f].vertices;srcVertices=a.morphTargets[f].vertices;j=0;for(k=srcVertices.length;j<k;j+=3)dstVertices.push(new THREE.Vertex(new THREE.Vector3(srcVertices[j],srcVertices[j+1],srcVertices[j+2])))}}})();e.computeCentroids();e.computeFaceNormals();c(e)};THREE.BinaryLoader=function(a){THREE.Loader.call(this,a)};
THREE.BinaryLoader.prototype=new THREE.Loader;THREE.BinaryLoader.prototype.constructor=THREE.BinaryLoader;THREE.BinaryLoader.prototype.supr=THREE.Loader.prototype;
THREE.BinaryLoader.prototype={load:function(a){var c=a.model,b=a.callback,e=a.texture_path?a.texture_path:THREE.Loader.prototype.extractUrlbase(c),f=a.bin_path?a.bin_path:THREE.Loader.prototype.extractUrlbase(c);a=(new Date).getTime();c=new Worker(c);var g=this.showProgress?THREE.Loader.prototype.updateProgress:null;c.onmessage=function(j){THREE.BinaryLoader.prototype.loadAjaxBuffers(j.data.buffers,j.data.materials,b,f,e,g)};c.onerror=function(j){alert("worker.onerror: "+j.message+"\n"+j.data);j.preventDefault()};
c.postMessage(a)},loadAjaxBuffers:function(a,c,b,e,f,g){var j=new XMLHttpRequest,k=e+"/"+a,m=0;j.onreadystatechange=function(){if(j.readyState==4)j.status==200||j.status==0?THREE.BinaryLoader.prototype.createBinModel(j.responseText,b,f,c):alert("Couldn't load ["+k+"] ["+j.status+"]");else if(j.readyState==3){if(g){m==0&&(m=j.getResponseHeader("Content-Length"));g({total:m,loaded:j.responseText.length})}}else j.readyState==2&&(m=j.getResponseHeader("Content-Length"))};j.open("GET",k,!0);j.overrideMimeType("text/plain; charset=x-user-defined");
j.setRequestHeader("Content-Type","text/plain");j.send(null)},createBinModel:function(a,c,b,e){var f=function(g){function j(h,t){var w=o(h,t),p=o(h,t+1),C=o(h,t+2),G=o(h,t+3),J=(G<<1&255|C>>7)-127;w|=(C&127)<<16|p<<8;if(w==0&&J==-127)return 0;return(1-2*(G>>7))*(1+w*Math.pow(2,-23))*Math.pow(2,J)}function k(h,t){var w=o(h,t),p=o(h,t+1),C=o(h,t+2);return(o(h,t+3)<<24)+(C<<16)+(p<<8)+w}function m(h,t){var w=o(h,t);return(o(h,t+1)<<8)+w}function n(h,t){var w=o(h,t);return w>127?w-256:w}function o(h,
t){return h.charCodeAt(t)&255}function x(h){var t,w,p;t=k(a,h);w=k(a,h+P);p=k(a,h+ka);h=m(a,h+d);THREE.BinaryLoader.prototype.f3(F,t,w,p,h)}function z(h){var t,w,p,C,G,J;t=k(a,h);w=k(a,h+P);p=k(a,h+ka);C=m(a,h+d);G=k(a,h+fa);J=k(a,h+X);h=k(a,h+ca);THREE.BinaryLoader.prototype.f3n(F,Q,t,w,p,C,G,J,h)}function y(h){var t,w,p,C;t=k(a,h);w=k(a,h+Y);p=k(a,h+ua);C=k(a,h+va);h=m(a,h+za);THREE.BinaryLoader.prototype.f4(F,t,w,p,C,h)}function B(h){var t,w,p,C,G,J,E,A;t=k(a,h);w=k(a,h+Y);p=k(a,h+ua);C=k(a,h+
va);G=m(a,h+za);J=k(a,h+ma);E=k(a,h+W);A=k(a,h+ia);h=k(a,h+Z);THREE.BinaryLoader.prototype.f4n(F,Q,t,w,p,C,G,J,E,A,h)}function H(h){var t,w;t=k(a,h);w=k(a,h+S);h=k(a,h+N);THREE.BinaryLoader.prototype.uv3(F.faceVertexUvs[0],R[t*2],R[t*2+1],R[w*2],R[w*2+1],R[h*2],R[h*2+1])}function I(h){var t,w,p;t=k(a,h);w=k(a,h+ha);p=k(a,h+ra);h=k(a,h+na);THREE.BinaryLoader.prototype.uv4(F.faceVertexUvs[0],R[t*2],R[t*2+1],R[w*2],R[w*2+1],R[p*2],R[p*2+1],R[h*2],R[h*2+1])}var F=this,M=0,D,Q=[],R=[],P,ka,d,fa,X,ca,Y,
ua,va,za,ma,W,ia,Z,S,N,ha,ra,na,qa,xa,Da,$a,ab,Ia;THREE.Geometry.call(this);THREE.Loader.prototype.init_materials(F,e,g);D={signature:a.substr(M,8),header_bytes:o(a,M+8),vertex_coordinate_bytes:o(a,M+9),normal_coordinate_bytes:o(a,M+10),uv_coordinate_bytes:o(a,M+11),vertex_index_bytes:o(a,M+12),normal_index_bytes:o(a,M+13),uv_index_bytes:o(a,M+14),material_index_bytes:o(a,M+15),nvertices:k(a,M+16),nnormals:k(a,M+16+4),nuvs:k(a,M+16+8),ntri_flat:k(a,M+16+12),ntri_smooth:k(a,M+16+16),ntri_flat_uv:k(a,
M+16+20),ntri_smooth_uv:k(a,M+16+24),nquad_flat:k(a,M+16+28),nquad_smooth:k(a,M+16+32),nquad_flat_uv:k(a,M+16+36),nquad_smooth_uv:k(a,M+16+40)};M+=D.header_bytes;P=D.vertex_index_bytes;ka=D.vertex_index_bytes*2;d=D.vertex_index_bytes*3;fa=D.vertex_index_bytes*3+D.material_index_bytes;X=D.vertex_index_bytes*3+D.material_index_bytes+D.normal_index_bytes;ca=D.vertex_index_bytes*3+D.material_index_bytes+D.normal_index_bytes*2;Y=D.vertex_index_bytes;ua=D.vertex_index_bytes*2;va=D.vertex_index_bytes*3;
za=D.vertex_index_bytes*4;ma=D.vertex_index_bytes*4+D.material_index_bytes;W=D.vertex_index_bytes*4+D.material_index_bytes+D.normal_index_bytes;ia=D.vertex_index_bytes*4+D.material_index_bytes+D.normal_index_bytes*2;Z=D.vertex_index_bytes*4+D.material_index_bytes+D.normal_index_bytes*3;S=D.uv_index_bytes;N=D.uv_index_bytes*2;ha=D.uv_index_bytes;ra=D.uv_index_bytes*2;na=D.uv_index_bytes*3;g=D.vertex_index_bytes*3+D.material_index_bytes;Ia=D.vertex_index_bytes*4+D.material_index_bytes;qa=D.ntri_flat*
g;xa=D.ntri_smooth*(g+D.normal_index_bytes*3);Da=D.ntri_flat_uv*(g+D.uv_index_bytes*3);$a=D.ntri_smooth_uv*(g+D.normal_index_bytes*3+D.uv_index_bytes*3);ab=D.nquad_flat*Ia;g=D.nquad_smooth*(Ia+D.normal_index_bytes*4);Ia=D.nquad_flat_uv*(Ia+D.uv_index_bytes*4);M+=function(h){for(var t,w,p,C=D.vertex_coordinate_bytes*3,G=h+D.nvertices*C;h<G;h+=C){t=j(a,h);w=j(a,h+D.vertex_coordinate_bytes);p=j(a,h+D.vertex_coordinate_bytes*2);THREE.BinaryLoader.prototype.v(F,t,w,p)}return D.nvertices*C}(M);M+=function(h){for(var t,
w,p,C=D.normal_coordinate_bytes*3,G=h+D.nnormals*C;h<G;h+=C){t=n(a,h);w=n(a,h+D.normal_coordinate_bytes);p=n(a,h+D.normal_coordinate_bytes*2);Q.push(t/127,w/127,p/127)}return D.nnormals*C}(M);M+=function(h){for(var t,w,p=D.uv_coordinate_bytes*2,C=h+D.nuvs*p;h<C;h+=p){t=j(a,h);w=j(a,h+D.uv_coordinate_bytes);R.push(t,w)}return D.nuvs*p}(M);qa=M+qa;xa=qa+xa;Da=xa+Da;$a=Da+$a;ab=$a+ab;g=ab+g;Ia=g+Ia;(function(h){var t,w=D.vertex_index_bytes*3+D.material_index_bytes,p=w+D.uv_index_bytes*3,C=h+D.ntri_flat_uv*
p;for(t=h;t<C;t+=p){x(t);H(t+w)}return C-h})(xa);(function(h){var t,w=D.vertex_index_bytes*3+D.material_index_bytes+D.normal_index_bytes*3,p=w+D.uv_index_bytes*3,C=h+D.ntri_smooth_uv*p;for(t=h;t<C;t+=p){z(t);H(t+w)}return C-h})(Da);(function(h){var t,w=D.vertex_index_bytes*4+D.material_index_bytes,p=w+D.uv_index_bytes*4,C=h+D.nquad_flat_uv*p;for(t=h;t<C;t+=p){y(t);I(t+w)}return C-h})(g);(function(h){var t,w=D.vertex_index_bytes*4+D.material_index_bytes+D.normal_index_bytes*4,p=w+D.uv_index_bytes*
4,C=h+D.nquad_smooth_uv*p;for(t=h;t<C;t+=p){B(t);I(t+w)}return C-h})(Ia);(function(h){var t,w=D.vertex_index_bytes*3+D.material_index_bytes,p=h+D.ntri_flat*w;for(t=h;t<p;t+=w)x(t);return p-h})(M);(function(h){var t,w=D.vertex_index_bytes*3+D.material_index_bytes+D.normal_index_bytes*3,p=h+D.ntri_smooth*w;for(t=h;t<p;t+=w)z(t);return p-h})(qa);(function(h){var t,w=D.vertex_index_bytes*4+D.material_index_bytes,p=h+D.nquad_flat*w;for(t=h;t<p;t+=w)y(t);return p-h})($a);(function(h){var t,w=D.vertex_index_bytes*
4+D.material_index_bytes+D.normal_index_bytes*4,p=h+D.nquad_smooth*w;for(t=h;t<p;t+=w)B(t);return p-h})(ab);this.computeCentroids();this.computeFaceNormals()};f.prototype=new THREE.Geometry;f.prototype.constructor=f;c(new f(b))},v:function(a,c,b,e){a.vertices.push(new THREE.Vertex(new THREE.Vector3(c,b,e)))},f3:function(a,c,b,e,f){a.faces.push(new THREE.Face3(c,b,e,null,null,a.materials[f]))},f4:function(a,c,b,e,f,g){a.faces.push(new THREE.Face4(c,b,e,f,null,null,a.materials[g]))},f3n:function(a,
c,b,e,f,g,j,k,m){g=a.materials[g];var n=c[k*3],o=c[k*3+1];k=c[k*3+2];var x=c[m*3],z=c[m*3+1];m=c[m*3+2];a.faces.push(new THREE.Face3(b,e,f,[new THREE.Vector3(c[j*3],c[j*3+1],c[j*3+2]),new THREE.Vector3(n,o,k),new THREE.Vector3(x,z,m)],null,g))},f4n:function(a,c,b,e,f,g,j,k,m,n,o){j=a.materials[j];var x=c[m*3],z=c[m*3+1];m=c[m*3+2];var y=c[n*3],B=c[n*3+1];n=c[n*3+2];var H=c[o*3],I=c[o*3+1];o=c[o*3+2];a.faces.push(new THREE.Face4(b,e,f,g,[new THREE.Vector3(c[k*3],c[k*3+1],c[k*3+2]),new THREE.Vector3(x,
z,m),new THREE.Vector3(y,B,n),new THREE.Vector3(H,I,o)],null,j))},uv3:function(a,c,b,e,f,g,j){var k=[];k.push(new THREE.UV(c,b));k.push(new THREE.UV(e,f));k.push(new THREE.UV(g,j));a.push(k)},uv4:function(a,c,b,e,f,g,j,k,m){var n=[];n.push(new THREE.UV(c,b));n.push(new THREE.UV(e,f));n.push(new THREE.UV(g,j));n.push(new THREE.UV(k,m));a.push(n)}};if(!window.Int32Array){window.Int32Array=Array;window.Float32Array=Array}
THREE.MarchingCubes=function(a,c){THREE.Object3D.call(this);this.materials=c instanceof Array?c:[c];this.init=function(b){this.isolation=80;this.size=b;this.size2=this.size*this.size;this.size3=this.size2*this.size;this.halfsize=this.size/2;this.delta=2/this.size;this.yd=this.size;this.zd=this.size2;this.field=new Float32Array(this.size3);this.normal_cache=new Float32Array(this.size3*3);this.vlist=new Float32Array(36);this.nlist=new Float32Array(36);this.firstDraw=!0;this.maxCount=4096;this.count=
0;this.hasPos=!1;this.hasNormal=!1;this.positionArray=new Float32Array(this.maxCount*3);this.normalArray=new Float32Array(this.maxCount*3)};this.lerp=function(b,e,f){return b+(e-b)*f};this.VIntX=function(b,e,f,g,j,k,m,n,o,x){j=(j-o)/(x-o);o=this.normal_cache;e[g]=k+j*this.delta;e[g+1]=m;e[g+2]=n;f[g]=this.lerp(o[b],o[b+3],j);f[g+1]=this.lerp(o[b+1],o[b+4],j);f[g+2]=this.lerp(o[b+2],o[b+5],j)};this.VIntY=function(b,e,f,g,j,k,m,n,o,x){j=(j-o)/(x-o);o=this.normal_cache;e[g]=k;e[g+1]=m+j*this.delta;e[g+
2]=n;e=b+this.yd*3;f[g]=this.lerp(o[b],o[e],j);f[g+1]=this.lerp(o[b+1],o[e+1],j);f[g+2]=this.lerp(o[b+2],o[e+2],j)};this.VIntZ=function(b,e,f,g,j,k,m,n,o,x){j=(j-o)/(x-o);o=this.normal_cache;e[g]=k;e[g+1]=m;e[g+2]=n+j*this.delta;e=b+this.zd*3;f[g]=this.lerp(o[b],o[e],j);f[g+1]=this.lerp(o[b+1],o[e+1],j);f[g+2]=this.lerp(o[b+2],o[e+2],j)};this.compNorm=function(b){var e=b*3;if(this.normal_cache[e]==0){this.normal_cache[e]=this.field[b-1]-this.field[b+1];this.normal_cache[e+1]=this.field[b-this.yd]-
this.field[b+this.yd];this.normal_cache[e+2]=this.field[b-this.zd]-this.field[b+this.zd]}};this.polygonize=function(b,e,f,g,j,k){var m=g+1,n=g+this.yd,o=g+this.zd,x=m+this.yd,z=m+this.zd,y=g+this.yd+this.zd,B=m+this.yd+this.zd,H=0,I=this.field[g],F=this.field[m],M=this.field[n],D=this.field[x],Q=this.field[o],R=this.field[z],P=this.field[y],ka=this.field[B];I<j&&(H|=1);F<j&&(H|=2);M<j&&(H|=8);D<j&&(H|=4);Q<j&&(H|=16);R<j&&(H|=32);P<j&&(H|=128);ka<j&&(H|=64);var d=THREE.edgeTable[H];if(d==0)return 0;
var fa=this.delta,X=b+fa,ca=e+fa;fa=f+fa;if(d&1){this.compNorm(g);this.compNorm(m);this.VIntX(g*3,this.vlist,this.nlist,0,j,b,e,f,I,F)}if(d&2){this.compNorm(m);this.compNorm(x);this.VIntY(m*3,this.vlist,this.nlist,3,j,X,e,f,F,D)}if(d&4){this.compNorm(n);this.compNorm(x);this.VIntX(n*3,this.vlist,this.nlist,6,j,b,ca,f,M,D)}if(d&8){this.compNorm(g);this.compNorm(n);this.VIntY(g*3,this.vlist,this.nlist,9,j,b,e,f,I,M)}if(d&16){this.compNorm(o);this.compNorm(z);this.VIntX(o*3,this.vlist,this.nlist,12,
j,b,e,fa,Q,R)}if(d&32){this.compNorm(z);this.compNorm(B);this.VIntY(z*3,this.vlist,this.nlist,15,j,X,e,fa,R,ka)}if(d&64){this.compNorm(y);this.compNorm(B);this.VIntX(y*3,this.vlist,this.nlist,18,j,b,ca,fa,P,ka)}if(d&128){this.compNorm(o);this.compNorm(y);this.VIntY(o*3,this.vlist,this.nlist,21,j,b,e,fa,Q,P)}if(d&256){this.compNorm(g);this.compNorm(o);this.VIntZ(g*3,this.vlist,this.nlist,24,j,b,e,f,I,Q)}if(d&512){this.compNorm(m);this.compNorm(z);this.VIntZ(m*3,this.vlist,this.nlist,27,j,X,e,f,F,R)}if(d&
1024){this.compNorm(x);this.compNorm(B);this.VIntZ(x*3,this.vlist,this.nlist,30,j,X,ca,f,D,ka)}if(d&2048){this.compNorm(n);this.compNorm(y);this.VIntZ(n*3,this.vlist,this.nlist,33,j,b,ca,f,M,P)}H<<=4;for(j=g=0;THREE.triTable[H+j]!=-1;){b=H+j;e=b+1;f=b+2;this.posnormtriv(this.vlist,this.nlist,3*THREE.triTable[b],3*THREE.triTable[e],3*THREE.triTable[f],k);j+=3;g++}return g};this.posnormtriv=function(b,e,f,g,j,k){var m=this.count*3;this.positionArray[m]=b[f];this.positionArray[m+1]=b[f+1];this.positionArray[m+
2]=b[f+2];this.positionArray[m+3]=b[g];this.positionArray[m+4]=b[g+1];this.positionArray[m+5]=b[g+2];this.positionArray[m+6]=b[j];this.positionArray[m+7]=b[j+1];this.positionArray[m+8]=b[j+2];this.normalArray[m]=e[f];this.normalArray[m+1]=e[f+1];this.normalArray[m+2]=e[f+2];this.normalArray[m+3]=e[g];this.normalArray[m+4]=e[g+1];this.normalArray[m+5]=e[g+2];this.normalArray[m+6]=e[j];this.normalArray[m+7]=e[j+1];this.normalArray[m+8]=e[j+2];this.hasPos=!0;this.hasNormal=!0;this.count+=3;this.count>=
this.maxCount-3&&k(this)};this.begin=function(){this.count=0;this.hasPos=!1;this.hasNormal=!1};this.end=function(b){if(this.count!=0){for(var e=this.count*3;e<this.positionArray.length;e++)this.positionArray[e]=0;b(this)}};this.addBall=function(b,e,f,g,j){var k=this.size*Math.sqrt(g/j),m=f*this.size,n=e*this.size,o=b*this.size,x=Math.floor(m-k);x<1&&(x=1);m=Math.floor(m+k);m>this.size-1&&(m=this.size-1);var z=Math.floor(n-k);z<1&&(z=1);n=Math.floor(n+k);n>this.size-1&&(n=this.size-1);var y=Math.floor(o-
k);y<1&&(y=1);k=Math.floor(o+k);k>this.size-1&&(k=this.size-1);for(var B,H,I,F,M,D;x<m;x++){o=this.size2*x;H=x/this.size-f;M=H*H;for(H=z;H<n;H++){I=o+this.size*H;B=H/this.size-e;D=B*B;for(B=y;B<k;B++){F=B/this.size-b;F=g/(1.0E-6+F*F+D+M)-j;F>0&&(this.field[I+B]+=F)}}}};this.addPlaneX=function(b,e){var f,g,j,k,m,n=this.size,o=this.yd,x=this.zd,z=this.field,y=n*Math.sqrt(b/e);y>n&&(y=n);for(f=0;f<y;f++){g=f/n;g*=g;k=b/(1.0E-4+g)-e;if(k>0)for(g=0;g<n;g++){m=f+g*o;for(j=0;j<n;j++)z[x*j+m]+=k}}};this.addPlaneY=
function(b,e){var f,g,j,k,m,n,o=this.size,x=this.yd,z=this.zd,y=this.field,B=o*Math.sqrt(b/e);B>o&&(B=o);for(g=0;g<B;g++){f=g/o;f*=f;k=b/(1.0E-4+f)-e;if(k>0){m=g*x;for(f=0;f<o;f++){n=m+f;for(j=0;j<o;j++)y[z*j+n]+=k}}}};this.addPlaneZ=function(b,e){var f,g,j,k,m,n;size=this.size;yd=this.yd;zd=this.zd;field=this.field;dist=size*Math.sqrt(b/e);dist>size&&(dist=size);for(j=0;j<dist;j++){f=j/size;f*=f;k=b/(1.0E-4+f)-e;if(k>0){m=zd*j;for(g=0;g<size;g++){n=m+g*yd;for(f=0;f<size;f++)field[n+f]+=k}}}};this.reset=
function(){var b;for(b=0;b<this.size3;b++){this.normal_cache[b*3]=0;this.field[b]=0}};this.render=function(b){this.begin();var e,f,g,j,k,m,n,o,x,z=this.size-2;for(j=1;j<z;j++){x=this.size2*j;n=(j-this.halfsize)/this.halfsize;for(g=1;g<z;g++){o=x+this.size*g;m=(g-this.halfsize)/this.halfsize;for(f=1;f<z;f++){k=(f-this.halfsize)/this.halfsize;e=o+f;this.polygonize(k,m,n,e,this.isolation,b)}}}this.end(b)};this.generateGeometry=function(){var b=0,e=new THREE.Geometry;this.render(function(f){var g,j,k,
m,n,o,x,z;for(g=0;g<f.count;g++){n=g*3;x=n+1;z=n+2;j=f.positionArray[n];k=f.positionArray[x];m=f.positionArray[z];o=new THREE.Vector3(j,k,m);j=f.normalArray[n];k=f.normalArray[x];m=f.normalArray[z];n=new THREE.Vector3(j,k,m);n.normalize();n=new THREE.Vertex(o,n);e.vertices.push(n)}nfaces=f.count/3;for(g=0;g<nfaces;g++){n=(b+g)*3;x=n+1;z=n+2;o=e.vertices[n].normal;j=e.vertices[x].normal;k=e.vertices[z].normal;n=new THREE.Face3(n,x,z,[o,j,k]);e.faces.push(n)}b+=nfaces;f.count=0});return e};this.init(a)};
THREE.MarchingCubes.prototype=new THREE.Object3D;THREE.MarchingCubes.prototype.constructor=THREE.MarchingCubes;
THREE.edgeTable=new Int32Array([0,265,515,778,1030,1295,1541,1804,2060,2309,2575,2822,3082,3331,3593,3840,400,153,915,666,1430,1183,1941,1692,2460,2197,2975,2710,3482,3219,3993,3728,560,825,51,314,1590,1855,1077,1340,2620,2869,2111,2358,3642,3891,3129,3376,928,681,419,170,1958,1711,1445,1196,2988,2725,2479,2214,4010,3747,3497,3232,1120,1385,1635,1898,102,367,613,876,3180,3429,3695,3942,2154,2403,2665,2912,1520,1273,2035,1786,502,255,1013,764,3580,3317,4095,3830,2554,2291,3065,2800,1616,1881,1107,
1370,598,863,85,348,3676,3925,3167,3414,2650,2899,2137,2384,1984,1737,1475,1226,966,719,453,204,4044,3781,3535,3270,3018,2755,2505,2240,2240,2505,2755,3018,3270,3535,3781,4044,204,453,719,966,1226,1475,1737,1984,2384,2137,2899,2650,3414,3167,3925,3676,348,85,863,598,1370,1107,1881,1616,2800,3065,2291,2554,3830,4095,3317,3580,764,1013,255,502,1786,2035,1273,1520,2912,2665,2403,2154,3942,3695,3429,3180,876,613,367,102,1898,1635,1385,1120,3232,3497,3747,4010,2214,2479,2725,2988,1196,1445,1711,1958,170,
419,681,928,3376,3129,3891,3642,2358,2111,2869,2620,1340,1077,1855,1590,314,51,825,560,3728,3993,3219,3482,2710,2975,2197,2460,1692,1941,1183,1430,666,915,153,400,3840,3593,3331,3082,2822,2575,2309,2060,1804,1541,1295,1030,778,515,265,0]);
THREE.triTable=new Int32Array([-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,0,8,3,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,0,1,9,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,1,8,3,9,8,1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,1,2,10,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,0,8,3,1,2,10,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,9,2,10,0,2,9,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,2,8,3,2,10,8,10,9,8,-1,-1,-1,-1,-1,-1,-1,3,11,2,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,0,11,2,8,11,0,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,1,9,0,2,3,11,-1,-1,-1,-1,-1,
-1,-1,-1,-1,-1,1,11,2,1,9,11,9,8,11,-1,-1,-1,-1,-1,-1,-1,3,10,1,11,10,3,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,0,10,1,0,8,10,8,11,10,-1,-1,-1,-1,-1,-1,-1,3,9,0,3,11,9,11,10,9,-1,-1,-1,-1,-1,-1,-1,9,8,10,10,8,11,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,4,7,8,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,4,3,0,7,3,4,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,0,1,9,8,4,7,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,4,1,9,4,7,1,7,3,1,-1,-1,-1,-1,-1,-1,-1,1,2,10,8,4,7,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,3,4,7,3,0,4,1,2,10,-1,-1,-1,-1,-1,-1,-1,9,2,10,9,0,2,8,4,7,
-1,-1,-1,-1,-1,-1,-1,2,10,9,2,9,7,2,7,3,7,9,4,-1,-1,-1,-1,8,4,7,3,11,2,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,11,4,7,11,2,4,2,0,4,-1,-1,-1,-1,-1,-1,-1,9,0,1,8,4,7,2,3,11,-1,-1,-1,-1,-1,-1,-1,4,7,11,9,4,11,9,11,2,9,2,1,-1,-1,-1,-1,3,10,1,3,11,10,7,8,4,-1,-1,-1,-1,-1,-1,-1,1,11,10,1,4,11,1,0,4,7,11,4,-1,-1,-1,-1,4,7,8,9,0,11,9,11,10,11,0,3,-1,-1,-1,-1,4,7,11,4,11,9,9,11,10,-1,-1,-1,-1,-1,-1,-1,9,5,4,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,9,5,4,0,8,3,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,0,5,4,1,5,0,-1,-1,-1,-1,-1,-1,
-1,-1,-1,-1,8,5,4,8,3,5,3,1,5,-1,-1,-1,-1,-1,-1,-1,1,2,10,9,5,4,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,3,0,8,1,2,10,4,9,5,-1,-1,-1,-1,-1,-1,-1,5,2,10,5,4,2,4,0,2,-1,-1,-1,-1,-1,-1,-1,2,10,5,3,2,5,3,5,4,3,4,8,-1,-1,-1,-1,9,5,4,2,3,11,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,0,11,2,0,8,11,4,9,5,-1,-1,-1,-1,-1,-1,-1,0,5,4,0,1,5,2,3,11,-1,-1,-1,-1,-1,-1,-1,2,1,5,2,5,8,2,8,11,4,8,5,-1,-1,-1,-1,10,3,11,10,1,3,9,5,4,-1,-1,-1,-1,-1,-1,-1,4,9,5,0,8,1,8,10,1,8,11,10,-1,-1,-1,-1,5,4,0,5,0,11,5,11,10,11,0,3,-1,-1,-1,-1,5,4,8,5,
8,10,10,8,11,-1,-1,-1,-1,-1,-1,-1,9,7,8,5,7,9,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,9,3,0,9,5,3,5,7,3,-1,-1,-1,-1,-1,-1,-1,0,7,8,0,1,7,1,5,7,-1,-1,-1,-1,-1,-1,-1,1,5,3,3,5,7,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,9,7,8,9,5,7,10,1,2,-1,-1,-1,-1,-1,-1,-1,10,1,2,9,5,0,5,3,0,5,7,3,-1,-1,-1,-1,8,0,2,8,2,5,8,5,7,10,5,2,-1,-1,-1,-1,2,10,5,2,5,3,3,5,7,-1,-1,-1,-1,-1,-1,-1,7,9,5,7,8,9,3,11,2,-1,-1,-1,-1,-1,-1,-1,9,5,7,9,7,2,9,2,0,2,7,11,-1,-1,-1,-1,2,3,11,0,1,8,1,7,8,1,5,7,-1,-1,-1,-1,11,2,1,11,1,7,7,1,5,-1,-1,-1,-1,-1,-1,
-1,9,5,8,8,5,7,10,1,3,10,3,11,-1,-1,-1,-1,5,7,0,5,0,9,7,11,0,1,0,10,11,10,0,-1,11,10,0,11,0,3,10,5,0,8,0,7,5,7,0,-1,11,10,5,7,11,5,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,10,6,5,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,0,8,3,5,10,6,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,9,0,1,5,10,6,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,1,8,3,1,9,8,5,10,6,-1,-1,-1,-1,-1,-1,-1,1,6,5,2,6,1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,1,6,5,1,2,6,3,0,8,-1,-1,-1,-1,-1,-1,-1,9,6,5,9,0,6,0,2,6,-1,-1,-1,-1,-1,-1,-1,5,9,8,5,8,2,5,2,6,3,2,8,-1,-1,-1,-1,2,3,11,10,6,
5,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,11,0,8,11,2,0,10,6,5,-1,-1,-1,-1,-1,-1,-1,0,1,9,2,3,11,5,10,6,-1,-1,-1,-1,-1,-1,-1,5,10,6,1,9,2,9,11,2,9,8,11,-1,-1,-1,-1,6,3,11,6,5,3,5,1,3,-1,-1,-1,-1,-1,-1,-1,0,8,11,0,11,5,0,5,1,5,11,6,-1,-1,-1,-1,3,11,6,0,3,6,0,6,5,0,5,9,-1,-1,-1,-1,6,5,9,6,9,11,11,9,8,-1,-1,-1,-1,-1,-1,-1,5,10,6,4,7,8,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,4,3,0,4,7,3,6,5,10,-1,-1,-1,-1,-1,-1,-1,1,9,0,5,10,6,8,4,7,-1,-1,-1,-1,-1,-1,-1,10,6,5,1,9,7,1,7,3,7,9,4,-1,-1,-1,-1,6,1,2,6,5,1,4,7,8,-1,-1,-1,-1,
-1,-1,-1,1,2,5,5,2,6,3,0,4,3,4,7,-1,-1,-1,-1,8,4,7,9,0,5,0,6,5,0,2,6,-1,-1,-1,-1,7,3,9,7,9,4,3,2,9,5,9,6,2,6,9,-1,3,11,2,7,8,4,10,6,5,-1,-1,-1,-1,-1,-1,-1,5,10,6,4,7,2,4,2,0,2,7,11,-1,-1,-1,-1,0,1,9,4,7,8,2,3,11,5,10,6,-1,-1,-1,-1,9,2,1,9,11,2,9,4,11,7,11,4,5,10,6,-1,8,4,7,3,11,5,3,5,1,5,11,6,-1,-1,-1,-1,5,1,11,5,11,6,1,0,11,7,11,4,0,4,11,-1,0,5,9,0,6,5,0,3,6,11,6,3,8,4,7,-1,6,5,9,6,9,11,4,7,9,7,11,9,-1,-1,-1,-1,10,4,9,6,4,10,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,4,10,6,4,9,10,0,8,3,-1,-1,-1,-1,-1,-1,-1,
10,0,1,10,6,0,6,4,0,-1,-1,-1,-1,-1,-1,-1,8,3,1,8,1,6,8,6,4,6,1,10,-1,-1,-1,-1,1,4,9,1,2,4,2,6,4,-1,-1,-1,-1,-1,-1,-1,3,0,8,1,2,9,2,4,9,2,6,4,-1,-1,-1,-1,0,2,4,4,2,6,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,8,3,2,8,2,4,4,2,6,-1,-1,-1,-1,-1,-1,-1,10,4,9,10,6,4,11,2,3,-1,-1,-1,-1,-1,-1,-1,0,8,2,2,8,11,4,9,10,4,10,6,-1,-1,-1,-1,3,11,2,0,1,6,0,6,4,6,1,10,-1,-1,-1,-1,6,4,1,6,1,10,4,8,1,2,1,11,8,11,1,-1,9,6,4,9,3,6,9,1,3,11,6,3,-1,-1,-1,-1,8,11,1,8,1,0,11,6,1,9,1,4,6,4,1,-1,3,11,6,3,6,0,0,6,4,-1,-1,-1,-1,-1,-1,-1,
6,4,8,11,6,8,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,7,10,6,7,8,10,8,9,10,-1,-1,-1,-1,-1,-1,-1,0,7,3,0,10,7,0,9,10,6,7,10,-1,-1,-1,-1,10,6,7,1,10,7,1,7,8,1,8,0,-1,-1,-1,-1,10,6,7,10,7,1,1,7,3,-1,-1,-1,-1,-1,-1,-1,1,2,6,1,6,8,1,8,9,8,6,7,-1,-1,-1,-1,2,6,9,2,9,1,6,7,9,0,9,3,7,3,9,-1,7,8,0,7,0,6,6,0,2,-1,-1,-1,-1,-1,-1,-1,7,3,2,6,7,2,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,2,3,11,10,6,8,10,8,9,8,6,7,-1,-1,-1,-1,2,0,7,2,7,11,0,9,7,6,7,10,9,10,7,-1,1,8,0,1,7,8,1,10,7,6,7,10,2,3,11,-1,11,2,1,11,1,7,10,6,1,6,7,1,-1,-1,-1,-1,
8,9,6,8,6,7,9,1,6,11,6,3,1,3,6,-1,0,9,1,11,6,7,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,7,8,0,7,0,6,3,11,0,11,6,0,-1,-1,-1,-1,7,11,6,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,7,6,11,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,3,0,8,11,7,6,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,0,1,9,11,7,6,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,8,1,9,8,3,1,11,7,6,-1,-1,-1,-1,-1,-1,-1,10,1,2,6,11,7,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,1,2,10,3,0,8,6,11,7,-1,-1,-1,-1,-1,-1,-1,2,9,0,2,10,9,6,11,7,-1,-1,-1,-1,-1,-1,-1,6,11,7,2,10,3,10,8,3,10,9,8,-1,-1,-1,-1,7,
2,3,6,2,7,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,7,0,8,7,6,0,6,2,0,-1,-1,-1,-1,-1,-1,-1,2,7,6,2,3,7,0,1,9,-1,-1,-1,-1,-1,-1,-1,1,6,2,1,8,6,1,9,8,8,7,6,-1,-1,-1,-1,10,7,6,10,1,7,1,3,7,-1,-1,-1,-1,-1,-1,-1,10,7,6,1,7,10,1,8,7,1,0,8,-1,-1,-1,-1,0,3,7,0,7,10,0,10,9,6,10,7,-1,-1,-1,-1,7,6,10,7,10,8,8,10,9,-1,-1,-1,-1,-1,-1,-1,6,8,4,11,8,6,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,3,6,11,3,0,6,0,4,6,-1,-1,-1,-1,-1,-1,-1,8,6,11,8,4,6,9,0,1,-1,-1,-1,-1,-1,-1,-1,9,4,6,9,6,3,9,3,1,11,3,6,-1,-1,-1,-1,6,8,4,6,11,8,2,10,1,-1,-1,-1,
-1,-1,-1,-1,1,2,10,3,0,11,0,6,11,0,4,6,-1,-1,-1,-1,4,11,8,4,6,11,0,2,9,2,10,9,-1,-1,-1,-1,10,9,3,10,3,2,9,4,3,11,3,6,4,6,3,-1,8,2,3,8,4,2,4,6,2,-1,-1,-1,-1,-1,-1,-1,0,4,2,4,6,2,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,1,9,0,2,3,4,2,4,6,4,3,8,-1,-1,-1,-1,1,9,4,1,4,2,2,4,6,-1,-1,-1,-1,-1,-1,-1,8,1,3,8,6,1,8,4,6,6,10,1,-1,-1,-1,-1,10,1,0,10,0,6,6,0,4,-1,-1,-1,-1,-1,-1,-1,4,6,3,4,3,8,6,10,3,0,3,9,10,9,3,-1,10,9,4,6,10,4,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,4,9,5,7,6,11,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,0,8,3,4,9,5,11,7,6,
-1,-1,-1,-1,-1,-1,-1,5,0,1,5,4,0,7,6,11,-1,-1,-1,-1,-1,-1,-1,11,7,6,8,3,4,3,5,4,3,1,5,-1,-1,-1,-1,9,5,4,10,1,2,7,6,11,-1,-1,-1,-1,-1,-1,-1,6,11,7,1,2,10,0,8,3,4,9,5,-1,-1,-1,-1,7,6,11,5,4,10,4,2,10,4,0,2,-1,-1,-1,-1,3,4,8,3,5,4,3,2,5,10,5,2,11,7,6,-1,7,2,3,7,6,2,5,4,9,-1,-1,-1,-1,-1,-1,-1,9,5,4,0,8,6,0,6,2,6,8,7,-1,-1,-1,-1,3,6,2,3,7,6,1,5,0,5,4,0,-1,-1,-1,-1,6,2,8,6,8,7,2,1,8,4,8,5,1,5,8,-1,9,5,4,10,1,6,1,7,6,1,3,7,-1,-1,-1,-1,1,6,10,1,7,6,1,0,7,8,7,0,9,5,4,-1,4,0,10,4,10,5,0,3,10,6,10,7,3,7,10,
-1,7,6,10,7,10,8,5,4,10,4,8,10,-1,-1,-1,-1,6,9,5,6,11,9,11,8,9,-1,-1,-1,-1,-1,-1,-1,3,6,11,0,6,3,0,5,6,0,9,5,-1,-1,-1,-1,0,11,8,0,5,11,0,1,5,5,6,11,-1,-1,-1,-1,6,11,3,6,3,5,5,3,1,-1,-1,-1,-1,-1,-1,-1,1,2,10,9,5,11,9,11,8,11,5,6,-1,-1,-1,-1,0,11,3,0,6,11,0,9,6,5,6,9,1,2,10,-1,11,8,5,11,5,6,8,0,5,10,5,2,0,2,5,-1,6,11,3,6,3,5,2,10,3,10,5,3,-1,-1,-1,-1,5,8,9,5,2,8,5,6,2,3,8,2,-1,-1,-1,-1,9,5,6,9,6,0,0,6,2,-1,-1,-1,-1,-1,-1,-1,1,5,8,1,8,0,5,6,8,3,8,2,6,2,8,-1,1,5,6,2,1,6,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,
1,3,6,1,6,10,3,8,6,5,6,9,8,9,6,-1,10,1,0,10,0,6,9,5,0,5,6,0,-1,-1,-1,-1,0,3,8,5,6,10,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,10,5,6,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,11,5,10,7,5,11,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,11,5,10,11,7,5,8,3,0,-1,-1,-1,-1,-1,-1,-1,5,11,7,5,10,11,1,9,0,-1,-1,-1,-1,-1,-1,-1,10,7,5,10,11,7,9,8,1,8,3,1,-1,-1,-1,-1,11,1,2,11,7,1,7,5,1,-1,-1,-1,-1,-1,-1,-1,0,8,3,1,2,7,1,7,5,7,2,11,-1,-1,-1,-1,9,7,5,9,2,7,9,0,2,2,11,7,-1,-1,-1,-1,7,5,2,7,2,11,5,9,2,3,2,8,9,8,2,-1,2,5,10,2,3,5,3,7,5,-1,-1,
-1,-1,-1,-1,-1,8,2,0,8,5,2,8,7,5,10,2,5,-1,-1,-1,-1,9,0,1,5,10,3,5,3,7,3,10,2,-1,-1,-1,-1,9,8,2,9,2,1,8,7,2,10,2,5,7,5,2,-1,1,3,5,3,7,5,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,0,8,7,0,7,1,1,7,5,-1,-1,-1,-1,-1,-1,-1,9,0,3,9,3,5,5,3,7,-1,-1,-1,-1,-1,-1,-1,9,8,7,5,9,7,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,5,8,4,5,10,8,10,11,8,-1,-1,-1,-1,-1,-1,-1,5,0,4,5,11,0,5,10,11,11,3,0,-1,-1,-1,-1,0,1,9,8,4,10,8,10,11,10,4,5,-1,-1,-1,-1,10,11,4,10,4,5,11,3,4,9,4,1,3,1,4,-1,2,5,1,2,8,5,2,11,8,4,5,8,-1,-1,-1,-1,0,4,11,0,11,3,4,5,11,
2,11,1,5,1,11,-1,0,2,5,0,5,9,2,11,5,4,5,8,11,8,5,-1,9,4,5,2,11,3,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,2,5,10,3,5,2,3,4,5,3,8,4,-1,-1,-1,-1,5,10,2,5,2,4,4,2,0,-1,-1,-1,-1,-1,-1,-1,3,10,2,3,5,10,3,8,5,4,5,8,0,1,9,-1,5,10,2,5,2,4,1,9,2,9,4,2,-1,-1,-1,-1,8,4,5,8,5,3,3,5,1,-1,-1,-1,-1,-1,-1,-1,0,4,5,1,0,5,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,8,4,5,8,5,3,9,0,5,0,3,5,-1,-1,-1,-1,9,4,5,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,4,11,7,4,9,11,9,10,11,-1,-1,-1,-1,-1,-1,-1,0,8,3,4,9,7,9,11,7,9,10,11,-1,-1,-1,-1,1,10,11,1,11,
4,1,4,0,7,4,11,-1,-1,-1,-1,3,1,4,3,4,8,1,10,4,7,4,11,10,11,4,-1,4,11,7,9,11,4,9,2,11,9,1,2,-1,-1,-1,-1,9,7,4,9,11,7,9,1,11,2,11,1,0,8,3,-1,11,7,4,11,4,2,2,4,0,-1,-1,-1,-1,-1,-1,-1,11,7,4,11,4,2,8,3,4,3,2,4,-1,-1,-1,-1,2,9,10,2,7,9,2,3,7,7,4,9,-1,-1,-1,-1,9,10,7,9,7,4,10,2,7,8,7,0,2,0,7,-1,3,7,10,3,10,2,7,4,10,1,10,0,4,0,10,-1,1,10,2,8,7,4,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,4,9,1,4,1,7,7,1,3,-1,-1,-1,-1,-1,-1,-1,4,9,1,4,1,7,0,8,1,8,7,1,-1,-1,-1,-1,4,0,3,7,4,3,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,4,8,7,-1,-1,-1,
-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,9,10,8,10,11,8,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,3,0,9,3,9,11,11,9,10,-1,-1,-1,-1,-1,-1,-1,0,1,10,0,10,8,8,10,11,-1,-1,-1,-1,-1,-1,-1,3,1,10,11,3,10,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,1,2,11,1,11,9,9,11,8,-1,-1,-1,-1,-1,-1,-1,3,0,9,3,9,11,1,2,9,2,11,9,-1,-1,-1,-1,0,2,11,8,0,11,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,3,2,11,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,2,3,8,2,8,10,10,8,9,-1,-1,-1,-1,-1,-1,-1,9,10,2,0,9,2,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,2,3,8,2,8,10,0,1,8,1,10,8,-1,-1,-1,-1,1,10,
2,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,1,3,8,9,1,8,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,0,9,1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,0,3,8,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1]);
